/**
 * The LINK element specifies a link to an external resource, and defines this document's relationship to that resource (or vice versa). See the LINK element definition in HTML 4.01 (see also the LinkStyle interface in the StyleSheet module [DOM Level 2 Style Sheets and CSS]).
 */
var HTMLLinkElement = {
}
/**
 * Language code of the linked resource. See the hreflang attribute definition in HTML 4.01.
 * @syntax hTMLLinkElement.hreflang
 * @returns {String} 
 */
HTMLLinkElement.prototype.hreflang = new String();

/**
 * Reverse link type. See the rev attribute definition in HTML 4.01.
 * @syntax hTMLLinkElement.rev
 * @returns {String} 
 */
HTMLLinkElement.prototype.rev = new String();

/**
 * Frame to render the resource in. See the target attribute definition in HTML 4.01.
 * @syntax hTMLLinkElement.target
 * @returns {String} 
 */
HTMLLinkElement.prototype.target = new String();

/**
 * The character encoding of the resource being linked to. See the charset attribute definition in HTML 4.01.
 * @syntax hTMLLinkElement.charset
 * @returns {String} 
 */
HTMLLinkElement.prototype.charset = new String();

/**
 * Forward link type. See the rel attribute definition in HTML 4.01.
 * @syntax hTMLLinkElement.rel
 * @returns {String} 
 */
HTMLLinkElement.prototype.rel = new String();

/**
 * Advisory content type. See the type attribute definition in HTML 4.01.
 * @syntax hTMLLinkElement.type
 * @returns {String} 
 */
HTMLLinkElement.prototype.type = new String();

/**
 * The URI [IETF RFC 2396] of the linked resource. See the href attribute definition in HTML 4.01.
 * @syntax hTMLLinkElement.href
 * @returns {String} 
 */
HTMLLinkElement.prototype.href = new String();

/**
 * Designed for use with one or more target media. See the media attribute definition in HTML 4.01.
 * @syntax hTMLLinkElement.media
 * @returns {String} 
 */
HTMLLinkElement.prototype.media = new String();

/**
 * Enables/disables the link. This is currently only used for style sheet links, and may be used to activate or deactivate style sheets.
 * @syntax hTMLLinkElement.disabled
 * @returns {boolean} 
 */
HTMLLinkElement.prototype.disabled = new boolean();

/**
 * Represents the HTMLLinkElement prototype object.
 * @syntax HTMLLinkElement.prototype
 * @static
 */
HTMLLinkElement.prototype;

