/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToolTip;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.ParameterInformation;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.modules.lsp.client.bindings.Icons;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;

public class CompletionProviderImpl
implements CompletionProvider {
    public CompletionTask createTask(int queryType, JTextComponent component) {
        if ((queryType & 4) != 0) {
            return new AsyncCompletionTask(new AsyncCompletionQuery(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
                    try {
                        FileObject file = NbEditorUtilities.getFileObject((Document)doc);
                        if (file == null) {
                            return;
                        }
                        LSPBindings server = LSPBindings.getBindings(file);
                        if (server == null) {
                            return;
                        }
                        String uri = Utils.toURI(file);
                        TextDocumentPositionParams params = new TextDocumentPositionParams(new TextDocumentIdentifier(uri), Utils.createPosition(doc, caretOffset));
                        SignatureHelp help = server.getTextDocumentService().signatureHelp(params).get();
                        if (help == null || help.getSignatures().isEmpty()) {
                            return;
                        }
                        StringBuilder signatures = new StringBuilder();
                        signatures.append("<html>");
                        for (SignatureInformation info : help.getSignatures()) {
                            if (info.getParameters().isEmpty()) {
                                signatures.append("No parameter.");
                                continue;
                            }
                            String sigSep = "";
                            int idx = 0;
                            for (ParameterInformation pi : info.getParameters()) {
                                if (idx == help.getActiveParameter()) {
                                    signatures.append("<b>");
                                }
                                signatures.append(sigSep);
                                signatures.append(pi.getLabel());
                                if (idx == help.getActiveParameter()) {
                                    signatures.append("</b>");
                                }
                                sigSep = ", ";
                                ++idx;
                            }
                        }
                        JToolTip tip = new JToolTip();
                        tip.setTipText(signatures.toString());
                        resultSet.setToolTip(tip);
                    }
                    catch (InterruptedException | BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (ExecutionException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        resultSet.finish();
                    }
                }
            }, component);
        }
        return new AsyncCompletionTask(new AsyncCompletionQuery(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
                try {
                    boolean incomplete;
                    List<CompletionItem> items;
                    FileObject file = NbEditorUtilities.getFileObject((Document)doc);
                    if (file == null) {
                        return;
                    }
                    LSPBindings server = LSPBindings.getBindings(file);
                    if (server == null) {
                        return;
                    }
                    String uri = Utils.toURI(file);
                    CompletionParams params = new CompletionParams(new TextDocumentIdentifier(uri), Utils.createPosition(doc, caretOffset));
                    CountDownLatch l = new CountDownLatch(1);
                    Either<List<CompletionItem>, CompletionList> completionResult = server.getTextDocumentService().completion(params).get();
                    if (completionResult.isLeft()) {
                        items = (List<CompletionItem>)completionResult.getLeft();
                        incomplete = true;
                    } else {
                        items = ((CompletionList)completionResult.getRight()).getItems();
                        incomplete = ((CompletionList)completionResult.getRight()).isIncomplete();
                    }
                    for (final CompletionItem i : items) {
                        String documentation;
                        final String insert = i.getInsertText() != null ? i.getInsertText() : i.getLabel();
                        final String leftLabel = CompletionProviderImpl.this.encode(i.getLabel());
                        final String rightLabel = CompletionProviderImpl.this.encode("");
                        final String sortText = i.getSortText() != null ? i.getSortText() : i.getLabel();
                        String header = "<html><b>" + (i.getDetail() != null ? i.getDetail() : i.getLabel()) + "</b>";
                        if (i.getDocumentation() != null) {
                            header = header + "<br><br>";
                            documentation = i.getDocumentation().isLeft() ? header + (String)i.getDocumentation().getLeft() : header + ((MarkupContent)i.getDocumentation().getRight()).getValue();
                        } else {
                            documentation = header;
                        }
                        CompletionItemKind kind = i.getKind();
                        Icon ic = Icons.getCompletionIcon(kind);
                        final ImageIcon icon = new ImageIcon(ImageUtilities.icon2Image((Icon)ic));
                        resultSet.addItem(new org.netbeans.spi.editor.completion.CompletionItem(){

                            public void defaultAction(JTextComponent jtc) {
                                Document doc = jtc.getDocument();
                                TextEdit te = i.getTextEdit();
                                if (te != null) {
                                    int start = Utils.getOffset(doc, te.getRange().getStart());
                                    int end = Utils.getOffset(doc, te.getRange().getEnd());
                                    NbDocument.runAtomic((StyledDocument)((StyledDocument)doc), () -> {
                                        try {
                                            doc.remove(start, end - start);
                                            doc.insertString(start, te.getNewText(), null);
                                        }
                                        catch (BadLocationException ex) {
                                            Exceptions.printStackTrace((Throwable)ex);
                                        }
                                    });
                                } else {
                                    String toAdd = i.getInsertText();
                                    if (toAdd == null) {
                                        toAdd = i.getLabel();
                                    }
                                    try {
                                        int offset = jtc.getCaretPosition();
                                        String ident = Utilities.getIdentifier((BaseDocument)((BaseDocument)doc), (int)offset);
                                        doc.insertString(offset, toAdd.substring(ident != null ? ident.length() : 0), null);
                                    }
                                    catch (BadLocationException ex) {
                                        Exceptions.printStackTrace((Throwable)ex);
                                    }
                                }
                            }

                            public void processKeyEvent(KeyEvent ke) {
                            }

                            public int getPreferredWidth(Graphics grphcs, Font font) {
                                return CompletionUtilities.getPreferredWidth((String)leftLabel, (String)rightLabel, (Graphics)grphcs, (Font)font);
                            }

                            public void render(Graphics grphcs, Font font, Color color, Color color1, int i2, int i1, boolean bln) {
                                CompletionUtilities.renderHtml((ImageIcon)icon, (String)leftLabel, (String)rightLabel, (Graphics)grphcs, (Font)font, (Color)color, (int)i2, (int)i1, (boolean)bln);
                            }

                            public CompletionTask createDocumentationTask() {
                                return new CompletionTask(){

                                    public void query(CompletionResultSet resultSet) {
                                        resultSet.setDocumentation(new CompletionDocumentation(){

                                            public String getText() {
                                                return documentation;
                                            }

                                            public URL getURL() {
                                                return null;
                                            }

                                            public CompletionDocumentation resolveLink(String link) {
                                                return null;
                                            }

                                            public Action getGotoSourceAction() {
                                                return null;
                                            }
                                        });
                                        resultSet.finish();
                                    }

                                    public void refresh(CompletionResultSet resultSet) {
                                    }

                                    public void cancel() {
                                    }
                                };
                            }

                            public CompletionTask createToolTipTask() {
                                return null;
                            }

                            public boolean instantSubstitution(JTextComponent jtc) {
                                return false;
                            }

                            public int getSortPriority() {
                                return 100;
                            }

                            public CharSequence getSortText() {
                                return sortText;
                            }

                            public CharSequence getInsertPrefix() {
                                return insert;
                            }
                        });
                    }
                }
                catch (InterruptedException | BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    resultSet.finish();
                }
            }
        }, component);
    }

    private String encode(String str) {
        return str.replace("&", "&amp;").replace("<", "&lt;");
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }
}

