/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.freeform.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.ant.FileChooser;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.web.freeform.WebProjectGenerator;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class WebClasspathPanel
extends JPanel
implements HelpCtx.Provider {
    private DefaultListModel listModel;
    private File projectFolder = null;
    private File nbProjectFolder;
    private File lastChosenFile = null;
    private boolean isSeparateClasspath = true;
    private boolean ignoreEvent;
    private static String JAVA_SOURCES_CLASSPATH = NbBundle.getMessage(WebClasspathPanel.class, (String)"LBL_JAVA_SOURCE_CLASSPATH");
    private JButton addClasspath;
    private JList classpath;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JButton moveDown;
    private JButton moveUp;
    private JButton removeClasspath;

    public WebClasspathPanel() {
        this(true);
    }

    public WebClasspathPanel(boolean isWizard) {
        this.initComponents();
        this.jTextArea1.setBackground(this.getBackground());
        this.listModel = new DefaultListModel();
        this.listModel.add(0, JAVA_SOURCES_CLASSPATH);
        this.classpath.setModel(this.listModel);
        if (!isWizard) {
            this.jTextArea1.setText(NbBundle.getMessage(WebClasspathPanel.class, (String)"LBL_ClasspathPanel_Explanation"));
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(WebClasspathPanel.class);
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.addClasspath = new JButton();
        this.removeClasspath = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.classpath = new JList();
        this.jPanel1 = new JPanel();
        this.moveUp = new JButton();
        this.moveDown = new JButton();
        this.jTextArea1 = new JTextArea();
        this.jPanel2 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jTextArea2 = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.classpath);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(WebClasspathPanel.class, (String)"LBL_ClasspathPanel_jLabel3"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebClasspathPanel.class, (String)"ACSD_ClasspathPanel_jLabel3"));
        Mnemonics.setLocalizedText((AbstractButton)this.addClasspath, (String)NbBundle.getMessage(WebClasspathPanel.class, (String)"BTN_ClasspathPanel_addClasspath"));
        this.addClasspath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebClasspathPanel.this.addClasspathActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.addClasspath, gridBagConstraints);
        this.addClasspath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebClasspathPanel.class, (String)"ACSD_ClasspathPanel_addClasspath"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeClasspath, (String)NbBundle.getMessage(WebClasspathPanel.class, (String)"BTN_ClasspathPanel_removeClasspath"));
        this.removeClasspath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebClasspathPanel.this.removeClasspathActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.removeClasspath, gridBagConstraints);
        this.removeClasspath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebClasspathPanel.class, (String)"ACSD_ClasspathPanel_removeClasspath"));
        this.classpath.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                WebClasspathPanel.this.classpathValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.classpath);
        this.classpath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebClasspathPanel.class, (String)"ACSD_ClasspathPanel_classpath"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.moveUp.setMnemonic(NbBundle.getMessage(WebClasspathPanel.class, (String)"LBL_MoveUp_MNE").charAt(0));
        this.moveUp.setText(NbBundle.getMessage(WebClasspathPanel.class, (String)"LBL_ClasspathPanel_Move_Up"));
        this.moveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebClasspathPanel.this.moveUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.moveUp, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/web/freeform/ui/Bundle");
        this.moveUp.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_ClasspathPanel_noveUp"));
        this.moveDown.setMnemonic(NbBundle.getMessage(WebClasspathPanel.class, (String)"LBL_MoveDown_MNE").charAt(0));
        this.moveDown.setText(NbBundle.getMessage(WebClasspathPanel.class, (String)"LBL_ClasspathPanel_Move_Down"));
        this.moveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WebClasspathPanel.this.moveDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.moveDown, gridBagConstraints);
        this.moveDown.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_ClasspathPanel_moveDown"));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setText(NbBundle.getMessage(WebClasspathPanel.class, (String)"MSG_ClasspathPanel_jTextArea"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setDisabledTextColor(Color.black);
        this.jTextArea1.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.jTextArea1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WebClasspathPanel.class, (String)"ACSN_ClasspathPanel_jTextArea"));
        this.jTextArea1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebClasspathPanel.class, (String)"ACSD_ClasspathPanel_jTextArea"));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Label.disabledForeground")));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/web/freeform/resources/alert_32.png")));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 8, 8, 0);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.jTextArea2.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.jTextArea2.setEditable(false);
        this.jTextArea2.setLineWrap(true);
        this.jTextArea2.setText(NbBundle.getMessage(WebClasspathPanel.class, (String)"Freeform_Warning_Message"));
        this.jTextArea2.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 10, 4, 4);
        this.jPanel2.add((Component)this.jTextArea2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void classpathValueChanged(ListSelectionEvent evt) {
        this.updateButtons();
    }

    private void moveDownActionPerformed(ActionEvent evt) {
        int[] indices = this.classpath.getSelectedIndices();
        if (indices.length == 0 || indices[indices.length - 1] == this.listModel.getSize() - 1) {
            return;
        }
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            Object o = this.listModel.remove(index);
            this.listModel.add(++index, o);
            indices[i] = index;
        }
        this.classpath.setSelectedIndices(indices);
        this.updateButtons();
    }

    private void moveUpActionPerformed(ActionEvent evt) {
        int[] indices = this.classpath.getSelectedIndices();
        if (indices.length == 0 || indices[0] == 0) {
            return;
        }
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            Object o = this.listModel.remove(index);
            this.listModel.add(--index, o);
            indices[i] = index;
        }
        this.classpath.setSelectedIndices(indices);
        this.updateButtons();
    }

    void updateButtons() {
        int[] indices = this.classpath.getSelectedIndices();
        this.removeClasspath.setEnabled(this.listModel.getSize() > 0 && indices.length != 0 && indices[0] != 0);
        this.moveUp.setEnabled(indices.length > 0 && indices[0] > 1);
        this.moveDown.setEnabled(indices.length > 0 && indices[indices.length - 1] != this.listModel.getSize() - 1 && indices[0] != 0);
    }

    private void removeClasspathActionPerformed(ActionEvent evt) {
        int[] entries = this.classpath.getSelectedIndices();
        for (int i = 0; i < entries.length; ++i) {
            this.listModel.remove(entries[i] - i);
        }
        this.updateButtons();
    }

    private void addClasspathActionPerformed(ActionEvent evt) {
        FileChooser chooser = new FileChooser(this.projectFolder, null);
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(2);
        chooser.setMultiSelectionEnabled(true);
        if (this.lastChosenFile != null) {
            chooser.setSelectedFile(this.lastChosenFile);
        } else if (this.projectFolder != null) {
            File[] files = this.projectFolder.listFiles();
            if (files != null && files.length > 0) {
                chooser.setSelectedFile(files[0]);
            } else {
                chooser.setSelectedFile(this.projectFolder);
            }
        }
        chooser.setDialogTitle(NbBundle.getMessage(WebClasspathPanel.class, (String)"LBL_Browse_Classpath"));
        SimpleFileFilter fileFilter = new SimpleFileFilter(NbBundle.getMessage(WebClasspathPanel.class, (String)"LBL_ZipJarFolderFilter"));
        chooser.setFileFilter((FileFilter)fileFilter);
        chooser.setAcceptAllFileFilterUsed(false);
        if (0 == chooser.showOpenDialog((Component)this)) {
            String[] filePaths = null;
            try {
                filePaths = chooser.getSelectedPaths();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            for (String filePath : filePaths) {
                this.listModel.addElement(filePath);
            }
            this.lastChosenFile = chooser.getCurrentDirectory();
            this.updateButtons();
        }
    }

    public void setProjectFolders(File baseFolder, File nbProjectFolder) {
        this.projectFolder = baseFolder;
        this.nbProjectFolder = nbProjectFolder;
    }

    public String getClasspath() {
        StringBuffer sf = new StringBuffer();
        for (int i = 1; i < this.listModel.getSize(); ++i) {
            String path = (String)this.listModel.get(i);
            sf.append(path);
            if (i >= this.listModel.getSize() - 1) continue;
            sf.append(File.pathSeparatorChar);
        }
        return sf.toString();
    }

    void setClasspath(String classpath, PropertyEvaluator evaluator) {
        if (classpath == null) {
            return;
        }
        this.listModel.clear();
        this.listModel.addElement(JAVA_SOURCES_CLASSPATH);
        String[] cpa = PropertyUtils.tokenizePath((String)evaluator.evaluate(classpath));
        for (int i = 0; i < cpa.length; ++i) {
            String path = cpa[i];
            if (path == null) continue;
            this.listModel.addElement(path);
        }
    }

    ActionListener getCustomizerOkListener(final AntProjectHelper projectHelper) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                AuxiliaryConfiguration aux = Util.getAuxiliaryConfiguration((AntProjectHelper)projectHelper);
                List<WebProjectGenerator.WebModule> l = WebProjectGenerator.getWebmodules(projectHelper, aux);
                if (l != null) {
                    WebProjectGenerator.WebModule wm = l.get(0);
                    wm.classpath = WebClasspathPanel.this.getClasspath();
                    WebProjectGenerator.putWebModules(projectHelper, aux, l);
                }
                WebClasspathPanel.this.updateButtons();
            }
        };
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;

        public SimpleFileFilter(String description) {
            this.description = description;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            try {
                return FileUtil.isArchiveFile((URL)f.toURI().toURL());
            }
            catch (MalformedURLException mue) {
                Exceptions.printStackTrace((Throwable)mue);
                return false;
            }
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

