/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.NbLifecycleManager;
import org.netbeans.core.network.proxy.pac.PacParsingException;
import org.netbeans.core.network.proxy.pac.PacScriptEvaluator;
import org.netbeans.core.network.proxy.pac.PacScriptEvaluatorFactory;
import org.netbeans.core.network.proxy.pac.PacScriptEvaluatorNoProxy;
import org.netbeans.core.network.proxy.pac.PacValidationException;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ProxyAutoConfig {
    private static final Map<String, ProxyAutoConfig> file2pac = new HashMap<String, ProxyAutoConfig>(2);
    private static final RequestProcessor RP = new RequestProcessor(ProxyAutoConfig.class);
    private static final String PROTO_FILE = "file://";
    private static final Logger LOGGER = Logger.getLogger(ProxyAutoConfig.class.getName());
    private PacScriptEvaluator evaluator;
    private final RequestProcessor.Task initTask;
    private final URI pacURI;

    public static synchronized ProxyAutoConfig get(String pacFile) {
        if (file2pac.get(pacFile) == null) {
            LOGGER.fine("Init ProxyAutoConfig for " + pacFile);
            ProxyAutoConfig instance = null;
            try {
                instance = new ProxyAutoConfig(pacFile);
            }
            catch (URISyntaxException ex) {
                LOGGER.warning("Parsing " + pacFile + " to URI throws " + ex);
            }
            finally {
                file2pac.put(pacFile, instance);
            }
        }
        return file2pac.get(pacFile);
    }

    private ProxyAutoConfig(String pacURL) throws URISyntaxException {
        assert (file2pac.get(pacURL) == null) : "Only once object for " + pacURL + " must exist.";
        String normPAC = this.normalizePAC(pacURL);
        this.pacURI = new URI(normPAC);
        this.initTask = RP.post(new Runnable(){

            @Override
            public void run() {
                NbLifecycleManager.advancePolicy();
                ProxyAutoConfig.this.initEngine();
            }
        });
    }

    public URI getPacURI() {
        return this.pacURI;
    }

    final void initEngine() {
        PacScriptEvaluatorFactory factory;
        String pacSource = null;
        if (this.pacURI.isAbsolute()) {
            try (InputStream is = ProxyAutoConfig.downloadPAC(this.pacURI.toURL());){
                pacSource = ProxyAutoConfig.convertInputStreamToString(is, 8192, StandardCharsets.UTF_8);
            }
            catch (MalformedURLException ex) {
                LOGGER.log(Level.INFO, "PAC URL is malformed : ", ex);
                return;
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "InputStream for " + this.pacURI + " throws ", ex);
                return;
            }
        }
        if ((factory = (PacScriptEvaluatorFactory)Lookup.getDefault().lookup(PacScriptEvaluatorFactory.class)) == null) {
            LOGGER.log(Level.WARNING, "No PAC Script Evaluator factory found. Will use dummy evaluator instead.");
            this.evaluator = new PacScriptEvaluatorNoProxy();
        } else {
            try {
                this.evaluator = factory.createPacScriptEvaluator(pacSource);
            }
            catch (PacParsingException ex) {
                LOGGER.log(Level.WARNING, "There was a catastrophic error with the PAC script downloaded from " + this.pacURI + ". Will use dummy instead. Error was : ", ex);
                this.evaluator = factory.getNoOpEvaluator();
            }
        }
        assert (this.evaluator != null) : "JavaScript evaluator cannot be null";
        if (this.evaluator == null) {
            LOGGER.log(Level.WARNING, "JavaScript evaluator cannot be null");
        }
    }

    public List<Proxy> findProxyForURL(URI u) {
        assert (this.initTask != null) : "initTask has be to posted.";
        if (!this.initTask.isFinished()) {
            while (!this.initTask.isFinished()) {
                try {
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                        }
                    }).waitFinished(100L);
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.FINEST, ex.getMessage(), ex);
                }
            }
        }
        try {
            return this.evaluator.findProxyForURL(u);
        }
        catch (PacValidationException ex) {
            LOGGER.log(Level.WARNING, "Incorrect answer from PAC script : ", ex);
            return Collections.singletonList(Proxy.NO_PROXY);
        }
    }

    private static InputStream downloadPAC(URL pacURL) throws IOException {
        URLConnection conn = pacURL.openConnection(Proxy.NO_PROXY);
        InputStream is = conn.getInputStream();
        return is;
    }

    protected static String convertInputStreamToString(InputStream in, int initSize, Charset charset) throws IOException {
        int length;
        ByteArrayOutputStream buf = new ByteArrayOutputStream(initSize);
        byte[] buffer = new byte[1024];
        while ((length = in.read(buffer)) != -1) {
            buf.write(buffer, 0, length);
        }
        return buf.toString(charset.name());
    }

    private String normalizePAC(String pacURL) {
        File f;
        String fileLocation;
        String inputSanitized = pacURL;
        int index = inputSanitized.indexOf("\n");
        if (index != -1) {
            inputSanitized = inputSanitized.substring(0, index);
        }
        if ((index = inputSanitized.indexOf("\r")) != -1) {
            inputSanitized = inputSanitized.substring(0, index);
        }
        if ((fileLocation = pacURL).startsWith(PROTO_FILE)) {
            fileLocation = fileLocation.substring(PROTO_FILE.length());
        }
        if ((index = (inputSanitized = (f = new File(fileLocation)).canRead() ? Utilities.toURI((File)f).toString() : inputSanitized.replaceAll("\\\\", "/")).indexOf(" ")) != -1) {
            inputSanitized = inputSanitized.substring(0, index);
        }
        return inputSanitized.trim();
    }
}

