/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.ui;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.swing.JEditorPane;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.gsf.testrunner.ui.api.UICommonUtils;
import org.netbeans.modules.junit.api.JUnitTestUtil;
import org.netbeans.modules.junit.ui.TestAction;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class OpenTestAction
extends TestAction {
    public OpenTestAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected void performAction(Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            Object[] objectArray;
            String msgPattern;
            boolean isDefPkg;
            FileObject selectedFO = UICommonUtils.getFileObjectFromNode((Node)nodes[i]);
            if (selectedFO == null) {
                JUnitTestUtil.notifyUser((String)NbBundle.getMessage(OpenTestAction.class, (String)"MSG_file_from_node_failed"));
                continue;
            }
            ClassPath cp = ClassPath.getClassPath((FileObject)selectedFO, (String)"classpath/source");
            if (cp == null) {
                JUnitTestUtil.notifyUser((String)NbBundle.getMessage(OpenTestAction.class, (String)"MSG_no_project", (Object)selectedFO));
                continue;
            }
            FileObject packageRoot = cp.findOwnerRoot(selectedFO);
            URL[] testRoots = UnitTestForSourceQuery.findUnitTests((FileObject)packageRoot);
            FileObject fileToOpen = null;
            for (int j = 0; j < testRoots.length && (fileToOpen = OpenTestAction.findUnitTestInTestRoot(cp, selectedFO, testRoots[j])) == null; ++j) {
            }
            if (fileToOpen != null) {
                OpenTestAction.openFile(fileToOpen);
                continue;
            }
            String testClsName = OpenTestAction.getTestName(cp, selectedFO).replace('/', '.');
            String pkgName = cp.getResourceName(selectedFO, '.', false);
            boolean isPackage = selectedFO.isFolder();
            boolean bl = isDefPkg = isPackage && pkgName.length() == 0;
            String string = !isPackage ? "MSG_test_class_not_found" : (msgPattern = isDefPkg ? "MSG_testsuite_class_not_found_def_pkg" : "MSG_testsuite_class_not_found");
            if (isDefPkg) {
                Object[] objectArray2 = new String[1];
                objectArray = objectArray2;
                objectArray2[0] = testClsName;
            } else {
                String[] stringArray = new String[2];
                stringArray[0] = testClsName;
                objectArray = stringArray;
                stringArray[1] = pkgName;
            }
            Object[] params = objectArray;
            JUnitTestUtil.notifyUser((String)NbBundle.getMessage(OpenTestAction.class, (String)msgPattern, (Object[])params), (int)1);
        }
    }

    private static FileObject findUnitTestInTestRoot(ClassPath cp, FileObject selectedFO, URL testRoot) {
        ClassPath testClassPath = null;
        if (testRoot == null) {
            testClassPath = cp;
        } else {
            try {
                ArrayList<PathResourceImplementation> cpItems = new ArrayList<PathResourceImplementation>();
                cpItems.add(ClassPathSupport.createResource((URL)testRoot));
                testClassPath = ClassPathSupport.createClassPath(cpItems);
            }
            catch (IllegalArgumentException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                testClassPath = cp;
            }
        }
        String testName = OpenTestAction.getTestName(cp, selectedFO);
        return testClassPath.findResource(testName + ".java");
    }

    private static String getTestName(ClassPath cp, FileObject selectedFO) {
        String resource = cp.getResourceName(selectedFO, '/', false);
        String testName = null;
        testName = selectedFO.isFolder() ? JUnitTestUtil.convertPackage2SuiteName((String)resource) : JUnitTestUtil.convertClass2TestName((String)resource);
        return testName;
    }

    public static boolean openFile(FileObject fo) {
        DataObject dobj;
        try {
            dobj = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException e) {
            OpenTestAction.getLogger().log(Level.WARNING, null, e);
            return false;
        }
        assert (dobj != null);
        EditorCookie editorCookie = (EditorCookie)dobj.getCookie(EditorCookie.class);
        if (editorCookie != null) {
            editorCookie.open();
            return true;
        }
        OpenCookie openCookie = (OpenCookie)dobj.getCookie(OpenCookie.class);
        if (openCookie != null) {
            openCookie.open();
            return true;
        }
        return false;
    }

    static boolean openFileAtElement(FileObject fileObject, ElementHandle<Element> element) {
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException e) {
            OpenTestAction.getLogger().log(Level.INFO, null, e);
            return false;
        }
        assert (dataObject != null);
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie != null) {
            StyledDocument doc;
            try {
                doc = editorCookie.openDocument();
            }
            catch (IOException ex) {
                String msg = ex.getLocalizedMessage();
                if (msg == null) {
                    msg = ex.getMessage();
                }
                OpenTestAction.getLogger().log(Level.SEVERE, msg, ex);
                return false;
            }
            editorCookie.open();
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (lineCookie != null && element != null && doc != null) {
                int startPos;
                int lineNum;
                int currentPos = -1;
                JEditorPane[] editorPanes = editorCookie.getOpenedPanes();
                if (editorPanes != null && editorPanes.length != 0) {
                    currentPos = editorPanes[0].getCaretPosition();
                }
                int[] elementPositionBounds = null;
                try {
                    elementPositionBounds = OpenTestAction.getPositionRange(fileObject, element);
                }
                catch (IOException ex) {
                    OpenTestAction.getLogger().log(Level.WARNING, null, ex);
                }
                if ((currentPos == -1 || elementPositionBounds != null && (currentPos < elementPositionBounds[0] || currentPos >= elementPositionBounds[1])) && (lineNum = NbDocument.findLineNumber((StyledDocument)doc, (int)(startPos = elementPositionBounds[0]))) != -1) {
                    Line line = lineCookie.getLineSet().getCurrent(lineNum);
                    try {
                        int lineOffset = NbDocument.findLineOffset((StyledDocument)doc, (int)lineNum);
                        int column = startPos - lineOffset;
                        line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, column);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        Logger.getLogger(OpenTestAction.class.getName()).log(Level.INFO, null, ex);
                        line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                    }
                }
            }
            return true;
        }
        OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
        if (openCookie != null) {
            openCookie.open();
            return true;
        }
        return false;
    }

    private static Logger getLogger() {
        return Logger.getLogger(OpenTestAction.class.getName());
    }

    private static int[] getPositionRange(FileObject fileObj, ElementHandle<Element> elemHandle) throws IOException {
        PositionRangeFinder posFinder = new PositionRangeFinder(fileObj, elemHandle);
        JavaSource.forFileObject((FileObject)fileObj).runUserActionTask((Task)posFinder, true);
        return posFinder.getPositionRange();
    }

    public String getName() {
        return NbBundle.getMessage(OpenTestAction.class, (String)"LBL_Action_OpenTest");
    }

    protected String iconResource() {
        return "org/netbeans/modules/junit/resources/OpenTestActionIcon.gif";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(OpenTestAction.class);
    }

    protected void initialize() {
        super.initialize();
        this.putProperty("ShortDescription", NbBundle.getMessage(OpenTestAction.class, (String)"HINT_Action_OpenTest"));
    }

    private static class DeclarationTreeFinder
    extends ErrorAwareTreePathScanner<Void, Void> {
        private final Element element;
        private final Trees trees;
        private Tree declTree;

        private DeclarationTreeFinder(Element element, Trees trees) {
            this.element = element;
            this.trees = trees;
        }

        public Void visitClass(ClassTree tree, Void d) {
            if (this.declTree == null) {
                this.handleDeclaration();
                super.visitClass(tree, (Object)d);
            }
            return null;
        }

        public Void visitMethod(MethodTree tree, Void d) {
            if (this.declTree == null) {
                this.handleDeclaration();
                super.visitMethod(tree, (Object)d);
            }
            return null;
        }

        public void handleDeclaration() {
            Element found = this.trees.getElement(this.getCurrentPath());
            if (this.element.equals(found)) {
                this.declTree = this.getCurrentPath().getLeaf();
            }
        }

        Tree getDeclarationTree() {
            return this.declTree;
        }
    }

    private static class PositionRangeFinder
    implements CancellableTask<CompilationController> {
        private final FileObject fileObj;
        private final ElementHandle<Element> elemHandle;
        private int[] positionRange = null;
        private volatile boolean cancelled;

        private PositionRangeFinder(FileObject fileObj, ElementHandle<Element> elemHandle) {
            this.fileObj = fileObj;
            this.elemHandle = elemHandle;
        }

        public void run(CompilationController controller) throws IOException {
            try {
                controller.toPhase(JavaSource.Phase.RESOLVED);
            }
            catch (IOException ex) {
                Logger.getLogger("global").log(Level.SEVERE, null, ex);
            }
            if (this.cancelled) {
                return;
            }
            Element element = this.elemHandle.resolve((CompilationInfo)controller);
            if (this.cancelled || element == null) {
                return;
            }
            Trees trees = controller.getTrees();
            CompilationUnitTree compUnit = controller.getCompilationUnit();
            DeclarationTreeFinder treeFinder = new DeclarationTreeFinder(element, trees);
            treeFinder.scan(compUnit, null);
            Tree tree = treeFinder.getDeclarationTree();
            if (tree != null) {
                SourcePositions srcPositions = trees.getSourcePositions();
                long startPos = srcPositions.getStartPosition(compUnit, tree);
                long endPos = srcPositions.getEndPosition(compUnit, tree);
                if (startPos >= 0L && startPos <= Integer.MAX_VALUE && endPos >= 0L && endPos <= Integer.MAX_VALUE) {
                    this.positionRange = new int[2];
                    this.positionRange[0] = (int)startPos;
                    this.positionRange[1] = (int)endPos;
                }
            }
        }

        public void cancel() {
            this.cancelled = true;
        }

        int[] getPositionRange() {
            return this.positionRange;
        }
    }
}

