/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.infra.lib.registries.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import org.netbeans.installer.downloader.DownloadManager;
import org.netbeans.installer.infra.lib.registries.ManagerException;
import org.netbeans.installer.infra.lib.registries.RegistriesManager;
import org.netbeans.installer.infra.lib.registries.impl.DummyFinishHandler;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.product.RegistryNode;
import org.netbeans.installer.product.components.Group;
import org.netbeans.installer.product.components.Product;
import org.netbeans.installer.product.filters.RegistryFilter;
import org.netbeans.installer.product.filters.TrueFilter;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.applications.JavaUtils;
import org.netbeans.installer.utils.exceptions.FinalizationException;
import org.netbeans.installer.utils.exceptions.InitializationException;
import org.netbeans.installer.utils.exceptions.ParseException;
import org.netbeans.installer.utils.exceptions.XMLException;
import org.netbeans.installer.utils.helper.ExecutionResults;
import org.netbeans.installer.utils.helper.FinishHandler;
import org.netbeans.installer.utils.helper.Pair;
import org.netbeans.installer.utils.helper.Platform;
import org.netbeans.installer.utils.helper.Status;
import org.netbeans.installer.utils.helper.Version;
import org.netbeans.installer.utils.progress.Progress;

public class RegistriesManagerImpl
implements RegistriesManager {
    private static Map<File, ReentrantLock> locks = new HashMap<File, ReentrantLock>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getEngine(File root) throws ManagerException {
        ReentrantLock lock = this.getLock(root);
        try {
            lock.lock();
            this.initializeRegistryNoLock(root);
            File file = new File(root, "engine.jar");
            return file;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void updateEngine(File root, File archive) throws ManagerException {
        ReentrantLock lock = this.getLock(root);
        try {
            lock.lock();
            this.initializeRegistryNoLock(root);
            this.deleteBundles(root);
            FileUtils.copyFile((File)archive, (File)new File(root, "engine.jar"));
        }
        catch (IOException e) {
            throw new ManagerException(e);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void addPackage(File root, File archive, String parentUid, String parentVersion, String parentPlatforms) throws ManagerException {
        ReentrantLock lock = this.getLock(root);
        try {
            Group parent;
            lock.lock();
            this.initializeRegistryNoLock(root);
            this.deleteBundles(root);
            File tempDir = FileUtils.createTempFile((File)new File(root, "temp"), (boolean)false);
            File registryXml = new File(root, "registry.xml");
            File componentsDir = new File(root, "components");
            File archiveDir = FileUtils.createTempFile((File)new File(root, "temp"), (boolean)false);
            File archiveRegistryXml = new File(archiveDir, "registry.xml");
            FileUtils.unjar((File)archive, (File)archiveDir);
            FileUtils.modifyFile((File)archiveRegistryXml, (String)"(\\>)resource:(.*?\\<\\/)", (Object)("$1" + componentsDir.toURI() + "$2"), (boolean)true, (String)"UTF-8");
            Registry registry = new Registry();
            registry.setLocalDirectory(tempDir);
            registry.setFinishHandler((FinishHandler)DummyFinishHandler.INSTANCE);
            registry.loadProductRegistry(registryXml);
            Registry archiveRegistry = new Registry();
            archiveRegistry.setLocalDirectory(tempDir);
            archiveRegistry.setFinishHandler((FinishHandler)DummyFinishHandler.INSTANCE);
            archiveRegistry.loadProductRegistry(archiveRegistryXml);
            LinkedList<Object> nodes = new LinkedList<Object>();
            for (Product product : archiveRegistry.getProducts()) {
                List existingProducts = registry.getProducts(product.getUid(), product.getVersion(), product.getPlatforms());
                if (existingProducts.size() <= 0) continue;
                for (Product existingProduct : existingProducts) {
                    nodes.offer(existingProduct);
                }
            }
            for (Group group : archiveRegistry.getGroups()) {
                Group existingGroup;
                if (group.equals(archiveRegistry.getRegistryRoot()) || (existingGroup = registry.getGroup(group.getUid())) == null) continue;
                nodes.offer(existingGroup);
            }
            if (nodes.size() > 0) {
                while (nodes.peek() != null) {
                    String path;
                    Object temp;
                    RegistryNode node = (RegistryNode)nodes.poll();
                    node.getParent().removeChild(node);
                    if (node instanceof Product) {
                        temp = (Product)node;
                        path = "components/products/" + temp.getUid() + "/" + temp.getVersion() + "/" + StringUtils.asString((List)temp.getPlatforms(), (String)" ");
                        FileUtils.deleteFile((File)new File(root, path), (boolean)true);
                    }
                    if (node instanceof Group) {
                        temp = (Group)node;
                        path = "components/groups/" + temp.getUid();
                        FileUtils.deleteFile((File)new File(root, path), (boolean)true);
                    }
                    for (RegistryNode child : node.getChildren()) {
                        nodes.offer(child);
                    }
                }
            }
            File productsDir = new File(root, "components/products");
            FileUtils.mkdirs((File)productsDir);
            FileUtils.copyFile((File)new File(archiveDir, "products"), (File)productsDir, (boolean)true);
            File groupsDir = new File(root, "components/groups");
            FileUtils.mkdirs((File)groupsDir);
            FileUtils.copyFile((File)new File(archiveDir, "groups"), (File)groupsDir, (boolean)true);
            List parents = null;
            if (parentVersion != null && !parentVersion.equals("null") && parentPlatforms != null && !parentPlatforms.equals("null")) {
                parents = registry.getProducts(parentUid, Version.getVersion((String)parentVersion), StringUtils.parsePlatforms((String)parentPlatforms));
            }
            if (parents == null || parents.size() == 0) {
                parent = registry.getGroup(parentUid);
                if (parent == null) {
                    parent = registry.getRegistryRoot();
                }
            } else {
                parent = (RegistryNode)parents.get(0);
            }
            parent.attachRegistry(archiveRegistry);
            registry.saveProductRegistry(registryXml, (RegistryFilter)TrueFilter.INSTANCE, true, true, true);
            FileUtils.deleteFile((File)archiveDir, (boolean)true);
            FileUtils.deleteFile((File)tempDir, (boolean)true);
        }
        catch (IOException e) {
            throw new ManagerException(e);
        }
        catch (InitializationException e) {
            throw new ManagerException(e);
        }
        catch (ParseException e) {
            throw new ManagerException(e);
        }
        catch (XMLException e) {
            throw new ManagerException(e);
        }
        catch (FinalizationException e) {
            throw new ManagerException(e);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void removeProduct(File root, String uid, String version, String platforms) throws ManagerException {
        ReentrantLock lock = this.getLock(root);
        try {
            lock.lock();
            this.initializeRegistryNoLock(root);
            this.deleteBundles(root);
            File tempDir = FileUtils.createTempFile((File)new File(root, "temp"), (boolean)false);
            File registryXml = new File(root, "registry.xml");
            File productsDir = new File(root, "components/products");
            File groupsDir = new File(root, "components/groups");
            Registry registry = new Registry();
            registry.setLocalDirectory(tempDir);
            registry.setFinishHandler((FinishHandler)DummyFinishHandler.INSTANCE);
            registry.loadProductRegistry(registryXml);
            List existing = registry.getProducts(uid, Version.getVersion((String)version), StringUtils.parsePlatforms((String)platforms));
            if (existing != null) {
                ((Product)existing.get(0)).getParent().removeChild((RegistryNode)existing.get(0));
                LinkedList nodes = new LinkedList();
                nodes.offer(existing.get(0));
                while (nodes.peek() != null) {
                    File uidDir;
                    RegistryNode node = (RegistryNode)nodes.poll();
                    if (node instanceof Product) {
                        Product product = (Product)node;
                        uidDir = new File(productsDir, product.getUid());
                        File versionDir = new File(uidDir, product.getVersion().toString());
                        File platformsDir = new File(versionDir, StringUtils.asString((List)product.getPlatforms(), (String)" "));
                        FileUtils.deleteFile((File)platformsDir, (boolean)true);
                        if (FileUtils.isEmpty((File)versionDir)) {
                            FileUtils.deleteFile((File)versionDir, (boolean)true);
                        }
                        if (FileUtils.isEmpty((File)uidDir)) {
                            FileUtils.deleteFile((File)uidDir, (boolean)true);
                        }
                    }
                    if (node instanceof Group) {
                        Group group = (Group)node;
                        uidDir = new File(groupsDir, group.getUid());
                        FileUtils.deleteFile((File)uidDir, (boolean)true);
                    }
                    for (RegistryNode child : node.getChildren()) {
                        nodes.offer(child);
                    }
                }
            }
            registry.saveProductRegistry(registryXml, (RegistryFilter)TrueFilter.INSTANCE, true, true, true);
        }
        catch (IOException e) {
            throw new ManagerException(e);
        }
        catch (InitializationException e) {
            throw new ManagerException(e);
        }
        catch (ParseException e) {
            throw new ManagerException(e);
        }
        catch (FinalizationException e) {
            throw new ManagerException(e);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void removeGroup(File root, String uid) throws ManagerException {
        ReentrantLock lock = this.getLock(root);
        try {
            lock.lock();
            this.initializeRegistryNoLock(root);
            this.deleteBundles(root);
            File tempDir = FileUtils.createTempFile((File)new File(root, "temp"), (boolean)false);
            File registryXml = new File(root, "registry.xml");
            File productsDir = new File(root, "components/products");
            File groupsDir = new File(root, "components/groups");
            Registry registry = new Registry();
            registry.setLocalDirectory(tempDir);
            registry.setFinishHandler((FinishHandler)DummyFinishHandler.INSTANCE);
            registry.loadProductRegistry(registryXml);
            Group existing = registry.getGroup(uid);
            if (existing != null) {
                existing.getParent().removeChild((RegistryNode)existing);
                LinkedList<Object> nodes = new LinkedList<Object>();
                nodes.offer(existing);
                while (nodes.peek() != null) {
                    File uidDir;
                    RegistryNode node = (RegistryNode)nodes.poll();
                    if (node instanceof Product) {
                        Product product = (Product)node;
                        uidDir = new File(productsDir, product.getUid());
                        File versionDir = new File(uidDir, product.getVersion().toString());
                        File platformsDir = new File(versionDir, StringUtils.asString((List)product.getPlatforms(), (String)" "));
                        FileUtils.deleteFile((File)platformsDir, (boolean)true);
                        if (FileUtils.isEmpty((File)versionDir)) {
                            FileUtils.deleteFile((File)versionDir, (boolean)true);
                        }
                        if (FileUtils.isEmpty((File)uidDir)) {
                            FileUtils.deleteFile((File)uidDir, (boolean)true);
                        }
                    }
                    if (node instanceof Group) {
                        Group group = (Group)node;
                        uidDir = new File(groupsDir, group.getUid());
                        FileUtils.deleteFile((File)uidDir, (boolean)true);
                    }
                    for (RegistryNode child : node.getChildren()) {
                        nodes.offer(child);
                    }
                }
            }
            registry.saveProductRegistry(registryXml, (RegistryFilter)TrueFilter.INSTANCE, true, true, true);
        }
        catch (IOException e) {
            throw new ManagerException(e);
        }
        catch (InitializationException e) {
            throw new ManagerException(e);
        }
        catch (FinalizationException e) {
            throw new ManagerException(e);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File createBundle(File root, Platform platform, String[] components, Properties props, Properties bundleProps) throws ManagerException {
        ReentrantLock lock = this.getLock(root);
        try {
            lock.lock();
            this.initializeRegistryNoLock(root);
            File file = this.createBundleNoLock(root, platform, components, props, bundleProps);
            return file;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public File createBundle(File root, Platform platform, String[] components) throws ManagerException {
        return this.createBundle(root, platform, components, new Properties(), new Properties());
    }

    @Override
    public void generateBundles(File root) throws ManagerException {
        ReentrantLock lock = this.getLock(root);
        try {
            lock.lock();
            this.initializeRegistryNoLock(root);
            File tempDir = FileUtils.createTempFile((File)new File(root, "temp"), (boolean)false);
            File registryXml = new File(root, "registry.xml");
            for (Platform platform : Platform.values()) {
                Registry registry = new Registry();
                registry.setLocalDirectory(tempDir);
                registry.setFinishHandler((FinishHandler)DummyFinishHandler.INSTANCE);
                registry.loadProductRegistry(registryXml);
                List products = registry.getProducts(platform);
                for (int i = 1; i <= products.size(); ++i) {
                    Product[] combination = new Product[i];
                    this.iterate(platform, root, registry, combination, 0, products, 0);
                }
            }
        }
        catch (IOException e) {
            throw new ManagerException(e);
        }
        catch (InitializationException e) {
            throw new ManagerException(e);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void deleteBundles(File root) throws ManagerException {
        ReentrantLock lock = this.getLock(root);
        try {
            lock.lock();
            this.initializeRegistryNoLock(root);
            this.deleteBudlesNoLock(root);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void initializeRegistry(File root) throws ManagerException {
        ReentrantLock lock = this.getLock(root);
        try {
            lock.lock();
            this.initializeRegistryNoLock(root);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public File exportRegistry(File root, File destination, String codebase) throws ManagerException {
        ReentrantLock lock = this.getLock(root);
        try {
            lock.lock();
            this.initializeRegistryNoLock(root);
            File registryXml = new File(root, "registry.xml");
            File tempDir = FileUtils.createTempFile((File)new File(root, "temp"), (boolean)true, (boolean)true);
            File tempUserDir = FileUtils.createTempFile((File)tempDir, (boolean)false);
            File tempRegistryXml = FileUtils.createTempFile((File)tempDir, (boolean)false);
            FileUtils.mkdirs((File)destination.getParentFile());
            Registry registry = new Registry();
            registry.setLocalDirectory(tempUserDir);
            registry.setFinishHandler((FinishHandler)DummyFinishHandler.INSTANCE);
            registry.loadProductRegistry(registryXml);
            registry.saveProductRegistry(tempRegistryXml, (RegistryFilter)TrueFilter.INSTANCE, false, true, true);
            FileUtils.copyFile((File)new File(root, "components"), (File)new File(destination, "components"), (boolean)true);
            String replacement = codebase.endsWith("/") ? codebase : codebase + "/";
            FileUtils.modifyFile((File)tempRegistryXml, (String)("uri>" + root.toURI().toString()), (Object)("uri>" + replacement), (String)"UTF-8");
            FileUtils.copyFile((File)tempRegistryXml, (File)new File(destination, "registry.xml"));
            FileUtils.copyFile((File)new File(root, "engine.jar"), (File)new File(destination, "engine.jar"));
            FileUtils.deleteFile((File)tempUserDir);
            FileUtils.deleteFile((File)tempRegistryXml);
            File file = destination;
            return file;
        }
        catch (IOException e) {
            throw new ManagerException(e);
        }
        catch (InitializationException e) {
            throw new ManagerException(e);
        }
        catch (FinalizationException e) {
            throw new ManagerException(e);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public String generateComponentsJs(File root) throws ManagerException {
        return this.generateComponentsJs(root, null, null);
    }

    @Override
    public String generateComponentsJs(File root, File bundlesList) throws ManagerException {
        return this.generateComponentsJs(root, bundlesList, null);
    }

    @Override
    public String generateComponentsJs(File root, File bundlesList, String localeString) throws ManagerException {
        Properties props = new Properties();
        try {
            if (bundlesList != null) {
                FileInputStream is = new FileInputStream(bundlesList);
                props.load(is);
                is.close();
            }
        }
        catch (IOException e) {
            throw new ManagerException(e);
        }
        LinkedList<Pair> bundles = new LinkedList<Pair>();
        for (Object key : props.keySet()) {
            Object value = props.get(key);
            List list = StringUtils.asList((String)value.toString());
            bundles.add(new Pair((Object)list, (Object)key.toString()));
        }
        HashMap notes = new HashMap();
        Locale locale = StringUtils.parseLocale((String)(localeString == null ? "" : localeString));
        ReentrantLock lock = this.getLock(root);
        try {
            int i;
            lock.lock();
            File tempDir = FileUtils.createTempFile((File)new File(root, "temp"), (boolean)true, (boolean)true);
            File tempUserDir = FileUtils.createTempFile((File)tempDir, (boolean)true, (boolean)true);
            StringBuilder out = new StringBuilder();
            Registry registry = this.loadRegistry(root, tempUserDir, Platform.GENERIC);
            List<Product> products = this.getProducts(registry.getRegistryRoot());
            List<Group> groups = this.getGroups(registry.getRegistryRoot());
            HashMap<Integer, Integer> productMapping = new HashMap<Integer, Integer>();
            LinkedList<String> productUids = new LinkedList<String>();
            LinkedList<String> productVersions = new LinkedList<String>();
            LinkedList<String> productDisplayNames = new LinkedList<String>();
            LinkedList<String> productNotes = new LinkedList<String>();
            LinkedList<String> productDescriptions = new LinkedList<String>();
            LinkedList<String> productDownloadSizes = new LinkedList<String>();
            LinkedList<List> productPlatforms = new LinkedList<List>();
            LinkedList<String> productProperties = new LinkedList<String>();
            LinkedList<Integer> defaultGroupProducts = new LinkedList<Integer>();
            LinkedList groupProducts = new LinkedList();
            LinkedList<String> groupDisplayNames = new LinkedList<String>();
            LinkedList<String> groupDescriptions = new LinkedList<String>();
            for (i = 0; i < products.size(); ++i) {
                Product product = products.get(i);
                boolean existingFound = false;
                for (int j = 0; j < productUids.size(); ++j) {
                    if (!((String)productUids.get(j)).equals(product.getUid()) || !((String)productVersions.get(j)).equals(product.getVersion().toString())) continue;
                    ((List)productPlatforms.get(j)).addAll(product.getPlatforms());
                    productMapping.put(i, j);
                    existingFound = true;
                    break;
                }
                if (existingFound) continue;
                long size = (long)Math.ceil((double)product.getDownloadSize() / 1024.0);
                productUids.add(product.getUid());
                productVersions.add(product.getVersion().toString());
                productDisplayNames.add(product.getDisplayName(locale).replace("\"", "\\\"").replaceAll("\r\n|\r|\n", "\\\n"));
                productDescriptions.add(product.getDescription(locale).replace("\"", "\\\"").replaceAll("\r\n|\r|\n", "\\\n"));
                productDownloadSizes.add(Long.toString(size));
                productPlatforms.add(product.getPlatforms());
                if (notes.get(product.getUid()) != null) {
                    productNotes.add(((String)notes.get(product.getUid())).replace("\"", "\\\"").replaceAll("\r\n|\r|\n", "\\\n"));
                } else {
                    productNotes.add("");
                }
                String properties = "PROPERTY_NONE";
                for (Pair pair : bundles) {
                    if (!((List)pair.getFirst()).contains(product.getUid())) continue;
                    properties = properties + " | PROPERTY_" + (String)pair.getSecond();
                }
                productProperties.add(properties);
                productMapping.put(i, productUids.size() - 1);
            }
            for (i = 0; i < productUids.size(); ++i) {
                out.append("add_product_info(\n");
                out.append("                 \"" + (String)productUids.get(i) + "\",\n");
                out.append("                 \"" + (String)productVersions.get(i) + "\",\n");
                out.append("                 \"" + (String)productDisplayNames.get(i) + "\",\n");
                out.append("                 \"" + (String)productNotes.get(i) + "\",\n");
                out.append("                 \"" + (String)productDescriptions.get(i) + "\",\n");
                out.append("                 " + (String)productDownloadSizes.get(i) + ",\n");
                out.append("                 \"" + StringUtils.asString((List)((List)productPlatforms.get(i))) + "\");\n");
                out.append("\n");
            }
            for (i = 0; i < productUids.size(); ++i) {
                defaultGroupProducts.add(i);
            }
            for (Group group : groups) {
                LinkedList<Integer> components = new LinkedList<Integer>();
                for (int i2 = 0; i2 < products.size(); ++i2) {
                    Integer index;
                    if (!products.get(i2).getParent().equals(group) || components.contains(index = Integer.valueOf((Integer)productMapping.get(i2)))) continue;
                    components.add(index);
                    defaultGroupProducts.remove(index);
                }
                groupProducts.add(components);
                groupDisplayNames.add(group.getDisplayName(locale).replace("\"", "\\\"").replaceAll("\r\n|\r|\n", "\\\n"));
                groupDescriptions.add(group.getDescription(locale).replace("\"", "\\\"").replaceAll("\r\n|\r|\n", "\\\n"));
            }
            if (defaultGroupProducts.size() > 0) {
                groupProducts.add(0, defaultGroupProducts);
                groupDisplayNames.add(0, "");
                groupDescriptions.add(0, "");
            }
            out.append("\n");
            for (int i3 = 0; i3 < groupProducts.size(); ++i3) {
                LinkedList uids = new LinkedList();
                for (int j = 0; j < ((List)groupProducts.get(i3)).size(); ++j) {
                    uids.add(productUids.get((Integer)((List)groupProducts.get(i3)).get(j)));
                }
                out.append("add_group_info(\n");
                out.append("               \"" + StringUtils.asString(uids) + "\",\n");
                out.append("               \"" + (String)groupDisplayNames.get(i3) + "\",\n");
                out.append("               \"" + (String)groupDescriptions.get(i3) + "\");\n");
                out.append("\n");
            }
            out.append("\n");
            for (Pair pair : bundles) {
                List uids = (List)pair.getFirst();
                String bundleId = (String)pair.getSecond();
                out.append("add_bundle_info(\"" + bundleId + "\", \"" + StringUtils.asString((List)uids) + "\");\n");
            }
            String string = out.toString();
            return string;
        }
        catch (IOException e) {
            throw new ManagerException(e);
        }
        finally {
            lock.unlock();
        }
    }

    private synchronized ReentrantLock getLock(File root) {
        if (locks.get(root) == null) {
            locks.put(root, new ReentrantLock());
        }
        return locks.get(root);
    }

    private File createBundleNoLock(File root, Platform platform, String[] components, Properties props, Properties bundleProps) throws ManagerException {
        try {
            String key = "" + platform.getCodeName() + ": " + StringUtils.asString((Object[])components);
            File bundlesListFile = new File(root, "bundles.list");
            List bundlesList = FileUtils.readStringList((File)bundlesListFile);
            if (bundlesList.contains(key)) {
                return new File((String)bundlesList.get(bundlesList.indexOf(key) + 1));
            }
            File registryXml = new File(root, "registry.xml");
            File tempDir = FileUtils.createTempFile((File)new File(root, "temp"), (boolean)true, (boolean)true);
            File tempUserDir = FileUtils.createTempFile((File)tempDir, (boolean)true, (boolean)true);
            File tempStatefile = FileUtils.createTempFile((File)tempDir, (boolean)false);
            File bundle = new File(FileUtils.createTempFile((File)new File(root, "bundles"), (boolean)false), "bundle.jar");
            Registry registry = new Registry();
            registry.setLocalDirectory(tempUserDir);
            registry.setFinishHandler((FinishHandler)DummyFinishHandler.INSTANCE);
            registry.setTargetPlatform(platform);
            registry.loadProductRegistry(registryXml);
            LinkedList<Product> products = new LinkedList<Product>();
            for (String string : components) {
                String[] parts = string.split(",");
                System.out.println("    processing: " + string);
                Product product = registry.getProduct(parts[0], Version.getVersion((String)parts[1]));
                products.add(product);
                product.setStatus(Status.INSTALLED);
            }
            registry.saveStateFile(tempStatefile, new Progress());
            bundle.getParentFile().mkdirs();
            File javaHome = new File(System.getProperty("java.home"));
            File tempPropertiesFile = FileUtils.createTempFile((File)tempDir, (boolean)false);
            FileOutputStream os = new FileOutputStream(tempPropertiesFile);
            props.store(os, null);
            ((OutputStream)os).close();
            File tempBundlePropertiesFile = FileUtils.createTempFile((File)tempDir, (boolean)false);
            os = new FileOutputStream(tempBundlePropertiesFile);
            bundleProps.store(os, null);
            ((OutputStream)os).close();
            ExecutionResults results = SystemUtils.executeCommand((String[])new String[]{JavaUtils.getExecutable((File)javaHome).getAbsolutePath(), "-Dnbi.product.remote.registries=" + registryXml.toURI(), "-jar", this.getEngine(root).getAbsolutePath(), "--silent", "--state", tempStatefile.getAbsolutePath(), "--create-bundle", bundle.getAbsolutePath(), "--ignore-lock", "--platform", platform.toString(), "--userdir", tempUserDir.getAbsolutePath(), "--properties", tempPropertiesFile.getAbsolutePath(), "--bundle-properties", tempBundlePropertiesFile.getAbsolutePath()});
            if (results.getErrorCode() != 0) {
                throw new ManagerException("Could not create bundle - error in running the engine.\nOutput:\n" + results.getStdOut() + "\nStderr:\n" + results.getStdErr());
            }
            FileUtils.deleteFile((File)tempStatefile);
            FileUtils.deleteFile((File)tempPropertiesFile);
            FileUtils.deleteFile((File)tempBundlePropertiesFile);
            FileUtils.deleteFile((File)tempUserDir, (boolean)true);
            bundle = platform.isCompatibleWith(Platform.WINDOWS) ? new File(bundle.getAbsolutePath().replaceFirst("\\.jar$", ".exe")) : (platform.isCompatibleWith(Platform.MACOSX) ? new File(bundle.getAbsolutePath().replaceFirst("\\.jar$", ".zip")) : new File(bundle.getAbsolutePath().replaceFirst("\\.jar$", ".sh")));
            if (!bundle.exists()) {
                throw new ManagerException("Could not create bundle.\nOutput:\n" + results.getStdOut() + "\nStderr:\n" + results.getStdErr());
            }
            bundlesList.add(key);
            bundlesList.add(bundle.getAbsolutePath());
            FileUtils.writeStringList((File)bundlesListFile, (List)bundlesList);
            return bundle;
        }
        catch (IOException e) {
            throw new ManagerException(e);
        }
        catch (InitializationException e) {
            throw new ManagerException(e);
        }
        catch (FinalizationException e) {
            throw new ManagerException(e);
        }
    }

    private void deleteBudlesNoLock(File root) throws ManagerException {
        try {
            FileUtils.writeFile((File)new File(root, "bundles.list"), (CharSequence)"");
            FileUtils.deleteFile((File)new File(root, "bundles"), (boolean)true);
            FileUtils.mkdirs((File)new File(root, "bundles"));
        }
        catch (IOException e) {
            throw new ManagerException(e);
        }
    }

    private void initializeRegistryNoLock(File root) throws ManagerException {
        try {
            File components;
            File bundles;
            File bundlesList;
            File temp;
            if (!root.exists()) {
                FileUtils.mkdirs((File)root);
            }
            if (!(temp = new File(root, "temp")).exists()) {
                FileUtils.mkdirs((File)temp);
            }
            DownloadManager.getInstance().setLocalDirectory(temp);
            DownloadManager.getInstance().setFinishHandler((FinishHandler)DummyFinishHandler.INSTANCE);
            System.setProperty("nbi.local.directory.path", temp.getAbsolutePath());
            System.setProperty("nbi.ignore.lock.file", "true");
            System.setProperty("nbi.utils.log.to.console", "false");
            System.setProperty("nbi.product.lazy.load.icons", "true");
            File registryXml = new File(root, "registry.xml");
            if (!registryXml.exists()) {
                new Registry().saveProductRegistry(registryXml, (RegistryFilter)TrueFilter.INSTANCE, true, true, true);
            }
            if (!(bundlesList = new File(root, "bundles.list")).exists()) {
                FileUtils.writeFile((File)bundlesList, (CharSequence)"");
            }
            if (!(bundles = new File(root, "bundles")).exists()) {
                FileUtils.mkdirs((File)bundles);
            }
            if (!(components = new File(root, "components")).exists()) {
                FileUtils.mkdirs((File)components);
            }
        }
        catch (FinalizationException e) {
            throw new ManagerException(e);
        }
        catch (IOException e) {
            throw new ManagerException(e);
        }
    }

    private Registry loadRegistry(File root, File tempUserDir, Platform platform) throws ManagerException {
        try {
            File registryXml = new File(root, "registry.xml");
            Registry registry = new Registry();
            registry.setLocalDirectory(tempUserDir);
            registry.setFinishHandler((FinishHandler)DummyFinishHandler.INSTANCE);
            registry.setTargetPlatform(platform);
            registry.loadProductRegistry(registryXml);
            return registry;
        }
        catch (InitializationException e) {
            throw new ManagerException(e);
        }
    }

    private void iterate(Platform platform, File root, Registry registry, Product[] combination, int index, List<Product> products, int start) throws ManagerException {
        for (int i = start; i < products.size(); ++i) {
            combination[index] = products.get(i);
            if (index == combination.length - 1) {
                for (Product product : products) {
                    product.setStatus(Status.NOT_INSTALLED);
                }
                for (Product product : combination) {
                    product.setStatus(Status.TO_BE_INSTALLED);
                }
                if (registry.getProductsToInstall().size() != combination.length) continue;
                String[] components = new String[combination.length];
                for (int j = 0; j < combination.length; ++j) {
                    components[j] = combination[j].getUid() + "," + combination[j].getVersion().toString();
                }
                this.createBundle(root, platform, components);
                continue;
            }
            this.iterate(platform, root, registry, combination, index + 1, products, i + 1);
        }
    }

    private List<Product> getProducts(RegistryNode root) {
        LinkedList<Product> list = new LinkedList<Product>();
        for (RegistryNode node : root.getChildren()) {
            if (node instanceof Product) {
                list.add((Product)node);
            }
            list.addAll(this.getProducts(node));
        }
        return list;
    }

    private List<Group> getGroups(RegistryNode root) {
        LinkedList<Group> list = new LinkedList<Group>();
        for (RegistryNode node : root.getChildren()) {
            if (node instanceof Group) {
                list.add((Group)node);
            }
            list.addAll(this.getGroups(node));
        }
        return list;
    }
}

