/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model.query;

import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.parser.EncapsulatedIdentificationVariableExpression;
import org.eclipse.persistence.jpa.jpql.tools.model.query.AbstractSingleEncapsulatedExpressionStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.IdentificationVariableStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedType;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeDeclaration;

public abstract class EncapsulatedIdentificationVariableExpressionStateObject
extends AbstractSingleEncapsulatedExpressionStateObject {
    private String identificationVariable;
    private IManagedType managedType;
    private IType type;
    private ITypeDeclaration typeDeclaration;
    public static final String IDENTIFICATION_VARIABLE_PROPERTY = "identificationVariable";

    protected EncapsulatedIdentificationVariableExpressionStateObject(StateObject parent) {
        super(parent);
    }

    protected EncapsulatedIdentificationVariableExpressionStateObject(StateObject parent, String identificationVariable) {
        super(parent);
        this.setIdentificationVariable(identificationVariable);
    }

    protected void checkIntegrity() {
        if (ExpressionTools.stringsAreDifferentIgnoreCase(this.identificationVariable, this.getStateObject().getText())) {
            this.clearResolvedObjects();
            this.identificationVariable = this.getStateObject().getText();
        }
    }

    protected void clearResolvedObjects() {
        this.type = null;
        this.managedType = null;
        this.typeDeclaration = null;
    }

    public EncapsulatedIdentificationVariableExpression getExpression() {
        return (EncapsulatedIdentificationVariableExpression)super.getExpression();
    }

    public String getIdentificationVariable() {
        this.identificationVariable = this.getStateObject().getText();
        return this.identificationVariable;
    }

    public IManagedType getManagedType() {
        if (this.managedType != null) {
            this.checkIntegrity();
        }
        if (this.managedType == null) {
            this.managedType = this.resolveManagedType();
        }
        return this.managedType;
    }

    protected String getQueryBNFId() {
        return "identification_variable";
    }

    public IdentificationVariableStateObject getStateObject() {
        return (IdentificationVariableStateObject)super.getStateObject();
    }

    public IType getType() {
        if (this.type != null) {
            this.checkIntegrity();
        }
        if (this.type == null) {
            this.type = this.resolveType();
        }
        return this.type;
    }

    public ITypeDeclaration getTypeDeclaration() {
        if (this.typeDeclaration != null) {
            this.checkIntegrity();
        }
        if (this.typeDeclaration == null) {
            this.typeDeclaration = this.resolveTypeDeclaration();
        }
        return this.typeDeclaration;
    }

    public boolean hasIdentificationVariable() {
        return ExpressionTools.stringIsNotEmpty(this.getIdentificationVariable());
    }

    protected void initialize() {
        super.initialize();
        this.setStateObject(new IdentificationVariableStateObject(this));
    }

    protected IManagedType resolveManagedType() {
        return this.getManagedTypeProvider().getManagedType(this.getType());
    }

    protected IType resolveType() {
        return this.getTypeDeclaration().getType();
    }

    protected ITypeDeclaration resolveTypeDeclaration() {
        return this.getStateObject().getTypeDeclaration();
    }

    public void setIdentificationVariable(String identificationVariable) {
        this.clearResolvedObjects();
        String oldIdentificationVariable = this.identificationVariable;
        this.identificationVariable = identificationVariable;
        this.getStateObject().setText(identificationVariable);
        this.firePropertyChanged(IDENTIFICATION_VARIABLE_PROPERTY, oldIdentificationVariable, identificationVariable);
    }
}

