/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.ui;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.analysis.commands.CodeSniffer;
import org.netbeans.modules.php.analysis.ui.Bundle;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.util.StringUtils;
import org.openide.util.RequestProcessor;

public final class CodeSnifferStandardsComboBoxModel
extends AbstractListModel<String>
implements ComboBoxModel<String> {
    private static final long serialVersionUID = -35785646574684544L;
    static final Logger LOGGER = Logger.getLogger(CodeSnifferStandardsComboBoxModel.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(CodeSnifferStandardsComboBoxModel.class);
    private static final String FETCHING_STANDARDS = Bundle.CodeSnifferStandardsComboBoxModel_standards_fetching();
    private static final String NO_STANDARDS_AVAILABLE = Bundle.CodeSnifferStandardsComboBoxModel_standards_none();
    private final List<String> standards = new ArrayList<String>();
    volatile String selectedStandard = null;

    public CodeSnifferStandardsComboBoxModel() {
        assert (EventQueue.isDispatchThread());
        this.setFetchingStandards();
    }

    @Override
    public int getSize() {
        assert (EventQueue.isDispatchThread());
        return this.standards.size();
    }

    @Override
    public String getElementAt(int index) {
        assert (EventQueue.isDispatchThread());
        return this.standards.get(index);
    }

    @Override
    public void setSelectedItem(final Object anItem) {
        if (anItem == null) {
            return;
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String standard = (String)anItem;
                        if (!standard.equals(CodeSnifferStandardsComboBoxModel.this.selectedStandard) && CodeSnifferStandardsComboBoxModel.this.standards.contains(standard)) {
                            CodeSnifferStandardsComboBoxModel.this.selectedStandard = standard;
                            CodeSnifferStandardsComboBoxModel.this.fireContentsChanged();
                        }
                    }
                });
            }
        });
    }

    @Override
    @CheckForNull
    public String getSelectedItem() {
        return this.selectedStandard;
    }

    @CheckForNull
    public String getSelectedStandard() {
        if (this.selectedStandard == NO_STANDARDS_AVAILABLE || this.selectedStandard == FETCHING_STANDARDS || this.selectedStandard.isEmpty()) {
            return null;
        }
        return this.selectedStandard;
    }

    public void fetchStandards(JComboBox<String> component) {
        this.fetchStandards(component, null);
    }

    public void fetchStandards(JComboBox<String> component, @NullAllowed Runnable postTask) {
        this.fetchStandards(component, null, postTask);
    }

    public void fetchStandards(final JComboBox<String> component, final @NullAllowed String customCodeSnifferPath, final @NullAllowed Runnable postTask) {
        assert (EventQueue.isDispatchThread());
        assert (component != null);
        component.setEnabled(false);
        RP.post(new Runnable(){

            @Override
            public void run() {
                List<String> fetchedStandards = null;
                try {
                    CodeSniffer codeSniffer = StringUtils.hasText((String)customCodeSnifferPath) ? CodeSniffer.getCustom(customCodeSnifferPath) : CodeSniffer.getDefault();
                    fetchedStandards = codeSniffer.getStandards();
                }
                catch (InvalidPhpExecutableException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                }
                final ArrayList<String> standardsRef = fetchedStandards == null ? null : new ArrayList<String>(fetchedStandards);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        assert (EventQueue.isDispatchThread());
                        component.setEnabled(true);
                        if (standardsRef == null) {
                            CodeSnifferStandardsComboBoxModel.this.setNoStandards();
                            component.setPrototypeDisplayValue(NO_STANDARDS_AVAILABLE);
                        } else {
                            standardsRef.add(0, "");
                            CodeSnifferStandardsComboBoxModel.this.setStandards(standardsRef);
                        }
                        if (postTask != null) {
                            postTask.run();
                        }
                    }
                });
            }
        });
    }

    void setFetchingStandards() {
        assert (EventQueue.isDispatchThread());
        this.standards.clear();
        this.standards.add(FETCHING_STANDARDS);
        this.selectedStandard = FETCHING_STANDARDS;
        this.fireContentsChanged();
    }

    void setNoStandards() {
        assert (EventQueue.isDispatchThread());
        this.standards.clear();
        this.standards.add(NO_STANDARDS_AVAILABLE);
        this.selectedStandard = NO_STANDARDS_AVAILABLE;
        this.fireContentsChanged();
    }

    void setStandards(List<String> standards) {
        assert (EventQueue.isDispatchThread());
        this.standards.clear();
        this.standards.addAll(standards);
        if (!standards.isEmpty()) {
            this.selectedStandard = standards.get(0);
        }
        this.fireContentsChanged();
    }

    void fireContentsChanged() {
        this.fireContentsChanged(this, -1, -1);
    }
}

