/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.server.state;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import org.netbeans.modules.payara.tooling.TaskEvent;
import org.netbeans.modules.payara.tooling.TaskState;
import org.netbeans.modules.payara.tooling.data.PayaraStatusCheck;
import org.netbeans.modules.payara.tooling.data.PayaraStatusCheckResult;
import org.netbeans.modules.payara.tooling.logging.Logger;
import org.netbeans.modules.payara.tooling.server.state.AbstractTask;
import org.netbeans.modules.payara.tooling.server.state.StatusJob;
import org.netbeans.modules.payara.tooling.server.state.StatusResult;

class AdminPortTask
extends AbstractTask {
    private static final Logger LOGGER = new Logger(AdminPortTask.class);
    private final String TM_SUFFIX = "Tm";
    private final String TASK_NAME = "port-check";
    int timeout;
    private StatusResult result;
    private long tmStart;

    static String tm(long tm) {
        StringBuilder sb = new StringBuilder(8);
        sb.append(Long.toString(tm / 1000L));
        sb.append('.');
        sb.append(Long.toString(tm % 1000L));
        return sb.toString();
    }

    AdminPortTask(StatusJob job, StatusJob.Task task, int timeout) {
        super(job, task, PayaraStatusCheck.PORT);
        this.timeout = timeout;
        this.result = null;
        this.tmStart = -1L;
    }

    StatusResult getResult() {
        return this.result;
    }

    String[] stateChangeArgs(String exMessage) {
        return new String[]{this.job.getStatus().getServer().getHost(), "port-check", exMessage, Boolean.toString(false)};
    }

    private void closeSocket(Socket socket) {
        String METHOD = "closeSocket";
        try {
            socket.close();
        }
        catch (IOException ioe) {
            this.handleIOException(ioe, this.job.getStatus().getServer().getHost(), this.job.getStatus().getServer().getAdminPort(), "closeSocket", "failed");
        }
    }

    private void handleIOException(IOException ioe, String host, int port, String method, String message) {
        if (this.tmStart >= 0L && LOGGER.isLoggable(Level.FINEST)) {
            StringBuilder sb = new StringBuilder(message.length() + "Tm".length());
            sb.append(message).append("Tm");
            long tm = System.currentTimeMillis() - this.tmStart;
            LOGGER.log(Level.FINEST, method, sb.toString(), new Object[]{AdminPortTask.tm(tm), host, Integer.toString(port), ioe.getMessage()});
        } else {
            LOGGER.log(Level.FINEST, method, message, new Object[]{host, Integer.toString(port), ioe.getMessage()});
        }
        this.result = new StatusResult(PayaraStatusCheckResult.FAILED, TaskEvent.EXCEPTION);
        this.handleStateChange(TaskState.FAILED, TaskEvent.EXCEPTION, this.stateChangeArgs(ioe.getLocalizedMessage()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String METHOD = "run";
        if (this.cancelled) {
            LOGGER.log(Level.FINER, "run", "cancelled");
            throw new IllegalStateException(LOGGER.excMsg("run", "cancelled"));
        }
        LOGGER.log(Level.FINER, "run", "started", new String[]{this.job.getStatus().getServer().getName(), this.jobState.toString()});
        String host = this.job.getStatus().getServer().getHost();
        int port = this.job.getStatus().getServer().getAdminPort();
        if (port < 0 || host == null) {
            this.result = new StatusResult(PayaraStatusCheckResult.FAILED);
            this.handleStateChange(TaskState.FAILED, TaskEvent.CMD_FAILED, this.stateChangeArgs(null));
        }
        this.tmStart = System.currentTimeMillis();
        InetSocketAddress sa = new InetSocketAddress(host, port);
        Socket socket = new Socket();
        try {
            socket.connect(sa, this.timeout);
            socket.setSoTimeout(this.timeout);
        }
        catch (ConnectException ce) {
            this.handleIOException(ce, host, port, "run", "connect");
            return;
        }
        catch (SocketTimeoutException ste) {
            this.handleIOException(ste, host, port, "run", "timeout");
            return;
        }
        catch (IOException ioe) {
            this.handleIOException(ioe, host, port, "run", "ioException");
            return;
        }
        finally {
            this.closeSocket(socket);
        }
        if (this.tmStart >= 0L && LOGGER.isLoggable(Level.FINEST)) {
            long tm = System.currentTimeMillis() - this.tmStart;
            LOGGER.log(Level.FINEST, "run", "success", new Object[]{AdminPortTask.tm(tm), this.jobState.toString(), host, Integer.toString(port)});
        }
        this.result = new StatusResult(PayaraStatusCheckResult.SUCCESS, TaskEvent.CMD_COMPLETED);
        this.handleStateChange(TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, this.stateChangeArgs(null));
    }
}

