/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.admin;

import java.io.File;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.modules.payara.tooling.PayaraIdeException;
import org.netbeans.modules.payara.tooling.TaskStateListener;
import org.netbeans.modules.payara.tooling.admin.Command;
import org.netbeans.modules.payara.tooling.admin.CommandTargetName;
import org.netbeans.modules.payara.tooling.admin.ResultString;
import org.netbeans.modules.payara.tooling.admin.RunnerHttpClass;
import org.netbeans.modules.payara.tooling.admin.RunnerHttpDeploy;
import org.netbeans.modules.payara.tooling.admin.RunnerRestClass;
import org.netbeans.modules.payara.tooling.admin.RunnerRestDeploy;
import org.netbeans.modules.payara.tooling.admin.ServerAdmin;
import org.netbeans.modules.payara.tooling.data.PayaraServer;

@RunnerHttpClass(runner=RunnerHttpDeploy.class)
@RunnerRestClass(runner=RunnerRestDeploy.class)
public class CommandDeploy
extends CommandTargetName {
    private static final String COMMAND = "deploy";
    private static final String ERROR_MESSAGE = "Application deployment failed.";
    final File path;
    final String contextRoot;
    final Map<String, String> properties;
    final File[] libraries;
    final boolean dirDeploy;

    public static ResultString deploy(PayaraServer server, File application, TaskStateListener listener) throws PayaraIdeException {
        CommandDeploy command = new CommandDeploy(null, null, application, null, null, null);
        Future future = ServerAdmin.exec(server, (Command)command, listener);
        try {
            return (ResultString)future.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException ie) {
            throw new PayaraIdeException(ERROR_MESSAGE, ie);
        }
    }

    public CommandDeploy(String name, String target, File path, String contextRoot, Map<String, String> properties, File[] libraries) {
        super(COMMAND, name, target);
        this.path = path;
        this.contextRoot = contextRoot;
        this.properties = properties;
        this.libraries = libraries;
        this.dirDeploy = path.isDirectory();
    }
}

