/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.support;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

public class HttpSessionHandshakeInterceptor
implements HandshakeInterceptor {
    private static Log logger = LogFactory.getLog(HttpSessionHandshakeInterceptor.class);
    private Collection<String> attributeNames;

    public HttpSessionHandshakeInterceptor() {
        this(null);
    }

    public HttpSessionHandshakeInterceptor(Collection<String> attributeNames) {
        this.attributeNames = attributeNames;
    }

    @Override
    public boolean beforeHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Map<String, Object> attributes) throws Exception {
        ServletServerHttpRequest servletRequest;
        HttpSession session;
        if (request instanceof ServletServerHttpRequest && (session = (servletRequest = (ServletServerHttpRequest)request).getServletRequest().getSession(false)) != null) {
            Enumeration names = session.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (CollectionUtils.isEmpty(this.attributeNames) || this.attributeNames.contains(name)) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Adding HTTP session attribute to handshake attributes: " + name));
                    }
                    attributes.put(name, session.getAttribute(name));
                    continue;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)"Skipped HTTP session attribute");
            }
        }
        return true;
    }

    @Override
    public void afterHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Exception ex) {
    }
}

