/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.callhierarchy;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.refactoring.java.callhierarchy.CallHierarchyModel;
import org.netbeans.modules.refactoring.java.callhierarchy.CallHierarchyTasks;
import org.netbeans.modules.refactoring.java.callhierarchy.CallNode;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.ListView;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class CallHierarchyTopComponent
extends TopComponent
implements ExplorerManager.Provider {
    private static CallHierarchyTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/refactoring/java/resources/callhierarchy.png";
    private static final String PREFERRED_ID = "CallHierarchyTopComponent";
    private final ExplorerManager manager;
    private final ExplorerManager managerCtx = new ExplorerManager();
    private CallHierarchyModel model;
    private BeanTreeView beanTreeView;
    private ButtonGroup buttonGroupScope;
    private JButton jBtnCancel;
    private JButton jBtnRefresh;
    private JCheckBoxMenuItem jMenuItemBaseClass;
    private JRadioButtonMenuItem jMenuItemCurrProject;
    private JRadioButtonMenuItem jMenuItemFilterAll;
    private JCheckBoxMenuItem jMenuItemUnitTests;
    private JPopupMenu jPopupMenuScope;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JSplitPane jSplitPane1;
    private JToggleButton jTogBtnCallee;
    private JToggleButton jTogBtnCaller;
    private JToggleButton jTogBtnScope;
    private JToolBar jToolBar;
    private ListView listView;
    private PropertyChangeListener modelListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName() == "root") {
                CallHierarchyTopComponent.this.switchRootNode();
            }
        }
    };

    private CallHierarchyTopComponent() {
        this.manager = new ExplorerManager();
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)this.getActionMap()));
        this.initComponents();
        this.jBtnRefresh.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/refactoring/api/resources/refresh.png", (boolean)false));
        ContextPanel ctxpanel = new ContextPanel();
        ctxpanel.setLayout(new BorderLayout());
        ctxpanel.add((Component)this.listView, "Center");
        this.jSplitPane1.setRightComponent(ctxpanel);
        Dimension dim = new Dimension(24, 24);
        this.jBtnRefresh.setMaximumSize(dim);
        this.jTogBtnCaller.setMaximumSize(dim);
        this.jTogBtnCallee.setMaximumSize(dim);
        this.jTogBtnScope.setMaximumSize(dim);
        this.jBtnCancel.setMaximumSize(dim);
        this.jBtnRefresh.setPreferredSize(dim);
        this.jTogBtnCaller.setPreferredSize(dim);
        this.jTogBtnCallee.setPreferredSize(dim);
        this.jTogBtnScope.setPreferredSize(dim);
        this.jBtnCancel.setPreferredSize(dim);
        this.setName(NbBundle.getMessage(CallHierarchyTopComponent.class, (String)"CTL_CallHierarchyTopComponent"));
        this.setToolTipText(NbBundle.getMessage(CallHierarchyTopComponent.class, (String)"HINT_CallHierarchyTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.jPopupMenuScope.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                CallHierarchyTopComponent.this.jTogBtnScope.setSelected(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                CallHierarchyTopComponent.this.jTogBtnScope.setSelected(false);
            }
        });
        this.manager.setRootContext((Node)CallNode.createDefault());
        this.manager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Node[] selectedNodes = CallHierarchyTopComponent.this.manager.getSelectedNodes();
                if (selectedNodes.length == 1) {
                    CallHierarchyTopComponent.this.managerCtx.setRootContext((Node)new FilterNode(selectedNodes[0], (Children)new CallNode.CallChildren(true)));
                } else {
                    CallHierarchyTopComponent.this.managerCtx.setRootContext((Node)CallNode.createPleaseWait());
                }
            }
        });
    }

    private void initComponents() {
        this.jPopupMenuScope = new JPopupMenu();
        this.jMenuItemFilterAll = new JRadioButtonMenuItem();
        this.jMenuItemCurrProject = new JRadioButtonMenuItem();
        this.jMenuItemUnitTests = new JCheckBoxMenuItem();
        this.jMenuItemBaseClass = new JCheckBoxMenuItem();
        this.buttonGroupScope = new ButtonGroup();
        this.listView = new ListView();
        this.jToolBar = new JToolBar();
        this.jBtnRefresh = new JButton();
        this.jBtnCancel = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jTogBtnCaller = new JToggleButton();
        this.jTogBtnCallee = new JToggleButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jTogBtnScope = new JToggleButton();
        this.jSplitPane1 = new JSplitPane();
        this.beanTreeView = new BeanTreeView();
        FormListener formListener = new FormListener();
        this.buttonGroupScope.add(this.jMenuItemFilterAll);
        this.jMenuItemFilterAll.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jMenuItemFilterAll, (String)NbBundle.getMessage(CallHierarchyTopComponent.class, (String)"CallHierarchyTopComponent.jMenuItemFilterAll.text"));
        this.jMenuItemFilterAll.addActionListener(formListener);
        this.jPopupMenuScope.add(this.jMenuItemFilterAll);
        this.buttonGroupScope.add(this.jMenuItemCurrProject);
        Mnemonics.setLocalizedText((AbstractButton)this.jMenuItemCurrProject, (String)NbBundle.getMessage(CallHierarchyTopComponent.class, (String)"CallHierarchyTopComponent.jMenuItemCurrProject.text"));
        this.jMenuItemCurrProject.addActionListener(formListener);
        this.jPopupMenuScope.add(this.jMenuItemCurrProject);
        this.jMenuItemUnitTests.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jMenuItemUnitTests, (String)NbBundle.getMessage(CallHierarchyTopComponent.class, (String)"CallHierarchyTopComponent.jMenuItemUnitTests.text"));
        this.jMenuItemUnitTests.addActionListener(formListener);
        this.jPopupMenuScope.add(this.jMenuItemUnitTests);
        this.jMenuItemBaseClass.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jMenuItemBaseClass, (String)NbBundle.getMessage(CallHierarchyTopComponent.class, (String)"CallHierarchyTopComponent.jMenuItemBaseClass.text"));
        this.jMenuItemBaseClass.addActionListener(formListener);
        this.jPopupMenuScope.add(this.jMenuItemBaseClass);
        this.setLayout(new BorderLayout());
        this.jToolBar.setFloatable(false);
        this.jToolBar.setOrientation(1);
        this.jToolBar.setRollover(true);
        this.jBtnRefresh.setToolTipText(NbBundle.getMessage(CallHierarchyTopComponent.class, (String)"CallHierarchyTopComponent.jBtnRefresh.toolTipText"));
        this.jBtnRefresh.setFocusable(false);
        this.jBtnRefresh.addActionListener(formListener);
        this.jToolBar.add(this.jBtnRefresh);
        this.jBtnCancel.setIcon(ImageUtilities.loadImageIcon((String)"/org/netbeans/modules/refactoring/java/resources/cancel.png", (boolean)false));
        this.jBtnCancel.setToolTipText(NbBundle.getMessage(CallHierarchyTopComponent.class, (String)"CallHierarchyTopComponent.jBtnCancel.toolTipText"));
        this.jBtnCancel.setEnabled(false);
        this.jBtnCancel.setFocusable(false);
        this.jBtnCancel.setHorizontalTextPosition(0);
        this.jBtnCancel.setVerticalTextPosition(3);
        this.jBtnCancel.addActionListener(formListener);
        this.jToolBar.add(this.jBtnCancel);
        this.jToolBar.add(this.jSeparator1);
        this.jTogBtnCaller.setIcon(ImageUtilities.loadImageIcon((String)"/org/netbeans/modules/refactoring/java/resources/who_is_called.png", (boolean)false));
        this.jTogBtnCaller.setSelected(true);
        this.jTogBtnCaller.setToolTipText(NbBundle.getMessage(CallHierarchyTopComponent.class, (String)"CallHierarchyTopComponent.jTogBtnCaller.toolTipText"));
        this.jTogBtnCaller.setFocusable(false);
        this.jTogBtnCaller.addActionListener(formListener);
        this.jToolBar.add(this.jTogBtnCaller);
        this.jTogBtnCallee.setIcon(ImageUtilities.loadImageIcon((String)"/org/netbeans/modules/refactoring/java/resources/who_calls.png", (boolean)false));
        this.jTogBtnCallee.setToolTipText(NbBundle.getMessage(CallHierarchyTopComponent.class, (String)"CallHierarchyTopComponent.jTogBtnCallee.toolTipText"));
        this.jTogBtnCallee.setFocusable(false);
        this.jTogBtnCallee.addActionListener(formListener);
        this.jToolBar.add(this.jTogBtnCallee);
        this.jToolBar.add(this.jSeparator2);
        this.jTogBtnScope.setIcon(ImageUtilities.loadImageIcon((String)"/org/netbeans/modules/refactoring/java/resources/filter.png", (boolean)false));
        this.jTogBtnScope.setToolTipText(NbBundle.getMessage(CallHierarchyTopComponent.class, (String)"CallHierarchyTopComponent.jTogBtnScope.toolTipText"));
        this.jTogBtnScope.setFocusable(false);
        this.jTogBtnScope.addItemListener(formListener);
        this.jToolBar.add(this.jTogBtnScope);
        this.add(this.jToolBar, "West");
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setLeftComponent((Component)this.beanTreeView);
        this.add(this.jSplitPane1, "Center");
    }

    private void jBtnRefreshActionPerformed(ActionEvent evt) {
        if (this.model != null) {
            this.model.replaceRoot();
        }
    }

    private void jTogBtnCallerActionPerformed(ActionEvent evt) {
        this.jTogBtnCallee.setSelected(false);
        if (this.model != null) {
            this.model.setType(CallHierarchyModel.HierarchyType.CALLER);
        }
    }

    private void jTogBtnCalleeActionPerformed(ActionEvent evt) {
        this.jTogBtnCaller.setSelected(false);
        if (this.model != null) {
            this.model.setType(CallHierarchyModel.HierarchyType.CALLEE);
        }
    }

    private void jTogBtnScopeItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.jPopupMenuScope.show(this.jTogBtnScope, 0, this.jTogBtnScope.getHeight());
        }
    }

    private void jBtnCancelActionPerformed(ActionEvent evt) {
        CallHierarchyTasks.stop();
    }

    private void jMenuItemScopeActionPerformed(ActionEvent evt) {
        if (this.model != null) {
            this.model.setScopes(this.getScopes());
        }
    }

    private void jMenuItemBaseClassActionPerformed(ActionEvent evt) {
        if (this.model != null) {
            this.model.setScopes(this.getScopes());
            this.model.replaceRoot();
        }
    }

    public static synchronized CallHierarchyTopComponent getDefault() {
        if (instance == null) {
            instance = new CallHierarchyTopComponent();
        }
        return instance;
    }

    public static synchronized CallHierarchyTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(CallHierarchyTopComponent.class.getName()).warning("Cannot find CallHierarchyTopComponent component. It will not be located properly in the window system.");
            return CallHierarchyTopComponent.getDefault();
        }
        if (win instanceof CallHierarchyTopComponent) {
            return (CallHierarchyTopComponent)win;
        }
        Logger.getLogger(CallHierarchyTopComponent.class.getName()).warning("There seem to be multiple components with the 'CallHierarchyTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return CallHierarchyTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CallHierarchyTopComponent.this.jSplitPane1.setDividerLocation(0.8);
                CallHierarchyTopComponent.this.jSplitPane1.setResizeWeight(1.0);
            }
        });
    }

    public void componentClosed() {
        this.jBtnCancelActionPerformed(null);
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.beanTreeView.requestFocusInWindow();
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void setModel(CallHierarchyModel model) {
        if (this.model != null) {
            this.model.removePropertyChangeListener(this.modelListener);
        }
        if (model != null) {
            model.addPropertyChangeListener(this.modelListener);
        }
        this.model = model;
        this.switchRootNode();
    }

    public void reset() {
        CallHierarchyTasks.stop();
        this.manager.setRootContext((Node)CallNode.createPleaseWait());
    }

    public Node getRootNode() {
        return this.manager.getRootContext();
    }

    private void switchRootNode() {
        Node root = CallNode.createRoot(this.model);
        this.manager.setRootContext(root);
        try {
            this.manager.setSelectedNodes(new Node[]{root});
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    CallHierarchyModel.HierarchyType getHierarchyType() {
        return this.jTogBtnCaller.isSelected() ? CallHierarchyModel.HierarchyType.CALLER : CallHierarchyModel.HierarchyType.CALLEE;
    }

    void setRunningState(boolean isRunning) {
        this.makeBusy(isRunning);
        this.jBtnCancel.setVisible(isRunning);
        this.jBtnCancel.setEnabled(isRunning);
        this.jBtnRefresh.setVisible(!isRunning);
    }

    Set<CallHierarchyModel.Scope> getScopes() {
        HashSet<CallHierarchyModel.Scope> scopes = new HashSet<CallHierarchyModel.Scope>();
        if (this.jMenuItemFilterAll.isSelected()) {
            scopes.add(CallHierarchyModel.Scope.ALL);
        } else if (this.jMenuItemCurrProject.isSelected()) {
            scopes.add(CallHierarchyModel.Scope.PROJECT);
        }
        if (this.jMenuItemUnitTests.isSelected()) {
            scopes.add(CallHierarchyModel.Scope.TESTS);
        }
        if (this.jMenuItemBaseClass.isSelected()) {
            scopes.add(CallHierarchyModel.Scope.BASE);
        }
        return scopes;
    }

    private final class ContextPanel
    extends JPanel
    implements ExplorerManager.Provider {
        private ContextPanel() {
        }

        public ExplorerManager getExplorerManager() {
            return CallHierarchyTopComponent.this.managerCtx;
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return CallHierarchyTopComponent.getDefault();
        }
    }

    private class FormListener
    implements ActionListener,
    ItemListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == CallHierarchyTopComponent.this.jBtnRefresh) {
                CallHierarchyTopComponent.this.jBtnRefreshActionPerformed(evt);
            } else if (evt.getSource() == CallHierarchyTopComponent.this.jBtnCancel) {
                CallHierarchyTopComponent.this.jBtnCancelActionPerformed(evt);
            } else if (evt.getSource() == CallHierarchyTopComponent.this.jTogBtnCaller) {
                CallHierarchyTopComponent.this.jTogBtnCallerActionPerformed(evt);
            } else if (evt.getSource() == CallHierarchyTopComponent.this.jTogBtnCallee) {
                CallHierarchyTopComponent.this.jTogBtnCalleeActionPerformed(evt);
            } else if (evt.getSource() == CallHierarchyTopComponent.this.jMenuItemFilterAll) {
                CallHierarchyTopComponent.this.jMenuItemScopeActionPerformed(evt);
            } else if (evt.getSource() == CallHierarchyTopComponent.this.jMenuItemCurrProject) {
                CallHierarchyTopComponent.this.jMenuItemScopeActionPerformed(evt);
            } else if (evt.getSource() == CallHierarchyTopComponent.this.jMenuItemUnitTests) {
                CallHierarchyTopComponent.this.jMenuItemScopeActionPerformed(evt);
            } else if (evt.getSource() == CallHierarchyTopComponent.this.jMenuItemBaseClass) {
                CallHierarchyTopComponent.this.jMenuItemBaseClassActionPerformed(evt);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            if (evt.getSource() == CallHierarchyTopComponent.this.jTogBtnScope) {
                CallHierarchyTopComponent.this.jTogBtnScopeItemStateChanged(evt);
            }
        }
    }
}

