/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mylyn.util;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.netbeans.modules.bugtracking.commons.AttachmentsPanel;
import org.netbeans.modules.bugtracking.spi.IssueScheduleInfo;
import org.netbeans.modules.bugtracking.spi.IssueStatusProvider;
import org.netbeans.modules.mylyn.util.MylynSupport;
import org.netbeans.modules.mylyn.util.NbDateRange;
import org.netbeans.modules.mylyn.util.NbTask;
import org.netbeans.modules.mylyn.util.NbTaskDataModel;
import org.netbeans.modules.mylyn.util.NbTaskDataState;
import org.netbeans.modules.mylyn.util.NbTaskListener;
import org.netbeans.modules.mylyn.util.TaskDataListener;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public abstract class AbstractNbTaskWrapper {
    static final String ATTR_NEW_UNREAD = "NetBeans.task.markedNewUnread";
    private static final Object MODEL_LOCK = new Object();
    private static final Logger LOG = Logger.getLogger(AbstractNbTaskWrapper.class.getName());
    private static final RequestProcessor RP = new RequestProcessor("NBTasks");
    public static final String NEW_ATTACHMENT_ATTRIBUTE_ID = "nb.attachments.new";
    private static final String NB_NEW_ATTACHMENT_PATCH_ATTR_ID = "nb.newattachment.patch";
    private static final String NB_NEW_ATTACHMENT_FILE_ATTR_ID = "nb.newattachment.file";
    private static final String NB_NEW_ATTACHMENT_CONTENT_TYPE_ATTR_ID = "nb.newattachment.contentType";
    private static final String NB_NEW_ATTACHMENT_DESC_ATTR_ID = "nb.newattachment.desc";
    private static final String NB_NEW_ATTACHMENT_ATTR_ID = "nb.newattachment.";
    private NbTask task;
    private NbTaskDataModel model;
    private NbTaskDataModel.NbTaskDataModelListener list;
    private boolean readPending;
    private final TaskDataListenerImpl taskDataListener;
    private final TaskListenerImpl taskListener;
    private Reference<TaskData> repositoryDataRef;
    private final RequestProcessor.Task repositoryTaskDataLoaderTask;
    private final PropertyChangeSupport support;
    private String privateNotes;
    private Date dueDate;
    private boolean dueDateModified;
    private NbDateRange scheduleDate;
    private boolean scheduleDateModified;
    private Integer estimate;

    public AbstractNbTaskWrapper(NbTask task) {
        this.task = task;
        this.repositoryDataRef = new SoftReference<Object>(null);
        this.support = new PropertyChangeSupport(this);
        this.repositoryTaskDataLoaderTask = RP.create(new Runnable(){

            @Override
            public void run() {
                AbstractNbTaskWrapper.this.loadRepositoryTaskData();
            }
        });
        MylynSupport mylynSupp = MylynSupport.getInstance();
        this.taskDataListener = new TaskDataListenerImpl();
        mylynSupp.addTaskDataListener((TaskDataListener)WeakListeners.create(TaskDataListener.class, (EventListener)this.taskDataListener, (Object)mylynSupp));
        this.taskListener = new TaskListenerImpl();
        task.addNbTaskListener((NbTaskListener)WeakListeners.create(NbTaskListener.class, (EventListener)this.taskListener, (Object)mylynSupp));
    }

    public static String getID(NbTask task) {
        if (task.isUnsubmittedRepositoryTask()) {
            return "-" + task.getTaskId();
        }
        return task.getTaskId();
    }

    protected static boolean attachmentAttributesDiffer(TaskAttribute ta1, TaskAttribute ta2) {
        String value2;
        boolean changes;
        if (ta2 == null) {
            return true;
        }
        String value1 = ta1.getValue();
        boolean bl = changes = !value1.equals(value2 = ta2.getValue());
        if (!changes) {
            for (TaskAttribute childTA : ta1.getAttributes().values()) {
                if (!AbstractNbTaskWrapper.attachmentAttributesDiffer(childTA, ta2.getAttribute(childTA.getId()))) continue;
                changes = true;
                break;
            }
        }
        return changes;
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    protected final TaskData getRepositoryTaskData() {
        TaskData taskData = this.repositoryDataRef.get();
        if (taskData == null) {
            if (EventQueue.isDispatchThread()) {
                this.repositoryTaskDataLoaderTask.schedule(100);
            } else {
                return this.loadRepositoryTaskData();
            }
        }
        return taskData;
    }

    private TaskData loadRepositoryTaskData() {
        assert (!EventQueue.isDispatchThread());
        TaskData td = this.repositoryDataRef.get();
        if (td != null) {
            return td;
        }
        try {
            NbTaskDataState taskDataState = this.task.getTaskDataState();
            if (taskDataState != null) {
                td = taskDataState.getRepositoryData();
                this.repositoryDataRef = new SoftReference<TaskData>(td);
                this.repositoryTaskDataLoaded(td);
            }
        }
        catch (CoreException ex) {
            LOG.log(Level.WARNING, null, ex);
        }
        return td;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void deleteTask() {
        assert (this.task.isLocal()) : "Only local tasks can be deleted: " + this.task.getDelegate().getConnectorKind();
        Object object = MODEL_LOCK;
        synchronized (object) {
            if (this.list != null) {
                this.model.removeNbTaskDataModelListener(this.list);
                this.list = null;
            }
            this.model = null;
        }
        MylynSupport mylynSupp = MylynSupport.getInstance();
        mylynSupp.removeTaskDataListener(this.taskDataListener);
        this.task.removeNbTaskListener(this.taskListener);
        if (this.task.isLocal()) {
            this.task.delete();
            this.taskDeleted(this.task);
            this.fireDeleted();
        }
    }

    protected abstract void taskDeleted(NbTask var1);

    public final boolean isMarkedNewUnread() {
        return this.task.isLocal() && Boolean.TRUE.toString().equals(this.task.getAttribute(ATTR_NEW_UNREAD));
    }

    public final boolean isNew() {
        return this.task.isUnsubmittedRepositoryTask();
    }

    protected final void markNewRead() {
        this.task.setAttribute(ATTR_NEW_UNREAD, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setUpToDate(boolean seen, boolean markReadPending) {
        Object object = MODEL_LOCK;
        synchronized (object) {
            NbTask.SynchronizationState syncState;
            this.readPending = markReadPending ? (this.readPending |= (syncState = this.task.getSynchronizationState()) == NbTask.SynchronizationState.INCOMING || syncState == NbTask.SynchronizationState.CONFLICT) : false;
            this.task.markSeen(seen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean editorOpened() {
        this.list = new NbTaskDataModel.NbTaskDataModelListener(){

            @Override
            public void attributeChanged(NbTaskDataModel.NbTaskDataModelEvent event) {
                NbTaskDataModel m = AbstractNbTaskWrapper.this.model;
                if (event.getModel() == m) {
                    AbstractNbTaskWrapper.this.attributeChanged(event, m);
                }
            }
        };
        if (this.task.getSynchronizationState() == NbTask.SynchronizationState.INCOMING_NEW) {
            this.setUpToDate(true, false);
        }
        Object object = MODEL_LOCK;
        synchronized (object) {
            NbTask nbTask = this.getNbTask();
            synchronized (nbTask) {
                if (this.readPending) {
                    this.setUpToDate(false, false);
                    if (this.task.getDelegate() instanceof AbstractTask) {
                        ((AbstractTask)this.task.getDelegate()).setMarkReadPending(false);
                    }
                }
                this.model = this.task.getTaskDataModel();
                if (this.model == null) {
                    if (!this.synchronizeTask()) {
                        return false;
                    }
                    this.model = this.task.getTaskDataModel();
                }
                if (this.model == null) {
                    LOG.log(Level.WARNING, "no model even after synchronizing {0}", this.task.getTaskId());
                    return false;
                }
                this.model.addNbTaskDataModelListener(this.list);
            }
            try {
                MylynSupport.getInstance().editorOpened(this.task.getDelegate());
            }
            catch (CoreException ex) {
                LOG.log(Level.WARNING, null, ex);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void editorClosed() {
        NbTaskDataModel m = this.model;
        boolean markedAsNewUnread = this.isMarkedNewUnread();
        if (m != null) {
            if (this.list != null) {
                m.removeNbTaskDataModelListener(this.list);
                this.list = null;
            }
            this.readPending = false;
            if (markedAsNewUnread) {
                this.deleteTask();
            } else {
                if (m.isDirty()) {
                    try {
                        this.save();
                    }
                    catch (CoreException ex) {
                        LOG.log(Level.WARNING, null, ex);
                    }
                }
                try {
                    MylynSupport.getInstance().editorClosing(this.task.getDelegate(), m.getRepositoryTaskData());
                }
                catch (CoreException ex) {
                    LOG.log(Level.WARNING, null, ex);
                }
                Object object = MODEL_LOCK;
                synchronized (object) {
                    if (this.model == m) {
                        this.model = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void runWithModelLoaded(Runnable runnable) {
        Object object = MODEL_LOCK;
        synchronized (object) {
            boolean closeModel = false;
            try {
                if (this.model == null) {
                    closeModel = true;
                    this.model = this.task.getTaskDataModel();
                }
                runnable.run();
            }
            finally {
                if (closeModel) {
                    if (this.model != null && this.model.isDirty()) {
                        try {
                            this.model.save();
                        }
                        catch (CoreException ex) {
                            LOG.log(Level.INFO, null, ex);
                        }
                    }
                    this.model = null;
                }
            }
        }
    }

    protected abstract void attributeChanged(NbTaskDataModel.NbTaskDataModelEvent var1, NbTaskDataModel var2);

    private void save() throws CoreException {
        NbTaskDataModel m = this.model;
        if (m == null) {
            m = this.task.getTaskDataModel();
        }
        this.markNewRead();
        boolean modified = this.persistPrivateTaskAttributes();
        if (m.isDirty()) {
            if (this.isNew()) {
                String summary = this.task.getSummary();
                String newSummary = this.getSummary(m.getLocalTaskData());
                if (newSummary != null && !newSummary.isEmpty() && !newSummary.equals(summary)) {
                    this.task.setSummary(newSummary);
                    this.taskModified(false);
                }
            }
            m.save();
            this.modelSaved(m);
        }
        if (modified) {
            this.taskModified(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void taskSubmitted(NbTask task) {
        if (task != null && task != this.task) {
            this.task.removeNbTaskListener(this.taskListener);
            this.task = task;
            task.addNbTaskListener(this.taskListener);
            Object object = MODEL_LOCK;
            synchronized (object) {
                if (this.list != null) {
                    this.model.removeNbTaskDataModelListener(this.list);
                }
                this.model = task.getTaskDataModel();
                this.repositoryDataRef.clear();
                if (this.list != null) {
                    this.model.addNbTaskDataModelListener(this.list);
                }
            }
        }
    }

    protected final boolean saveChanges() {
        try {
            this.save();
            return true;
        }
        catch (CoreException ex) {
            LOG.log(Level.WARNING, null, ex);
            return false;
        }
    }

    public final boolean cancelChanges() {
        try {
            if (this.saveChanges()) {
                this.task.discardLocalEdits();
                this.model.refresh();
                return true;
            }
        }
        catch (CoreException ex) {
            LOG.log(Level.WARNING, null, ex);
        }
        return false;
    }

    public final void clearUnsavedChanges() {
        this.clearPrivateTaskAttributeChanges();
        this.model.clearUnsavedChanges();
    }

    public final boolean hasLocalEdits() {
        NbTaskDataModel m = this.model;
        return m != null && !m.getChangedAttributes().isEmpty();
    }

    public final boolean hasUnsavedChanges() {
        NbTaskDataModel m = this.model;
        return m != null && m.isDirty() || this.hasUnsavedPrivateTaskAttributes();
    }

    protected final boolean updateModel() {
        try {
            this.model.refresh();
            MylynSupport.getInstance().editorOpened(this.task.getDelegate());
            return true;
        }
        catch (CoreException ex) {
            LOG.log(Level.INFO, null, ex);
            return false;
        }
    }

    protected abstract void modelSaved(NbTaskDataModel var1);

    protected abstract String getSummary(TaskData var1);

    protected abstract void taskDataUpdated();

    protected final boolean isSeen() {
        NbTask.SynchronizationState syncState = this.task.getSynchronizationState();
        return syncState == NbTask.SynchronizationState.OUTGOING || syncState == NbTask.SynchronizationState.OUTGOING_NEW || syncState == NbTask.SynchronizationState.SYNCHRONIZED;
    }

    protected abstract void taskModified(boolean var1);

    protected final NbTaskDataModel getModel() {
        return this.model;
    }

    protected abstract void repositoryTaskDataLoaded(TaskData var1);

    protected final NbTask getNbTask() {
        return this.task;
    }

    public final long getCreated() {
        Date createdDate = this.getCreatedDate();
        if (createdDate != null) {
            return createdDate.getTime();
        }
        return -1L;
    }

    public final Date getCreatedDate() {
        return this.task.getCreationDate();
    }

    public final long getLastModify() {
        Date lastModifyDate = this.getLastModifyDate();
        if (lastModifyDate != null) {
            return lastModifyDate.getTime();
        }
        return -1L;
    }

    public final Date getLastModifyDate() {
        return this.task.getModificationDate();
    }

    public final String getSummary() {
        return this.task.getSummary();
    }

    public final String getID() {
        return AbstractNbTaskWrapper.getID(this.task);
    }

    public final boolean isFinished() {
        return this.task.isCompleted();
    }

    protected final NbTask.SynchronizationState getSynchronizationState() {
        return this.task.getSynchronizationState();
    }

    public final IssueStatusProvider.Status getStatus() {
        switch (this.getSynchronizationState()) {
            case CONFLICT: {
                return IssueStatusProvider.Status.CONFLICT;
            }
            case INCOMING: {
                return IssueStatusProvider.Status.INCOMING_MODIFIED;
            }
            case INCOMING_NEW: {
                return IssueStatusProvider.Status.INCOMING_NEW;
            }
            case OUTGOING: {
                return IssueStatusProvider.Status.OUTGOING_MODIFIED;
            }
            case OUTGOING_NEW: {
                return IssueStatusProvider.Status.OUTGOING_NEW;
            }
            case SYNCHRONIZED: {
                return IssueStatusProvider.Status.SEEN;
            }
        }
        return null;
    }

    protected abstract boolean synchronizeTask();

    protected final boolean setNewAttachments(List<AttachmentsPanel.AttachmentInfo> newAttachments) {
        NbTaskDataModel m = this.getModel();
        TaskData td = m.getLocalTaskData();
        TaskAttribute ta = td.getRoot().getAttribute(NEW_ATTACHMENT_ATTRIBUTE_ID);
        Map previousAttachments = Collections.emptyMap();
        if (ta != null) {
            previousAttachments = ta.getAttributes();
            ta.clearAttributes();
        }
        boolean retval = false;
        if (newAttachments.isEmpty() && !previousAttachments.isEmpty()) {
            m.attributeChanged(ta);
            retval = true;
        } else if (!newAttachments.isEmpty()) {
            if (ta == null) {
                ta = td.getRoot().createAttribute(NEW_ATTACHMENT_ATTRIBUTE_ID);
            }
            boolean present = true;
            block0: for (int i = 0; i < newAttachments.size(); ++i) {
                AttachmentsPanel.AttachmentInfo att = newAttachments.get(i);
                TaskAttribute attAttr = ta.createAttribute(NB_NEW_ATTACHMENT_ATTR_ID + i);
                if (att.getDescription() != null) {
                    attAttr.createAttribute(NB_NEW_ATTACHMENT_DESC_ATTR_ID).setValue(att.getDescription());
                }
                if (att.getContentType() != null) {
                    attAttr.createAttribute(NB_NEW_ATTACHMENT_CONTENT_TYPE_ATTR_ID).setValue(att.getContentType());
                }
                if (att.getFile() != null) {
                    attAttr.createAttribute(NB_NEW_ATTACHMENT_FILE_ATTR_ID).setValue(att.getFile().getAbsolutePath());
                }
                attAttr.createAttribute(NB_NEW_ATTACHMENT_PATCH_ATTR_ID).setValue(att.isPatch() ? "1" : "0");
                if (!present) continue;
                present = false;
                for (TaskAttribute previousAttachment : previousAttachments.values()) {
                    if (AbstractNbTaskWrapper.attachmentAttributesDiffer(previousAttachment, ta)) continue;
                    present = true;
                    continue block0;
                }
            }
            if (!present || previousAttachments.size() != newAttachments.size()) {
                m.attributeChanged(ta);
                retval = true;
            }
        }
        return retval;
    }

    protected final List<AttachmentsPanel.AttachmentInfo> getNewAttachments() {
        TaskAttribute ta;
        NbTaskDataModel m = this.getModel();
        TaskData td = m == null ? null : m.getLocalTaskData();
        List<AttachmentsPanel.AttachmentInfo> attachments = Collections.emptyList();
        if (td != null && (ta = td.getRoot().getAttribute(NEW_ATTACHMENT_ATTRIBUTE_ID)) != null) {
            Map attributes = ta.getAttributes();
            attachments = new ArrayList<AttachmentsPanel.AttachmentInfo>(attributes.size());
            for (TaskAttribute attAttr : attributes.values()) {
                AttachmentsPanel.AttachmentInfo attInfo = new AttachmentsPanel.AttachmentInfo();
                attInfo.setDescription("");
                attInfo.setFile(null);
                attInfo.setIsPatch(false);
                for (Map.Entry attSubAttr : attAttr.getAttributes().entrySet()) {
                    if (NB_NEW_ATTACHMENT_DESC_ATTR_ID.equals(attSubAttr.getKey())) {
                        attInfo.setDescription(((TaskAttribute)attSubAttr.getValue()).getValue());
                        continue;
                    }
                    if (NB_NEW_ATTACHMENT_CONTENT_TYPE_ATTR_ID.equals(attSubAttr.getKey())) {
                        attInfo.setContentType(((TaskAttribute)attSubAttr.getValue()).getValue());
                        continue;
                    }
                    if (NB_NEW_ATTACHMENT_FILE_ATTR_ID.equals(attSubAttr.getKey())) {
                        attInfo.setFile(new File(((TaskAttribute)attSubAttr.getValue()).getValue()));
                        continue;
                    }
                    if (!NB_NEW_ATTACHMENT_PATCH_ATTR_ID.equals(attSubAttr.getKey())) continue;
                    attInfo.setIsPatch("1".equals(((TaskAttribute)attSubAttr.getValue()).getValue()));
                }
                attachments.add(attInfo);
            }
        }
        return attachments;
    }

    protected final void setPrivateNotes(String text) {
        this.privateNotes = text;
    }

    public final String getPrivateNotes() {
        if (this.privateNotes == null) {
            return this.getNbTask().getPrivateNotes();
        }
        return this.privateNotes;
    }

    public final Date getDueDate() {
        return this.dueDateModified ? this.dueDate : this.getNbTask().getDueDate();
    }

    protected final void setDueDate(Date date, boolean persistentChange) {
        this.dueDate = date;
        this.dueDateModified = true;
        if (persistentChange) {
            this.persistDueDate();
        }
    }

    public final NbDateRange getScheduleDate() {
        return this.scheduleDateModified ? this.scheduleDate : this.getNbTask().getScheduleDate();
    }

    protected final void setScheduleDate(IssueScheduleInfo info, boolean persistentChange) {
        this.scheduleDate = info == null ? null : new NbDateRange(info);
        this.scheduleDateModified = true;
        if (persistentChange) {
            this.persistScheduleDate();
        }
    }

    public final int getEstimate() {
        return this.estimate == null ? this.getNbTask().getEstimate() : this.estimate.intValue();
    }

    protected final void setEstimate(int estimate, boolean persistentChange) {
        this.estimate = estimate;
        if (persistentChange) {
            this.persistEstimate();
        }
    }

    public final Date getPersistentDueDate() {
        return this.getNbTask().getDueDate();
    }

    public final int getPersistentEstimate() {
        return this.getNbTask().getEstimate();
    }

    public final IssueScheduleInfo getPersistentScheduleInfo() {
        NbDateRange scheduled = this.getNbTask().getScheduleDate();
        return scheduled == null ? null : scheduled.toSchedulingInfo();
    }

    protected final boolean hasUnsavedPrivateTaskAttributes() {
        return this.privateNotes != null || this.dueDateModified || this.scheduleDateModified || this.estimate != null;
    }

    private boolean persistPrivateTaskAttributes() {
        boolean modified = false;
        if (this.privateNotes != null) {
            this.getNbTask().setPrivateNotes(this.privateNotes.isEmpty() ? null : this.privateNotes);
            this.privateNotes = null;
            modified = true;
        }
        boolean fireScheduleEvent = false;
        if (this.persistEstimate()) {
            modified = true;
            fireScheduleEvent = true;
        }
        if (this.persistDueDate()) {
            modified = true;
            fireScheduleEvent = true;
        }
        if (this.persistScheduleDate()) {
            modified = true;
            fireScheduleEvent = true;
        }
        if (fireScheduleEvent) {
            this.fireScheduleChanged();
        }
        return modified;
    }

    private boolean persistDueDate() {
        boolean modified = false;
        if (this.dueDateModified) {
            this.getNbTask().setDueDate(this.dueDate);
            this.dueDate = null;
            this.dueDateModified = false;
            modified = true;
        }
        return modified;
    }

    private boolean persistEstimate() {
        boolean modified = false;
        if (this.estimate != null) {
            this.getNbTask().setEstimate(this.estimate);
            this.estimate = null;
            modified = true;
        }
        return modified;
    }

    private boolean persistScheduleDate() {
        boolean modified = false;
        if (this.scheduleDateModified) {
            this.getNbTask().setScheduleDate(this.scheduleDate);
            this.scheduleDate = null;
            this.scheduleDateModified = false;
            modified = true;
        }
        return modified;
    }

    private void clearPrivateTaskAttributeChanges() {
        this.privateNotes = null;
        this.dueDate = null;
        this.dueDateModified = false;
        this.scheduleDate = null;
        this.scheduleDateModified = false;
        this.estimate = null;
    }

    protected final String getDueDisplayString() {
        Calendar cal = Calendar.getInstance();
        Date date = this.getPersistentDueDate();
        if (date == null) {
            return "";
        }
        cal.setTime(date);
        return this.formatDate(cal);
    }

    protected final String getEstimateDisplayString() {
        int est = this.getPersistentEstimate();
        if (est == 0) {
            return "";
        }
        return "" + est;
    }

    protected final String getScheduleDisplayString() {
        NbDateRange schedule = this.getNbTask().getScheduleDate();
        if (schedule == null) {
            return "";
        }
        int interval = schedule.getEndDate().get(6) - schedule.getStartDate().get(6);
        if (interval == 1) {
            return this.formatDate(schedule.getStartDate());
        }
        return this.formateDate(schedule.getStartDate(), schedule.getEndDate());
    }

    protected final void fireChanged() {
        this.support.firePropertyChange("bugtracking.changed", null, null);
    }

    protected final void fireDataChanged() {
        this.support.firePropertyChange("issue.data_changed", null, null);
    }

    protected final void fireScheduleChanged() {
        this.support.firePropertyChange("issue.schedule_changed", null, null);
    }

    protected final void fireStatusChanged() {
        this.support.firePropertyChange("issue.status_changed", null, null);
    }

    private void fireDeleted() {
        this.support.firePropertyChange("issue.deleted", null, null);
    }

    private String formatDate(Calendar date) {
        return DateFormat.getDateInstance(2).format(date.getTime());
    }

    private String formateDate(Calendar start, Calendar end) {
        DateFormat format = DateFormat.getDateInstance(2);
        return format.format(start.getTime()) + " - " + format.format(end.getTime());
    }

    private class TaskListenerImpl
    implements NbTaskListener {
        private TaskListenerImpl() {
        }

        @Override
        public void taskModified(NbTaskListener.TaskEvent event) {
            if (event.getTask() == AbstractNbTaskWrapper.this.task && event.getKind() == NbTaskListener.TaskEvent.Kind.MODIFIED) {
                boolean syncStateChanged = event.taskStateChanged();
                AbstractNbTaskWrapper.this.taskModified(syncStateChanged);
            }
        }
    }

    private class TaskDataListenerImpl
    implements TaskDataListener {
        private TaskDataListenerImpl() {
        }

        @Override
        public void taskDataUpdated(TaskDataListener.TaskDataEvent event) {
            if (event.getTask() == AbstractNbTaskWrapper.this.task) {
                if (event.getTaskData() != null && !event.getTaskData().isPartial()) {
                    AbstractNbTaskWrapper.this.repositoryDataRef = new SoftReference<TaskData>(event.getTaskData());
                }
                if (event.getTaskDataUpdated()) {
                    NbTaskDataModel m = AbstractNbTaskWrapper.this.model;
                    if (m != null) {
                        try {
                            m.refresh();
                        }
                        catch (CoreException ex) {
                            LOG.log(Level.INFO, null, ex);
                        }
                    }
                    AbstractNbTaskWrapper.this.taskDataUpdated();
                }
            }
        }
    }
}

