/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Point;
import java.util.List;
import org.netbeans.api.visual.action.MoveControlPointProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;

public final class MoveControlPointAction
extends WidgetAction.LockedAdapter {
    private MoveControlPointProvider provider;
    private ConnectionWidget.RoutingPolicy routingPolicy;
    private ConnectionWidget movingWidget = null;
    private Point controlPointLocation;
    private int controlPointIndex;
    private Point lastLocation = null;

    public MoveControlPointAction(MoveControlPointProvider provider, ConnectionWidget.RoutingPolicy routingPolicy) {
        this.provider = provider;
        this.routingPolicy = routingPolicy;
    }

    @Override
    protected boolean isLocked() {
        return this.movingWidget != null;
    }

    @Override
    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (this.isLocked()) {
            return WidgetAction.State.createLocked(widget, this);
        }
        if (event.getButton() == 1 && event.getClickCount() == 1 && widget instanceof ConnectionWidget) {
            ConnectionWidget conn = (ConnectionWidget)widget;
            this.controlPointIndex = conn.getControlPointHitAt(event.getPoint());
            if (this.controlPointIndex >= 0) {
                this.movingWidget = conn;
                this.controlPointLocation = new Point(conn.getControlPoints().get(this.controlPointIndex));
                this.lastLocation = new Point(event.getPoint());
                return WidgetAction.State.createLocked(widget, this);
            }
            this.movingWidget = null;
        }
        return WidgetAction.State.REJECTED;
    }

    @Override
    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent event) {
        WidgetAction.State state = this.move(widget, event.getPoint()) ? WidgetAction.State.CONSUMED : WidgetAction.State.REJECTED;
        this.movingWidget = null;
        return state;
    }

    @Override
    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent event) {
        if (this.move(widget, event.getPoint())) {
            return WidgetAction.State.createLocked(widget, this);
        }
        this.movingWidget = null;
        return WidgetAction.State.REJECTED;
    }

    private boolean move(Widget widget, Point newLocation) {
        if (this.movingWidget != widget) {
            return false;
        }
        List<Point> controlPoints = this.movingWidget.getControlPoints();
        if (this.controlPointIndex < 0 || this.controlPointIndex >= controlPoints.size()) {
            return false;
        }
        Point location = new Point(this.controlPointLocation);
        location.translate(newLocation.x - this.lastLocation.x, newLocation.y - this.lastLocation.y);
        controlPoints = this.provider.locationSuggested(this.movingWidget, this.controlPointIndex, location);
        if (controlPoints == null) {
            return false;
        }
        if (this.routingPolicy != null) {
            this.movingWidget.setRoutingPolicy(this.routingPolicy);
        }
        this.movingWidget.setControlPoints(controlPoints, false);
        return true;
    }
}

