/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.prep.editor.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.prep.editor.CPCssIndexModel;
import org.netbeans.modules.css.prep.editor.CPUtils;
import org.netbeans.modules.css.prep.editor.model.CPElement;
import org.netbeans.modules.css.prep.editor.model.CPElementHandle;
import org.netbeans.modules.css.prep.editor.model.CPModel;
import org.netbeans.modules.css.prep.editor.refactoring.RefactoringElement;
import org.netbeans.modules.css.prep.editor.refactoring.RefactoringElementContext;
import org.netbeans.modules.css.prep.editor.refactoring.WhereUsedElement;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.web.common.api.DependencyType;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class CPWhereUsedQueryPlugin
implements RefactoringPlugin {
    private WhereUsedQuery refactoring;
    private boolean cancelled = false;

    public CPWhereUsedQueryPlugin(WhereUsedQuery refactoring) {
        this.refactoring = refactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag elements) {
        try {
            if (this.cancelled) {
                return null;
            }
            Lookup lookup = this.refactoring.getRefactoringSource();
            RefactoringElementContext context = (RefactoringElementContext)lookup.lookup(RefactoringElementContext.class);
            Node element = context.getElement();
            if (element != null) {
                switch (element.type()) {
                    case cp_variable: {
                        this.findVariables(context, elements);
                        break;
                    }
                    case cp_mixin_name: {
                        this.findMixins(context, elements);
                    }
                }
            }
        }
        catch (IOException | ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            String msg = ex.getLocalizedMessage();
            return new Problem(true, msg != null ? msg : ex.toString());
        }
        return null;
    }

    private void findVariables(RefactoringElementContext context, RefactoringElementsBag elements) throws IOException, ParseException {
        for (RefactoringElement re : CPWhereUsedQueryPlugin.findVariables(context)) {
            elements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create(re.getFile(), re.getName(), re.getRange(), ElementKind.VARIABLE));
        }
    }

    public static Collection<RefactoringElement> findVariables(RefactoringElementContext context) throws IOException, ParseException {
        ArrayList<RefactoringElement> elements = new ArrayList<RefactoringElement>();
        String varName = context.getElementName();
        int offset = context.getCaret();
        CPModel model = context.getCPModel();
        CPElement currentVar = model.getVariableAtOffset(offset);
        if (currentVar == null) {
            throw new IllegalStateException();
        }
        boolean useIndexForCurrentFile = false;
        switch (currentVar.getType()) {
            case VARIABLE_GLOBAL_DECLARATION: {
                useIndexForCurrentFile = true;
                break;
            }
            case VARIABLE_USAGE: {
                Collection<CPElement> visibleVars = model.getVariables(offset);
                for (CPElement cPElement : visibleVars) {
                    if (!cPElement.getName().equals(varName)) continue;
                    elements.add(new RefactoringElement(context.getFileObject(), cPElement.getRange(), cPElement.getName()));
                }
                break;
            }
            case VARIABLE_DECLARATION_IN_BLOCK_CONTROL: {
                elements.add(new RefactoringElement(context.getFileObject(), currentVar.getRange(), currentVar.getName()));
            }
            case VARIABLE_LOCAL_DECLARATION: {
                OffsetRange scope = currentVar.getScope();
                for (CPElement var : model.getVariables()) {
                    if (!var.getName().equals(varName) || scope == null || !scope.containsInclusive(var.getRange().getStart())) continue;
                    elements.add(new RefactoringElement(context.getFileObject(), var.getRange(), var.getName()));
                }
                return elements;
            }
            default: {
                return elements;
            }
        }
        Map<FileObject, CPCssIndexModel> indexModels = CPUtils.getIndexModels(context.getFileObject(), DependencyType.REFERRING_AND_REFERRED, !useIndexForCurrentFile);
        for (Map.Entry entry : indexModels.entrySet()) {
            CPCssIndexModel im = (CPCssIndexModel)((Object)entry.getValue());
            FileObject file = (FileObject)entry.getKey();
            CPModel cpModel = CPModel.getModel(file);
            for (CPElementHandle var : im.getVariables()) {
                switch (var.getType()) {
                    case VARIABLE_GLOBAL_DECLARATION: 
                    case VARIABLE_USAGE: {
                        CPElement cpElement;
                        if (!var.getName().equals(varName) || (cpElement = var.resolve(cpModel)) == null) break;
                        OffsetRange elementRange = cpElement.getRange();
                        elements.add(new RefactoringElement(file, elementRange, varName));
                    }
                }
            }
        }
        return elements;
    }

    private void findMixins(RefactoringElementContext context, RefactoringElementsBag elements) throws IOException, ParseException {
        for (RefactoringElement re : CPWhereUsedQueryPlugin.findMixins(context)) {
            elements.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)WhereUsedElement.create(re.getFile(), re.getName(), re.getRange(), ElementKind.METHOD));
        }
    }

    public static Collection<RefactoringElement> findMixins(RefactoringElementContext context) throws IOException, ParseException {
        ArrayList<RefactoringElement> elements = new ArrayList<RefactoringElement>();
        String mixinName = context.getElementName();
        Map<FileObject, CPCssIndexModel> indexModels = CPUtils.getIndexModels(context.getFileObject(), DependencyType.REFERRING_AND_REFERRED, false);
        for (Map.Entry<FileObject, CPCssIndexModel> entry : indexModels.entrySet()) {
            CPCssIndexModel im = entry.getValue();
            FileObject file = entry.getKey();
            CPModel cpModel = CPModel.getModel(file);
            for (CPElementHandle var : im.getMixins()) {
                CPElement cpElement;
                if (!var.getName().equals(mixinName) || (cpElement = var.resolve(cpModel)) == null) continue;
                OffsetRange elementRange = cpElement.getRange();
                elements.add(new RefactoringElement(file, elementRange, mixinName));
            }
        }
        return elements;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public void cancelRequest() {
        this.cancelled = true;
    }
}

