/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.rules;

import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.fixes.AddWSOperation;
import org.netbeans.modules.websvc.editor.hints.rules.AbstractWebServiceRule;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class NoOperations
extends AbstractWebServiceRule {
    @Override
    protected ErrorDescription[] apply(TypeElement subject, ProblemContext ctx) {
        if (subject.getKind() == ElementKind.CLASS && !this.hasWebMethods(subject)) {
            String label = NbBundle.getMessage(NoOperations.class, (String)"MSG_AddOperation");
            AddWSOperation addOperFix = new AddWSOperation(ctx.getFileObject());
            ErrorDescription problem = NoOperations.createProblem((Element)subject, ctx, label, addOperFix);
            return new ErrorDescription[]{problem};
        }
        return null;
    }

    private boolean hasWebMethods(TypeElement classElement) {
        TypeElement superTypeElement;
        Element element;
        for (ExecutableElement executableElement : ElementFilter.methodsIn(classElement.getEnclosedElements())) {
            if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            return true;
        }
        for (TypeMirror typeMirror : classElement.getInterfaces()) {
            TypeElement superTypeElement2;
            Element superIFElement;
            if (typeMirror.getKind() != TypeKind.DECLARED || (superIFElement = ((DeclaredType)typeMirror).asElement()).getKind() != ElementKind.INTERFACE || !this.hasWebMethods(superTypeElement2 = (TypeElement)superIFElement)) continue;
            return true;
        }
        TypeMirror superClass = classElement.getSuperclass();
        if (superClass.getKind() == TypeKind.DECLARED && (element = ((DeclaredType)superClass).asElement()).getKind() == ElementKind.CLASS && (superTypeElement = (TypeElement)element).getSuperclass().getKind() != TypeKind.NONE) {
            return this.hasWebMethods(superTypeElement);
        }
        return false;
    }
}

