/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.mobile.renderkit;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.button.Button;
import org.primefaces.mobile.util.MobileUtils;
import org.primefaces.util.HTML;

public class ButtonRenderer
extends org.primefaces.component.button.ButtonRenderer {
    public void encodeMarkup(FacesContext context, Button button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        String value = (String)button.getValue();
        String icon = button.resolveIcon();
        writer.startElement("button", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("name", (Object)clientId, "name");
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", (Object)this.resolveStyleClass(button), "styleClass");
        this.renderPassThruAttributes(context, (UIComponent)button, HTML.BUTTON_ATTRS, HTML.CLICK_EVENT);
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        } else {
            writer.writeAttribute("onclick", (Object)this.buildOnclick(context, button), null);
        }
        if (value == null) {
            writer.write("ui-button");
        } else if (button.isEscape()) {
            writer.writeText((Object)value, "value");
        } else {
            writer.write(value.toString());
        }
        writer.endElement("button");
    }

    public void encodeScript(FacesContext context, Button button) throws IOException {
    }

    protected String buildOnclick(FacesContext context, Button button) {
        String command = null;
        String outcome = button.getOutcome();
        if (outcome != null && outcome.startsWith("pm:")) {
            command = MobileUtils.buildNavigation(outcome);
        } else {
            String targetURL = this.getTargetURL(context, button);
            if (targetURL != null) {
                command = "window.open('" + targetURL + "','" + button.getTarget() + "')";
            }
        }
        return this.buildDomEvent(context, (UIComponent)button, "onclick", "click", "action", command);
    }

    public String resolveStyleClass(Button button) {
        String userStyleClass;
        String icon = button.getIcon();
        String iconPos = button.getIconPos();
        Object value = button.getValue();
        String styleClass = "ui-btn ui-shadow ui-corner-all";
        if (value != null && icon != null) {
            styleClass = styleClass + " " + icon + " ui-btn-icon-" + iconPos;
        } else if (value == null && icon != null) {
            styleClass = styleClass + " " + icon + " ui-btn-icon-notext";
        }
        if (button.isDisabled()) {
            styleClass = styleClass + " ui-state-disabled";
        }
        if ((userStyleClass = button.getStyleClass()) != null) {
            styleClass = styleClass + " " + userStyleClass;
        }
        return styleClass;
    }
}

