/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.outputpanel;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.outputpanel.OutputPanel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class OutputPanelRenderer
extends CoreRenderer {
    private static final String BLOCK = "div";
    private static final String INLINE = "span";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        OutputPanel panel = (OutputPanel)component;
        if (panel.isContentLoad(context)) {
            this.renderChildren(context, (UIComponent)panel);
        } else {
            this.encodeMarkup(context, panel);
            if (panel.isDeferred()) {
                this.encodeScript(context, panel);
            }
        }
    }

    public void encodeMarkup(FacesContext context, OutputPanel panel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String tag = panel.getLayout().equals("block") ? BLOCK : INLINE;
        String clientId = panel.getClientId(context);
        String style = panel.getStyle();
        String styleClass = panel.getStyleClass();
        styleClass = styleClass == null ? "ui-outputpanel ui-widget" : "ui-outputpanel ui-widget " + styleClass;
        writer.startElement(tag, (UIComponent)panel);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)panel.getStyle(), "style");
        }
        if (panel.isDeferred()) {
            this.renderLoading(context, panel);
        } else {
            this.renderChildren(context, (UIComponent)panel);
        }
        writer.endElement(tag);
    }

    protected void encodeScript(FacesContext context, OutputPanel panel) throws IOException {
        String clientId = panel.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.initWithDomReady("OutputPanel", panel.resolveWidgetVar(), clientId);
        if (panel.isDeferred()) {
            wb.attr("deferred", true).attr("deferredMode", panel.getDeferredMode()).attr("global", panel.isGlobal(), false);
        }
        wb.finish();
    }

    protected void renderLoading(FacesContext context, OutputPanel panel) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement(BLOCK, null);
        writer.writeAttribute("class", (Object)"ui-outputpanel-loading ui-widget", null);
        writer.endElement(BLOCK);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

