/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.issuetable;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.api.RepositoryManager;
import org.netbeans.modules.bugtracking.api.Util;
import org.netbeans.modules.bugtracking.issuetable.IssueTable;
import org.netbeans.modules.bugtracking.spi.IssueProvider;
import org.netbeans.modules.bugtracking.spi.IssueStatusProvider;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public abstract class IssueNode<I>
extends AbstractNode {
    public static final String LABEL_NAME_SEEN = "issue.seen";
    public static final String LABEL_RECENT_CHANGES = "issue.recent_changes";
    public static final String LABEL_NAME_SUMMARY = "issue.summary";
    private final String repositoryID;
    private final String connectorID;
    private Repository repository;
    private IssueImpl issueImpl;
    private String htmlDisplayName;
    private Action preferedAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Repository repo = IssueNode.this.getRepository();
            Util.openIssue((Repository)repo, (String)IssueNode.this.issueImpl.getID());
        }
    };
    private final ChangesProvider<I> changesProvider;

    public IssueNode(String connectorID, String repositoryID, I i, IssueProvider<I> issueProvider, IssueStatusProvider<?, I> statusProvider, ChangesProvider<I> changesProvider) {
        super(Children.LEAF);
        this.issueImpl = new IssueImpl(i, issueProvider, statusProvider);
        this.repositoryID = repositoryID;
        this.connectorID = connectorID;
        this.changesProvider = changesProvider;
        this.initProperties();
        this.refreshHtmlDisplayName();
        this.issueImpl.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (IssueNode.this.issueImpl.i != evt.getSource()) {
                    return;
                }
                if (evt.getPropertyName().equals("issue.status_changed")) {
                    IssueNode.this.fireSeenValueChanged();
                } else if ("issue.data_changed".equals(evt.getPropertyName())) {
                    IssueNode.this.fireDataChanged();
                }
            }
        }, (Object)((Object)this)));
    }

    public I getIssueData() {
        return (I)this.issueImpl.i;
    }

    protected abstract Node.Property<?>[] getProperties();

    public Action getPreferredAction() {
        return this.preferedAction;
    }

    public boolean wasSeen() {
        return this.issueImpl.getStatus() == IssueStatusProvider.Status.SEEN;
    }

    IssueStatusProvider.Status getStatus() {
        return this.issueImpl.getStatus();
    }

    void setSeen(boolean b) {
        this.issueImpl.setSeen(b);
    }

    String getSummary() {
        return this.issueImpl.getSummary();
    }

    private void initProperties() {
        Node.Property<?>[] properties;
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        for (Node.Property<?> property : properties = this.getProperties()) {
            ps.put(property);
        }
        ps.put((Node.Property)new RecentChangesProperty());
        ps.put((Node.Property)new SeenProperty());
        sheet.put(ps);
        this.setSheet(sheet);
    }

    private void refreshHtmlDisplayName() {
        this.htmlDisplayName = this.issueImpl.getDisplayName();
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    void fireSeenValueChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Node.Property<?>[] properties;
                for (Node.Property<?> p : properties = IssueNode.this.getProperties()) {
                    if (!(p instanceof IssueProperty)) continue;
                    String pName = ((IssueProperty)p).getName();
                    IssueNode.this.firePropertyChange(pName, null, null);
                }
            }
        });
    }

    protected void fireDataChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Node.Property<?>[] properties;
                for (Node.Property<?> p : properties = IssueNode.this.getProperties()) {
                    if (!(p instanceof IssueProperty)) continue;
                    String pName = ((IssueProperty)p).getName();
                    IssueNode.this.firePropertyChange(pName, null, null);
                }
            }
        });
    }

    private Repository getRepository() {
        if (this.repository == null) {
            this.repository = RepositoryManager.getInstance().getRepository(this.connectorID, this.repositoryID);
        }
        return this.repository;
    }

    private class IssueImpl {
        private final I i;
        private final IssueProvider<I> provider;
        private final IssueStatusProvider<?, I> statusProvider;

        public IssueImpl(I i, IssueProvider<I> provider, IssueStatusProvider<?, I> statusProvider) {
            this.i = i;
            this.provider = provider;
            this.statusProvider = statusProvider;
        }

        private void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.provider.addPropertyChangeListener(this.i, propertyChangeListener);
        }

        private IssueStatusProvider.Status getStatus() {
            return this.statusProvider.getStatus(this.i);
        }

        private String getDisplayName() {
            return this.provider.getDisplayName(this.i);
        }

        private String getSummary() {
            return this.provider.getSummary(this.i);
        }

        private void setSeen(boolean b) {
            this.statusProvider.setSeenIncoming(this.i, b);
        }

        private String getID() {
            return this.provider.getID(this.i);
        }
    }

    public class RecentChangesProperty
    extends IssueProperty<String> {
        public RecentChangesProperty() {
            super(IssueNode.LABEL_RECENT_CHANGES, String.class, NbBundle.getMessage(IssueNode.class, (String)"CTL_Issue_Recent"), NbBundle.getMessage(IssueNode.class, (String)"CTL_Issue_Recent_Desc"));
        }

        @Override
        public String getValue() {
            return IssueNode.this.changesProvider.getRecentChanges(IssueNode.this.issueImpl.i);
        }

        @Override
        public int compareTo(IssueProperty<String> p) {
            if (p == null) {
                return 1;
            }
            if (p.getClass().isAssignableFrom(RecentChangesProperty.class)) {
                String recentChanges1 = IssueNode.this.changesProvider.getRecentChanges(IssueNode.this.issueImpl.i);
                String recentChanges2 = IssueNode.this.changesProvider.getRecentChanges(p.getIssueData());
                return recentChanges1.compareToIgnoreCase(recentChanges2);
            }
            return 1;
        }
    }

    public class SeenProperty
    extends IssueProperty<Boolean> {
        public SeenProperty() {
            super(IssueNode.LABEL_NAME_SEEN, Boolean.class, "", NbBundle.getMessage(IssueNode.class, (String)"CTL_Issue_Seen_Desc"));
        }

        @Override
        public Boolean getValue() {
            return IssueNode.this.issueImpl.getStatus() == IssueStatusProvider.Status.SEEN;
        }

        @Override
        public int compareTo(IssueProperty p) {
            if (p == null) {
                return 1;
            }
            Boolean b1 = IssueNode.this.wasSeen();
            Boolean b2 = p.getStatus() == IssueStatusProvider.Status.SEEN;
            return b1.compareTo(b2);
        }
    }

    public class SummaryProperty
    extends IssueProperty<String> {
        public SummaryProperty() {
            super(IssueNode.LABEL_NAME_SUMMARY, String.class, NbBundle.getMessage(IssueNode.class, (String)"CTL_Issue_Summary_Title"), NbBundle.getMessage(IssueNode.class, (String)"CTL_Issue_Summary_Desc"));
        }

        @Override
        public String getValue() {
            return IssueNode.this.getSummary();
        }

        @Override
        public int compareTo(IssueProperty p) {
            if (p == null) {
                return 1;
            }
            String s1 = IssueNode.this.getSummary();
            String s2 = p.getSummary();
            return s1.compareTo(s2);
        }
    }

    public abstract class IssueProperty<T>
    extends PropertySupport.ReadOnly
    implements Comparable<IssueProperty<T>> {
        protected IssueProperty(String name, Class<T> type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public String toString() {
            try {
                return this.getValue().toString();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                IssueTable.LOG.log(Level.INFO, null, e);
                return e.getLocalizedMessage();
            }
        }

        public I getIssueData() {
            return IssueNode.this.issueImpl.i;
        }

        @Override
        public int compareTo(IssueProperty<T> o) {
            return this.toString().compareTo(o.toString());
        }

        public abstract T getValue() throws IllegalAccessException, InvocationTargetException;

        IssueStatusProvider.Status getStatus() {
            return IssueNode.this.getStatus();
        }

        String getRecentChanges() {
            String changes = IssueNode.this.changesProvider.getRecentChanges(this.getIssueData());
            changes = changes == null ? "" : changes.trim();
            IssueStatusProvider.Status status = IssueNode.this.issueImpl.getStatus();
            if (changes.equals("") && status == IssueStatusProvider.Status.INCOMING_MODIFIED) {
                changes = NbBundle.getMessage(IssueNode.class, (String)"LBL_IssueModified");
            }
            return changes;
        }

        private String getSummary() {
            return IssueNode.this.getSummary();
        }
    }

    public static interface ChangesProvider<I> {
        public String getRecentChanges(I var1);
    }
}

