/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.mylyn.wikitext.core.validation.ValidationProblem;
import org.eclipse.mylyn.wikitext.core.validation.ValidationRule;

public class MarkupValidator {
    private final List<ValidationRule> rules = new ArrayList<ValidationRule>();

    public List<ValidationProblem> validate(String markup) {
        return this.validate(markup, 0, markup.length());
    }

    public List<ValidationProblem> validate(String markup, int offset, int length) {
        if (length == 0 || this.rules.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ValidationProblem> problems = new ArrayList<ValidationProblem>();
        for (ValidationRule rule : this.rules) {
            problems.addAll(rule.findProblems(markup, offset, length));
        }
        if (!problems.isEmpty()) {
            Collections.sort(problems);
        }
        return problems;
    }

    public List<ValidationRule> getRules() {
        return this.rules;
    }
}

