/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.spi;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.derby.api.DerbyDatabases;
import org.netbeans.modules.derby.spi.support.DerbySupport;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class RegisterDatabase {
    private static volatile RegisterDatabase reg = null;

    public static RegisterDatabase getDefault() {
        if (reg == null) {
            reg = new RegisterDatabase();
        }
        return reg;
    }

    public void setupDerby(String serverinstall) {
        String location = DerbySupport.getLocation();
        if (null != location && location.trim().length() > 0) {
            return;
        }
        File dbloc = new File(serverinstall, "javadb");
        if (dbloc.exists() && dbloc.isDirectory() && dbloc.canRead()) {
            DerbySupport.setLocation((String)dbloc.getAbsolutePath());
            location = DerbySupport.getSystemHome();
            if (null != location && location.trim().length() > 0) {
                return;
            }
            File dbdir = new File(DerbySupport.getDefaultSystemHome());
            if (!dbdir.exists()) {
                dbdir.mkdirs();
            }
            DerbySupport.setSystemHome((String)DerbySupport.getDefaultSystemHome());
        }
        this.configureDatabase();
    }

    public void configureDatabase() {
        String location = DerbySupport.getLocation();
        File dbInstall = new File(location);
        if (dbInstall != null && dbInstall.exists()) {
            this.registerDerbyLibrary(dbInstall);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        DerbyDatabases.createSampleDatabase();
                    }
                    catch (IOException | DatabaseException ex) {
                        Logger.getLogger("payara-eecommon").log(Level.INFO, ex.getLocalizedMessage(), ex);
                    }
                }
            });
        }
    }

    private void registerDerbyLibrary(File location) {
        FileObject libsFolder = FileUtil.getConfigFile((String)"org-netbeans-api-project-libraries/Libraries");
        if (libsFolder != null) {
            try {
                libsFolder.getFileSystem().runAtomicAction((FileSystem.AtomicAction)new DerbyLibraryRegistrar(location, libsFolder));
            }
            catch (FileStateInvalidException ex) {
                Logger.getLogger("payara-eecommon").log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
            catch (IOException ex) {
                Logger.getLogger("payara-eecommon").log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
        }
    }

    static class DerbyLibraryRegistrar
    implements FileSystem.AtomicAction {
        private File location;
        private FileObject libsFolder;

        DerbyLibraryRegistrar(File location, FileObject libsFolder) {
            this.location = location;
            this.libsFolder = libsFolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            FileLock ld = null;
            OutputStream outStreamd = null;
            Writer outd = null;
            OutputStreamWriter osw = null;
            try {
                FileObject derbyLib = null;
                derbyLib = this.libsFolder.getFileObject("JavaDB", "xml");
                if (null == derbyLib) {
                    derbyLib = this.libsFolder.createData("JavaDB", "xml");
                    ld = derbyLib.lock();
                    outStreamd = derbyLib.getOutputStream(ld);
                    osw = new OutputStreamWriter(outStreamd);
                    outd = new BufferedWriter(osw);
                    outd.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE library PUBLIC \"-//NetBeans//DTD Library Declaration 1.0//EN\" \"http://www.netbeans.org/dtds/library-declaration-1_0.dtd\">\n");
                    outd.write("<library version=\"1.0\">\n<name>JAVADB_DRIVER_LABEL</name>\n");
                    outd.write("<type>j2se</type>\n");
                    outd.write("<localizing-bundle>org.netbeans.modules.payara.eecommon.api.Bundle</localizing-bundle>\n");
                    outd.write("<volume>\n<type>classpath</type>\n");
                    outd.write("<resource>jar:" + new File(this.location.getAbsolutePath() + "/lib/derby.jar").toURI().toURL() + "!/</resource>\n");
                    outd.write("<resource>jar:" + new File(this.location.getAbsolutePath() + "/lib/derbyclient.jar").toURI().toURL() + "!/</resource>\n");
                    outd.write("<resource>jar:" + new File(this.location.getAbsolutePath() + "/lib/derbynet.jar").toURI().toURL() + "!/</resource>\n");
                    outd.write("</volume>\n<volume>\n<type>src</type>\n</volume>\n");
                    outd.write("<volume>\n<type>javadoc</type>\n");
                    outd.write("</volume>\n</library>");
                }
            }
            finally {
                if (null != outd) {
                    try {
                        outd.close();
                    }
                    catch (IOException ioe) {
                        Logger.getLogger("payara-eecommon").log(Level.INFO, ioe.getLocalizedMessage(), ioe);
                    }
                }
                if (null != outStreamd) {
                    try {
                        outStreamd.close();
                    }
                    catch (IOException ioe) {
                        Logger.getLogger("payara-eecommon").log(Level.INFO, ioe.getLocalizedMessage(), ioe);
                    }
                }
                if (null != ld) {
                    ld.releaseLock();
                }
            }
        }
    }
}

