/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.textmate.lexer;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.registry.IRegistryOptions;
import org.eclipse.tm4e.core.registry.Registry;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.textmate.lexer.TextmateLexer;
import org.netbeans.spi.editor.mimelookup.MimeDataProvider;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public enum TextmateTokenId implements TokenId
{
    TEXTMATE,
    UNTOKENIZED;


    public String primaryCategory() {
        return "textmate";
    }

    public static final class MimeDataProviderImpl
    implements MimeDataProvider {
        private static final Logger LOG = Logger.getLogger(MimeDataProviderImpl.class.getName());

        public Lookup getLookup(MimePath arg0) {
            String scope = (String)LanguageHierarchyImpl.mimeType2Scope.get(arg0.getPath());
            if (scope != null) {
                try {
                    return Lookups.singleton((Object)new LanguageHierarchyImpl(arg0.getPath(), scope).language());
                }
                catch (Exception ex) {
                    LOG.log(Level.FINE, null, ex);
                }
            }
            return null;
        }
    }

    public static class LanguageHierarchyImpl
    extends LanguageHierarchy<TextmateTokenId> {
        public static final String GRAMMAR_MARK = "textmate-grammar";
        public static final String INJECTION_MARK = "inject-to";
        private static final Map<String, FileObject> scope2File = new HashMap<String, FileObject>();
        private static final Map<String, Collection<String>> scope2Injections = new HashMap<String, Collection<String>>();
        private static final Map<String, String> mimeType2Scope = new HashMap<String, String>();
        private final String mimeType;
        private final IGrammar grammar;

        public LanguageHierarchyImpl(String mimeType, String scope) throws Exception {
            this.mimeType = mimeType;
            IRegistryOptions opts = new IRegistryOptions(){

                public String getFilePath(String scopeName) {
                    FileObject file = (FileObject)scope2File.get(scopeName);
                    return file != null ? file.getNameExt() : null;
                }

                public InputStream getInputStream(String scopeName) throws IOException {
                    FileObject file = (FileObject)scope2File.get(scopeName);
                    return file != null ? file.getInputStream() : null;
                }

                public Collection<String> getInjections(String scopeName) {
                    return (Collection)scope2Injections.get(scopeName);
                }
            };
            this.grammar = new Registry(opts).loadGrammar(scope);
        }

        protected Collection<TextmateTokenId> createTokenIds() {
            return Arrays.asList(TextmateTokenId.values());
        }

        protected Lexer<TextmateTokenId> createLexer(LexerRestartInfo<TextmateTokenId> lri) {
            return new TextmateLexer(lri.input(), lri.state(), (TokenFactory<TextmateTokenId>)lri.tokenFactory(), this.grammar);
        }

        protected String mimeType() {
            return this.mimeType;
        }

        static {
            FileObject editors = FileUtil.getSystemConfigRoot().getFileObject("Editors");
            if (editors != null) {
                Enumeration en = editors.getChildren(true);
                while (en.hasMoreElements()) {
                    FileObject candidate = (FileObject)en.nextElement();
                    Object attr = candidate.getAttribute(GRAMMAR_MARK);
                    if (attr == null || !(attr instanceof String)) continue;
                    String scope = (String)attr;
                    scope2File.put(scope, candidate);
                    attr = candidate.getAttribute(INJECTION_MARK);
                    if (attr != null && attr instanceof String) {
                        for (String s : ((String)attr).split(",")) {
                            scope2Injections.computeIfAbsent(s, str -> new ArrayList()).add(scope);
                        }
                        continue;
                    }
                    mimeType2Scope.put(FileUtil.getRelativePath((FileObject)editors, (FileObject)candidate.getParent()), scope);
                }
            }
        }
    }
}

