/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.openjdk.project;

import java.awt.Image;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public class LogicalViewProviderImpl
implements LogicalViewProvider {
    private final Project p;

    public LogicalViewProviderImpl(Project p) {
        this.p = p;
    }

    public Node createLogicalView() {
        return new RootNode(this.p);
    }

    public Node findPath(Node root, Object target) {
        Project prj = (Project)root.getLookup().lookup(Project.class);
        if (prj == null) {
            return null;
        }
        if (target instanceof FileObject) {
            FileObject fo = (FileObject)target;
            if (LogicalViewProviderImpl.isOtherProjectSource(fo, prj)) {
                return null;
            }
            for (Node n : root.getChildren().getNodes(true)) {
                Node result = PackageView.findPath((Node)n, (Object)target);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private static boolean isOtherProjectSource(@NonNull FileObject fo, @NonNull Project me) {
        Project owner = FileOwnerQuery.getOwner((FileObject)fo);
        if (owner == null) {
            return false;
        }
        if (me.equals(owner)) {
            return false;
        }
        for (SourceGroup sg : ProjectUtils.getSources((Project)owner).getSourceGroups("java")) {
            if (!FileUtil.isParentOf((FileObject)sg.getRootFolder(), (FileObject)fo)) continue;
            return true;
        }
        return false;
    }

    private static final class RootChildFactory
    extends ChildFactory<Key>
    implements ChangeListener {
        private final Sources sources;

        public RootChildFactory(Project project) {
            this.sources = ProjectUtils.getSources((Project)project);
            this.sources.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.sources));
        }

        protected boolean createKeys(List<Key> toPopulate) {
            Set javaSourceGroups = Collections.newSetFromMap(new IdentityHashMap());
            javaSourceGroups.addAll(Arrays.asList(this.sources.getSourceGroups("java")));
            Set testGroups = Collections.newSetFromMap(new IdentityHashMap());
            testGroups.addAll(Arrays.asList(this.sources.getSourceGroups("jdk-project-sources-tests")));
            for (SourceGroup sg : this.sources.getSourceGroups("jdk-project-sources")) {
                if (testGroups.contains(sg)) {
                    toPopulate.add(new Key(sg){

                        @Override
                        public Node createNode() {
                            try {
                                DataObject od = DataObject.find((FileObject)this.group.getRootFolder());
                                return new FilterNode(od.getNodeDelegate()){

                                    public String getDisplayName() {
                                        return group.getDisplayName();
                                    }
                                };
                            }
                            catch (DataObjectNotFoundException ex) {
                                return Node.EMPTY;
                            }
                        }
                    });
                    continue;
                }
                if (javaSourceGroups.contains(sg)) {
                    toPopulate.add(new Key(sg){

                        @Override
                        public Node createNode() {
                            return PackageView.createPackageView((SourceGroup)this.group);
                        }
                    });
                    continue;
                }
                toPopulate.add(new Key(sg){

                    @Override
                    public Node createNode() {
                        try {
                            DataObject od = DataObject.find((FileObject)this.group.getRootFolder());
                            return new FilterNode(od.getNodeDelegate()){

                                public Image getIcon(int type) {
                                    return ImageUtilities.loadImage((String)"org/netbeans/modules/java/openjdk/project/resources/nativeFilesFolder.gif");
                                }

                                public Image getOpenedIcon(int type) {
                                    return ImageUtilities.loadImage((String)"org/netbeans/modules/java/openjdk/project/resources/nativeFilesFolderOpened.gif");
                                }

                                public String getDisplayName() {
                                    return group.getDisplayName();
                                }
                            };
                        }
                        catch (DataObjectNotFoundException ex) {
                            return Node.EMPTY;
                        }
                    }
                });
            }
            return true;
        }

        protected Node createNodeForKey(Key key) {
            return key.createNode();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refresh(false);
        }

        private static abstract class Key {
            public final SourceGroup group;

            public Key(SourceGroup group) {
                this.group = group;
            }

            public abstract Node createNode();

            public int hashCode() {
                int hash = 7;
                hash = 53 * hash + Objects.hashCode(this.group);
                return hash;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Key other = (Key)obj;
                return Objects.equals(this.group, other.group);
            }
        }
    }

    private static final class RootNode
    extends AbstractNode {
        private final Project project;

        public RootNode(Project p) {
            super(Children.create((ChildFactory)new RootChildFactory(p), (boolean)true), Lookups.fixed((Object[])new Object[]{p}));
            this.project = p;
            this.setDisplayName();
            this.setIconBaseWithExtension("org/netbeans/modules/java/openjdk/project/resources/jdk-project.png");
        }

        private void setDisplayName() {
            this.setDisplayName(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        }

        public String getHtmlDisplayName() {
            return null;
        }

        public Action[] getActions(boolean context) {
            return CommonProjectActions.forType((String)"org-netbeans-modules-java-openjdk-project-JDKProject");
        }
    }
}

