/*
 * Decompiled with CFR 0.152.
 */
package javax.faces;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.servlet.ServletContext;

final class ServletContextFacesContextFactory
extends FacesContextFactory {
    static final String SERVLET_CONTEXT_FINDER_NAME = "com.sun.faces.ServletContextFacesContextFactory";
    static final String SERVLET_CONTEXT_FINDER_REMOVAL_NAME = "com.sun.faces.ServletContextFacesContextFactory_Removal";
    private static final Logger LOGGER = Logger.getLogger("javax.faces", "javax.faces.LogStrings");
    private ThreadLocal<FacesContext> facesContextCurrentInstance;
    private ConcurrentHashMap<Thread, FacesContext> facesContextThreadInitContextMap;
    private ConcurrentHashMap<FacesContext, ServletContext> initContextServletContextMap;

    ServletContextFacesContextFactory() {
        block8: {
            try {
                Field instanceField = FacesContext.class.getDeclaredField("instance");
                instanceField.setAccessible(true);
                this.facesContextCurrentInstance = (ThreadLocal)instanceField.get(null);
                Field threadInitContextMapField = FacesContext.class.getDeclaredField("threadInitContext");
                threadInitContextMapField.setAccessible(true);
                this.facesContextThreadInitContextMap = (ConcurrentHashMap)threadInitContextMapField.get(null);
                Field initContextServletContextMapField = FacesContext.class.getDeclaredField("initContextServletContext");
                initContextServletContextMapField.setAccessible(true);
                this.initContextServletContextMap = (ConcurrentHashMap)initContextServletContextMapField.get(null);
            }
            catch (IllegalAccessException ex) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "Unable to access instance field of FacesContext", ex);
                }
            }
            catch (IllegalArgumentException ex) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "Unable to access instance field of FacesContext", ex);
                }
            }
            catch (NoSuchFieldException ex) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "Unable to access instance field of FacesContext", ex);
                }
            }
            catch (SecurityException ex) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block8;
                LOGGER.log(Level.SEVERE, "Unable to access instance field of FacesContext", ex);
            }
        }
    }

    FacesContext getFacesContextWithoutServletContextLookup() {
        FacesContext result = this.facesContextCurrentInstance.get();
        if (null == result && null != this.facesContextThreadInitContextMap && !this.facesContextThreadInitContextMap.isEmpty()) {
            result = this.facesContextThreadInitContextMap.get(Thread.currentThread());
        }
        return result;
    }

    @Override
    public FacesContext getFacesContext(Object context, Object request, Object response, Lifecycle lifecycle) throws FacesException {
        ServletContext servletContext;
        FacesContext result = null;
        if (null != this.initContextServletContextMap && !this.initContextServletContextMap.isEmpty() && null != (servletContext = (ServletContext)FactoryFinder.FACTORIES_CACHE.getServletContextForCurrentClassLoader())) {
            for (Map.Entry<FacesContext, ServletContext> entry : this.initContextServletContextMap.entrySet()) {
                if (!servletContext.equals(entry.getValue())) continue;
                result = entry.getKey();
                break;
            }
        }
        return result;
    }
}

