/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute.ui;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.debug.Utils;
import org.netbeans.modules.maven.execute.cmd.ExecMojo;
import org.netbeans.modules.maven.execute.ui.Bundle;
import org.netbeans.modules.maven.queries.MavenSourceJavadocAttacher;
import org.netbeans.modules.maven.queries.SourceJavadocByHash;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class DebugPluginSourceAction
extends AbstractAction {
    private final ExecMojo mojo;
    private final RunConfig config;

    public DebugPluginSourceAction(ExecMojo start, RunConfig conf) {
        this.putValue("Name", Bundle.ACT_DEBUG_Plugin());
        this.mojo = start;
        this.config = conf;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final AtomicBoolean cancel = new AtomicBoolean();
        ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                DebugPluginSourceAction.this.doLoad(cancel);
            }
        }, (String)Bundle.TIT_DEBUG_Plugin(), (AtomicBoolean)cancel, (boolean)false);
    }

    private void doLoad(final AtomicBoolean cancel) {
        URL[] urls = this.mojo.getClasspathURLs();
        String impl = this.mojo.getImplementationClass();
        if (urls != null) {
            ArrayList<URL> normalizedUrls = new ArrayList<URL>();
            MavenSourceJavadocAttacher attacher = new MavenSourceJavadocAttacher();
            for (URL url : urls) {
                try {
                    url = FileUtil.urlForArchiveOrDir((File)FileUtil.normalizeFile((File)Utilities.toFile((URI)url.toURI())));
                    if (url == null) continue;
                    normalizedUrls.add(url);
                    List<? extends URL> ret = attacher.getSources(url, new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return cancel.get();
                        }
                    });
                    SourceForBinaryQuery.Result2 result = SourceForBinaryQuery.findSourceRoots2((URL)url);
                    if (result.getRoots().length == 0 && !ret.isEmpty()) {
                        HashSet<File> fls = new HashSet<File>();
                        for (URL uRL : ret) {
                            File f = FileUtil.archiveOrDirForURL((URL)uRL);
                            if (f == null) continue;
                            fls.add(f);
                        }
                        if (!fls.isEmpty()) {
                            SourceJavadocByHash.register(url, fls.toArray(new File[0]), false);
                        }
                    }
                    if (!cancel.get()) continue;
                    return;
                }
                catch (URISyntaxException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (cancel.get()) {
                return;
            }
            ClassPath cp = Utils.convertToSourcePath(normalizedUrls.toArray(new URL[0]));
            RunConfig clone = RunUtils.cloneRunConfig(this.config);
            clone.setInternalProperty("jpda.additionalClasspath", cp);
            clone.setInternalProperty("jpda.stopclass", impl);
            clone.setInternalProperty("jpda.stopmethod", "execute");
            clone.setProperty("jpda.listen", "maven");
            if (cancel.get()) {
                return;
            }
            RunUtils.run(clone);
        }
    }
}

