/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project;

import java.util.Set;
import java.util.function.Supplier;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.AbstractClassPathProvider;
import org.netbeans.modules.java.api.common.project.ActionProviderSupport;
import org.netbeans.modules.java.api.common.project.JavaActionProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.util.Parameters;

public final class MultiModuleActionProviderBuilder {
    private final JavaActionProvider.Builder builder;
    private final PropertyEvaluator evaluator;

    private MultiModuleActionProviderBuilder(@NonNull JavaActionProvider.Builder builder, @NonNull PropertyEvaluator evaluator) {
        Parameters.notNull((CharSequence)"builder", (Object)builder);
        Parameters.notNull((CharSequence)"evaluator", (Object)evaluator);
        this.builder = builder;
        this.evaluator = evaluator;
    }

    @NonNull
    private MultiModuleActionProviderBuilder addProjectSensitiveActions() {
        this.builder.addAction(this.builder.createDefaultScriptAction("clean", false, false, true, "clean"));
        this.builder.addAction(this.builder.createDefaultScriptAction("build", false, false, true, ActionProviderSupport.createConditionalTarget(this.evaluator, ActionProviderSupport.createJarEnabledPredicate(), new String[]{"jar"}, new String[]{"compile"})));
        this.builder.addAction(this.builder.createDefaultScriptAction("rebuild", false, false, true, ActionProviderSupport.createConditionalTarget(this.evaluator, ActionProviderSupport.createJarEnabledPredicate(), new String[]{"clean", "jar"}, new String[]{"clean", "compile"})));
        this.builder.addAction(this.builder.createDefaultScriptAction("run", false, true, true, "run"));
        this.builder.addAction(this.builder.createDefaultScriptAction("debug", false, true, true, "debug"));
        this.builder.addAction(this.builder.createDefaultScriptAction("profile", false, false, true, "profile"));
        this.builder.addAction(this.builder.createDefaultScriptAction("test", false, false, true, "test"));
        this.builder.addAction(this.builder.createDefaultScriptAction("compile.single", false, false, false, "compile-single"));
        this.builder.addAction(this.builder.createDefaultScriptAction("run.single", false, true, true, "run-single"));
        this.builder.addAction(this.builder.createDefaultScriptAction("debug.single", false, true, true, "debug-single"));
        this.builder.addAction(this.builder.createDefaultScriptAction("profile.single", false, false, true, "profile-single"));
        this.builder.addAction(this.builder.createDefaultScriptAction("test.single", false, false, true, "test-single"));
        this.builder.addAction(this.builder.createDefaultScriptAction("debug.test.single", false, false, true, "debug-test"));
        this.builder.addAction(this.builder.createDefaultScriptAction("profile.test.single", false, false, true, "profile-test"));
        this.builder.addAction(this.builder.createDefaultScriptAction("run.single.method", false, true, true, "test-single-method"));
        this.builder.addAction(this.builder.createDefaultScriptAction("debug.single.method", false, true, true, "debug-single-method"));
        this.builder.addAction(this.builder.createDefaultScriptAction("debug.fix", false, true, false, "debug-fix"));
        return this;
    }

    @NonNull
    private MultiModuleActionProviderBuilder addProjectOperationsActions(String ... commands) {
        for (String command : commands) {
            this.builder.addAction(this.builder.createProjectOperation(command));
        }
        return this;
    }

    @NonNull
    public MultiModuleActionProviderBuilder setCompileOnSaveOperationsProvider(@NonNull Supplier<? extends Set<? extends JavaActionProvider.CompileOnSaveOperation>> cosOpsProvider) {
        this.builder.setCompileOnSaveOperationsProvider(cosOpsProvider);
        return this;
    }

    @NonNull
    public JavaActionProvider build() {
        this.addProjectOperationsActions("delete", "move", "copy", "rename");
        this.addProjectSensitiveActions();
        return this.builder.build();
    }

    @NonNull
    public static MultiModuleActionProviderBuilder newInstance(@NonNull Project project, @NonNull UpdateHelper updateHelper, @NonNull PropertyEvaluator evaluator, @NonNull SourceRoots sourceRoots, @NonNull SourceRoots testSourceRoots, @NonNull AbstractClassPathProvider cpp) {
        return new MultiModuleActionProviderBuilder(JavaActionProvider.Builder.newInstance(project, updateHelper, evaluator, sourceRoots, testSourceRoots, (String id) -> {
            ClassPath[] cps = cpp.getProjectClassPaths((String)id);
            if (cps == null || cps.length < 1) {
                return null;
            }
            return cps[0];
        }), evaluator);
    }
}

