/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.fold.ui;

import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldStateChange;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.modules.editor.fold.ui.CaretFoldExpanderImpl;
import org.netbeans.modules.editor.fold.ui.FoldViewFactory;
import org.netbeans.modules.editor.lib2.caret.CaretFoldExpander;
import org.netbeans.spi.editor.fold.FoldHierarchyMonitor;
import org.openide.util.Exceptions;

public class FoldingEditorSupport
implements FoldHierarchyListener {
    private static final Logger LOG = Logger.getLogger(FoldingEditorSupport.class.getName());
    private final JTextComponent component;
    private final FoldHierarchy foldHierarchy;

    FoldingEditorSupport(FoldHierarchy h, JTextComponent component) {
        this.component = component;
        this.foldHierarchy = h;
        component.putClientProperty("org.netbeans.api.fold.expander", new C());
        this.foldHierarchy.addFoldHierarchyListener((FoldHierarchyListener)this);
    }

    public void foldHierarchyChanged(final FoldHierarchyEvent evt) {
        final Caret c = this.component.getCaret();
        if (c == null) {
            return;
        }
        int caretOffset = c.getDot();
        int addedFoldCnt = evt.getAddedFoldCount();
        boolean scrollToView = false;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Received fold hierarchy change {1}, added folds: {0}", new Object[]{addedFoldCnt, evt.hashCode()});
        }
        boolean expand = false;
        boolean includeEnd = false;
        int newPosition = -1;
        FoldHierarchy hierarchy = (FoldHierarchy)evt.getSource();
        if (addedFoldCnt > 0) {
            expand = true;
        } else {
            int startOffset = Integer.MAX_VALUE;
            if (evt.getAffectedStartOffset() <= caretOffset && evt.getAffectedEndOffset() >= caretOffset) {
                for (int i = 0; i < evt.getFoldStateChangeCount(); ++i) {
                    boolean e;
                    int from;
                    int to;
                    Fold fold;
                    FoldStateChange change = evt.getFoldStateChange(i);
                    if (change.isCollapsedChanged()) {
                        fold = change.getFold();
                        if (!fold.isCollapsed() || fold.getStartOffset() > caretOffset || fold.getEndOffset() < caretOffset || fold.getStartOffset() >= startOffset) continue;
                        startOffset = fold.getStartOffset();
                        LOG.log(Level.FINER, "Moving caret from just collapsed fold {0} to offset {1}; evt=" + evt.hashCode(), new Object[]{fold, startOffset});
                        continue;
                    }
                    if (change.isStartOffsetChanged()) {
                        fold = change.getFold();
                        int ostart = change.getOriginalStartOffset();
                        int nstart = fold.getStartOffset();
                        int nend = fold.getEndOffset();
                        to = Math.max(ostart, nstart);
                        from = Math.min(ostart, nstart);
                        boolean bl = e = caretOffset >= from && caretOffset <= to && caretOffset >= nstart && caretOffset < nend;
                        if (e && LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINER, "Fold start extended over caret: {0}; evt= " + evt.hashCode(), fold);
                        }
                        expand |= e;
                        continue;
                    }
                    if (!change.isEndOffsetChanged()) continue;
                    fold = change.getFold();
                    int oend = change.getOriginalEndOffset();
                    int nend = fold.getEndOffset();
                    int nstart = fold.getStartOffset();
                    to = Math.max(oend, nend);
                    from = Math.min(oend, nend);
                    e = caretOffset >= from && caretOffset <= to && caretOffset >= nstart && caretOffset <= nend;
                    expand |= e;
                    boolean bl = includeEnd = caretOffset == nend && nend - nstart > 1;
                    if (!e || !LOG.isLoggable(Level.FINE)) continue;
                    LOG.log(Level.FINER, "Fold end extended over caret: {0}, includeEnd = {1}; evt= " + evt.hashCode(), new Object[]{fold, includeEnd});
                }
                if (startOffset != Integer.MAX_VALUE) {
                    newPosition = startOffset;
                    c.setDot(startOffset);
                    expand = false;
                }
            }
        }
        boolean wasExpanded = false;
        if (expand) {
            Fold collapsed = null;
            if (includeEnd) {
                --caretOffset;
            }
            int dot = caretOffset;
            while ((collapsed = FoldUtilities.findCollapsedFold((FoldHierarchy)hierarchy, (int)caretOffset, (int)caretOffset)) != null) {
                boolean shouldExpand = false;
                if (collapsed.getStartOffset() < caretOffset) {
                    if (collapsed.getEndOffset() > caretOffset) {
                        shouldExpand = true;
                    } else if (addedFoldCnt > 0 && collapsed.getEndOffset() == caretOffset) {
                        shouldExpand = true;
                    }
                }
                if (!shouldExpand) break;
                LOG.log(Level.FINER, "Expanding fold {0}; evt= " + evt.hashCode(), collapsed);
                wasExpanded = true;
                hierarchy.expand(collapsed);
            }
        }
        if (!wasExpanded) {
            Fold preceding;
            Fold fold = preceding = caretOffset > 0 ? FoldUtilities.findNearestFold((FoldHierarchy)hierarchy, (int)(-caretOffset)) : null;
            if (preceding != null) {
                Fold f;
                int i;
                int precEnd = preceding.getEndOffset();
                for (i = 0; i < addedFoldCnt && (f = evt.getAddedFold(i)).getStartOffset() <= precEnd; ++i) {
                    if (f != preceding || !this.onlyWhitespacesBetween(f.getEndOffset(), caretOffset)) continue;
                    LOG.log(Level.FINER, "Expanding fold {0}; evt= " + evt.hashCode(), f);
                    wasExpanded = true;
                    hierarchy.expand(f);
                    break;
                }
                if (!wasExpanded) {
                    FoldStateChange change;
                    Fold f2;
                    int so;
                    for (i = 0; i < evt.getFoldStateChangeCount() && (so = (f2 = (change = evt.getFoldStateChange(i)).getFold()).getStartOffset()) <= precEnd; ++i) {
                        if (!change.isEndOffsetChanged() || f2 != preceding || !f2.isCollapsed() || !this.onlyWhitespacesBetween(f2.getEndOffset(), caretOffset) || this.onlyWhitespacesBetween(change.getOriginalEndOffset(), caretOffset)) continue;
                        LOG.log(Level.FINER, "Expanding fold {0}; evt= " + evt.hashCode(), f2);
                        wasExpanded = true;
                        hierarchy.expand(f2);
                        break;
                    }
                }
            }
        }
        scrollToView = wasExpanded;
        final int newPositionF = newPosition;
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "Added folds: {0}, should scroll: {1}, new pos: {2}; evt= " + evt.hashCode(), new Object[]{addedFoldCnt, scrollToView, newPosition});
        }
        if (addedFoldCnt > 1 || scrollToView || newPosition >= 0) {
            boolean scroll = scrollToView;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LOG.fine("Updating after fold hierarchy change; evt= " + evt.hashCode());
                    if (FoldingEditorSupport.this.component == null || FoldingEditorSupport.this.component.getCaret() != c) {
                        return;
                    }
                    if (newPositionF >= 0) {
                        c.setDot(newPositionF);
                    }
                }
            });
        }
    }

    private boolean onlyWhitespacesBetween(final int endOffset, final int dot) {
        final String[] cnt = new String[1];
        final Document doc = this.component.getDocument();
        doc.render(new Runnable(){

            @Override
            public void run() {
                int dl = doc.getLength();
                int from = Math.min(dl, Math.min(endOffset, dot));
                int to = Math.min(dl, Math.max(endOffset, dot));
                try {
                    cnt[0] = doc.getText(from, to - from);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        return cnt[0] == null || cnt[0].trim().isEmpty();
    }

    static {
        CaretFoldExpander.register((CaretFoldExpander)new CaretFoldExpanderImpl());
    }

    public static class F
    implements FoldHierarchyMonitor {
        public void foldsAttached(FoldHierarchy h) {
            FoldingEditorSupport supp = new FoldingEditorSupport(h, h.getComponent());
            h.getComponent().putClientProperty(F.class, supp);
        }

        static {
            FoldViewFactory.register();
        }
    }

    private class C
    implements Runnable,
    Callable<Boolean> {
        private boolean res;
        private boolean sharp;

        private C() {
        }

        @Override
        public void run() {
            FoldingEditorSupport.this.foldHierarchy.lock();
            try {
                int offset = FoldingEditorSupport.this.component.getCaret().getDot();
                this.res = false;
                Fold f = FoldUtilities.findCollapsedFold((FoldHierarchy)FoldingEditorSupport.this.foldHierarchy, (int)offset, (int)offset);
                if (f != null) {
                    if (this.sharp) {
                        this.res = f.getStartOffset() < offset && f.getEndOffset() > offset;
                    } else {
                        boolean bl = this.res = f.getStartOffset() <= offset && f.getEndOffset() >= offset;
                    }
                    if (this.res) {
                        FoldingEditorSupport.this.foldHierarchy.expand(f);
                    }
                }
            }
            finally {
                FoldingEditorSupport.this.foldHierarchy.unlock();
            }
        }

        public boolean equals(Object whatever) {
            if (!(whatever instanceof Caret)) {
                return super.equals(whatever);
            }
            this.sharp = false;
            Document doc = FoldingEditorSupport.this.component.getDocument();
            doc.render(this);
            return this.res;
        }

        @Override
        public Boolean call() {
            this.sharp = true;
            Document doc = FoldingEditorSupport.this.component.getDocument();
            doc.render(this);
            return this.res;
        }
    }
}

