/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.InvocationExceptionTranslated;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.truffle.RemoteServices;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.modules.debugger.jpda.truffle.breakpoints.TruffleBreakpointsHandler;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.openide.util.Exceptions;

final class DebugManagerHandler {
    private static final Logger LOG = Logger.getLogger(DebugManagerHandler.class.getName());
    private static final String ACCESSOR_START_ACCESS_LOOP = "startAccessLoop";
    private static final String ACCESSOR_LOOP_RUNNING_FIELD = "accessLoopRunning";
    private static final String ACCESSOR_SET_UP_DEBUG_MANAGER_FOR = "setUpDebugManagerFor";
    private static final String ACCESSOR_SET_UP_DEBUG_MANAGER_FOR_SGN = "(L" + Object.class.getName().replace('.', '/') + ";Z)Lorg/netbeans/modules/debugger/jpda/backend/truffle/JPDATruffleDebugManager;";
    private static final Map<JPDADebugger, Boolean> dbgStepInto = Collections.synchronizedMap(new WeakHashMap());
    private final JPDADebugger debugger;
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private ClassType accessorClass;
    private JPDAClassType accessorJPDAClass;
    private final Object accessorClassLock = new Object();
    private final TruffleBreakpointsHandler breakpointsHandler;

    public DebugManagerHandler(JPDADebugger debugger) {
        this.debugger = debugger;
        this.breakpointsHandler = new TruffleBreakpointsHandler(debugger);
    }

    static void execStepInto(JPDADebugger debugger, boolean doStepInto) {
        if (doStepInto) {
            dbgStepInto.put(debugger, doStepInto);
        } else {
            dbgStepInto.remove(debugger);
        }
    }

    private boolean isStepInto() {
        Boolean stepInto = dbgStepInto.get(this.debugger);
        return stepInto != null && stepInto != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newPolyglotEngineInstance(ObjectReference engine, JPDAThreadImpl thread) {
        LOG.log(Level.FINE, "Engine created breakpoint hit: engine = {0} in thread = {1}", new Object[]{engine, thread.getThreadReference()});
        if (this.inited.compareAndSet(false, true)) {
            this.initDebuggerRemoteService((JPDAThread)thread);
        }
        if (this.accessorClass == null) {
            return;
        }
        InvocationExceptionTranslated iextr = null;
        try {
            thread.notifyMethodInvoking();
            VirtualMachine vm = ((JPDADebuggerImpl)this.debugger).getVirtualMachine();
            if (vm == null) {
                return;
            }
            BooleanValue doStepInto = vm.mirrorOf(this.isStepInto());
            Method debugManagerMethod = ClassTypeWrapper.concreteMethodByName((ClassType)this.accessorClass, (String)ACCESSOR_SET_UP_DEBUG_MANAGER_FOR, (String)ACCESSOR_SET_UP_DEBUG_MANAGER_FOR_SGN);
            ThreadReference tr = thread.getThreadReference();
            List<Value> dmArgs = Arrays.asList(engine, doStepInto);
            LOG.log(Level.FINE, "Setting engine and step into = {0}", this.isStepInto());
            Value ret = ClassTypeWrapper.invokeMethod((ClassType)this.accessorClass, (ThreadReference)tr, (Method)debugManagerMethod, dmArgs, (int)1);
            if (ret instanceof ObjectReference) {
                this.breakpointsHandler.submitBreakpoints(this.accessorClass, (ObjectReference)ret, thread);
            }
        }
        catch (VMDisconnectedExceptionWrapper vm) {
        }
        catch (InvocationException iex) {
            iextr = new InvocationExceptionTranslated(iex, thread.getDebugger());
            Exceptions.printStackTrace((Throwable)iex);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            thread.notifyMethodInvokeDone();
        }
        if (iextr != null) {
            iextr.preload(thread);
            Exceptions.printStackTrace((Throwable)iextr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDebuggerRemoteService(JPDAThread thread) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "initDebuggerRemoteService({0})", thread);
        }
        JPDAThreadImpl t = (JPDAThreadImpl)thread;
        Lock writeLock = t.accessLock.writeLock();
        writeLock.lock();
        try {
            ClassObjectReference cor = null;
            try {
                cor = RemoteServices.uploadBasicClasses(t, "org.netbeans.modules.debugger.jpda.backend.truffle.JPDATruffleAccessor");
            }
            catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | PropertyVetoException | IOException pvex) {
                Exceptions.printStackTrace((Throwable)pvex);
            }
            catch (InvocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                InvocationExceptionTranslated iextr = new InvocationExceptionTranslated(ex, t.getDebugger());
                iextr.preload(t);
                Exceptions.printStackTrace((Throwable)iextr);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Uploaded class = {0}", cor);
            }
            if (cor == null) {
                return;
            }
            ThreadReference tr = t.getThreadReference();
            ClassType serviceClass = (ClassType)ClassObjectReferenceWrapper.reflectedType((ClassObjectReference)cor);
            InvocationExceptionTranslated iextr = null;
            Method startMethod = ClassTypeWrapper.concreteMethodByName((ClassType)serviceClass, (String)ACCESSOR_START_ACCESS_LOOP, (String)"()Ljava/lang/Thread;");
            if (startMethod == null) {
                LOG.log(Level.WARNING, "Could not start the access loop of " + serviceClass + ", no " + ACCESSOR_START_ACCESS_LOOP + " method.");
                return;
            }
            try {
                t.notifyMethodInvoking();
                Value ret = ClassTypeWrapper.invokeMethod((ClassType)serviceClass, (ThreadReference)tr, (Method)startMethod, Collections.emptyList(), (int)1);
                if (!(ret instanceof ThreadReference)) {
                    LOG.log(Level.WARNING, "Could not start the access loop of " + serviceClass);
                    return;
                }
                RemoteServices.setAccessLoopStarted((JPDADebugger)t.getDebugger(), (ThreadReference)ret);
                TruffleAccess.assureBPSet(this.debugger, serviceClass);
                JPDAClassType serviceJPDAClass = ((JPDADebuggerImpl)this.debugger).getClassType((ReferenceType)serviceClass);
                Object object = this.accessorClassLock;
                synchronized (object) {
                    this.accessorClass = serviceClass;
                    this.accessorJPDAClass = serviceJPDAClass;
                }
            }
            catch (InvocationException iex) {
                iextr = new InvocationExceptionTranslated(iex, t.getDebugger());
                Exceptions.printStackTrace((Throwable)iex);
            }
            catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | PropertyVetoException | InternalExceptionWrapper | ObjectCollectedExceptionWrapper ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                t.notifyMethodInvokeDone();
                ObjectReferenceWrapper.enableCollection((ObjectReference)cor);
            }
            if (iextr != null) {
                iextr.preload(t);
                Exceptions.printStackTrace((Throwable)iextr);
            }
        }
        catch (InternalExceptionWrapper cor) {
        }
        catch (ClassNotPreparedExceptionWrapper cnpex) {
            Exceptions.printStackTrace((Throwable)cnpex);
        }
        catch (ObjectCollectedExceptionWrapper cnpex) {
        }
        catch (UnsupportedOperationExceptionWrapper uex) {
            LOG.log(Level.INFO, uex.getLocalizedMessage(), uex);
        }
        catch (VMDisconnectedExceptionWrapper uex) {
        }
        finally {
            writeLock.unlock();
        }
        if (LOG.isLoggable(Level.FINE)) {
            try {
                LOG.fine("The JPDATruffleAccessor is there: " + RemoteServices.getClass(t.getThreadReference().virtualMachine(), "org.netbeans.modules.debugger.jpda.backend.truffle.JPDATruffleAccessor"));
            }
            catch (Exception ex) {
                LOG.log(Level.FINE, "", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassType getAccessorClass() {
        Object object = this.accessorClassLock;
        synchronized (object) {
            return this.accessorClass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JPDAClassType getAccessorJPDAClass() {
        Object object = this.accessorClassLock;
        synchronized (object) {
            return this.accessorJPDAClass;
        }
    }

    void destroy() {
        this.breakpointsHandler.destroy();
        if (this.accessorClass == null) {
            return;
        }
        try {
            Field accessLoopRunning = ReferenceTypeWrapper.fieldByName((ReferenceType)this.accessorClass, (String)ACCESSOR_LOOP_RUNNING_FIELD);
            if (accessLoopRunning != null) {
                ClassTypeWrapper.setValue((ClassType)this.accessorClass, (Field)accessLoopRunning, (Value)VirtualMachineWrapper.mirrorOf((VirtualMachine)this.accessorClass.virtualMachine(), (boolean)false));
                RemoteServices.interruptServiceAccessThread(this.debugger);
            }
        }
        catch (VMDisconnectedExceptionWrapper accessLoopRunning) {
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    void breakpointAdded(JSLineBreakpoint jsLineBreakpoint) {
        this.breakpointsHandler.breakpointAdded(jsLineBreakpoint);
    }

    void breakpointRemoved(JSLineBreakpoint jsLineBreakpoint) {
        this.breakpointsHandler.breakpointRemoved(jsLineBreakpoint);
    }
}

