/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.completion;

import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.php.twig.editor.completion.Bundle;
import org.netbeans.modules.php.twig.editor.completion.TwigCompletionContextFinder;
import org.netbeans.modules.php.twig.editor.completion.TwigElement;
import org.netbeans.modules.php.twig.editor.parsing.TwigParserResult;
import org.openide.util.ImageUtilities;

public abstract class TwigCompletionProposal
implements CompletionProposal {
    private final TwigElement element;
    private final CompletionRequest request;

    public TwigCompletionProposal(TwigElement element, CompletionRequest request) {
        this.element = element;
        this.request = request;
    }

    public int getAnchorOffset() {
        return this.request.anchorOffset;
    }

    public ElementHandle getElement() {
        return this.element;
    }

    public String getName() {
        return this.element.getName();
    }

    public String getInsertPrefix() {
        return this.element.getName();
    }

    public String getSortText() {
        return this.element.getName();
    }

    public ImageIcon getIcon() {
        return null;
    }

    public Set<Modifier> getModifiers() {
        return this.element.getModifiers();
    }

    public boolean isSmart() {
        return this.getName().startsWith(this.request.prefix);
    }

    public int getSortPrioOverride() {
        return 0;
    }

    public String getLhsHtml(HtmlFormatter formatter) {
        formatter.name(this.getKind(), true);
        formatter.appendText(this.getName());
        formatter.name(this.getKind(), false);
        this.element.formatParameters(formatter);
        return formatter.getText();
    }

    public String getCustomInsertTemplate() {
        return this.element.getTemplate();
    }

    public static class CompletionRequest {
        public int anchorOffset;
        public String prefix;
        public TwigParserResult parserResult;
        public TwigCompletionContextFinder.CompletionContext context;
    }

    static class OperatorCompletionProposal
    extends TwigCompletionProposal {
        private static final ImageIcon ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/php/twig/resources/twig-logo.png"));

        public OperatorCompletionProposal(TwigElement element, CompletionRequest request) {
            super(element, request);
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return Bundle.OperatorRhs();
        }

        public ElementKind getKind() {
            return ElementKind.KEYWORD;
        }

        @Override
        public ImageIcon getIcon() {
            return ICON;
        }
    }

    static class TestCompletionProposal
    extends TwigCompletionProposal {
        public TestCompletionProposal(TwigElement element, CompletionRequest request) {
            super(element, request);
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return Bundle.TestRhs();
        }

        public ElementKind getKind() {
            return ElementKind.TEST;
        }

        @Override
        public String getSortText() {
            return "20" + this.getName();
        }
    }

    static class FunctionCompletionProposal
    extends TwigCompletionProposal {
        public FunctionCompletionProposal(TwigElement element, CompletionRequest request) {
            super(element, request);
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return Bundle.FunctionRhs();
        }

        public ElementKind getKind() {
            return ElementKind.METHOD;
        }

        @Override
        public String getSortText() {
            return "10" + this.getName();
        }
    }

    static class FilterCompletionProposal
    extends TwigCompletionProposal {
        private static final ImageIcon ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/php/twig/resources/filter.png"));

        public FilterCompletionProposal(TwigElement element, CompletionRequest request) {
            super(element, request);
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return Bundle.FilterRhs();
        }

        public ElementKind getKind() {
            return ElementKind.RULE;
        }

        @Override
        public ImageIcon getIcon() {
            return ICON;
        }
    }

    static class TagCompletionProposal
    extends TwigCompletionProposal {
        public TagCompletionProposal(TwigElement element, CompletionRequest request) {
            super(element, request);
        }

        public String getRhsHtml(HtmlFormatter formatter) {
            return Bundle.TagRhs();
        }

        public ElementKind getKind() {
            return ElementKind.TAG;
        }
    }
}

