/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text;

import org.netbeans.editor.Acceptor;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.modules.xml.text.indent.DTDIndentEngine;
import org.netbeans.modules.xml.text.indent.XMLIndentEngine;
import org.openide.text.IndentEngine;

public final class ComplexValueSettingsFactory {
    private static final Acceptor xmlIdentifierAcceptor = new Acceptor(){

        public boolean accept(char ch) {
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '&': 
                case '\'': 
                case '/': 
                case '<': 
                case '>': 
                case '\\': {
                    return false;
                }
            }
            return true;
        }
    };
    private static final Acceptor abbrevResetAcceptor = new Acceptor(){

        public boolean accept(char ch) {
            return AcceptorFactory.NON_JAVA_IDENTIFIER.accept(ch) && ch != '!' && ch != '?';
        }
    };

    public static IndentEngine getXMLIndentEngine() {
        return new XMLIndentEngine();
    }

    public static Acceptor getXMLIdentifierAcceptor() {
        return xmlIdentifierAcceptor;
    }

    public static Acceptor getXMLAbbrevResetAcceptor() {
        return abbrevResetAcceptor;
    }

    public static IndentEngine getDTDIndentEngine() {
        return new DTDIndentEngine();
    }

    public static Acceptor getDTDAbbrevResetAcceptor() {
        return abbrevResetAcceptor;
    }

    private ComplexValueSettingsFactory() {
    }
}

