/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.client.wizard;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.support.ClientCreator;
import org.netbeans.modules.websvc.core.WSStackUtils;
import org.netbeans.modules.websvc.core.client.wizard.WebServiceClientWizardIterator;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

public class JaxWsClientCreator
implements ClientCreator {
    private Project project;
    private WizardDescriptor wiz;
    private static final boolean DEBUG = false;
    private static final int JSE_PROJECT_TYPE = 0;
    private static final int WEB_PROJECT_TYPE = 1;
    private static final int EJB_PROJECT_TYPE = 2;
    private static final int CAR_PROJECT_TYPE = 3;
    Task task;

    public JaxWsClientCreator(Project project, WizardDescriptor wiz) {
        this.project = project;
        this.wiz = wiz;
    }

    public void createClient() throws IOException {
        WSStackUtils stackUtils = new WSStackUtils(this.project);
        final boolean isJsr109Supported = stackUtils.isJsr109Supported();
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(JaxWsClientCreator.class, (String)"MSG_WizCreateClient"));
        this.task = new Task(new Runnable(){

            @Override
            public void run() {
                try {
                    handle.start();
                    JaxWsClientCreator.this.generate15Client(isJsr109Supported, handle);
                }
                catch (IOException exc) {
                    handle.finish();
                    ErrorManager.getDefault().notify(4096, (Throwable)exc);
                }
            }
        });
        RequestProcessor.getDefault().post((Runnable)this.task);
    }

    private void generate15Client(boolean isJsr109Platform, ProgressHandle handle) throws IOException {
        String packageName;
        JAXWSClientSupport jaxWsClientSupport = null;
        if (this.project != null) {
            jaxWsClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.project.getProjectDirectory());
        }
        if (jaxWsClientSupport == null) {
            String mes = NbBundle.getMessage(WebServiceClientWizardIterator.class, (String)"ERR_NoWebServiceClientSupport");
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            handle.finish();
            return;
        }
        String wsdlUrl = (String)this.wiz.getProperty("wsdlDownloadUrl");
        String filePath = (String)this.wiz.getProperty("wsdlFilePath");
        Boolean useDispatch = (Boolean)this.wiz.getProperty("useDispatch");
        if (wsdlUrl == null) {
            wsdlUrl = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(filePath))).getURL().toExternalForm();
        }
        if ((packageName = (String)this.wiz.getProperty("wsdlPackageName")) != null && packageName.length() == 0) {
            packageName = null;
        }
        String clientName = jaxWsClientSupport.addServiceClient(this.getWsdlName(wsdlUrl), wsdlUrl, packageName, isJsr109Platform);
        if (useDispatch.booleanValue()) {
            List clients = jaxWsClientSupport.getServiceClients();
            for (Object c : clients) {
                if (!((Client)c).getName().equals(clientName)) continue;
                ((Client)c).setUseDispatch(useDispatch);
            }
            JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
            jaxWsModel.write();
        }
        handle.finish();
    }

    private String getWsdlName(String wsdlUrl) {
        String wsdlName;
        int ind = wsdlUrl.lastIndexOf("/");
        String string = wsdlName = ind >= 0 ? wsdlUrl.substring(ind + 1) : wsdlUrl;
        if (wsdlName.toUpperCase().endsWith("?WSDL")) {
            wsdlName = wsdlName.substring(0, wsdlName.length() - 5);
        }
        if ((ind = wsdlName.lastIndexOf(".")) > 0) {
            wsdlName = wsdlName.substring(0, ind);
        }
        return this.convertAllSpecialChars(wsdlName);
    }

    private String convertAllSpecialChars(String resultStr) {
        StringBuffer sb = new StringBuffer(resultStr);
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '/' || c == '.' || c == '_' || c == ' ' || c == '-') continue;
            sb.setCharAt(i, '_');
        }
        return sb.toString();
    }

    static SourceGroup[] getJavaSourceGroups(Project project) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        Set<SourceGroup> testGroups = JaxWsClientCreator.getTestSourceGroups(project, sourceGroups);
        ArrayList<SourceGroup> result = new ArrayList<SourceGroup>();
        for (int i = 0; i < sourceGroups.length; ++i) {
            if (testGroups.contains(sourceGroups[i])) continue;
            result.add(sourceGroups[i]);
        }
        return result.toArray(new SourceGroup[result.size()]);
    }

    private static Set<SourceGroup> getTestSourceGroups(Project project, SourceGroup[] sourceGroups) {
        Map<FileObject, SourceGroup> foldersToSourceGroupsMap = JaxWsClientCreator.createFoldersToSourceGroupsMap(sourceGroups);
        HashSet<SourceGroup> testGroups = new HashSet<SourceGroup>();
        for (int i = 0; i < sourceGroups.length; ++i) {
            testGroups.addAll(JaxWsClientCreator.getTestTargets(sourceGroups[i], foldersToSourceGroupsMap));
        }
        return testGroups;
    }

    private static List<SourceGroup> getTestTargets(SourceGroup sourceGroup, Map<FileObject, SourceGroup> foldersToSourceGroupsMap) {
        URL[] rootURLs = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroup.getRootFolder());
        if (rootURLs.length == 0) {
            return new ArrayList<SourceGroup>();
        }
        ArrayList<SourceGroup> result = new ArrayList<SourceGroup>();
        List<FileObject> sourceRoots = JaxWsClientCreator.getFileObjects(rootURLs);
        for (int i = 0; i < sourceRoots.size(); ++i) {
            FileObject sourceRoot = sourceRoots.get(i);
            SourceGroup srcGroup = foldersToSourceGroupsMap.get(sourceRoot);
            if (srcGroup == null) continue;
            result.add(srcGroup);
        }
        return result;
    }

    private static Map<FileObject, SourceGroup> createFoldersToSourceGroupsMap(SourceGroup[] sourceGroups) {
        Map<FileObject, SourceGroup> result;
        if (sourceGroups.length == 0) {
            result = Collections.emptyMap();
        } else {
            result = new HashMap<FileObject, SourceGroup>(2 * sourceGroups.length, 0.5f);
            for (int i = 0; i < sourceGroups.length; ++i) {
                SourceGroup sourceGroup = sourceGroups[i];
                result.put(sourceGroup.getRootFolder(), sourceGroup);
            }
        }
        return result;
    }

    private static List<FileObject> getFileObjects(URL[] urls) {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (int i = 0; i < urls.length; ++i) {
            FileObject sourceRoot = URLMapper.findFileObject((URL)urls[i]);
            if (sourceRoot != null) {
                result.add(sourceRoot);
                continue;
            }
            int severity = 1;
            if (!ErrorManager.getDefault().isNotifiable(severity)) continue;
            ErrorManager.getDefault().notify(severity, (Throwable)new IllegalStateException("No FileObject found for the following URL: " + urls[i]));
        }
        return result;
    }
}

