/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.swing.SwingUtilities;
import javax.xml.namespace.QName;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.ui.ScanDialog;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.javaee.specs.support.api.JaxWs;
import org.netbeans.modules.javaee.specs.support.api.JaxWsStackSupport;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsModel;
import org.netbeans.modules.websvc.api.jaxws.bindings.BindingsModelFactory;
import org.netbeans.modules.websvc.api.jaxws.bindings.GlobalBindings;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlParameter;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.api.support.java.GenerationUtils;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.core.ProjectInfo;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBinding;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBody;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPHeader;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPMessageBase;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JaxWsUtils {
    public static final String HANDLER_TEMPLATE = "Templates/WebServices/MessageHandler.java";
    private static final String OLD_SOAP12_NAMESPACE = "http://java.sun.com/xml/ns/jaxws/2003/05/soap/bindings/HTTP/";
    private static final String SOAP12_NAMESPACE = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
    private static final String BINDING_TYPE_ANNOTATION = "javax.xml.ws.BindingType";
    private static int projectType;
    private static boolean jsr109Supported;

    public static void generateJaxWsImplementationClass(Project project, FileObject targetFolder, String targetName, WsdlModel wsdlModel, Service service) throws Exception {
        WsdlService wsdlService = wsdlModel.getServiceByName(service.getServiceName());
        WsdlPort wsdlPort = null;
        if (wsdlService != null) {
            wsdlPort = wsdlService.getPortByName(service.getPortName());
        }
        if (wsdlService != null && wsdlPort != null) {
            boolean isStatelessSB;
            String serviceID = service.getName();
            JaxWsUtils.initProjectInfo(project);
            boolean bl = isStatelessSB = projectType == 2;
            if (wsdlPort.isProvider() || service.isUseProvider()) {
                JaxWsUtils.generateProviderImplClass(project, targetFolder, null, targetName, wsdlService, wsdlPort, serviceID, isStatelessSB);
            } else {
                JaxWsUtils.generateJaxWsImplClass(project, targetFolder, targetName, null, wsdlService, wsdlPort, false, serviceID, isStatelessSB);
            }
        }
    }

    public static void generateJaxWsImplementationClass(Project project, FileObject targetFolder, String targetName, URL wsdlURL, WsdlService service, WsdlPort port, boolean useProvider, boolean isStatelessSB) throws Exception {
        if (useProvider) {
            JaxWsUtils.generateJaxWsProvider(project, targetFolder, targetName, wsdlURL, service, port, isStatelessSB);
        } else {
            JaxWsUtils.initProjectInfo(project);
            JaxWsUtils.generateJaxWsImplClass(project, targetFolder, targetName, wsdlURL, service, port, true, null, isStatelessSB);
        }
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static void generateJaxWsArtifacts(Project project, FileObject targetFolder, String targetName, URL wsdlURL, String service, String port) throws Exception {
        JaxWsUtils.initProjectInfo(project);
        JAXWSSupport jaxWsSupport = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
        String artifactsPckg = "service." + targetName.toLowerCase();
        ClassPath classPath = ClassPath.getClassPath((FileObject)targetFolder, (String)"classpath/source");
        String serviceImplPath = classPath.getResourceName(targetFolder, '.', false);
        boolean jsr109 = true;
        JaxWsModel jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            jsr109 = JaxWsUtils.isJsr109(jaxWsModel);
        }
        jaxWsSupport.addService(targetName, serviceImplPath + "." + targetName, wsdlURL.toExternalForm(), service, port, artifactsPckg, jsr109, false);
    }

    public static boolean hasAnnotation(Element element, String fqn) {
        return JaxWsUtils.getAnnotation(element, fqn) != null;
    }

    public static AnnotationMirror getAnnotation(Element element, String fqn) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!JaxWsUtils.hasFqn(annotationMirror, fqn)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean hasFqn(AnnotationMirror mirror, String fqn) {
        Element anElement = mirror.getAnnotationType().asElement();
        if (anElement instanceof TypeElement) {
            return fqn.contentEquals(((TypeElement)anElement).getQualifiedName());
        }
        return false;
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private static void generateProviderImplClass(Project project, FileObject targetFolder, FileObject implClass, String targetName, final WsdlService service, final WsdlPort port, String serviceID, final boolean isStatelessSB) throws Exception {
        JAXWSSupport jaxWsSupport = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
        FileObject implClassFo = implClass;
        if (implClassFo == null) {
            implClassFo = GenerationUtils.createClass((FileObject)targetFolder, (String)targetName, null);
            implClassFo.setAttribute("jax-ws-service", (Object)Boolean.TRUE);
            implClassFo.setAttribute("jax-ws-service-provider", (Object)Boolean.TRUE);
            DataObject.find((FileObject)implClassFo).setValid(false);
        }
        final String wsdlLocation = jaxWsSupport.getWsdlLocation(serviceID);
        final JavaSource targetSource = JavaSource.forFileObject((FileObject)implClassFo);
        final boolean[] isIncomplete = new boolean[1];
        CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                ClassTree javaClass = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                if (javaClass != null) {
                    TypeElement serviceModeAn;
                    TreeMaker make = workingCopy.getTreeMaker();
                    GenerationUtils genUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
                    IdentifierTree implClause = make.Identifier((CharSequence)"javax.xml.ws.Provider<javax.xml.transform.Source>");
                    ClassTree modifiedClass = make.addClassImplementsClause(javaClass, (Tree)implClause);
                    if (isStatelessSB) {
                        TypeElement statelessAn = workingCopy.getElements().getTypeElement("javax.ejb.Stateless");
                        if (statelessAn == null) {
                            isIncomplete[0] = true;
                            return;
                        }
                        AnnotationTree StatelessAnnotation = make.Annotation((Tree)make.QualIdent((Element)statelessAn), Collections.emptyList());
                        modifiedClass = genUtils.addAnnotation(modifiedClass, StatelessAnnotation);
                    }
                    if ((serviceModeAn = workingCopy.getElements().getTypeElement("javax.xml.ws.ServiceMode")) == null) {
                        isIncomplete[0] = true;
                        return;
                    }
                    ArrayList<AssignmentTree> attrs = new ArrayList<AssignmentTree>();
                    IdentifierTree idTree = make.Identifier((CharSequence)"javax.xml.ws.Service.Mode.PAYLOAD");
                    attrs.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"value"), (ExpressionTree)idTree));
                    AnnotationTree serviceModeAnnotation = make.Annotation((Tree)make.QualIdent((Element)serviceModeAn), attrs);
                    modifiedClass = genUtils.addAnnotation(modifiedClass, serviceModeAnnotation);
                    TypeElement wsProviderAn = workingCopy.getElements().getTypeElement("javax.xml.ws.WebServiceProvider");
                    if (wsProviderAn == null) {
                        isIncomplete[0] = true;
                        return;
                    }
                    attrs = new ArrayList();
                    attrs.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"serviceName"), (ExpressionTree)make.Literal((Object)service.getName())));
                    attrs.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"portName"), (ExpressionTree)make.Literal((Object)port.getName())));
                    attrs.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"targetNamespace"), (ExpressionTree)make.Literal((Object)port.getNamespaceURI())));
                    attrs.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"wsdlLocation"), (ExpressionTree)make.Literal((Object)wsdlLocation)));
                    AnnotationTree providerAnnotation = make.Annotation((Tree)make.QualIdent((Element)wsProviderAn), attrs);
                    modifiedClass = genUtils.addAnnotation(modifiedClass, providerAnnotation);
                    String type = "javax.xml.transform.Source";
                    ArrayList<VariableTree> params = new ArrayList<VariableTree>();
                    params.add(make.Variable(make.Modifiers(Collections.emptySet(), Collections.emptyList()), (CharSequence)"source", (Tree)make.Identifier((CharSequence)type), null));
                    ModifiersTree methodModifiers = make.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.emptyList());
                    MethodTree method = make.Method(methodModifiers, (CharSequence)"invoke", (Tree)make.Identifier((CharSequence)type), Collections.emptyList(), params, Collections.emptyList(), "{ //TODO implement this method\nthrow new UnsupportedOperationException(\"Not implemented yet.\") }", null);
                    modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    workingCopy.rewrite((Tree)javaClass, (Tree)modifiedClass);
                }
            }

            public void cancel() {
            }
        };
        ModificationResult result = targetSource.runModificationTask((Task)task);
        if (isIncomplete[0] && org.netbeans.api.java.source.SourceUtils.isScanInProgress()) {
            FileObject implClassArg = implClassFo;
            final Runnable runnable = new Runnable((CancellableTask)task, serviceID, jaxWsSupport, implClassArg){
                final /* synthetic */ CancellableTask val$task;
                final /* synthetic */ String val$serviceID;
                final /* synthetic */ JAXWSSupport val$jaxWsSupport;
                final /* synthetic */ FileObject val$implClassArg;
                {
                    this.val$task = cancellableTask;
                    this.val$serviceID = string;
                    this.val$jaxWsSupport = jAXWSSupport;
                    this.val$implClassArg = fileObject;
                }

                @Override
                public void run() {
                    try {
                        targetSource.runModificationTask((Task)this.val$task).commit();
                        JaxWsUtils.openInEditor(this.val$serviceID, this.val$jaxWsSupport, this.val$implClassArg);
                    }
                    catch (IOException e) {
                        Logger.getLogger(JaxWsUtils.class.getName()).log(Level.WARNING, null, e);
                    }
                }
            };
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScanDialog.runWhenScanFinished((Runnable)runnable, (String)NbBundle.getMessage(JaxWsUtils.class, (String)"LBL_GenerateProvider"));
                }
            });
        } else {
            result.commit();
            JaxWsUtils.openInEditor(serviceID, jaxWsSupport, implClassFo);
        }
    }

    private static void openInEditor(String serviceID, JAXWSSupport jaxWsSupport, FileObject implClassFo) throws DataObjectNotFoundException {
        DataObject dobj = DataObject.find((FileObject)implClassFo);
        if (dobj == null) {
            return;
        }
        JaxWsUtils.openFileInEditor(dobj);
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private static void generateJaxWsProvider(Project project, FileObject targetFolder, String targetName, URL wsdlURL, WsdlService service, WsdlPort port, boolean isStatelessSB) throws Exception {
        JaxWsUtils.initProjectInfo(project);
        JAXWSSupport jaxWsSupport = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
        String portJavaName = port.getJavaName();
        String artifactsPckg = portJavaName.substring(0, portJavaName.lastIndexOf("."));
        FileObject implClassFo = GenerationUtils.createClass((FileObject)targetFolder, (String)targetName, null);
        implClassFo.setAttribute("jax-ws-service", (Object)Boolean.TRUE);
        implClassFo.setAttribute("jax-ws-service-provider", (Object)Boolean.TRUE);
        DataObject.find((FileObject)implClassFo).setValid(false);
        ClassPath classPath = ClassPath.getClassPath((FileObject)implClassFo, (String)"classpath/source");
        String serviceImplPath = classPath.getResourceName(implClassFo, '.', false);
        boolean jsr109 = true;
        JaxWsModel jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            jsr109 = JaxWsUtils.isJsr109(jaxWsModel);
        }
        String serviceID = jaxWsSupport.addService(targetName, serviceImplPath, wsdlURL.toString(), service.getName(), port.getName(), artifactsPckg, jsr109, true);
        JaxWsUtils.generateProviderImplClass(project, targetFolder, implClassFo, targetName, service, port, serviceID, isStatelessSB);
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private static void generateJaxWsImplClass(final Project project, final FileObject targetFolder, final String targetName, final URL wsdlURL, final WsdlService service, final WsdlPort port, final boolean addService, final String serviceID, final boolean isStatelessSB) throws Exception {
        final FileObject implClassFo = GenerationUtils.createClass((FileObject)targetFolder, (String)targetName, null);
        implClassFo.setAttribute("jax-ws-service", (Object)Boolean.TRUE);
        DataObject.find((FileObject)implClassFo).setValid(false);
        DataObject.find((FileObject)implClassFo);
        JavaSource targetSource = JavaSource.forFileObject((FileObject)implClassFo);
        final boolean[] isIncomplete = new boolean[1];
        final String[] sIdContainer = new String[1];
        CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                if (!isIncomplete[0]) {
                    sIdContainer[0] = JaxWsUtils.addService(project, targetFolder, targetName, wsdlURL, service, port, implClassFo, serviceID, addService);
                }
                JAXWSSupport jaxWsSupport = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
                String wsdlLocation = jaxWsSupport.getWsdlLocation(sIdContainer[0]);
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                ClassTree javaClass = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                if (javaClass != null) {
                    TreeMaker make = workingCopy.getTreeMaker();
                    GenerationUtils genUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
                    TypeElement wSAn = workingCopy.getElements().getTypeElement("javax.jws.WebService");
                    if (wSAn == null) {
                        isIncomplete[0] = true;
                        return;
                    }
                    ArrayList<AssignmentTree> attrs = new ArrayList<AssignmentTree>();
                    attrs.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"serviceName"), (ExpressionTree)make.Literal((Object)service.getName())));
                    attrs.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"portName"), (ExpressionTree)make.Literal((Object)port.getName())));
                    attrs.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"endpointInterface"), (ExpressionTree)make.Literal((Object)port.getJavaName())));
                    attrs.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"targetNamespace"), (ExpressionTree)make.Literal((Object)port.getNamespaceURI())));
                    attrs.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"wsdlLocation"), (ExpressionTree)make.Literal((Object)wsdlLocation)));
                    AnnotationTree wSAnnotation = make.Annotation((Tree)make.QualIdent((Element)wSAn), attrs);
                    ClassTree modifiedClass = genUtils.addAnnotation(javaClass, wSAnnotation);
                    if ("http://schemas.xmlsoap.org/wsdl/soap12/".equals(port.getSOAPVersion())) {
                        TypeElement bindingElement = workingCopy.getElements().getTypeElement(JaxWsUtils.BINDING_TYPE_ANNOTATION);
                        if (bindingElement != null) {
                            ArrayList<AssignmentTree> bindingAttrs = new ArrayList<AssignmentTree>();
                            bindingAttrs.add(make.Assignment((ExpressionTree)make.Identifier((CharSequence)"value"), (ExpressionTree)make.Literal((Object)JaxWsUtils.OLD_SOAP12_NAMESPACE)));
                            AnnotationTree bindingAnnotation = make.Annotation((Tree)make.QualIdent((Element)bindingElement), bindingAttrs);
                            modifiedClass = genUtils.addAnnotation(modifiedClass, bindingAnnotation);
                        } else {
                            isIncomplete[0] = true;
                        }
                    }
                    if (isStatelessSB) {
                        TypeElement statelessAn = workingCopy.getElements().getTypeElement("javax.ejb.Stateless");
                        if (statelessAn == null) {
                            isIncomplete[0] = true;
                            return;
                        }
                        AnnotationTree StatelessAnnotation = make.Annotation((Tree)make.QualIdent((Element)statelessAn), Collections.emptyList());
                        modifiedClass = genUtils.addAnnotation(modifiedClass, StatelessAnnotation);
                    }
                    List operations = port.getOperations();
                    for (WsdlOperation operation : operations) {
                        String returnType = operation.getReturnTypeName();
                        List parameters = operation.getParameters();
                        ArrayList<VariableTree> params = new ArrayList<VariableTree>();
                        for (WsdlParameter parameter : parameters) {
                            params.add(make.Variable(make.Modifiers(Collections.emptySet(), Collections.emptyList()), (CharSequence)parameter.getName(), (Tree)make.Identifier((CharSequence)parameter.getTypeName()), null));
                        }
                        Iterator exceptions = operation.getExceptions();
                        ArrayList<ExpressionTree> exc = new ArrayList<ExpressionTree>();
                        while (exceptions.hasNext()) {
                            String exception = (String)exceptions.next();
                            TypeElement excEl = workingCopy.getElements().getTypeElement(exception);
                            if (excEl != null) {
                                exc.add(make.QualIdent((Element)excEl));
                                continue;
                            }
                            exc.add(make.Identifier((CharSequence)exception));
                        }
                        ModifiersTree methodModifiers = make.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.emptyList());
                        MethodTree method = make.Method(methodModifiers, (CharSequence)operation.getJavaName(), (Tree)make.Identifier((CharSequence)returnType), Collections.emptyList(), params, exc, "{ //TODO implement this method\nthrow new UnsupportedOperationException(\"Not implemented yet.\") }", null);
                        modifiedClass = make.addClassMember(modifiedClass, (Tree)method);
                    }
                    workingCopy.rewrite((Tree)javaClass, (Tree)modifiedClass);
                }
            }

            public void cancel() {
            }
        };
        JaxWsUtils.commitModificationTask(targetSource, (Task<WorkingCopy>)task, implClassFo, !isIncomplete[0]);
    }

    public static void openFileInEditor(DataObject dobj) {
        final OpenCookie openCookie = (OpenCookie)dobj.getCookie(OpenCookie.class);
        if (openCookie != null) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    openCookie.open();
                }
            }, 1000);
        } else {
            final EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    ec.open();
                }
            }, 1000);
        }
    }

    public static String getPackageName(String fullyQualifiedName) {
        String packageName = "";
        int index = fullyQualifiedName.lastIndexOf(".");
        if (index != -1) {
            packageName = fullyQualifiedName.substring(0, index);
        }
        return packageName;
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private static String addService(Project project, FileObject targetFolder, String targetName, URL wsdlURL, WsdlService service, WsdlPort port, FileObject implClassFo, String serviceID, boolean addService) {
        if (addService) {
            ClassPath classPath = ClassPath.getClassPath((FileObject)implClassFo, (String)"classpath/source");
            String portJavaName = port.getJavaName();
            String serviceImplPath = classPath.getResourceName(implClassFo, '.', false);
            String artifactsPckg = portJavaName.substring(0, portJavaName.lastIndexOf(46));
            JAXWSSupport jaxWsSupport = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory());
            boolean jsr109 = true;
            JaxWsModel jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class);
            if (jaxWsModel != null) {
                jsr109 = JaxWsUtils.isJsr109(jaxWsModel);
            }
            if ((serviceID = jaxWsSupport.addService(targetName, serviceImplPath, wsdlURL.toString(), service.getName(), port.getName(), artifactsPckg, jsr109, false)) == null) {
                Logger.getLogger(JaxWsUtils.class.getName()).log(Level.WARNING, "Failed to add service element to nbproject/jax-ws.xml. Either problem with downloading wsdl file or problem with writing into nbproject/jax-ws.xml.");
                return serviceID;
            }
        }
        return serviceID;
    }

    private static void commitModificationTask(final JavaSource javaSource, final Task<WorkingCopy> task, final FileObject fileObject, boolean isComplete) throws IOException {
        ModificationResult result = javaSource.runModificationTask(task);
        if (!isComplete && org.netbeans.api.java.source.SourceUtils.isScanInProgress()) {
            final Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        javaSource.runModificationTask(task).commit();
                        JaxWsUtils.openFileInEditor(DataObject.find((FileObject)fileObject));
                    }
                    catch (IOException e) {
                        Logger.getLogger(JaxWsUtils.class.getName()).log(Level.WARNING, null, e);
                    }
                }
            };
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScanDialog.runWhenScanFinished((Runnable)runnable, (String)NbBundle.getMessage(JaxWsUtils.class, (String)"LBL_GenerateWebserviceClass"));
                }
            });
        } else {
            result.commit();
            JaxWsUtils.openFileInEditor(DataObject.find((FileObject)fileObject));
        }
    }

    private static void initProjectInfo(Project project) {
        J2eeModuleProvider provider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (provider != null) {
            J2eeModule.Type moduleType;
            String serverInstance = provider.getServerInstanceID();
            if (serverInstance != null) {
                try {
                    J2eePlatform j2eePlatform = Deployment.getDefault().getServerInstance(serverInstance).getJ2eePlatform();
                    WSStack wsStack = JaxWsStackSupport.getJaxWsStack((J2eePlatform)j2eePlatform);
                    if (wsStack != null) {
                        jsr109Supported = wsStack.isFeatureSupported((WSStack.Feature)JaxWs.Feature.JSR109);
                    }
                }
                catch (InstanceRemovedException ex) {
                    Logger.getLogger(JaxWsUtils.class.getName()).log(Level.INFO, "Failed to find J2eePlatform", ex);
                }
            }
            projectType = J2eeModule.Type.EJB.equals(moduleType = provider.getJ2eeModule().getType()) ? 2 : (J2eeModule.Type.WAR.equals(moduleType) ? 1 : (J2eeModule.Type.CAR.equals(moduleType) ? 3 : 0));
        } else {
            projectType = 0;
        }
    }

    public static boolean isProjectReferenceable(Project clientProject, Project targetProject) {
        AntArtifact jarArtifact;
        if (clientProject == targetProject) {
            return true;
        }
        AntArtifactProvider antArtifactProvider = (AntArtifactProvider)clientProject.getLookup().lookup(AntArtifactProvider.class);
        return antArtifactProvider != null && (jarArtifact = JaxWsUtils.getJarArtifact(antArtifactProvider)) != null;
    }

    public static boolean addProjectReference(Project clientProject, FileObject targetFile) {
        block8: {
            try {
                assert (clientProject != null && targetFile != null);
                Project targetProject = FileOwnerQuery.getOwner((FileObject)targetFile);
                if (clientProject != targetProject) {
                    AntArtifact jarArtifact;
                    AntArtifactProvider antArtifactProvider = (AntArtifactProvider)clientProject.getLookup().lookup(AntArtifactProvider.class);
                    if (antArtifactProvider != null && (jarArtifact = JaxWsUtils.getJarArtifact(antArtifactProvider)) != null) {
                        FileObject targetFo = targetFile;
                        if (!"java".equals(targetFile.getExt())) {
                            SourceGroup[] srcGroups = ProjectUtils.getSources((Project)targetProject).getSourceGroups("java");
                            if (srcGroups != null && srcGroups.length > 0) {
                                targetFo = srcGroups[0].getRootFolder();
                            } else {
                                return false;
                            }
                        }
                        AntArtifact[] jarArtifacts = new AntArtifact[]{jarArtifact};
                        URI[] artifactsUri = jarArtifact.getArtifactLocations();
                        ProjectClassPathModifier.addAntArtifacts((AntArtifact[])jarArtifacts, (URI[])artifactsUri, (FileObject)targetFo, (String)"classpath/compile");
                        return true;
                    }
                    break block8;
                }
                return true;
            }
            catch (IOException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
        }
        return false;
    }

    private static AntArtifact getJarArtifact(AntArtifactProvider antArtifactProvider) {
        AntArtifact[] artifacts = antArtifactProvider.getBuildArtifacts();
        for (int i = 0; i < artifacts.length; ++i) {
            if (!"jar".equals(artifacts[i].getType())) continue;
            return artifacts[i];
        }
        return null;
    }

    public static boolean addRelativeWsdlLocation(FileObject bindingFile, String relativePath) {
        BindingsModel bindingsModel;
        GlobalBindings gb = null;
        ModelSource ms = Utilities.getModelSource((FileObject)bindingFile, (boolean)true);
        if (ms != null && (bindingsModel = BindingsModelFactory.getDefault().getModel(ms)) != null && (gb = bindingsModel.getGlobalBindings()) != null) {
            bindingsModel.startTransaction();
            gb.setWsdlLocation(relativePath);
            bindingsModel.endTransaction();
            return true;
        }
        return false;
    }

    public static boolean isJavaPackage(String pkg) {
        boolean result = false;
        StringTokenizer tukac = new StringTokenizer(pkg, ".", true);
        while (tukac.hasMoreTokens()) {
            String token = tukac.nextToken();
            if (".".equals(token)) {
                if (result) {
                    result = false;
                    continue;
                }
                return false;
            }
            if (!org.openide.util.Utilities.isJavaIdentifier((String)token)) {
                return false;
            }
            result = true;
        }
        return result;
    }

    public static boolean isJavaIdentifier(String id) {
        boolean result = true;
        if (id == null || id.length() == 0 || !Character.isJavaIdentifierStart(id.charAt(0))) {
            result = false;
        } else {
            int idlength = id.length();
            for (int i = 1; i < idlength; ++i) {
                if (Character.isJavaIdentifierPart(id.charAt(i))) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    public static boolean isEjbJavaEE5orHigher(Project project) {
        ProjectInfo projectInfo = new ProjectInfo(project);
        return JaxWsUtils.isEjbJavaEE5orHigher(projectInfo);
    }

    public static boolean isEjbJavaEE5orHigher(ProjectInfo projectInfo) {
        EjbJar ejbModule;
        int projType = projectInfo.getProjectType();
        return projType == 2 && (ejbModule = EjbJar.getEjbJar((FileObject)projectInfo.getProject().getProjectDirectory())) != null && ejbModule.getDeploymentDescriptor() == null;
    }

    public static boolean isCarProject(Project project) {
        ProjectInfo projectInfo = new ProjectInfo(project);
        return JaxWsUtils.isCarProject(projectInfo);
    }

    public static boolean isCarProject(ProjectInfo projectInfo) {
        int projType = projectInfo.getProjectType();
        return projType == 3;
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static void setWebServiceAttrValue(FileObject implClassFo, final String attrName, final String attrValue) {
        final JavaSource javaSource = JavaSource.forFileObject((FileObject)implClassFo);
        final boolean[] isIncomplete = new boolean[1];
        CancellableTask<WorkingCopy> modificationTask = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                ClassTree classTree = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                if (classTree != null) {
                    TreeMaker make = workingCopy.getTreeMaker();
                    GenerationUtils genUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
                    ExpressionTree attrExpr = attrValue == null ? null : genUtils.createAnnotationArgument(attrName, (Object)attrValue);
                    ModifiersTree modif = classTree.getModifiers();
                    List<? extends AnnotationTree> annotations = modif.getAnnotations();
                    ArrayList<AnnotationTree> newAnnotations = new ArrayList<AnnotationTree>();
                    TypeElement webServiceEl = workingCopy.getElements().getTypeElement("javax.jws.WebService");
                    if (webServiceEl == null) {
                        isIncomplete[0] = true;
                        return;
                    }
                    for (AnnotationTree annotationTree : annotations) {
                        IdentifierTree ident = (IdentifierTree)annotationTree.getAnnotationType();
                        TreePath anTreePath = workingCopy.getTrees().getPath(workingCopy.getCompilationUnit(), ident);
                        TypeElement anElement = (TypeElement)workingCopy.getTrees().getElement(anTreePath);
                        if (anElement == null) {
                            isIncomplete[0] = true;
                            continue;
                        }
                        if (anElement.getQualifiedName().contentEquals(webServiceEl.getQualifiedName())) {
                            List<? extends ExpressionTree> expressions = annotationTree.getArguments();
                            ArrayList<ExpressionTree> newExpressions = new ArrayList<ExpressionTree>();
                            boolean attrFound = false;
                            for (ExpressionTree expressionTree : expressions) {
                                AssignmentTree as = (AssignmentTree)expressionTree;
                                IdentifierTree id = (IdentifierTree)as.getVariable();
                                if (id.getName().contentEquals(attrName)) {
                                    attrFound = true;
                                    if (attrExpr == null) continue;
                                    newExpressions.add(attrExpr);
                                    continue;
                                }
                                newExpressions.add(expressionTree);
                            }
                            if (!attrFound) {
                                newExpressions.add(attrExpr);
                            }
                            AnnotationTree webServiceAn = make.Annotation((Tree)make.QualIdent((Element)webServiceEl), newExpressions);
                            newAnnotations.add(webServiceAn);
                            continue;
                        }
                        newAnnotations.add(annotationTree);
                    }
                    ModifiersTree newModifier = make.Modifiers(modif, newAnnotations);
                    workingCopy.rewrite((Tree)modif, (Tree)newModifier);
                }
            }

            public void cancel() {
            }
        };
        try {
            ModificationResult result = javaSource.runModificationTask((Task)modificationTask);
            if (isIncomplete[0] && org.netbeans.api.java.source.SourceUtils.isScanInProgress()) {
                final Runnable runnable = new Runnable((CancellableTask)modificationTask){
                    final /* synthetic */ CancellableTask val$modificationTask;
                    {
                        this.val$modificationTask = cancellableTask;
                    }

                    @Override
                    public void run() {
                        try {
                            javaSource.runModificationTask((Task)this.val$modificationTask).commit();
                        }
                        catch (IOException e) {
                            Logger.getLogger(JaxWsUtils.class.getName()).log(Level.WARNING, null, e);
                        }
                    }
                };
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ScanDialog.runWhenScanFinished((Runnable)runnable, (String)NbBundle.getMessage(JaxWsUtils.class, (String)"LBL_ConfigureWebservice"));
                    }
                });
            } else {
                result.commit();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(JaxWsUtils.class.getName()).log(Level.INFO, null, ex);
        }
    }

    private boolean resolveServiceUrl(Object moduleType, CompilationController controller, TypeElement targetElement, TypeElement wsElement, String[] serviceName, String[] name) throws IOException {
        boolean foundWsAnnotation = false;
        List<? extends AnnotationMirror> annotations = targetElement.getAnnotationMirrors();
        block0: for (AnnotationMirror annotationMirror : annotations) {
            if (!controller.getTypes().isSameType(wsElement.asType(), annotationMirror.getAnnotationType())) continue;
            foundWsAnnotation = true;
            Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : expressions.entrySet()) {
                Object value;
                if (entry.getKey().getSimpleName().contentEquals("serviceName")) {
                    value = expressions.get(entry.getKey()).getValue();
                    if (value != null) {
                        serviceName[0] = URLEncoder.encode(value.toString(), "UTF-8");
                    }
                } else if (entry.getKey().getSimpleName().contentEquals("name") && (value = expressions.get(entry.getKey()).getValue()) != null) {
                    name[0] = URLEncoder.encode(value.toString(), "UTF-8");
                }
                if (serviceName[0] == null || name[0] == null) continue;
                break block0;
            }
        }
        return foundWsAnnotation;
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static boolean isSoap12(FileObject implClassFo) {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)implClassFo);
        final String[] version = new String[1];
        CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)controller);
                List<? extends AnnotationMirror> annotations = typeElement.getAnnotationMirrors();
                boolean foundAnnotation = false;
                for (AnnotationMirror annotationMirror : annotations) {
                    Element annotationElement = annotationMirror.getAnnotationType().asElement();
                    String fqn = null;
                    if (annotationElement instanceof TypeElement) {
                        fqn = ((TypeElement)annotationElement).getQualifiedName().toString();
                    }
                    if (fqn != null && JaxWsUtils.BINDING_TYPE_ANNOTATION.contentEquals(fqn)) {
                        Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = annotationMirror.getElementValues();
                        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : expressions.entrySet()) {
                            if (!entry.getKey().getSimpleName().contentEquals("value")) continue;
                            version[0] = (String)entry.getValue().getValue();
                            foundAnnotation = true;
                            break;
                        }
                    }
                    if (!foundAnnotation) continue;
                    break;
                }
            }

            public void cancel() {
            }
        };
        try {
            javaSource.runUserActionTask((Task)task, true);
        }
        catch (IOException e) {
            Logger.getLogger(JaxWsUtils.class.getName()).log(Level.WARNING, null, e);
        }
        return version[0] != null && (SOAP12_NAMESPACE.equals(version[0]) || OLD_SOAP12_NAMESPACE.equals(version[0]));
    }

    public static void setSOAP12Binding(FileObject implClassFo, final boolean isSOAP12) {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)implClassFo);
        final boolean[] isIncomplete = new boolean[1];
        CancellableTask<WorkingCopy> modificationTask = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TreeMaker make = workingCopy.getTreeMaker();
                TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)workingCopy);
                ClassTree javaClass = workingCopy.getTrees().getTree(typeElement);
                TypeElement bindingElement = workingCopy.getElements().getTypeElement(JaxWsUtils.BINDING_TYPE_ANNOTATION);
                if (bindingElement == null) {
                    isIncomplete[0] = true;
                } else {
                    AnnotationTree bindingAnnotation = null;
                    List<? extends AnnotationTree> annots = javaClass.getModifiers().getAnnotations();
                    for (AnnotationTree annotationTree : annots) {
                        Tree ident = annotationTree.getAnnotationType();
                        TreePath anTreePath = workingCopy.getTrees().getPath(workingCopy.getCompilationUnit(), ident);
                        TypeElement anElement = (TypeElement)workingCopy.getTrees().getElement(anTreePath);
                        if (anTreePath == null) {
                            isIncomplete[0] = true;
                            continue;
                        }
                        if (!anElement.getQualifiedName().contentEquals(JaxWsUtils.BINDING_TYPE_ANNOTATION)) continue;
                        bindingAnnotation = annotationTree;
                        break;
                    }
                    if (isSOAP12 && bindingAnnotation == null) {
                        ModifiersTree modifiersTree = javaClass.getModifiers();
                        AssignmentTree assignmentTree = make.Assignment((ExpressionTree)make.Identifier((CharSequence)"value"), (ExpressionTree)make.Literal((Object)JaxWsUtils.OLD_SOAP12_NAMESPACE));
                        AnnotationTree soapVersionAnnotation = make.Annotation((Tree)make.QualIdent((Element)bindingElement), Collections.singletonList(assignmentTree));
                        ModifiersTree newModifiersTree = make.addModifiersAnnotation(modifiersTree, soapVersionAnnotation);
                        workingCopy.rewrite((Tree)modifiersTree, (Tree)newModifiersTree);
                    } else if (!isSOAP12 && bindingAnnotation != null) {
                        ModifiersTree modifiers = javaClass.getModifiers();
                        ModifiersTree modifiersTree = make.removeModifiersAnnotation(modifiers, bindingAnnotation);
                        workingCopy.rewrite((Tree)modifiers, (Tree)modifiersTree);
                        CompilationUnitTree compileUnitTree = workingCopy.getCompilationUnit();
                        List<? extends ImportTree> imports = compileUnitTree.getImports();
                        for (ImportTree importTree : imports) {
                            Tree impTree = importTree.getQualifiedIdentifier();
                            TreePath impTreePath = workingCopy.getTrees().getPath(workingCopy.getCompilationUnit(), impTree);
                            TypeElement impElement = (TypeElement)workingCopy.getTrees().getElement(impTreePath);
                            if (impElement == null) {
                                isIncomplete[0] = true;
                                continue;
                            }
                            if (!impElement.getQualifiedName().contentEquals(JaxWsUtils.BINDING_TYPE_ANNOTATION)) continue;
                            CompilationUnitTree newCompileUnitTree = make.removeCompUnitImport(compileUnitTree, importTree);
                            workingCopy.rewrite((Tree)compileUnitTree, (Tree)newCompileUnitTree);
                            break;
                        }
                    }
                }
            }

            public void cancel() {
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            JaxWsUtils.modifySoap12Binding(javaSource, modificationTask, implClassFo, isIncomplete[0]);
        } else {
            JaxWsUtils.doModifySoap12Binding(javaSource, modificationTask, implClassFo, isIncomplete[0]);
        }
    }

    private static void modifySoap12Binding(final JavaSource javaSource, final CancellableTask<WorkingCopy> modificationTask, final FileObject implClass, final boolean isIncomplete) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                JaxWsUtils.doModifySoap12Binding(javaSource, (CancellableTask<WorkingCopy>)modificationTask, implClass, isIncomplete);
            }
        });
    }

    private static void doModifySoap12Binding(final JavaSource javaSource, final CancellableTask<WorkingCopy> modificationTask, final FileObject implClass, boolean isIncomplete) {
        try {
            ModificationResult result = javaSource.runModificationTask(modificationTask);
            if (isIncomplete && org.netbeans.api.java.source.SourceUtils.isScanInProgress()) {
                final Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        JaxWsUtils.modifySoap12Binding(javaSource, (CancellableTask<WorkingCopy>)modificationTask, implClass, false);
                    }
                };
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ScanDialog.runWhenScanFinished((Runnable)runnable, (String)NbBundle.getMessage(JaxWsUtils.class, (String)"LBL_ConfigureSoapBinding"));
                    }
                });
            } else {
                result.commit();
                JaxWsUtils.saveFile(implClass);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(JaxWsUtils.class.getName()).log(Level.WARNING, null, ex);
        }
    }

    private static void saveFile(FileObject file) throws IOException {
        SaveCookie cookie;
        DataObject dataObject = DataObject.find((FileObject)file);
        if (dataObject != null && (cookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
            cookie.save();
        }
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static void setWebMethodAttrValue(FileObject implClassFo, final ElementHandle<?> method, final String attrName, final String attrValue) {
        final JavaSource javaSource = JavaSource.forFileObject((FileObject)implClassFo);
        final boolean[] isIncomplete = new boolean[1];
        CancellableTask<WorkingCopy> modificationTask = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                Element methodEl = method.resolve((CompilationInfo)workingCopy);
                if (methodEl == null) {
                    isIncomplete[0] = true;
                } else {
                    GenerationUtils genUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
                    if (genUtils != null) {
                        TreeMaker make = workingCopy.getTreeMaker();
                        ExpressionTree attrExpr = attrValue == null ? null : genUtils.createAnnotationArgument(attrName, (Object)attrValue);
                        MethodTree methodTree = (MethodTree)workingCopy.getTrees().getTree(methodEl);
                        ModifiersTree modif = methodTree.getModifiers();
                        List<? extends AnnotationTree> annotations = modif.getAnnotations();
                        ArrayList<AnnotationTree> newAnnotations = new ArrayList<AnnotationTree>();
                        boolean foundWebMethodAn = false;
                        TypeElement webMethodEl = workingCopy.getElements().getTypeElement("javax.jws.WebMethod");
                        if (webMethodEl == null) {
                            isIncomplete[0] = true;
                            return;
                        }
                        for (AnnotationTree annotationTree : annotations) {
                            IdentifierTree ident = (IdentifierTree)annotationTree.getAnnotationType();
                            TreePath anTreePath = workingCopy.getTrees().getPath(workingCopy.getCompilationUnit(), ident);
                            TypeElement anElement = (TypeElement)workingCopy.getTrees().getElement(anTreePath);
                            if (anElement == null) {
                                isIncomplete[0] = true;
                                continue;
                            }
                            if (anElement.getQualifiedName().contentEquals(webMethodEl.getQualifiedName())) {
                                foundWebMethodAn = true;
                                List<? extends ExpressionTree> expressions = annotationTree.getArguments();
                                ArrayList<ExpressionTree> newExpressions = new ArrayList<ExpressionTree>();
                                boolean attrFound = false;
                                for (ExpressionTree expressionTree : expressions) {
                                    AssignmentTree as = (AssignmentTree)expressionTree;
                                    IdentifierTree id = (IdentifierTree)as.getVariable();
                                    if (id.getName().contentEquals(attrName)) {
                                        attrFound = true;
                                        if (attrExpr == null) continue;
                                        newExpressions.add(attrExpr);
                                        continue;
                                    }
                                    newExpressions.add(expressionTree);
                                }
                                if (!attrFound) {
                                    newExpressions.add(attrExpr);
                                }
                                AnnotationTree webMethodAn = make.Annotation((Tree)make.QualIdent((Element)webMethodEl), newExpressions);
                                newAnnotations.add(webMethodAn);
                                continue;
                            }
                            newAnnotations.add(annotationTree);
                        }
                        if (!foundWebMethodAn && attrExpr != null) {
                            AnnotationTree webMethodAn = make.Annotation((Tree)make.QualIdent((Element)webMethodEl), Collections.singletonList(attrExpr));
                            newAnnotations.add(webMethodAn);
                        }
                        ModifiersTree newModifier = make.Modifiers(modif, newAnnotations);
                        workingCopy.rewrite((Tree)modif, (Tree)newModifier);
                    }
                }
            }

            public void cancel() {
            }
        };
        try {
            ModificationResult result = javaSource.runModificationTask((Task)modificationTask);
            if (isIncomplete[0] && org.netbeans.api.java.source.SourceUtils.isScanInProgress()) {
                final Runnable runnable = new Runnable((CancellableTask)modificationTask){
                    final /* synthetic */ CancellableTask val$modificationTask;
                    {
                        this.val$modificationTask = cancellableTask;
                    }

                    @Override
                    public void run() {
                        try {
                            javaSource.runModificationTask((Task)this.val$modificationTask).commit();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(JaxWsUtils.class.getName()).log(Level.WARNING, null, ex);
                        }
                    }
                };
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ScanDialog.runWhenScanFinished((Runnable)runnable, (String)NbBundle.getMessage(JaxWsUtils.class, (String)"LBL_ConfigureMethod"));
                    }
                });
            } else {
                result.commit();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(JaxWsUtils.class.getName()).log(Level.WARNING, null, ex);
        }
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static void setWebParamAttrValue(FileObject implClassFo, final ElementHandle<?> methodHandle, final String paramName, final String attrName, final String attrValue) {
        final JavaSource javaSource = JavaSource.forFileObject((FileObject)implClassFo);
        final boolean[] isIncomplete = new boolean[1];
        CancellableTask<WorkingCopy> modificationTask = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                Element methodEl = methodHandle.resolve((CompilationInfo)workingCopy);
                if (methodEl == null) {
                    isIncomplete[0] = true;
                } else {
                    GenerationUtils genUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
                    if (genUtils != null) {
                        TreeMaker make = workingCopy.getTreeMaker();
                        ExpressionTree attrExpr = attrValue == null ? null : genUtils.createAnnotationArgument(attrName, (Object)attrValue);
                        MethodTree methodTree = (MethodTree)workingCopy.getTrees().getTree(methodEl);
                        List<? extends VariableTree> parameters = methodTree.getParameters();
                        TypeElement webParamEl = workingCopy.getElements().getTypeElement("javax.jws.WebParam");
                        if (webParamEl == null) {
                            isIncomplete[0] = true;
                            return;
                        }
                        for (VariableTree variableTree : parameters) {
                            if (!variableTree.getName().contentEquals(paramName)) continue;
                            ModifiersTree modif = variableTree.getModifiers();
                            List<? extends AnnotationTree> annotations = modif.getAnnotations();
                            ArrayList<AnnotationTree> newAnnotations = new ArrayList<AnnotationTree>();
                            boolean foundWebParamAn = false;
                            for (AnnotationTree annotationTree : annotations) {
                                IdentifierTree ident = (IdentifierTree)annotationTree.getAnnotationType();
                                TreePath anTreePath = workingCopy.getTrees().getPath(workingCopy.getCompilationUnit(), ident);
                                TypeElement anElement = (TypeElement)workingCopy.getTrees().getElement(anTreePath);
                                if (anElement == null) {
                                    isIncomplete[0] = true;
                                    continue;
                                }
                                if (anElement.getQualifiedName().contentEquals(webParamEl.getQualifiedName())) {
                                    foundWebParamAn = true;
                                    List<? extends ExpressionTree> expressions = annotationTree.getArguments();
                                    ArrayList<ExpressionTree> newExpressions = new ArrayList<ExpressionTree>();
                                    boolean attrFound = false;
                                    for (ExpressionTree expressionTree : expressions) {
                                        AssignmentTree as = (AssignmentTree)expressionTree;
                                        IdentifierTree id = (IdentifierTree)as.getVariable();
                                        if (id.getName().contentEquals(attrName)) {
                                            attrFound = true;
                                            if (attrExpr == null) continue;
                                            newExpressions.add(attrExpr);
                                            continue;
                                        }
                                        newExpressions.add(expressionTree);
                                    }
                                    if (!attrFound) {
                                        newExpressions.add(attrExpr);
                                    }
                                    AnnotationTree webParamAn = make.Annotation((Tree)make.QualIdent((Element)webParamEl), newExpressions);
                                    newAnnotations.add(webParamAn);
                                    continue;
                                }
                                newAnnotations.add(annotationTree);
                            }
                            if (!foundWebParamAn && attrExpr != null) {
                                AnnotationTree webParamAn = make.Annotation((Tree)make.QualIdent((Element)webParamEl), Collections.singletonList(attrExpr));
                                newAnnotations.add(webParamAn);
                            }
                            ModifiersTree newModifier = make.Modifiers(modif, newAnnotations);
                            workingCopy.rewrite((Tree)modif, (Tree)newModifier);
                            break;
                        }
                    }
                }
            }

            public void cancel() {
            }
        };
        try {
            ModificationResult result = javaSource.runModificationTask((Task)modificationTask);
            if (isIncomplete[0] && org.netbeans.api.java.source.SourceUtils.isScanInProgress()) {
                final Runnable runnable = new Runnable((CancellableTask)modificationTask){
                    final /* synthetic */ CancellableTask val$modificationTask;
                    {
                        this.val$modificationTask = cancellableTask;
                    }

                    @Override
                    public void run() {
                        try {
                            javaSource.runModificationTask((Task)this.val$modificationTask).commit();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(JaxWsUtils.class.getName()).log(Level.WARNING, null, ex);
                        }
                    }
                };
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ScanDialog.runWhenScanFinished((Runnable)runnable, (String)NbBundle.getMessage(JaxWsUtils.class, (String)"LBL_ConfigureMethodParameter"));
                    }
                });
            } else {
                result.commit();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(JaxWsUtils.class.getName()).log(Level.WARNING, null, ex);
        }
    }

    public static boolean needsSoapHandler(WsdlModel model) {
        return false;
    }

    public static Map<QName, String> getSoapHandlerParameterTypes(WsdlModel model) {
        return null;
    }

    public static Map<QName, String> getSoapHandlerParameterTypes(PortType portType) {
        List soapBindings;
        HashMap<QName, String> paramMap = new HashMap<QName, String>();
        Definitions definitions = portType.getModel().getDefinitions();
        Collection bindings = definitions.getBindings();
        Binding binding = null;
        for (Binding b : bindings) {
            NamedComponentReference portTypeRef = b.getType();
            if (!((PortType)portTypeRef.get()).equals(portType)) continue;
            binding = b;
            break;
        }
        if (binding != null && (soapBindings = binding.getExtensibilityElements(SOAPBinding.class)).size() > 0) {
            Collection bindingOperations = binding.getBindingOperations();
            for (BindingOperation bOp : bindingOperations) {
                BindingInput bindingInput = bOp.getBindingInput();
                List headers = bindingInput.getExtensibilityElements(SOAPHeader.class);
                for (SOAPHeader header : headers) {
                    NamedComponentReference messageRef = header.getMessage();
                    Message message = (Message)messageRef.get();
                    String partName = header.getPart();
                    Collection messages = definitions.getMessages();
                    block3: for (Message m : messages) {
                        if (!m.equals(message)) continue;
                        Collection parts = m.getParts();
                        for (Part part : parts) {
                            QName qname;
                            if (!part.getName().equals(partName)) continue;
                            NamedComponentReference elementRef = part.getElement();
                            if (elementRef != null) {
                                QName qname2 = elementRef.getQName();
                                if (paramMap.containsKey(qname2)) continue block3;
                                paramMap.put(qname2, "");
                                continue block3;
                            }
                            NamedComponentReference typeRef = part.getType();
                            if (typeRef == null || paramMap.containsKey(qname = typeRef.getQName())) continue block3;
                            paramMap.put(qname, "");
                            continue block3;
                        }
                    }
                }
            }
        }
        return paramMap;
    }

    public static FileObject getSoapHandler(WsdlModel model) {
        return null;
    }

    public static FileObject createSoapHandler(FileObject dest, PortType portType, Map<QName, Object> soapHeaderValues) throws IOException {
        String handlerName = portType.getName() + "_handler.java";
        DataObject dataObj = JaxWsUtils.createDataObjectFromTemplate(HANDLER_TEMPLATE, dest, handlerName);
        return dataObj.getPrimaryFile();
    }

    public static FileObject createSoapHandler(FileObject dest, WsdlModel model, Map<QName, Object> soapHeaderValues) {
        return null;
    }

    public static DataObject createDataObjectFromTemplate(String template, FileObject targetFolder, String targetName) throws IOException {
        assert (template != null);
        assert (targetFolder != null);
        assert (targetName != null && targetName.trim().length() > 0);
        FileObject templateFO = FileUtil.getConfigFile((String)template);
        DataObject templateDO = DataObject.find((FileObject)templateFO);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)targetFolder);
        return templateDO.createFromTemplate(dataFolder, targetName);
    }

    public static boolean isInSourceGroup(Project prj, String serviceClass) {
        SourceGroup[] sourceGroups;
        for (SourceGroup group : sourceGroups = ProjectUtils.getSources((Project)prj).getSourceGroups("java")) {
            String resource = serviceClass.replace('.', '/') + ".java";
            if (group.getRootFolder().getFileObject(resource) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isEjbSupported(Project project) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null) {
            String serverInstanceId = j2eeModuleProvider.getServerInstanceID();
            if (serverInstanceId == null) {
                return false;
            }
            try {
                J2eePlatform platform = Deployment.getDefault().getServerInstance(serverInstanceId).getJ2eePlatform();
                if (platform.getSupportedTypes().contains(J2eeModule.Type.EJB)) {
                    return true;
                }
            }
            catch (InstanceRemovedException ex) {
                Logger.getLogger(JaxWsUtils.class.getName()).log(Level.INFO, "Failed to find J2eePlatform", ex);
            }
        }
        return false;
    }

    public static boolean isRPCEncoded(URI wsdlURI) {
        try {
            FileObject wsdlFO = FileUtil.toFileObject((File)new File(wsdlURI));
            WSDLModel wsdlModel = WSDLModelFactory.getDefault().getModel(Utilities.createModelSource((FileObject)wsdlFO, (boolean)true));
            Definitions definitions = wsdlModel.getDefinitions();
            if (definitions != null) {
                Collection bindings = definitions.getBindings();
                for (Binding binding : bindings) {
                    List soapBindings = binding.getExtensibilityElements(SOAPBinding.class);
                    for (SOAPBinding soapBinding : soapBindings) {
                        if (soapBinding.getStyle() != SOAPBinding.Style.RPC) continue;
                        Collection bindingOperations = binding.getBindingOperations();
                        for (BindingOperation bindingOperation : bindingOperations) {
                            SOAPBody soapBody;
                            List soapBodies;
                            BindingInput bindingInput = bindingOperation.getBindingInput();
                            if (bindingInput == null || (soapBodies = bindingInput.getExtensibilityElements(SOAPBody.class)) == null || soapBodies.size() <= 0 || (soapBody = (SOAPBody)soapBodies.get(0)).getUse() != SOAPMessageBase.Use.ENCODED) continue;
                            return true;
                        }
                    }
                }
            }
        }
        catch (CatalogModelException ex) {
            Logger.global.log(Level.INFO, "", ex);
        }
        return false;
    }

    public static Service findServiceForServiceName(FileObject createdFile, String serviceName) {
        JAXWSSupport support = JAXWSSupport.getJAXWSSupport((FileObject)createdFile);
        List services = support.getServices();
        if (services.size() > 1) {
            Project prj = FileOwnerQuery.getOwner((FileObject)createdFile);
            for (int i = 0; i < services.size() - 1; ++i) {
                Service service = (Service)services.get(i);
                if (!(service.getWsdlUrl() != null ? serviceName.equals(service.getServiceName()) : serviceName.equals(JaxWsUtils.getServiceName(prj, service)))) continue;
                return service;
            }
        }
        return null;
    }

    @SuppressWarnings(value={"NP_NULL_PARAM_DEREF"})
    private static String getServiceName(Project prj, Service service) {
        SourceGroup[] srcGroups = ProjectUtils.getSources((Project)prj).getSourceGroups("java");
        FileObject implClassFo = null;
        String implClassResource = service.getImplementationClass().replace('.', '/') + ".java";
        final String[] serviceName = new String[1];
        if (srcGroups != null) {
            SourceGroup srcGroup;
            FileObject root;
            SourceGroup[] sourceGroupArray = srcGroups;
            int n = sourceGroupArray.length;
            for (int i = 0; i < n && (implClassFo = (root = (srcGroup = sourceGroupArray[i]).getRootFolder()).getFileObject(implClassResource)) == null; ++i) {
            }
        }
        if (implClassFo != null) {
            JavaSource javaSource = JavaSource.forFileObject(implClassFo);
            if (javaSource != null) {
                CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

                    public void run(CompilationController controller) throws IOException {
                        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TypeElement classElement = SourceUtils.getPublicTopLevelElement((CompilationController)controller);
                        if (classElement != null) {
                            List<? extends AnnotationMirror> annotations = classElement.getAnnotationMirrors();
                            block0: for (AnnotationMirror annotationMirror : annotations) {
                                Element annotationElement = annotationMirror.getAnnotationType().asElement();
                                String fqn = null;
                                if (annotationElement instanceof TypeElement) {
                                    fqn = ((TypeElement)annotationElement).getQualifiedName().toString();
                                }
                                if (!"javax.jws.WebService".contentEquals(fqn)) continue;
                                Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = annotationMirror.getElementValues();
                                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : expressions.entrySet()) {
                                    if (entry.getKey().getSimpleName().contentEquals("serviceName")) {
                                        serviceName[0] = (String)expressions.get(entry.getKey()).getValue();
                                    }
                                    if (serviceName[0] == null) continue;
                                    break block0;
                                }
                            }
                        }
                    }

                    public void cancel() {
                    }
                };
                try {
                    javaSource.runUserActionTask((Task)task, true);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
            if (serviceName[0] == null) {
                serviceName[0] = implClassFo.getName() + "Service";
            }
        }
        return serviceName[0];
    }

    public static J2eeModule getJ2eeModule(Project prj) {
        J2eeModuleProvider provider = (J2eeModuleProvider)prj.getLookup().lookup(J2eeModuleProvider.class);
        if (provider != null) {
            return provider.getJ2eeModule();
        }
        return null;
    }

    public static String getModuleType(Project prj) {
        J2eeModuleProvider provider = (J2eeModuleProvider)prj.getLookup().lookup(J2eeModuleProvider.class);
        if (provider != null) {
            J2eeModule.Type moduleType = provider.getJ2eeModule().getType();
            if (J2eeModule.Type.EJB.equals(moduleType)) {
                return "EJB";
            }
            if (J2eeModule.Type.WAR.equals(moduleType)) {
                return "WAR";
            }
            if (J2eeModule.Type.CAR.equals(moduleType)) {
                return "CAR";
            }
            return "UNKNOWN";
        }
        return "J2SE";
    }

    public static boolean askForSunJaxWsConfig(JaxWsModel jaxWsModel) {
        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(JaxWsUtils.class, (String)"MSG_USE_METRO"), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        boolean jsr109 = true;
        if (desc.getValue().equals(DialogDescriptor.YES_OPTION)) {
            jaxWsModel.setJsr109(Boolean.FALSE);
            try {
                jaxWsModel.write();
            }
            catch (IOException ex) {
                Logger.getLogger(JaxWsUtils.class.getName()).log(Level.FINE, "jax-ws.xml not yet exists", ex);
            }
            jsr109 = false;
        } else {
            jaxWsModel.setJsr109(Boolean.TRUE);
            try {
                jaxWsModel.write();
            }
            catch (IOException ex) {
                Logger.getLogger(JaxWsUtils.class.getName()).log(Level.FINE, "jax-ws.xml not yet exists", ex);
            }
            jsr109 = true;
        }
        return jsr109;
    }

    private static boolean isJsr109(JaxWsModel jaxWsModel) {
        if (jaxWsModel.getJsr109() != null) {
            return jaxWsModel.getJsr109();
        }
        if (!jsr109Supported) {
            return JaxWsUtils.askForSunJaxWsConfig(jaxWsModel);
        }
        return true;
    }

    static {
        jsr109Supported = false;
    }

    public static class WsImportClientFailedMessage
    extends NotifyDescriptor.Message {
        public WsImportClientFailedMessage(Throwable ex) {
            super((Object)NbBundle.getMessage(JaxWsUtils.class, (String)"TXT_CannotGenerateClient", (Object)ex.getLocalizedMessage()), 0);
        }
    }

    public static class WsImportServiceFailedMessage
    extends NotifyDescriptor.Message {
        public WsImportServiceFailedMessage(Throwable ex) {
            super((Object)NbBundle.getMessage(JaxWsUtils.class, (String)"TXT_CannotGenerateService", (Object)ex.getLocalizedMessage()), 0);
        }
    }
}

