/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2semodule.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class ModuleTargetChooserPanelGUI
extends JPanel
implements ActionListener,
DocumentListener {
    private static final String NEW_MODULE_PREFIX = NbBundle.getMessage(ModuleTargetChooserPanelGUI.class, (String)"LBL_ModuleTargetChooserPanelGUI_NewModulePrefix");
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    private final Project project;
    private final SourceGroup[] groups;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private final ThreadLocal<Boolean> ignoreChange;
    private JPanel bottomPanelContainer;
    private JLabel documentNameLabel;
    private JTextField documentNameTextField;
    private JLabel fileLabel;
    private JTextField fileTextField;
    private JLabel jLabel1;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField projectTextField;
    private JComboBox rootComboBox;
    private JSeparator targetSeparator;

    public ModuleTargetChooserPanelGUI(Project p, SourceGroup[] groups, Component bottomPanel) {
        this.project = p;
        this.groups = groups;
        this.ignoreChange = new ThreadLocal();
        for (SourceGroup sourceGroup : groups) {
            if (sourceGroup != null) continue;
            throw new NullPointerException();
        }
        this.initComponents();
        this.documentNameTextField.getDocument().addDocumentListener(this);
        if (bottomPanel != null) {
            this.bottomPanelContainer.add(bottomPanel, "Center");
        }
        this.rootComboBox.setRenderer(new GroupListCellRenderer());
        this.rootComboBox.addActionListener(this);
        this.setPreferredSize(PREF_DIM);
        this.setName(NbBundle.getBundle(ModuleTargetChooserPanelGUI.class).getString("LBL_ModuleTargetChooserPanelGUI_Name"));
    }

    @Override
    public void addNotify() {
        Dimension panel2Size = this.jPanel2.getPreferredSize();
        Dimension bottomPanelSize = this.bottomPanelContainer.getPreferredSize();
        Dimension splitterSize = this.targetSeparator.getPreferredSize();
        int vmax = panel2Size.height + bottomPanelSize.height + splitterSize.height + 12;
        if (vmax > ModuleTargetChooserPanelGUI.PREF_DIM.height) {
            this.setPreferredSize(new Dimension(ModuleTargetChooserPanelGUI.PREF_DIM.width, vmax));
        }
        super.addNotify();
    }

    public void initValues(FileObject template, FileObject preselectedFolder) {
        String displayName;
        assert (this.project != null) : "Project must be specified.";
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        assert (template != null);
        try {
            DataObject templateDo = DataObject.find((FileObject)template);
            displayName = templateDo.getNodeDelegate().getDisplayName();
        }
        catch (DataObjectNotFoundException ex) {
            displayName = template.getName();
        }
        this.putClientProperty("NewFileWizard_Title", displayName);
        this.rootComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.groups));
        SourceGroup preselectedGroup = this.getPreselectedGroup(preselectedFolder);
        this.rootComboBox.setSelectedItem(preselectedGroup);
        if (this.documentNameTextField.getText().trim().length() == 0) {
            String baseName;
            String activeName = baseName = NEW_MODULE_PREFIX + displayName.toLowerCase();
            if (preselectedFolder != null) {
                FileObject _tmp;
                int index = 0;
                while ((_tmp = preselectedFolder.getFileObject(activeName, null)) != null) {
                    activeName = baseName + ++index;
                }
            }
            this.documentNameTextField.setText(activeName);
            this.documentNameTextField.selectAll();
        }
        this.updateText();
    }

    public FileObject getRootFolder() {
        Object selectedItem = this.rootComboBox.getSelectedItem();
        return selectedItem instanceof SourceGroup ? ((SourceGroup)selectedItem).getRootFolder() : null;
    }

    public String getTargetName() {
        String text = this.documentNameTextField.getText().trim();
        return text.length() == 0 ? null : text;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    private void initComponents() {
        this.targetSeparator = new JSeparator();
        this.bottomPanelContainer = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.documentNameLabel = new JLabel();
        this.documentNameTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.projectTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.rootComboBox = new JComboBox();
        this.fileLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.bottomPanelContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanelContainer, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.documentNameLabel.setLabelFor(this.documentNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.documentNameLabel, (String)NbBundle.getMessage(ModuleTargetChooserPanelGUI.class, (String)"LBL_ModuleTargetChooserPanelGUI_ModuleName_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.documentNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.documentNameTextField, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/java/j2semodule/ui/wizards/Bundle");
        this.documentNameTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_documentNameTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 24, 0);
        this.jPanel2.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel5.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(ModuleTargetChooserPanelGUI.class, (String)"LBL_ModuleTargetChooserPanelGUI_jLabel5"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_projectTextField"));
        this.jLabel1.setLabelFor(this.rootComboBox);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ModuleTargetChooserPanelGUI.class, (String)"LBL_ModuleTargetChooserPanelGUI_jLabel1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        this.rootComboBox.setMinimumSize(new Dimension(154, 27));
        this.rootComboBox.setPreferredSize(new Dimension(154, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.rootComboBox, gridBagConstraints);
        this.rootComboBox.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_rootComboBox"));
        this.fileLabel.setLabelFor(this.fileTextField);
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)NbBundle.getMessage(ModuleTargetChooserPanelGUI.class, (String)"LBL_ModuleTargetChooserPanelGUI_CreatedModule_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 12, 0);
        this.jPanel2.add((Component)this.fileLabel, gridBagConstraints);
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 12, 0);
        this.jPanel2.add((Component)this.fileTextField, gridBagConstraints);
        this.fileTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_fileTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_ModuleTargetChooserPanelGUI"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.ignoreChange.get() == Boolean.TRUE) {
            return;
        }
        if (this.rootComboBox == e.getSource()) {
            this.updateText();
            this.fireChange();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateText();
        this.fireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    private void updateText() {
        String createdFileName;
        Object selectedItem = this.rootComboBox.getSelectedItem();
        if (selectedItem instanceof SourceGroup) {
            SourceGroup g = (SourceGroup)selectedItem;
            FileObject rootFolder = g.getRootFolder();
            String documentName = this.documentNameTextField.getText().trim();
            createdFileName = FileUtil.getFileDisplayName((FileObject)rootFolder) + "/" + documentName;
        } else {
            createdFileName = "";
        }
        this.fileTextField.setText(createdFileName.replace('/', File.separatorChar));
    }

    private SourceGroup getPreselectedGroup(FileObject folder) {
        for (int i = 0; folder != null && i < this.groups.length; ++i) {
            FileObject root = this.groups[i].getRootFolder();
            if (!root.equals(folder) && !FileUtil.isParentOf((FileObject)root, (FileObject)folder)) continue;
            return this.groups[i];
        }
        return this.groups[0];
    }

    private static final class GroupListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon;
            String name;
            if (value == null) {
                name = "";
                icon = null;
            } else {
                assert (value instanceof SourceGroup);
                SourceGroup g = (SourceGroup)value;
                name = g.getDisplayName();
                icon = g.getIcon(false);
            }
            super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
            this.setIcon(icon);
            return this;
        }
    }
}

