/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.downloader.connector;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.installer.downloader.DownloadManager;
import org.netbeans.installer.downloader.connector.MyProxy;
import org.netbeans.installer.downloader.connector.MyProxySelector;
import org.netbeans.installer.downloader.connector.MyProxyType;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.exceptions.ParseException;
import org.netbeans.installer.utils.helper.Pair;
import org.netbeans.installer.utils.xml.DomUtil;
import org.netbeans.installer.utils.xml.visitors.RecursiveDomVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class URLConnector {
    private static URLConnector instance;
    final MyProxySelector proxySelector = new MyProxySelector();
    int readTimeout = 20000;
    int connectTimeout = 20000;
    boolean doInput = true;
    boolean doOutput = false;
    boolean useCaches = false;
    boolean useProxy = false;
    private File settingFile;
    public static final int SECOND = 1000;
    public static final int MINUTE = 60000;
    public static final String SETTINGS_FILE_NAME = "settings.xml";
    public static final String HTTP_PROXY_HOST_PROPERTY = "http.proxyHost";
    public static final String HTTP_PROXY_PORT_PROPERTY = "http.proxyPort";
    public static final String FTP_PROXY_HOST_PROPERTY = "ftp.proxyHost";
    public static final String FTP_PROXY_PORT_PROPERTY = "ftp.proxyPort";
    public static final String HTTPS_PROXY_HOST_PROPERTY = "https.proxyHost";
    public static final String HTTPS_PROXY_PORT_PROPERTY = "https.proxyPort";
    public static final String SOCKS_PROXY_HOST_PROPERTY = "socksProxyHost";
    public static final String SOCKS_PROXY_PORT_PROPERTY = "socksProxyPort";
    public static final String DEPLOYMENT_PROXY_HTTP_HOST = "deployment.proxy.http.host";
    public static final String DEPLOYMENT_PROXY_HTTP_PORT = "deployment.proxy.http.port";
    public static final String DEPLOYMENT_PROXY_FTP_HOST = "deployment.proxy.ftp.host";
    public static final String DEPLOYMENT_PROXY_FTP_PORT = "deployment.proxy.ftp.port";
    public static final String DEPLOYMENT_PROXY_SOCKS_HOST = "deployment.proxy.socks.host";
    public static final String DEPLOYMENT_PROXY_SOCKS_PORT = "deployment.proxy.socks.port";
    public static final String DEPLOYMENT_PROXY_BYPASS_LIST = "deployment.proxy.bypass.list";
    public static final String DIRECT_CONNECTION_PROPERTY = "javaplugin.proxy.config.type";
    public static final String DIRECT_CONNECTION_VALUE = "direct";
    public static final String PROXY_BYPASS_LIST_SEPARATOR = ",|;";
    public static final String PROXY_TAG = "proxy";
    public static final String USE_PROXY_TAG = "useProxy";
    public static final String CONNECT_TIMEOUT_TAG = "connectTimeout";
    public static final String READ_TIMEOUT_TAG = "readTimeout";
    public static final String DEFAULT_SETTINGS_TEXT = "<connectSettings/>";
    public static final String ERROR_FAILED_PROXY_KEY = "UC.error.failed.proxy";

    public static synchronized URLConnector getConnector() {
        if (instance != null) {
            return instance;
        }
        instance = new URLConnector(new File(DownloadManager.instance.getWd(), SETTINGS_FILE_NAME));
        return instance;
    }

    private void addSystemProxies() {
        this.addProxyFrom(HTTP_PROXY_HOST_PROPERTY, HTTPS_PROXY_PORT_PROPERTY, MyProxyType.HTTP);
        this.addProxyFrom(FTP_PROXY_HOST_PROPERTY, FTP_PROXY_PORT_PROPERTY, MyProxyType.FTP);
        this.addProxyFrom(SOCKS_PROXY_HOST_PROPERTY, SOCKS_PROXY_PORT_PROPERTY, MyProxyType.SOCKS);
    }

    private void addDeploymentProxies() {
        this.addProxyFrom(DEPLOYMENT_PROXY_HTTP_HOST, DEPLOYMENT_PROXY_HTTP_PORT, MyProxyType.HTTP);
        this.addProxyFrom(DEPLOYMENT_PROXY_FTP_HOST, DEPLOYMENT_PROXY_FTP_PORT, MyProxyType.FTP);
        this.addProxyFrom(DEPLOYMENT_PROXY_SOCKS_HOST, DEPLOYMENT_PROXY_SOCKS_PORT, MyProxyType.SOCKS);
        if (DIRECT_CONNECTION_VALUE.equalsIgnoreCase(System.getProperty(DIRECT_CONNECTION_PROPERTY))) {
            this.useProxy = false;
        }
    }

    private void configureByPassList() {
        this.addByPassHostsFrom(DEPLOYMENT_PROXY_BYPASS_LIST);
    }

    private void addProxyFrom(String hostProp, String portProp, MyProxyType type) {
        int port;
        String host = System.getProperty(hostProp);
        String stringPort = System.getProperty(portProp);
        int n = port = stringPort != null ? Integer.parseInt(stringPort) : -1;
        if (host != null && port != -1) {
            Proxy socksProxy = new Proxy(type.getType(), new InetSocketAddress(host, port));
            this.proxySelector.add(new MyProxy(socksProxy, type));
            this.useProxy = true;
        }
    }

    private void addByPassHostsFrom(String byPassProp) {
        String byPassList = System.getProperty(byPassProp);
        if (byPassList == null) {
            return;
        }
        for (String host : byPassList.split(PROXY_BYPASS_LIST_SEPARATOR)) {
            if ("".equals(host = host.trim())) continue;
            this.proxySelector.addByPassHost(host);
        }
    }

    public URLConnector(File settingFile) {
        this.addSystemProxies();
        this.addDeploymentProxies();
        this.configureByPassList();
        this.settingFile = settingFile;
        if (settingFile.exists()) {
            this.load();
            LogManager.log("loaded configuration from file: " + settingFile);
        } else {
            LogManager.log("" + settingFile + " not exist, default configuration was set");
        }
    }

    private void load() {
        try {
            Document settings = DomUtil.parseXmlFile(this.settingFile);
            RecursiveDomVisitor visitor = new RecursiveDomVisitor(){

                @Override
                public void visit(Element elemet) {
                    if (URLConnector.READ_TIMEOUT_TAG.equals(elemet.getNodeName())) {
                        URLConnector.this.readTimeout = Integer.parseInt(elemet.getTextContent().trim());
                    } else if (URLConnector.CONNECT_TIMEOUT_TAG.equals(elemet.getNodeName())) {
                        URLConnector.this.connectTimeout = Integer.parseInt(elemet.getTextContent().trim());
                    } else if (URLConnector.USE_PROXY_TAG.equals(elemet.getNodeName())) {
                        URLConnector.this.useProxy = Boolean.valueOf(elemet.getTextContent().trim());
                    } else if (URLConnector.PROXY_TAG.equals(elemet.getNodeName())) {
                        MyProxy proxy = new MyProxy();
                        proxy.readXML(elemet);
                        URLConnector.this.proxySelector.add(proxy);
                    } else {
                        super.visit(elemet);
                    }
                }
            };
            visitor.visit(settings);
        }
        catch (IOException e) {
            ErrorManager.notifyDebug("I/O error during connector setting loading. Default configuration was set.", e);
        }
        catch (ParseException e) {
            ErrorManager.notifyDebug("Failed to load settings: corrupted xml. Default configuration set.", e);
        }
    }

    public synchronized void dump() {
        try {
            Document document = DomUtil.parseXmlFile(DEFAULT_SETTINGS_TEXT);
            Element root = document.getDocumentElement();
            DomUtil.addElement(root, READ_TIMEOUT_TAG, String.valueOf(this.readTimeout));
            DomUtil.addElement(root, CONNECT_TIMEOUT_TAG, String.valueOf(this.connectTimeout));
            DomUtil.addElement(root, USE_PROXY_TAG, String.valueOf(this.useProxy));
            DomUtil.addChild(root, this.proxySelector);
            DomUtil.writeXmlFile(document, this.settingFile);
        }
        catch (IOException e) {
            ErrorManager.notifyDebug("I/O error. Can't dump configuration", e);
        }
        catch (ParseException e) {
            ErrorManager.notifyDebug("fatal error can't parse <connectSettings/>", e);
        }
    }

    public void addProxy(MyProxy proxy) {
        this.proxySelector.add(proxy);
        this.dump();
    }

    public void removeProxy(MyProxyType type) {
        this.proxySelector.remove(type);
        this.dump();
    }

    public void addByPassHost(String host) {
        this.proxySelector.addByPassHost(host);
    }

    public void clearByPassList() {
        this.proxySelector.clearByPassList();
    }

    public String[] getByPassHosts() {
        return this.proxySelector.getByPass();
    }

    public void setReadTimeout(int readTimeout) {
        if (readTimeout < 0) {
            throw new IllegalArgumentException();
        }
        this.readTimeout = readTimeout;
        this.dump();
    }

    public void setConnectTimeout(int connectTimeout) {
        if (connectTimeout < 0) {
            throw new IllegalArgumentException();
        }
        this.connectTimeout = connectTimeout;
        this.dump();
    }

    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
        this.dump();
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean getUseProxy() {
        return this.useProxy;
    }

    public Proxy getProxy(MyProxyType type) {
        MyProxy proxy = this.proxySelector.getForType(type);
        return proxy != null ? proxy.getProxy() : null;
    }

    public URLConnection establishConnection(URL url) throws IOException {
        return this.establishConnection(url, new ArrayList<Pair<String, String>>(0));
    }

    public URLConnection establishConnection(URL url, List<Pair<String, String>> headerFields) throws IOException {
        Proxy proxy = null;
        URI uri = null;
        try {
            Proxy proxy2;
            if (this.useProxy) {
                uri = url.toURI();
                proxy2 = this.proxySelector.select(uri).get(0);
            } else {
                proxy2 = Proxy.NO_PROXY;
            }
            proxy = proxy2;
            URLConnection connection = this.getConnectionThroughProxy(url, proxy);
            this.configure(connection, headerFields);
            connection.connect();
            return connection;
        }
        catch (URISyntaxException e) {
            ErrorManager.notifyDebug(url + " does not comply with RFC 2396 and cannot be converted to URI", e);
            return url.openConnection(Proxy.NO_PROXY);
        }
        catch (IOException e) {
            this.proxySelector.connectFailed(uri, proxy.address(), e);
            throw (IOException)new IOException(ResourceUtils.getString(URLConnector.class, ERROR_FAILED_PROXY_KEY, proxy, url)).initCause(e);
        }
    }

    private URLConnection getConnectionThroughProxy(URL url, Proxy proxy) throws IOException {
        try {
            return url.openConnection(proxy);
        }
        catch (SecurityException e) {
            ErrorManager.notifyDebug("No permission to connect to proxy: " + proxy, e);
        }
        catch (IllegalArgumentException e) {
            ErrorManager.notifyDebug("Proxy: " + proxy + "has wrong type.", e);
        }
        catch (UnsupportedOperationException e) {
            ErrorManager.notifyDebug(url.getProtocol() + " handler does not support openConnection through proxy.", e);
        }
        throw new IOException(ResourceUtils.getString(URLConnector.class, ERROR_FAILED_PROXY_KEY, proxy, url));
    }

    private void configure(URLConnection connection, List<Pair<String, String>> headerFields) {
        connection.setConnectTimeout(this.connectTimeout);
        connection.setReadTimeout(this.readTimeout);
        connection.setDoInput(this.doInput);
        connection.setDoOutput(this.doOutput);
        connection.setUseCaches(this.useCaches);
        for (Pair<String, String> pair : headerFields) {
            connection.setRequestProperty(pair.getFirst(), pair.getSecond());
        }
    }
}

