/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.jade.editor.indent;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Formatter;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.javascript2.jade.editor.indent.IndentationCounter;

public class JadeFormatter
implements Formatter {
    private static final int INDENT_SIZE = 4;
    private static final int CONTINUATION_SIZE = 8;
    private static final Logger LOG = Logger.getLogger(JadeFormatter.class.getName());

    public JadeFormatter() {
        LOG.log(Level.FINE, "Jade Formatter: {0}", this.toString());
    }

    public void reformat(Context context, ParserResult compilationInfo) {
    }

    public void reindent(Context context) {
        String mimeType = JadeFormatter.getMimeTypeAtOffset(context.document(), context.startOffset());
        String lineEndMimeType = JadeFormatter.getMimeTypeAtOffset(context.document(), context.endOffset() - 1);
        if ("text/jade".equals(mimeType) && mimeType.equals(lineEndMimeType)) {
            IndentationCounter.Indentation indent = new IndentationCounter((BaseDocument)context.document()).count(context.caretOffset());
            indent.modify(context);
        }
    }

    public boolean needsParserResult() {
        return false;
    }

    public int indentSize() {
        return 4;
    }

    public int hangingIndentSize() {
        return 8;
    }

    private static String getMimeTypeAtOffset(Document doc, int offset) {
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        List tsl = th.embeddedTokenSequences(offset, false);
        if (tsl != null && tsl.size() > 0) {
            TokenSequence tokenSequence = (TokenSequence)tsl.get(tsl.size() - 1);
            return tokenSequence.language().mimeType();
        }
        return null;
    }
}

