/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.i18n.FileSelector;
import org.netbeans.modules.i18n.FilteredNode;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.Util;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeOperation;
import org.openide.util.ImageUtilities;
import org.openide.util.UserCancelException;

public class SelectorUtils {
    public static final FilteredNode.NodeFilter BUNDLES_FILTER = new FilteredNode.NodeFilter(){

        @Override
        public boolean acceptNode(Node n) {
            DataObject dataObject = (DataObject)n.getCookie(DataObject.class);
            if (dataObject == null) {
                return false;
            }
            return dataObject instanceof DataFolder && SelectorUtils.isVisible(dataObject) || dataObject instanceof PropertiesDataObject;
        }
    };
    public static final FilteredNode.NodeFilter ALL_FILTER = new FilteredNode.NodeFilter(){

        @Override
        public boolean acceptNode(Node n) {
            return true;
        }
    };

    private static boolean isVisible(DataObject dobj) {
        return dobj.getPrimaryFile() == null || VisibilityQuery.getDefault().isVisible(dobj.getPrimaryFile());
    }

    public static DataObject selectBundle(Project prj, FileObject file) {
        try {
            Node root = SelectorUtils.bundlesNode(prj, file, true);
            Node[] selectedNodes = NodeOperation.getDefault().select(Util.getString("CTL_SelectPropDO_Dialog_Title"), Util.getString("CTL_SelectPropDO_Dialog_RootTitle"), root, new NodeAcceptor(){

                public boolean acceptNodes(Node[] nodes) {
                    if (nodes == null || nodes.length != 1) {
                        return false;
                    }
                    DataObject dataObject = (DataObject)nodes[0].getCookie(DataObject.class);
                    if (dataObject == null) {
                        return false;
                    }
                    return dataObject.getClass().equals(PropertiesDataObject.class);
                }
            });
            return (DataObject)selectedNodes[0].getCookie(DataObject.class);
        }
        catch (UserCancelException uce) {
            return null;
        }
    }

    public static Node bundlesNode(Project prj, FileObject file, boolean includeFiles) {
        ClassPath cp;
        LinkedList<Node> nodes = new LinkedList<Node>();
        if (prj == null) {
            prj = FileOwnerQuery.getOwner((FileObject)file);
        }
        if ((cp = ClassPath.getClassPath((FileObject)file, (String)"classpath/execute")) != null) {
            nodes.addAll(SelectorUtils.getRootNodes(prj, SelectorUtils.getRoots(ClassPath.getClassPath((FileObject)file, (String)"classpath/source"), cp), BUNDLES_FILTER, includeFiles));
        }
        return SelectorUtils.createRootFor(nodes, prj);
    }

    private static List<FileObject> getRoots(ClassPath sources, ClassPath cp) {
        ArrayList<FileObject> l = new ArrayList<FileObject>(cp.entries().size());
        for (ClassPath.Entry e : sources.entries()) {
            if (e.getRoot() == null) continue;
            l.add(e.getRoot());
        }
        for (ClassPath.Entry e : cp.entries()) {
            URL url = e.getURL();
            SourceForBinaryQuery.Result r = SourceForBinaryQuery.findSourceRoots((URL)url);
            FileObject[] fos = r.getRoots();
            if (fos.length > 0) {
                for (FileObject fo : fos) {
                    if (l.contains(fo)) continue;
                    l.add(fo);
                }
                continue;
            }
            if (e.getRoot() == null || l.contains(e.getRoot())) continue;
            l.add(e.getRoot());
        }
        return l;
    }

    private static List<Node> getRootNodes(Project prj, List<FileObject> roots, FilteredNode.NodeFilter filter, boolean includeFiles) {
        ArrayList<Node> nodes = new ArrayList<Node>(roots.size());
        for (FileObject rfo : roots) {
            try {
                if (!includeFiles && FileUtil.toFile((FileObject)rfo) == null) continue;
                Project owner = FileOwnerQuery.getOwner((FileObject)rfo);
                Node origNode = DataObject.find((FileObject)rfo).getNodeDelegate();
                FilteredNode node = new FilteredNode(origNode, filter, SelectorUtils.getDisplayName(rfo, owner, prj != owner));
                nodes.add((Node)node);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {}
        }
        return nodes;
    }

    private static String getDisplayName(FileObject fo, Project owner, boolean incPrjName) {
        if (owner != null) {
            String n;
            SourceGroup grp = SelectorUtils.getSourceGroup(fo, owner);
            String string = n = grp != null ? grp.getDisplayName() : FileUtil.getFileDisplayName((FileObject)fo);
            if (incPrjName) {
                ProjectInformation pi = ProjectUtils.getInformation((Project)owner);
                n = n + " [" + pi.getDisplayName() + "]";
            }
            return n;
        }
        return FileUtil.getFileDisplayName((FileObject)fo);
    }

    private static SourceGroup getSourceGroup(FileObject file, Project prj) {
        SourceGroup[] srcgrps;
        Sources src = ProjectUtils.getSources((Project)prj);
        for (SourceGroup srcGrp : srcgrps = src.getSourceGroups("java")) {
            if (file != srcGrp.getRootFolder()) continue;
            return srcGrp;
        }
        return null;
    }

    public static Node sourcesNode(Project prj, FilteredNode.NodeFilter filter) {
        Sources src = ProjectUtils.getSources((Project)prj);
        SourceGroup[] srcgrps = src.getSourceGroups("java");
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (SourceGroup srcGrp : srcgrps) {
            try {
                FileObject rfo = srcGrp.getRootFolder();
                FilteredNode node = new FilteredNode(DataObject.find((FileObject)rfo).getNodeDelegate(), filter);
                node.setDisplayName(srcGrp.getDisplayName());
                nodes.add((Node)node);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return SelectorUtils.createRootFor(nodes, prj);
    }

    private static Node createRootFor(List<Node> nodes, Project prj) {
        Children.Array ch = new Children.Array();
        Node[] nodesArray = new Node[nodes.size()];
        nodes.toArray(nodesArray);
        ch.add(nodesArray);
        final Icon icon = ProjectUtils.getInformation((Project)prj).getIcon();
        AbstractNode ret = new AbstractNode((Children)ch){

            public Image getIcon(int type) {
                return ImageUtilities.icon2Image((Icon)icon);
            }

            public Image getOpenedIcon(int type) {
                return this.getIcon(type);
            }
        };
        ret.setDisplayName(ProjectUtils.getInformation((Project)prj).getDisplayName());
        return ret;
    }

    public static DataObject instantiateTemplate(Project project, FileObject refFile, DataObject template) throws IOException {
        ObjectNameInputPanel panel = new ObjectNameInputPanel();
        Node repositoryNode = SelectorUtils.bundlesNode(project, refFile, false);
        DataFolder dataFolder = (DataFolder)NodeOperation.getDefault().select(I18nUtil.getBundle().getString("CTL_Template_Dialog_Title"), I18nUtil.getBundle().getString("CTL_Template_Dialog_RootTitle"), repositoryNode, new NodeAcceptor(){

            public boolean acceptNodes(Node[] nodes) {
                if (nodes == null || nodes.length != 1) {
                    return false;
                }
                DataFolder cookie = (DataFolder)nodes[0].getCookie(DataFolder.class);
                return cookie != null && cookie.getPrimaryFile().canWrite();
            }
        }, (Component)panel)[0].getCookie(DataFolder.class);
        String name = panel.getText();
        DataObject newObject = name.equals("") ? template.createFromTemplate(dataFolder) : template.createFromTemplate(dataFolder, name);
        try {
            return newObject;
        }
        catch (ClassCastException cce) {
            throw new UserCancelException();
        }
    }

    public static DataObject selectOrCreateBundle(FileObject refFile, DataObject template, DataObject actBundle) {
        Node rootNode = SelectorUtils.bundlesNode(null, refFile, true);
        FileObject actFile = actBundle != null ? actBundle.getPrimaryFile() : null;
        FileSelector fs = new FileSelector(refFile, template, actFile);
        fs.getDialog(I18nUtil.getBundle().getString("CTL_SelectPropDO_Dialog_Title"), null).setVisible(true);
        return fs.isConfirmed() ? fs.getSelectedDataObject() : null;
    }

    private static class ObjectNameInputPanel
    extends JPanel {
        static final long serialVersionUID = 1980214734060402958L;
        JTextField text;

        public ObjectNameInputPanel() {
            BorderLayout layout = new BorderLayout();
            layout.setVgap(5);
            layout.setHgap(5);
            this.setLayout(layout);
            String labelText = I18nUtil.getBundle().getString("LBL_TemplateName");
            JLabel label = new JLabel();
            Mnemonics.setLocalizedText((JLabel)label, (String)labelText);
            this.text = new JTextField();
            this.text.getAccessibleContext().setAccessibleDescription(I18nUtil.getBundle().getString("ACS_TEXT_ObjectNameInputPanel"));
            label.setLabelFor(this.text);
            this.add("West", label);
            this.add("Center", this.text);
        }

        @Override
        public void requestFocus() {
            this.text.requestFocus();
        }

        public String getText() {
            return this.text.getText();
        }

        public void setText(String s) {
            this.setText(s);
        }
    }
}

