/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.wizard;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformImpl;
import org.netbeans.modules.java.j2seplatform.platformdefinition.PlatformConvertor;
import org.netbeans.modules.java.j2seplatform.platformdefinition.Util;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

public final class NewJ2SEPlatform
extends J2SEPlatformImpl
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(NewJ2SEPlatform.class.getName());
    private boolean valid;

    public static NewJ2SEPlatform create(FileObject installFolder) throws IOException {
        assert (installFolder != null);
        HashMap<String, String> platformProperties = new HashMap<String, String>();
        return new NewJ2SEPlatform(null, Collections.singletonList(installFolder.toURL()), platformProperties, Collections.emptyMap());
    }

    private NewJ2SEPlatform(String name, List<URL> installFolders, Map<String, String> platformProperties, Map<String, String> systemProperties) {
        super(name, name, installFolders, platformProperties, systemProperties, null, null);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void run() {
        try {
            for (String toolName : PlatformConvertor.IMPORTANT_TOOLS) {
                if (this.findTool(toolName) != null) continue;
                return;
            }
            FileObject java = this.findTool("java");
            if (java == null) {
                return;
            }
            File javaFile = FileUtil.toFile((FileObject)java);
            if (javaFile == null) {
                return;
            }
            String javapath = javaFile.getAbsolutePath();
            String filePath = File.createTempFile("nb-platformdetect", "properties").getAbsolutePath();
            String probePath = this.getSDKProperties(javapath, filePath);
            File f = new File(filePath);
            Properties p = new Properties();
            try (FileInputStream is = new FileInputStream(f);){
                p.load(is);
            }
            Collection<FileObject> instFolders = this.getInstallFolders();
            HashMap<String, String> m = new HashMap<String, String>(p.size());
            Enumeration<Object> en = p.keys();
            while (en.hasMoreElements()) {
                String k = (String)en.nextElement();
                String v = p.getProperty(k);
                if ("user.dir".equals(k)) {
                    v = "";
                }
                v = Util.fixSymLinks(k, v, instFolders);
                m.put(k, v);
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Platform properties: {0}", m);
            }
            this.setSystemProperties(Util.filterProbe(m, probePath));
            this.valid = true;
            f.delete();
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Cannot execute probe process", ex);
            this.valid = false;
        }
    }

    private String getSDKProperties(String javaPath, String path) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        try {
            String[] command = new String[]{javaPath, "-classpath", InstalledFileLocator.getDefault().locate("modules/ext/org-netbeans-modules-java-j2seplatform-probe.jar", "org.netbeans.modules.java.j2seplatform", false).getAbsolutePath(), "org.netbeans.modules.java.j2seplatform.wizard.SDKProbe", path};
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Executing: %s %s %s %s %s", command[0], command[1], command[2], command[3], command[4]));
            }
            Process process = runtime.exec(command);
            process.waitFor();
            int exitValue = process.exitValue();
            if (exitValue != 0) {
                throw new IOException(String.format("Java process exit code: %d", exitValue));
            }
            return command[2];
        }
        catch (InterruptedException ex) {
            IOException e = new IOException(ex);
            throw e;
        }
    }
}

