/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.transfer;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.project.connections.RemoteClientImplementation;
import org.netbeans.modules.php.project.connections.common.RemoteUtils;
import org.netbeans.modules.php.project.connections.spi.RemoteFile;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;

final class RemoteTransferFile
extends TransferFile {
    private static final Logger LOGGER = Logger.getLogger(RemoteTransferFile.class.getName());
    private final RemoteFile file;

    public RemoteTransferFile(RemoteClientImplementation remoteClient, RemoteFile file, TransferFile parent) {
        super(remoteClient, parent);
        this.file = file;
        if (file == null) {
            throw new NullPointerException("Remote file cannot be null");
        }
        String parentDirectory = this.getParentDirectory();
        if (!parentDirectory.startsWith("/")) {
            throw new IllegalArgumentException("Parent directory '" + parentDirectory + "' must start with '" + "/" + "'");
        }
        RemoteTransferFile.checkParentDirectory(remoteClient.getBaseRemoteDirectory(), parentDirectory);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Absolute remote path \"{0}\" -> remote path \"{1}\" (base directory \"{2}\")", new Object[]{this.getAbsolutePath(), this.getRemotePath(), remoteClient.getBaseRemoteDirectory()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        RemoteFile remoteFile = this.file;
        synchronized (remoteFile) {
            return this.file.getName();
        }
    }

    @Override
    public String getRemotePath() {
        String absolutePath = this.getAbsolutePath();
        if (absolutePath.equals(this.remoteClient.getBaseRemoteDirectory())) {
            return ".";
        }
        String relativePath = absolutePath.substring(this.remoteClient.getBaseRemoteDirectory().length());
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring("/".length());
        }
        return relativePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getSizeImpl() {
        if (this.isFile()) {
            RemoteFile remoteFile = this.file;
            synchronized (remoteFile) {
                return this.file.getSize();
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDirectory() {
        RemoteFile remoteFile = this.file;
        synchronized (remoteFile) {
            return this.file.isDirectory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFile() {
        RemoteFile remoteFile = this.file;
        synchronized (remoteFile) {
            return this.file.isFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLink() {
        RemoteFile remoteFile = this.file;
        synchronized (remoteFile) {
            return this.file.isLink();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long getTimestampImpl() {
        RemoteFile remoteFile = this.file;
        synchronized (remoteFile) {
            return this.file.getTimestamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getParentDirectory() {
        RemoteFile remoteFile = this.file;
        synchronized (remoteFile) {
            return RemoteUtils.sanitizeDirectoryPath(this.file.getParentDirectory());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getAbsolutePath() {
        RemoteFile remoteFile = this.file;
        synchronized (remoteFile) {
            String parentDirectory = this.getParentDirectory();
            if (!parentDirectory.endsWith("/")) {
                parentDirectory = parentDirectory + "/";
            }
            return parentDirectory + this.getName();
        }
    }

    static void checkParentDirectory(String baseRemoteDirectory, String parentDirectory) {
        boolean root = baseRemoteDirectory.equals("/");
        if (root && !parentDirectory.startsWith("/") || !root && !(parentDirectory + "/").startsWith(baseRemoteDirectory + "/")) {
            throw new IllegalArgumentException("Parent directory '" + parentDirectory + "' must be underneath base directory '" + baseRemoteDirectory + "'");
        }
    }
}

