/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.netserver;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import org.netbeans.modules.netserver.SocketFramework;

public class SocketServer
extends SocketFramework {
    private ServerSocketChannel serverChannel = ServerSocketChannel.open();

    public SocketServer(SocketAddress address) throws IOException {
        this.serverChannel.configureBlocking(false);
        this.serverChannel.socket().bind(address);
        this.serverChannel.register(this.getSelector(), 16);
    }

    @Override
    public void run() {
        try {
            this.doRun();
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, null, e);
        }
        finally {
            try {
                this.serverChannel.close();
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, null, e);
            }
        }
    }

    @Override
    protected SocketAddress getAddress() {
        return this.serverChannel.socket().getLocalSocketAddress();
    }

    @Override
    protected void process(SelectionKey key) throws IOException {
        if (key.isAcceptable()) {
            this.acceptConnection(key);
        } else {
            super.process(key);
        }
    }

    @Override
    protected Queue<ByteBuffer> getWriteQueue(SelectionKey key) {
        Object attachment = key.attachment();
        return (Queue)attachment;
    }

    protected void initWriteQueue(SelectionKey key) {
        if (key.attachment() == null) {
            key.attach(new ConcurrentLinkedQueue());
        }
    }

    @Override
    protected void chanelClosed(SelectionKey key) {
    }

    private void acceptConnection(SelectionKey key) throws IOException {
        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
        SocketChannel socketChannel = serverSocketChannel.accept();
        socketChannel.configureBlocking(false);
        socketChannel.register(this.getSelector(), 1);
        this.initWriteQueue(socketChannel.keyFor(this.getSelector()));
    }
}

