/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.completion;

import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.languages.neon.spi.completion.MethodCompletionProvider;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.ElementQueryFactory;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QuerySupportFactory;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.openide.filesystems.FileObject;

public final class PhpMethodCompletionProvider
implements MethodCompletionProvider {
    private static final PhpMethodCompletionProvider INSTANCE = new PhpMethodCompletionProvider();

    public static PhpMethodCompletionProvider getInstance() {
        return INSTANCE;
    }

    private PhpMethodCompletionProvider() {
    }

    public Set<String> complete(String prefix, String typeName, FileObject fileObject) {
        HashSet<String> result = new HashSet<String>();
        if (typeName != null && !typeName.isEmpty()) {
            ElementQuery.Index indexQuery = ElementQueryFactory.createIndexQuery(QuerySupportFactory.get(fileObject));
            Set<TypeElement> types = indexQuery.getTypes(NameKind.prefix(typeName));
            for (TypeElement typeElement : types) {
                Set<MethodElement> accessibleMethods = indexQuery.getAccessibleMethods(typeElement, typeElement);
                Set<MethodElement> filteredMethods = ElementFilter.forName(NameKind.prefix(prefix)).filter(accessibleMethods);
                for (MethodElement methodElement : filteredMethods) {
                    result.add(methodElement.asString(BaseFunctionElement.PrintAs.NameAndParamsInvocation).trim());
                }
            }
        }
        return result;
    }
}

