/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.typeinference;

import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.typeinference.TypeCompareEnum;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeCompare {
    private static final Logger LOG = LoggerFactory.getLogger(TypeCompare.class);
    private final RootNode root;
    private final ArgTypeComparator comparator;

    public TypeCompare(RootNode root) {
        this.root = root;
        this.comparator = new ArgTypeComparator();
    }

    public TypeCompareEnum compareTypes(ArgType first, ArgType second) {
        boolean secondArray;
        boolean secondKnown;
        if (first == second || Objects.equals(first, second)) {
            return TypeCompareEnum.EQUAL;
        }
        boolean firstKnown = first.isTypeKnown();
        if (firstKnown != (secondKnown = second.isTypeKnown())) {
            if (firstKnown) {
                return this.compareWithUnknown(first, second);
            }
            return this.compareWithUnknown(second, first).invert();
        }
        boolean firstArray = first.isArray();
        if (firstArray != (secondArray = second.isArray())) {
            if (firstArray) {
                return this.compareArrayWithOtherType(first, second);
            }
            return this.compareArrayWithOtherType(second, first).invert();
        }
        if (firstArray) {
            return this.compareTypes(first.getArrayElement(), second.getArrayElement());
        }
        if (!firstKnown) {
            int variantLen = Integer.compare(first.getPossibleTypes().length, second.getPossibleTypes().length);
            return variantLen > 0 ? TypeCompareEnum.WIDER : TypeCompareEnum.NARROW;
        }
        boolean firstPrimitive = first.isPrimitive();
        boolean secondPrimitive = second.isPrimitive();
        boolean firstObj = first.isObject();
        boolean secondObj = second.isObject();
        if (firstObj && secondObj) {
            return this.compareObjects(first, second);
        }
        if (firstObj && secondPrimitive) {
            return TypeCompareEnum.CONFLICT;
        }
        if (firstPrimitive && secondObj) {
            return TypeCompareEnum.CONFLICT;
        }
        if (firstPrimitive && secondPrimitive) {
            int comparePrimitives = first.getPrimitiveType().compareTo(second.getPrimitiveType());
            return comparePrimitives > 0 ? TypeCompareEnum.WIDER : TypeCompareEnum.NARROW;
        }
        LOG.warn("Type compare function not complete, can't compare {} and {}", (Object)first, (Object)second);
        return TypeCompareEnum.CONFLICT;
    }

    private TypeCompareEnum compareArrayWithOtherType(ArgType array, ArgType other) {
        if (!other.isTypeKnown()) {
            if (other.contains(PrimitiveType.ARRAY)) {
                return TypeCompareEnum.NARROW;
            }
            return TypeCompareEnum.CONFLICT;
        }
        if (other.isObject()) {
            if (other.equals(ArgType.OBJECT)) {
                return TypeCompareEnum.NARROW;
            }
            return TypeCompareEnum.CONFLICT;
        }
        if (other.isPrimitive()) {
            return TypeCompareEnum.CONFLICT;
        }
        throw new JadxRuntimeException("Unprocessed type: " + other + " in array compare");
    }

    private TypeCompareEnum compareWithUnknown(ArgType known, ArgType unknown) {
        PrimitiveType[] possibleTypes;
        if (unknown == ArgType.UNKNOWN) {
            return TypeCompareEnum.NARROW;
        }
        if (unknown == ArgType.UNKNOWN_OBJECT && (known.isObject() || known.isArray())) {
            return TypeCompareEnum.NARROW;
        }
        if (known.equals(ArgType.OBJECT) && unknown.isArray()) {
            return TypeCompareEnum.WIDER;
        }
        PrimitiveType knownPrimitive = known.isPrimitive() ? known.getPrimitiveType() : (known.isArray() ? PrimitiveType.ARRAY : PrimitiveType.OBJECT);
        for (PrimitiveType possibleType : possibleTypes = unknown.getPossibleTypes()) {
            if (possibleType != knownPrimitive) continue;
            return TypeCompareEnum.NARROW;
        }
        return TypeCompareEnum.CONFLICT;
    }

    private TypeCompareEnum compareObjects(ArgType first, ArgType second) {
        boolean secondGeneric;
        boolean objectsEquals = first.getObject().equals(second.getObject());
        boolean firstGenericType = first.isGenericType();
        boolean secondGenericType = second.isGenericType();
        if (firstGenericType && secondGenericType && !objectsEquals) {
            return TypeCompareEnum.CONFLICT;
        }
        if (firstGenericType || secondGenericType) {
            if (firstGenericType) {
                return this.compareGenericTypeWithObject(first, second);
            }
            return this.compareGenericTypeWithObject(second, first).invert();
        }
        boolean firstGeneric = first.isGeneric();
        if (firstGeneric != (secondGeneric = second.isGeneric()) && objectsEquals) {
            return firstGeneric ? TypeCompareEnum.NARROW_BY_GENERIC : TypeCompareEnum.WIDER_BY_GENERIC;
        }
        boolean firstIsObjCls = first.equals(ArgType.OBJECT);
        if (firstIsObjCls || second.equals(ArgType.OBJECT)) {
            return firstIsObjCls ? TypeCompareEnum.WIDER : TypeCompareEnum.NARROW;
        }
        if (ArgType.isInstanceOf(this.root, first, second)) {
            return TypeCompareEnum.NARROW;
        }
        if (ArgType.isInstanceOf(this.root, second, first)) {
            return TypeCompareEnum.WIDER;
        }
        if (!ArgType.isClsKnown(this.root, first) || !ArgType.isClsKnown(this.root, second)) {
            return TypeCompareEnum.UNKNOWN;
        }
        return TypeCompareEnum.CONFLICT;
    }

    private TypeCompareEnum compareGenericTypeWithObject(ArgType genericType, ArgType objType) {
        List<ArgType> extendTypes = genericType.getExtendTypes();
        if (extendTypes == null || extendTypes.isEmpty()) {
            if (objType.equals(ArgType.OBJECT)) {
                return TypeCompareEnum.NARROW_BY_GENERIC;
            }
        } else {
            if (extendTypes.contains(objType) || objType.equals(ArgType.OBJECT)) {
                return TypeCompareEnum.NARROW_BY_GENERIC;
            }
            for (ArgType extendType : extendTypes) {
                if (ArgType.isInstanceOf(this.root, extendType, objType)) continue;
                return TypeCompareEnum.CONFLICT;
            }
            return TypeCompareEnum.NARROW_BY_GENERIC;
        }
        return TypeCompareEnum.NARROW_BY_GENERIC;
    }

    public ArgTypeComparator getComparator() {
        return this.comparator;
    }

    private final class ArgTypeComparator
    implements Comparator<ArgType> {
        private ArgTypeComparator() {
        }

        @Override
        public int compare(ArgType a, ArgType b) {
            TypeCompareEnum result = TypeCompare.this.compareTypes(a, b);
            switch (result) {
                case CONFLICT: {
                    return -2;
                }
                case WIDER: 
                case WIDER_BY_GENERIC: {
                    return -1;
                }
                case NARROW: 
                case NARROW_BY_GENERIC: {
                    return 1;
                }
            }
            return 0;
        }
    }
}

