/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.api.JavaNode;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.ContentPanel;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.UsageDialog;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.utils.NLS;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.fife.ui.rsyntaxtextarea.Token;

public final class FindUsageAction
extends AbstractAction
implements PopupMenuListener {
    private static final long serialVersionUID = 4692546569977976384L;
    private final transient ContentPanel contentPanel;
    private final transient CodeArea codeArea;
    private final transient JClass jCls;
    private transient JavaNode node;

    public FindUsageAction(ContentPanel contentPanel, CodeArea codeArea, JClass jCls) {
        super(NLS.str("popup.find_usage", new Object[0]));
        this.contentPanel = contentPanel;
        this.codeArea = codeArea;
        this.jCls = jCls;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.node == null) {
            return;
        }
        MainWindow mainWindow = this.contentPanel.getTabbedPane().getMainWindow();
        JNode jNode = mainWindow.getCacheObject().getNodeCache().makeFrom(this.node);
        UsageDialog usageDialog = new UsageDialog(mainWindow, jNode);
        usageDialog.setVisible(true);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        Token token;
        this.node = null;
        Point pos = this.codeArea.getMousePosition();
        if (pos != null && (token = this.codeArea.viewToToken(pos)) != null) {
            this.node = this.codeArea.getJavaNodeAtOffset(this.jCls, token.getOffset());
        }
        this.setEnabled(this.node != null);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }
}

