/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.PainlessScript;
import org.elasticsearch.painless.ScriptClassInfo;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.antlr.Walker;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.node.SSource;
import org.objectweb.asm.util.Printer;

final class Compiler {
    private static final CodeSource CODESOURCE;
    private final Class<?> scriptClass;
    private final PainlessLookup painlessLookup;
    private final Map<String, Class<?>> additionalClasses;

    public Loader createLoader(ClassLoader parent) {
        return new Loader(parent);
    }

    Compiler(Class<?> scriptClass, Class<?> factoryClass, Class<?> statefulFactoryClass, PainlessLookup painlessLookup) {
        this.scriptClass = scriptClass;
        this.painlessLookup = painlessLookup;
        HashMap additionalClasses = new HashMap();
        additionalClasses.put(scriptClass.getName(), scriptClass);
        Compiler.addFactoryMethod(additionalClasses, factoryClass, "newInstance");
        Compiler.addFactoryMethod(additionalClasses, statefulFactoryClass, "newFactory");
        Compiler.addFactoryMethod(additionalClasses, statefulFactoryClass, "newInstance");
        this.additionalClasses = Collections.unmodifiableMap(additionalClasses);
    }

    private static void addFactoryMethod(Map<String, Class<?>> additionalClasses, Class<?> factoryClass, String methodName) {
        if (factoryClass == null) {
            return;
        }
        Method factoryMethod = null;
        for (Method method : factoryClass.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            factoryMethod = method;
            break;
        }
        if (factoryMethod == null) {
            return;
        }
        additionalClasses.put(factoryClass.getName(), factoryClass);
        for (int i = 0; i < factoryMethod.getParameterTypes().length; ++i) {
            Class<?> parameterClazz = factoryMethod.getParameterTypes()[i];
            additionalClasses.put(parameterClazz.getName(), parameterClazz);
        }
    }

    Constructor<?> compile(Loader loader, SSource.MainMethodReserved reserved, String name, String source, CompilerSettings settings) {
        ScriptClassInfo scriptClassInfo = new ScriptClassInfo(this.painlessLookup, this.scriptClass);
        SSource root = Walker.buildPainlessTree(scriptClassInfo, reserved, name, source, settings, this.painlessLookup, null);
        root.analyze(this.painlessLookup);
        Map<String, Object> statics = root.write();
        try {
            Class<? extends PainlessScript> clazz = loader.defineScript(WriterConstants.CLASS_NAME, root.getBytes());
            clazz.getField("$NAME").set(null, name);
            clazz.getField("$SOURCE").set(null, source);
            clazz.getField("$STATEMENTS").set(null, root.getStatements());
            clazz.getField("$DEFINITION").set(null, this.painlessLookup);
            for (Map.Entry<String, Object> statik : statics.entrySet()) {
                clazz.getField(statik.getKey()).set(null, statik.getValue());
            }
            return clazz.getConstructors()[0];
        }
        catch (Exception exception) {
            throw new IllegalStateException("An internal error occurred attempting to define the script [" + name + "].", exception);
        }
    }

    byte[] compile(String name, String source, CompilerSettings settings, Printer debugStream) {
        ScriptClassInfo scriptClassInfo = new ScriptClassInfo(this.painlessLookup, this.scriptClass);
        SSource root = Walker.buildPainlessTree(scriptClassInfo, new SSource.MainMethodReserved(), name, source, settings, this.painlessLookup, debugStream);
        root.analyze(this.painlessLookup);
        root.write();
        return root.getBytes();
    }

    static {
        try {
            CODESOURCE = new CodeSource(new URL("file:/untrusted"), (Certificate[])null);
        }
        catch (MalformedURLException impossible) {
            throw new RuntimeException(impossible);
        }
    }

    final class Loader
    extends SecureClassLoader {
        private final AtomicInteger lambdaCounter;

        Loader(ClassLoader parent) {
            super(parent);
            this.lambdaCounter = new AtomicInteger(0);
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            Class<?> found = (Class<?>)Compiler.this.additionalClasses.get(name);
            if (found != null) {
                return found;
            }
            found = Compiler.this.painlessLookup.javaClassNameToClass(name);
            return found != null ? found : super.findClass(name);
        }

        Class<?> defineFactory(String name, byte[] bytes) {
            return this.defineClass(name, bytes, 0, bytes.length, CODESOURCE);
        }

        Class<? extends PainlessScript> defineScript(String name, byte[] bytes) {
            return this.defineClass(name, bytes, 0, bytes.length, CODESOURCE).asSubclass(PainlessScript.class);
        }

        Class<?> defineLambda(String name, byte[] bytes) {
            return this.defineClass(name, bytes, 0, bytes.length, CODESOURCE);
        }

        int newLambdaIdentifier() {
            return this.lambdaCounter.getAndIncrement();
        }
    }
}

