/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;

public class RestClearIndicesCacheAction
extends BaseRestHandler {
    public RestClearIndicesCacheAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, "/_cache/clear", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_cache/clear", this);
        controller.registerHandler(RestRequest.Method.GET, "/_cache/clear", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_cache/clear", this);
    }

    @Override
    public String getName() {
        return "clear_indices_cache_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        ClearIndicesCacheRequest clearIndicesCacheRequest = new ClearIndicesCacheRequest(Strings.splitStringByCommaToArray(request.param("index")));
        clearIndicesCacheRequest.indicesOptions(IndicesOptions.fromRequest(request, clearIndicesCacheRequest.indicesOptions()));
        RestClearIndicesCacheAction.fromRequest(request, clearIndicesCacheRequest);
        return channel -> client.admin().indices().clearCache(clearIndicesCacheRequest, new RestToXContentListener<ClearIndicesCacheResponse>((RestChannel)channel));
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }

    public static ClearIndicesCacheRequest fromRequest(RestRequest request, ClearIndicesCacheRequest clearIndicesCacheRequest) {
        for (Map.Entry<String, String> entry : request.params().entrySet()) {
            if (Fields.QUERY.match(entry.getKey(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE)) {
                clearIndicesCacheRequest.queryCache(request.paramAsBoolean(entry.getKey(), clearIndicesCacheRequest.queryCache()));
                continue;
            }
            if (Fields.REQUEST.match(entry.getKey(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE)) {
                clearIndicesCacheRequest.requestCache(request.paramAsBoolean(entry.getKey(), clearIndicesCacheRequest.requestCache()));
                continue;
            }
            if (Fields.FIELDDATA.match(entry.getKey(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE)) {
                clearIndicesCacheRequest.fieldDataCache(request.paramAsBoolean(entry.getKey(), clearIndicesCacheRequest.fieldDataCache()));
                continue;
            }
            if (!Fields.FIELDS.match(entry.getKey(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE)) continue;
            clearIndicesCacheRequest.fields(request.paramAsStringArray(entry.getKey(), clearIndicesCacheRequest.fields()));
        }
        return clearIndicesCacheRequest;
    }

    public static class Fields {
        public static final ParseField QUERY = new ParseField("query", new String[]{"filter", "filter_cache"});
        public static final ParseField REQUEST = new ParseField("request", new String[]{"request_cache"});
        public static final ParseField FIELDDATA = new ParseField("fielddata", new String[]{"field_data"});
        public static final ParseField FIELDS = new ParseField("fields", new String[0]);
    }
}

