/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class FieldCapabilities
implements Writeable,
ToXContentObject {
    private static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    private static final ParseField SEARCHABLE_FIELD = new ParseField("searchable", new String[0]);
    private static final ParseField AGGREGATABLE_FIELD = new ParseField("aggregatable", new String[0]);
    private static final ParseField INDICES_FIELD = new ParseField("indices", new String[0]);
    private static final ParseField NON_SEARCHABLE_INDICES_FIELD = new ParseField("non_searchable_indices", new String[0]);
    private static final ParseField NON_AGGREGATABLE_INDICES_FIELD = new ParseField("non_aggregatable_indices", new String[0]);
    private final String name;
    private final String type;
    private final boolean isSearchable;
    private final boolean isAggregatable;
    private final String[] indices;
    private final String[] nonSearchableIndices;
    private final String[] nonAggregatableIndices;
    private static ConstructingObjectParser<FieldCapabilities, String> PARSER = new ConstructingObjectParser("field_capabilities", true, (a, name) -> new FieldCapabilities((String)name, (String)a[0], (Boolean)a[1], (Boolean)a[2], a[3] != null ? ((List)a[3]).toArray(new String[0]) : null, a[4] != null ? ((List)a[4]).toArray(new String[0]) : null, a[5] != null ? ((List)a[5]).toArray(new String[0]) : null));

    public FieldCapabilities(String name, String type, boolean isSearchable, boolean isAggregatable) {
        this(name, type, isSearchable, isAggregatable, null, null, null);
    }

    public FieldCapabilities(String name, String type, boolean isSearchable, boolean isAggregatable, String[] indices, String[] nonSearchableIndices, String[] nonAggregatableIndices) {
        this.name = name;
        this.type = type;
        this.isSearchable = isSearchable;
        this.isAggregatable = isAggregatable;
        this.indices = indices;
        this.nonSearchableIndices = nonSearchableIndices;
        this.nonAggregatableIndices = nonAggregatableIndices;
    }

    public FieldCapabilities(StreamInput in) throws IOException {
        this.name = in.readString();
        this.type = in.readString();
        this.isSearchable = in.readBoolean();
        this.isAggregatable = in.readBoolean();
        this.indices = in.readOptionalStringArray();
        this.nonSearchableIndices = in.readOptionalStringArray();
        this.nonAggregatableIndices = in.readOptionalStringArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.type);
        out.writeBoolean(this.isSearchable);
        out.writeBoolean(this.isAggregatable);
        out.writeOptionalStringArray(this.indices);
        out.writeOptionalStringArray(this.nonSearchableIndices);
        out.writeOptionalStringArray(this.nonAggregatableIndices);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TYPE_FIELD.getPreferredName(), this.type);
        builder.field(SEARCHABLE_FIELD.getPreferredName(), this.isSearchable);
        builder.field(AGGREGATABLE_FIELD.getPreferredName(), this.isAggregatable);
        if (this.indices != null) {
            builder.field(INDICES_FIELD.getPreferredName(), (Object)this.indices);
        }
        if (this.nonSearchableIndices != null) {
            builder.field(NON_SEARCHABLE_INDICES_FIELD.getPreferredName(), (Object)this.nonSearchableIndices);
        }
        if (this.nonAggregatableIndices != null) {
            builder.field(NON_AGGREGATABLE_INDICES_FIELD.getPreferredName(), (Object)this.nonAggregatableIndices);
        }
        builder.endObject();
        return builder;
    }

    public static FieldCapabilities fromXContent(String name, XContentParser parser) throws IOException {
        return (FieldCapabilities)PARSER.parse(parser, (Object)name);
    }

    public String getName() {
        return this.name;
    }

    public boolean isAggregatable() {
        return this.isAggregatable;
    }

    public boolean isSearchable() {
        return this.isSearchable;
    }

    public String getType() {
        return this.type;
    }

    public String[] indices() {
        return this.indices;
    }

    public String[] nonSearchableIndices() {
        return this.nonSearchableIndices;
    }

    public String[] nonAggregatableIndices() {
        return this.nonAggregatableIndices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCapabilities that = (FieldCapabilities)o;
        if (this.isSearchable != that.isSearchable) {
            return false;
        }
        if (this.isAggregatable != that.isAggregatable) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (!Arrays.equals(this.indices, that.indices)) {
            return false;
        }
        if (!Arrays.equals(this.nonSearchableIndices, that.nonSearchableIndices)) {
            return false;
        }
        return Arrays.equals(this.nonAggregatableIndices, that.nonAggregatableIndices);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.isSearchable ? 1 : 0);
        result = 31 * result + (this.isAggregatable ? 1 : 0);
        result = 31 * result + Arrays.hashCode(this.indices);
        result = 31 * result + Arrays.hashCode(this.nonSearchableIndices);
        result = 31 * result + Arrays.hashCode(this.nonAggregatableIndices);
        return result;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TYPE_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), SEARCHABLE_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), AGGREGATABLE_FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), INDICES_FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), NON_SEARCHABLE_INDICES_FIELD);
        PARSER.declareStringArray(ConstructingObjectParser.optionalConstructorArg(), NON_AGGREGATABLE_INDICES_FIELD);
    }

    private static class IndexCaps {
        final String name;
        final boolean isSearchable;
        final boolean isAggregatable;

        IndexCaps(String name, boolean isSearchable, boolean isAggregatable) {
            this.name = name;
            this.isSearchable = isSearchable;
            this.isAggregatable = isAggregatable;
        }
    }

    static class Builder {
        private String name;
        private String type;
        private boolean isSearchable;
        private boolean isAggregatable;
        private List<IndexCaps> indiceList;

        Builder(String name, String type) {
            this.name = name;
            this.type = type;
            this.isSearchable = true;
            this.isAggregatable = true;
            this.indiceList = new ArrayList<IndexCaps>();
        }

        void add(String index, boolean search, boolean agg) {
            IndexCaps indexCaps = new IndexCaps(index, search, agg);
            this.indiceList.add(indexCaps);
            this.isSearchable &= search;
            this.isAggregatable &= agg;
        }

        FieldCapabilities build(boolean withIndices) {
            Collections.sort(this.indiceList, Comparator.comparing(o -> o.name));
            String[] indices = withIndices ? (String[])this.indiceList.stream().map(caps -> caps.name).toArray(String[]::new) : null;
            String[] nonSearchableIndices = !this.isSearchable && this.indiceList.stream().anyMatch(caps -> caps.isSearchable) ? (String[])this.indiceList.stream().filter(caps -> !caps.isSearchable).map(caps -> caps.name).toArray(String[]::new) : null;
            String[] nonAggregatableIndices = !this.isAggregatable && this.indiceList.stream().anyMatch(caps -> caps.isAggregatable) ? (String[])this.indiceList.stream().filter(caps -> !caps.isAggregatable).map(caps -> caps.name).toArray(String[]::new) : null;
            return new FieldCapabilities(this.name, this.type, this.isSearchable, this.isAggregatable, indices, nonSearchableIndices, nonAggregatableIndices);
        }
    }
}

