/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4.pipelining;

import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.util.ReferenceCounted;

class HttpPipelinedResponse
implements Comparable<HttpPipelinedResponse>,
ReferenceCounted {
    private final FullHttpResponse response;
    private final ChannelPromise promise;
    private final int sequence;

    HttpPipelinedResponse(FullHttpResponse response, ChannelPromise promise, int sequence) {
        this.response = response;
        this.promise = promise;
        this.sequence = sequence;
    }

    public FullHttpResponse response() {
        return this.response;
    }

    public ChannelPromise promise() {
        return this.promise;
    }

    public int sequence() {
        return this.sequence;
    }

    @Override
    public int compareTo(HttpPipelinedResponse o) {
        return Integer.compare(this.sequence, o.sequence);
    }

    public int refCnt() {
        return this.response.refCnt();
    }

    public ReferenceCounted retain() {
        this.response.retain();
        return this;
    }

    public ReferenceCounted retain(int increment) {
        this.response.retain(increment);
        return this;
    }

    public ReferenceCounted touch() {
        this.response.touch();
        return this;
    }

    public ReferenceCounted touch(Object hint) {
        this.response.touch(hint);
        return this;
    }

    public boolean release() {
        return this.response.release();
    }

    public boolean release(int decrement) {
        return this.response.release(decrement);
    }
}

