/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.cluster;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.di.cluster.Messages;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.changed.ChangedFlag;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.www.SlaveServerDetection;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterSchema
extends ChangedFlag
implements Cloneable,
SharedObjectInterface,
VariableSpace {
    public static final String XML_TAG = "clusterschema";
    private String name;
    private List<SlaveServer> slaveServers;
    private String basePort;
    private boolean shared;
    private String socketsBufferSize;
    private String socketsFlushInterval;
    private boolean socketsCompressed;
    private boolean dynamic;
    private VariableSpace variables = new Variables();
    private long id;

    public ClusterSchema() {
        this.id = -1L;
        this.slaveServers = new ArrayList<SlaveServer>();
        this.socketsBufferSize = "2000";
        this.socketsFlushInterval = "5000";
        this.socketsCompressed = true;
        this.basePort = "40000";
        this.dynamic = false;
    }

    public ClusterSchema(String name, List<SlaveServer> slaveServers) {
        this.name = name;
        this.slaveServers = slaveServers;
    }

    public ClusterSchema clone() {
        ClusterSchema clusterSchema = new ClusterSchema();
        clusterSchema.replaceMeta(this);
        return clusterSchema;
    }

    public void replaceMeta(ClusterSchema clusterSchema) {
        this.name = clusterSchema.name;
        this.basePort = clusterSchema.basePort;
        this.socketsBufferSize = clusterSchema.socketsBufferSize;
        this.socketsCompressed = clusterSchema.socketsCompressed;
        this.socketsFlushInterval = clusterSchema.socketsFlushInterval;
        this.dynamic = clusterSchema.dynamic;
        this.slaveServers.clear();
        this.slaveServers.addAll(clusterSchema.slaveServers);
        this.shared = clusterSchema.shared;
        this.id = clusterSchema.id;
        this.setChanged(true);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.name.equals(((ClusterSchema)obj).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getXML() {
        StringBuffer xml = new StringBuffer(500);
        xml.append("        <").append(XML_TAG).append(">").append(Const.CR);
        xml.append("          ").append(XMLHandler.addTagValue((String)"name", (String)this.name));
        xml.append("          ").append(XMLHandler.addTagValue((String)"base_port", (String)this.basePort));
        xml.append("          ").append(XMLHandler.addTagValue((String)"sockets_buffer_size", (String)this.socketsBufferSize));
        xml.append("          ").append(XMLHandler.addTagValue((String)"sockets_flush_interval", (String)this.socketsFlushInterval));
        xml.append("          ").append(XMLHandler.addTagValue((String)"sockets_compressed", (boolean)this.socketsCompressed));
        xml.append("          ").append(XMLHandler.addTagValue((String)"dynamic", (boolean)this.dynamic));
        xml.append("          <slaveservers>").append(Const.CR);
        for (int i = 0; i < this.slaveServers.size(); ++i) {
            SlaveServer slaveServer = this.slaveServers.get(i);
            xml.append("            ").append(XMLHandler.addTagValue((String)"name", (String)slaveServer.getName()));
        }
        xml.append("          </slaveservers>").append(Const.CR);
        xml.append("        </").append(XML_TAG).append(">").append(Const.CR);
        return xml.toString();
    }

    public ClusterSchema(Node clusterSchemaNode, List<SlaveServer> referenceSlaveServers) {
        this();
        this.name = XMLHandler.getTagValue((Node)clusterSchemaNode, (String)"name");
        this.basePort = XMLHandler.getTagValue((Node)clusterSchemaNode, (String)"base_port");
        this.socketsBufferSize = XMLHandler.getTagValue((Node)clusterSchemaNode, (String)"sockets_buffer_size");
        this.socketsFlushInterval = XMLHandler.getTagValue((Node)clusterSchemaNode, (String)"sockets_flush_interval");
        this.socketsCompressed = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)clusterSchemaNode, (String)"sockets_compressed"));
        this.dynamic = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)clusterSchemaNode, (String)"dynamic"));
        Node slavesNode = XMLHandler.getSubNode((Node)clusterSchemaNode, (String)"slaveservers");
        int nrSlaves = XMLHandler.countNodes((Node)slavesNode, (String)"name");
        for (int i = 0; i < nrSlaves; ++i) {
            Node serverNode = XMLHandler.getSubNodeByNr((Node)slavesNode, (String)"name", (int)i);
            String serverName = XMLHandler.getNodeValue((Node)serverNode);
            SlaveServer slaveServer = SlaveServer.findSlaveServer(referenceSlaveServers, serverName);
            if (slaveServer == null) continue;
            this.slaveServers.add(slaveServer);
        }
    }

    public void saveRep(Repository rep) throws KettleException {
        this.saveRep(rep, -1L, false);
    }

    public void saveRep(Repository rep, long id_transformation, boolean isUsedByTransformation) throws KettleException {
        this.setId(rep.getClusterID(this.name));
        if (this.getId() < 0L) {
            this.setId(rep.insertCluster(this));
        } else {
            rep.delClusterSlaves(this.getId());
        }
        for (int i = 0; i < this.slaveServers.size(); ++i) {
            SlaveServer slaveServer = this.slaveServers.get(i);
            if (slaveServer.getId() < 0L) {
                slaveServer.saveRep(rep, id_transformation, isUsedByTransformation);
            }
            rep.insertClusterSlave(this, slaveServer);
        }
        if (isUsedByTransformation) {
            rep.insertTransformationCluster(id_transformation, this.getId());
        }
    }

    public ClusterSchema(Repository rep, long id_cluster_schema, List<SlaveServer> slaveServers) throws KettleException {
        this();
        this.setId(id_cluster_schema);
        RowMetaAndData row = rep.getClusterSchema(id_cluster_schema);
        this.name = row.getString("NAME", null);
        this.basePort = row.getString("BASE_PORT", null);
        this.socketsBufferSize = row.getString("SOCKETS_BUFFER_SIZE", null);
        this.socketsFlushInterval = row.getString("SOCKETS_FLUSH_INTERVAL", null);
        this.socketsCompressed = row.getBoolean("SOCKETS_COMPRESSED", true);
        this.dynamic = row.getBoolean("DYNAMIC_CLUSTER", true);
        long[] pids = rep.getSlaveIDs(id_cluster_schema);
        for (int i = 0; i < pids.length; ++i) {
            SlaveServer slaveServer = new SlaveServer(rep, pids[i]);
            SlaveServer reference = SlaveServer.findSlaveServer(slaveServers, slaveServer.getName());
            if (reference != null) {
                this.slaveServers.add(reference);
                continue;
            }
            this.slaveServers.add(slaveServer);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<SlaveServer> getSlaveServers() {
        return this.slaveServers;
    }

    public void setSlaveServers(List<SlaveServer> slaveServers) {
        this.slaveServers = slaveServers;
    }

    public String[] getSlaveServerStrings() {
        String[] strings = new String[this.slaveServers.size()];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = this.slaveServers.get(i).toString();
        }
        return strings;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public String getBasePort() {
        return this.basePort;
    }

    public void setBasePort(String basePort) {
        this.basePort = basePort;
    }

    public SlaveServer findMaster() throws KettleException {
        for (int i = 0; i < this.slaveServers.size(); ++i) {
            SlaveServer slaveServer = this.slaveServers.get(i);
            if (!slaveServer.isMaster()) continue;
            return slaveServer;
        }
        if (this.slaveServers.size() > 0) {
            throw new KettleException(Messages.getString("ClusterSchema.NoMasterServerDefined", this.name));
        }
        throw new KettleException(Messages.getString("ClusterSchema.NoSlaveServerDefined", this.name));
    }

    public int findNrSlaves() {
        int nr = 0;
        for (int i = 0; i < this.slaveServers.size(); ++i) {
            SlaveServer slaveServer = this.slaveServers.get(i);
            if (slaveServer.isMaster()) continue;
            ++nr;
        }
        return nr;
    }

    public String getSocketsFlushInterval() {
        return this.socketsFlushInterval;
    }

    public void setSocketsFlushInterval(String socketFlushInterval) {
        this.socketsFlushInterval = socketFlushInterval;
    }

    public String getSocketsBufferSize() {
        return this.socketsBufferSize;
    }

    public void setSocketsBufferSize(String socketsBufferSize) {
        this.socketsBufferSize = socketsBufferSize;
    }

    public boolean isSocketsCompressed() {
        return this.socketsCompressed;
    }

    public void setSocketsCompressed(boolean socketsCompressed) {
        this.socketsCompressed = socketsCompressed;
    }

    public SlaveServer findSlaveServer(String slaveServerName) {
        for (int i = 0; i < this.slaveServers.size(); ++i) {
            SlaveServer slaveServer = this.slaveServers.get(i);
            if (!slaveServer.getName().equalsIgnoreCase(slaveServerName)) continue;
            return slaveServer;
        }
        return null;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Const.isEmpty((String)variableName) && !Const.isEmpty((String)(value = this.environmentSubstitute(variableName)))) {
            return ValueMeta.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    public String[] listVariables() {
        return this.variables.listVariables();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
    }

    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public List<SlaveServer> getSlaveServersFromMasterOrLocal() throws KettleException {
        if (this.isDynamic()) {
            ArrayList<SlaveServer> dynamicSlaves = null;
            Exception exception = null;
            for (int i = 0; i < this.slaveServers.size(); ++i) {
                SlaveServer slave = this.slaveServers.get(i);
                if (!slave.isMaster() || dynamicSlaves != null) continue;
                try {
                    List<SlaveServerDetection> detections = slave.getSlaveServerDetections();
                    dynamicSlaves = new ArrayList<SlaveServer>();
                    for (SlaveServerDetection detection : detections) {
                        if (!detection.isActive()) continue;
                        dynamicSlaves.add(detection.getSlaveServer());
                        LogWriter.getInstance().logBasic(this.toString(), "Found dynamic slave : " + detection.getSlaveServer().getName() + " --> " + detection.getSlaveServer().getServerAndPort(), new Object[0]);
                    }
                    continue;
                }
                catch (Exception e) {
                    exception = e;
                }
            }
            if (dynamicSlaves == null && exception != null) {
                throw new KettleException(exception);
            }
            return dynamicSlaves;
        }
        return this.slaveServers;
    }
}

