/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.encoding;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import nu.validator.encoding.Big5;
import nu.validator.encoding.EucJp;
import nu.validator.encoding.EucKr;
import nu.validator.encoding.Gb18030;
import nu.validator.encoding.Gbk;
import nu.validator.encoding.Ibm866;
import nu.validator.encoding.Iso10;
import nu.validator.encoding.Iso13;
import nu.validator.encoding.Iso14;
import nu.validator.encoding.Iso15;
import nu.validator.encoding.Iso16;
import nu.validator.encoding.Iso2;
import nu.validator.encoding.Iso2022Jp;
import nu.validator.encoding.Iso3;
import nu.validator.encoding.Iso4;
import nu.validator.encoding.Iso5;
import nu.validator.encoding.Iso6;
import nu.validator.encoding.Iso7;
import nu.validator.encoding.Iso8;
import nu.validator.encoding.Iso8I;
import nu.validator.encoding.Koi8R;
import nu.validator.encoding.Koi8U;
import nu.validator.encoding.MacCyrillic;
import nu.validator.encoding.Macintosh;
import nu.validator.encoding.Replacement;
import nu.validator.encoding.ShiftJis;
import nu.validator.encoding.UserDefined;
import nu.validator.encoding.Utf16Be;
import nu.validator.encoding.Utf16Le;
import nu.validator.encoding.Utf8;
import nu.validator.encoding.Windows1250;
import nu.validator.encoding.Windows1251;
import nu.validator.encoding.Windows1252;
import nu.validator.encoding.Windows1253;
import nu.validator.encoding.Windows1254;
import nu.validator.encoding.Windows1255;
import nu.validator.encoding.Windows1256;
import nu.validator.encoding.Windows1257;
import nu.validator.encoding.Windows1258;
import nu.validator.encoding.Windows874;

public abstract class Encoding
extends Charset {
    private static final String[] LABELS = new String[]{"866", "ansi_x3.4-1968", "arabic", "ascii", "asmo-708", "big5", "big5-hkscs", "chinese", "cn-big5", "cp1250", "cp1251", "cp1252", "cp1253", "cp1254", "cp1255", "cp1256", "cp1257", "cp1258", "cp819", "cp866", "csbig5", "cseuckr", "cseucpkdfmtjapanese", "csgb2312", "csibm866", "csiso2022jp", "csiso2022kr", "csiso58gb231280", "csiso88596e", "csiso88596i", "csiso88598e", "csiso88598i", "csisolatin1", "csisolatin2", "csisolatin3", "csisolatin4", "csisolatin5", "csisolatin6", "csisolatin9", "csisolatinarabic", "csisolatincyrillic", "csisolatingreek", "csisolatinhebrew", "cskoi8r", "csksc56011987", "csmacintosh", "csshiftjis", "cyrillic", "dos-874", "ecma-114", "ecma-118", "elot_928", "euc-jp", "euc-kr", "gb18030", "gb2312", "gb_2312", "gb_2312-80", "gbk", "greek", "greek8", "hebrew", "hz-gb-2312", "ibm819", "ibm866", "iso-2022-cn", "iso-2022-cn-ext", "iso-2022-jp", "iso-2022-kr", "iso-8859-1", "iso-8859-10", "iso-8859-11", "iso-8859-13", "iso-8859-14", "iso-8859-15", "iso-8859-16", "iso-8859-2", "iso-8859-3", "iso-8859-4", "iso-8859-5", "iso-8859-6", "iso-8859-6-e", "iso-8859-6-i", "iso-8859-7", "iso-8859-8", "iso-8859-8-e", "iso-8859-8-i", "iso-8859-9", "iso-ir-100", "iso-ir-101", "iso-ir-109", "iso-ir-110", "iso-ir-126", "iso-ir-127", "iso-ir-138", "iso-ir-144", "iso-ir-148", "iso-ir-149", "iso-ir-157", "iso-ir-58", "iso8859-1", "iso8859-10", "iso8859-11", "iso8859-13", "iso8859-14", "iso8859-15", "iso8859-2", "iso8859-3", "iso8859-4", "iso8859-5", "iso8859-6", "iso8859-7", "iso8859-8", "iso8859-9", "iso88591", "iso885910", "iso885911", "iso885913", "iso885914", "iso885915", "iso88592", "iso88593", "iso88594", "iso88595", "iso88596", "iso88597", "iso88598", "iso88599", "iso_8859-1", "iso_8859-15", "iso_8859-1:1987", "iso_8859-2", "iso_8859-2:1987", "iso_8859-3", "iso_8859-3:1988", "iso_8859-4", "iso_8859-4:1988", "iso_8859-5", "iso_8859-5:1988", "iso_8859-6", "iso_8859-6:1987", "iso_8859-7", "iso_8859-7:1987", "iso_8859-8", "iso_8859-8:1988", "iso_8859-9", "iso_8859-9:1989", "koi", "koi8", "koi8-r", "koi8-ru", "koi8-u", "koi8_r", "korean", "ks_c_5601-1987", "ks_c_5601-1989", "ksc5601", "ksc_5601", "l1", "l2", "l3", "l4", "l5", "l6", "l9", "latin1", "latin2", "latin3", "latin4", "latin5", "latin6", "logical", "mac", "macintosh", "ms932", "ms_kanji", "shift-jis", "shift_jis", "sjis", "sun_eu_greek", "tis-620", "unicode-1-1-utf-8", "us-ascii", "utf-16", "utf-16be", "utf-16le", "utf-8", "utf8", "visual", "windows-1250", "windows-1251", "windows-1252", "windows-1253", "windows-1254", "windows-1255", "windows-1256", "windows-1257", "windows-1258", "windows-31j", "windows-874", "windows-949", "x-cp1250", "x-cp1251", "x-cp1252", "x-cp1253", "x-cp1254", "x-cp1255", "x-cp1256", "x-cp1257", "x-cp1258", "x-euc-jp", "x-gbk", "x-mac-cyrillic", "x-mac-roman", "x-mac-ukrainian", "x-sjis", "x-user-defined", "x-x-big5"};
    private static final Encoding[] ENCODINGS_FOR_LABELS = new Encoding[]{Ibm866.INSTANCE, Windows1252.INSTANCE, Iso6.INSTANCE, Windows1252.INSTANCE, Iso6.INSTANCE, Big5.INSTANCE, Big5.INSTANCE, Gbk.INSTANCE, Big5.INSTANCE, Windows1250.INSTANCE, Windows1251.INSTANCE, Windows1252.INSTANCE, Windows1253.INSTANCE, Windows1254.INSTANCE, Windows1255.INSTANCE, Windows1256.INSTANCE, Windows1257.INSTANCE, Windows1258.INSTANCE, Windows1252.INSTANCE, Ibm866.INSTANCE, Big5.INSTANCE, EucKr.INSTANCE, EucJp.INSTANCE, Gbk.INSTANCE, Ibm866.INSTANCE, Iso2022Jp.INSTANCE, Replacement.INSTANCE, Gbk.INSTANCE, Iso6.INSTANCE, Iso6.INSTANCE, Iso8.INSTANCE, Iso8I.INSTANCE, Windows1252.INSTANCE, Iso2.INSTANCE, Iso3.INSTANCE, Iso4.INSTANCE, Windows1254.INSTANCE, Iso10.INSTANCE, Iso15.INSTANCE, Iso6.INSTANCE, Iso5.INSTANCE, Iso7.INSTANCE, Iso8.INSTANCE, Koi8R.INSTANCE, EucKr.INSTANCE, Macintosh.INSTANCE, ShiftJis.INSTANCE, Iso5.INSTANCE, Windows874.INSTANCE, Iso6.INSTANCE, Iso7.INSTANCE, Iso7.INSTANCE, EucJp.INSTANCE, EucKr.INSTANCE, Gb18030.INSTANCE, Gbk.INSTANCE, Gbk.INSTANCE, Gbk.INSTANCE, Gbk.INSTANCE, Iso7.INSTANCE, Iso7.INSTANCE, Iso8.INSTANCE, Replacement.INSTANCE, Windows1252.INSTANCE, Ibm866.INSTANCE, Replacement.INSTANCE, Replacement.INSTANCE, Iso2022Jp.INSTANCE, Replacement.INSTANCE, Windows1252.INSTANCE, Iso10.INSTANCE, Windows874.INSTANCE, Iso13.INSTANCE, Iso14.INSTANCE, Iso15.INSTANCE, Iso16.INSTANCE, Iso2.INSTANCE, Iso3.INSTANCE, Iso4.INSTANCE, Iso5.INSTANCE, Iso6.INSTANCE, Iso6.INSTANCE, Iso6.INSTANCE, Iso7.INSTANCE, Iso8.INSTANCE, Iso8.INSTANCE, Iso8I.INSTANCE, Windows1254.INSTANCE, Windows1252.INSTANCE, Iso2.INSTANCE, Iso3.INSTANCE, Iso4.INSTANCE, Iso7.INSTANCE, Iso6.INSTANCE, Iso8.INSTANCE, Iso5.INSTANCE, Windows1254.INSTANCE, EucKr.INSTANCE, Iso10.INSTANCE, Gbk.INSTANCE, Windows1252.INSTANCE, Iso10.INSTANCE, Windows874.INSTANCE, Iso13.INSTANCE, Iso14.INSTANCE, Iso15.INSTANCE, Iso2.INSTANCE, Iso3.INSTANCE, Iso4.INSTANCE, Iso5.INSTANCE, Iso6.INSTANCE, Iso7.INSTANCE, Iso8.INSTANCE, Windows1254.INSTANCE, Windows1252.INSTANCE, Iso10.INSTANCE, Windows874.INSTANCE, Iso13.INSTANCE, Iso14.INSTANCE, Iso15.INSTANCE, Iso2.INSTANCE, Iso3.INSTANCE, Iso4.INSTANCE, Iso5.INSTANCE, Iso6.INSTANCE, Iso7.INSTANCE, Iso8.INSTANCE, Windows1254.INSTANCE, Windows1252.INSTANCE, Iso15.INSTANCE, Windows1252.INSTANCE, Iso2.INSTANCE, Iso2.INSTANCE, Iso3.INSTANCE, Iso3.INSTANCE, Iso4.INSTANCE, Iso4.INSTANCE, Iso5.INSTANCE, Iso5.INSTANCE, Iso6.INSTANCE, Iso6.INSTANCE, Iso7.INSTANCE, Iso7.INSTANCE, Iso8.INSTANCE, Iso8.INSTANCE, Windows1254.INSTANCE, Windows1254.INSTANCE, Koi8R.INSTANCE, Koi8R.INSTANCE, Koi8R.INSTANCE, Koi8U.INSTANCE, Koi8U.INSTANCE, Koi8R.INSTANCE, EucKr.INSTANCE, EucKr.INSTANCE, EucKr.INSTANCE, EucKr.INSTANCE, EucKr.INSTANCE, Windows1252.INSTANCE, Iso2.INSTANCE, Iso3.INSTANCE, Iso4.INSTANCE, Windows1254.INSTANCE, Iso10.INSTANCE, Iso15.INSTANCE, Windows1252.INSTANCE, Iso2.INSTANCE, Iso3.INSTANCE, Iso4.INSTANCE, Windows1254.INSTANCE, Iso10.INSTANCE, Iso8I.INSTANCE, Macintosh.INSTANCE, Macintosh.INSTANCE, ShiftJis.INSTANCE, ShiftJis.INSTANCE, ShiftJis.INSTANCE, ShiftJis.INSTANCE, ShiftJis.INSTANCE, Iso7.INSTANCE, Windows874.INSTANCE, Utf8.INSTANCE, Windows1252.INSTANCE, Utf16Le.INSTANCE, Utf16Be.INSTANCE, Utf16Le.INSTANCE, Utf8.INSTANCE, Utf8.INSTANCE, Iso8.INSTANCE, Windows1250.INSTANCE, Windows1251.INSTANCE, Windows1252.INSTANCE, Windows1253.INSTANCE, Windows1254.INSTANCE, Windows1255.INSTANCE, Windows1256.INSTANCE, Windows1257.INSTANCE, Windows1258.INSTANCE, ShiftJis.INSTANCE, Windows874.INSTANCE, EucKr.INSTANCE, Windows1250.INSTANCE, Windows1251.INSTANCE, Windows1252.INSTANCE, Windows1253.INSTANCE, Windows1254.INSTANCE, Windows1255.INSTANCE, Windows1256.INSTANCE, Windows1257.INSTANCE, Windows1258.INSTANCE, EucJp.INSTANCE, Gbk.INSTANCE, MacCyrillic.INSTANCE, Macintosh.INSTANCE, MacCyrillic.INSTANCE, ShiftJis.INSTANCE, UserDefined.INSTANCE, Big5.INSTANCE};
    private static final Encoding[] ENCODINGS = new Encoding[]{Big5.INSTANCE, EucJp.INSTANCE, EucKr.INSTANCE, Gb18030.INSTANCE, Gbk.INSTANCE, Ibm866.INSTANCE, Iso2022Jp.INSTANCE, Iso10.INSTANCE, Iso13.INSTANCE, Iso14.INSTANCE, Iso15.INSTANCE, Iso16.INSTANCE, Iso2.INSTANCE, Iso3.INSTANCE, Iso4.INSTANCE, Iso5.INSTANCE, Iso6.INSTANCE, Iso7.INSTANCE, Iso8.INSTANCE, Iso8I.INSTANCE, Koi8R.INSTANCE, Koi8U.INSTANCE, Macintosh.INSTANCE, Replacement.INSTANCE, ShiftJis.INSTANCE, Utf16Be.INSTANCE, Utf16Le.INSTANCE, Utf8.INSTANCE, Windows1250.INSTANCE, Windows1251.INSTANCE, Windows1252.INSTANCE, Windows1253.INSTANCE, Windows1254.INSTANCE, Windows1255.INSTANCE, Windows1256.INSTANCE, Windows1257.INSTANCE, Windows1258.INSTANCE, Windows874.INSTANCE, MacCyrillic.INSTANCE, UserDefined.INSTANCE};
    public static final Encoding BIG5 = Big5.INSTANCE;
    public static final Encoding EUC_JP = EucJp.INSTANCE;
    public static final Encoding EUC_KR = EucKr.INSTANCE;
    public static final Encoding GB18030 = Gb18030.INSTANCE;
    public static final Encoding GBK = Gbk.INSTANCE;
    public static final Encoding IBM866 = Ibm866.INSTANCE;
    public static final Encoding ISO_2022_JP = Iso2022Jp.INSTANCE;
    public static final Encoding ISO_8859_10 = Iso10.INSTANCE;
    public static final Encoding ISO_8859_13 = Iso13.INSTANCE;
    public static final Encoding ISO_8859_14 = Iso14.INSTANCE;
    public static final Encoding ISO_8859_15 = Iso15.INSTANCE;
    public static final Encoding ISO_8859_16 = Iso16.INSTANCE;
    public static final Encoding ISO_8859_2 = Iso2.INSTANCE;
    public static final Encoding ISO_8859_3 = Iso3.INSTANCE;
    public static final Encoding ISO_8859_4 = Iso4.INSTANCE;
    public static final Encoding ISO_8859_5 = Iso5.INSTANCE;
    public static final Encoding ISO_8859_6 = Iso6.INSTANCE;
    public static final Encoding ISO_8859_7 = Iso7.INSTANCE;
    public static final Encoding ISO_8859_8 = Iso8.INSTANCE;
    public static final Encoding ISO_8859_8_I = Iso8I.INSTANCE;
    public static final Encoding KOI8_R = Koi8R.INSTANCE;
    public static final Encoding KOI8_U = Koi8U.INSTANCE;
    public static final Encoding MACINTOSH = Macintosh.INSTANCE;
    public static final Encoding REPLACEMENT = Replacement.INSTANCE;
    public static final Encoding SHIFT_JIS = ShiftJis.INSTANCE;
    public static final Encoding UTF_16BE = Utf16Be.INSTANCE;
    public static final Encoding UTF_16LE = Utf16Le.INSTANCE;
    public static final Encoding UTF_8 = Utf8.INSTANCE;
    public static final Encoding WINDOWS_1250 = Windows1250.INSTANCE;
    public static final Encoding WINDOWS_1251 = Windows1251.INSTANCE;
    public static final Encoding WINDOWS_1252 = Windows1252.INSTANCE;
    public static final Encoding WINDOWS_1253 = Windows1253.INSTANCE;
    public static final Encoding WINDOWS_1254 = Windows1254.INSTANCE;
    public static final Encoding WINDOWS_1255 = Windows1255.INSTANCE;
    public static final Encoding WINDOWS_1256 = Windows1256.INSTANCE;
    public static final Encoding WINDOWS_1257 = Windows1257.INSTANCE;
    public static final Encoding WINDOWS_1258 = Windows1258.INSTANCE;
    public static final Encoding WINDOWS_874 = Windows874.INSTANCE;
    public static final Encoding X_MAC_CYRILLIC = MacCyrillic.INSTANCE;
    public static final Encoding X_USER_DEFINED = UserDefined.INSTANCE;
    private static SortedMap<String, Charset> encodings = null;

    protected Encoding(String canonicalName, String[] aliases) {
        super(canonicalName, aliases);
    }

    /*
     * Unable to fully structure code
     */
    public static Encoding forName(String label) {
        if (label == null) {
            throw new IllegalArgumentException("Label must not be null.");
        }
        if (label.length() == 0) {
            throw new IllegalCharsetNameException(label);
        }
        index = Arrays.binarySearch(Encoding.LABELS, label);
        if (index >= 0) {
            return Encoding.ENCODINGS_FOR_LABELS[index];
        }
        sb = new StringBuilder();
        state = State.HEAD;
        block14: for (i = 0; i < label.length(); ++i) {
            c = label.charAt(i);
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t' || c == '\f') {
                if (state != State.LABEL) continue;
                state = State.TAIL;
                continue;
            }
            if ((c < 'a' || c > 'z') && (c < '0' || c > '9')) ** GOTO lbl-1000
            switch (1.$SwitchMap$nu$validator$encoding$Encoding$State[state.ordinal()]) {
                case 1: {
                    state = State.LABEL;
                }
                case 2: {
                    sb.append(c);
                    continue block14;
                }
                case 3: {
                    throw new IllegalCharsetNameException(label);
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (c >= 'A' && c <= 'Z') {
                        c = (char)(c + 32);
                        switch (1.$SwitchMap$nu$validator$encoding$Encoding$State[state.ordinal()]) {
                            case 1: {
                                state = State.LABEL;
                            }
                            case 2: {
                                sb.append(c);
                                continue block14;
                            }
                            case 3: {
                                throw new IllegalCharsetNameException(label);
                            }
                        }
                    }
                    if (c == '-' || c == '+' || c == '.' || c == ':' || c == '_') {
                        switch (1.$SwitchMap$nu$validator$encoding$Encoding$State[state.ordinal()]) {
                            case 2: {
                                sb.append(c);
                                continue block14;
                            }
                            case 1: 
                            case 3: {
                                throw new IllegalCharsetNameException(label);
                            }
                        }
                    }
                    throw new IllegalCharsetNameException(label);
                }
            }
        }
        index = Arrays.binarySearch(Encoding.LABELS, sb.toString());
        if (index >= 0) {
            return Encoding.ENCODINGS_FOR_LABELS[index];
        }
        throw new UnsupportedCharsetException(label);
    }

    public static Encoding forNameNoReplacement(String label) {
        Encoding encoding = Encoding.forName(label);
        if (encoding == REPLACEMENT) {
            throw new UnsupportedCharsetException(label);
        }
        return encoding;
    }

    public static boolean isSupported(String label) {
        try {
            Encoding.forName(label);
        }
        catch (UnsupportedCharsetException e) {
            return false;
        }
        return true;
    }

    public static boolean isSupportedNoReplacement(String label) {
        try {
            Encoding.forNameNoReplacement(label);
        }
        catch (UnsupportedCharsetException e) {
            return false;
        }
        return true;
    }

    public static SortedMap<String, Charset> availableCharsets() {
        if (encodings == null) {
            TreeMap<String, Encoding> map = new TreeMap<String, Encoding>();
            for (Encoding encoding : ENCODINGS) {
                map.put(encoding.name(), encoding);
            }
            encodings = Collections.unmodifiableSortedMap(map);
        }
        return encodings;
    }

    public static Encoding defaultCharset() {
        return WINDOWS_1252;
    }

    @Override
    public boolean canEncode() {
        return false;
    }

    @Override
    public boolean contains(Charset cs) {
        return false;
    }

    @Override
    public CharsetEncoder newEncoder() {
        throw new UnsupportedOperationException("Encoder not implemented.");
    }

    private static enum State {
        HEAD,
        LABEL,
        TAIL;

    }
}

