/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;

final class LongConverter
implements Converter {
    public static final LongConverter INSTANCE = new LongConverter();

    LongConverter() {
    }

    @Override
    public boolean accept(Class<?> cls) {
        return Long.TYPE == cls || Long.class == cls;
    }

    @Override
    public Object convert(JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        if (value == null) {
            return c == Long.TYPE ? Long.valueOf(0L) : null;
        }
        if (value instanceof Map) {
            value = ((Map)value).get(null);
        } else if (value instanceof List) {
            List src = (List)value;
            Object object = value = !src.isEmpty() ? (Object)src.get(0) : null;
        }
        if (value == null) {
            return c == Long.TYPE ? Long.valueOf(0L) : null;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).longValueExact();
        }
        if (value instanceof String) {
            String str;
            NumberFormat f = context.getNumberFormat();
            if (f != null) {
                value = f.parse((String)value);
            }
            if ((str = value.toString().trim()).length() > 0) {
                int start = 0;
                if (str.charAt(0) == '+') {
                    ++start;
                }
                if (str.startsWith("0x", start)) {
                    return Long.parseLong(str.substring(start + 2), 16);
                }
                return Long.parseLong(str.substring(start));
            }
            return c == Long.TYPE ? Long.valueOf(0L) : null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1L : 0L;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        throw new UnsupportedOperationException("Cannot convert " + value.getClass() + " to " + t);
    }
}

