#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.18';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD500',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD850',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Reconyx::Type2',
	'Image::ExifTool::Reconyx::Type3',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GAudio',
	'Image::ExifTool::XMP::GCamera',
	'Image::ExifTool::XMP::GCreations',
	'Image::ExifTool::XMP::GDepth',
	'Image::ExifTool::XMP::GFocus',
	'Image::ExifTool::XMP::GImage',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GSpherical',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 104 => 0x69 },
	'about' => { 474 => 'about' },
	'aboutcvterm' => { 466 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 466 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 466 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 466 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 466 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 111 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 480 => 'absPeakAudioFilePath' },
	'academicfield' => { 470 => 'academicField' },
	'acceleration' => { 114 => 0x9404, 461 => 'Acceleration' },
	'accelerationtracking' => { 79 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 372 => 0x3 },
	'accelerometerx' => { 302 => 0x8d },
	'accelerometery' => { 302 => 0x8e },
	'accelerometerz' => { 302 => 0x8c },
	'accessoryserialnumber' => { 302 => 0x54 },
	'accessorytype' => { 302 => 0x53 },
	'actionadvised' => { 126 => 0x2a },
	'activearea' => { 114 => 0xc68d },
	'actived-lighting' => { 215 => 0x22, 253 => 0x24 },
	'actived-lightingmode' => { 253 => 0x25 },
	'adaptervoltage' => { 132 => 0x407 },
	'addaspectratioinfo' => { 79 => 0x80e },
	'addiptcinformation' => { 79 => 0x815 },
	'additionalmodelinformation' => { 466 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 79 => 0x80f, 80 => 0x11, 81 => 0x13, 84 => 0x14 },
	'address' => { 153 => 'Address' },
	'adjustmentmode' => { 379 => 0x15 },
	'adlbracketingstep' => { 234 => 0x883 },
	'adlbracketingtype' => { 234 => 0x884 },
	'adobe' => { 115 => 'Adobe' },
	'adultcontentwarning' => { 289 => 'AdultContentWarning', 473 => 'adultContentWarning' },
	'advancedfilter' => { 122 => 0x1201 },
	'advancedraw' => { 255 => 0x76a43203 },
	'advancedscenetype' => { 302 => 0x3d },
	'advisory' => { 478 => 'Advisory' },
	'ae_iso' => { 310 => 0x2, 311 => 0x4, 312 => 0x12 },
	'aeaperture' => { 310 => 0x1, 311 => 0x3, 312 => 0x11 },
	'aeaperturesteps' => { 310 => 0x8, 311 => 0xb },
	'aebautocancel' => { 79 => 0x104 },
	'aebbracketvalue' => { 73 => 0x11 },
	'aebracketingsteps' => { 233 => 0x174c, 234 => 0x87b, 242 => 0x1756 },
	'aebsequence' => { 79 => 0x105 },
	'aebsequenceautocancel' => { 77 => 0x9, 78 => 0x9, 80 => 0x8, 81 => 0x9, 84 => 0x9, 85 => 0x7 },
	'aebshotcount' => { 79 => 0x106 },
	'aebxv' => { 310 => 0x4, 311 => 0x6 },
	'aeerror' => { 311 => 0x8 },
	'aeexposuretime' => { 310 => 0x0, 311 => 0x2, 312 => 0x10 },
	'aelbutton' => { 175 => 0x45 },
	'aelexposureindicator' => { 175 => 0x51 },
	'aelock' => { 175 => 0x5b, 264 => '4.2', 273 => '4.2', 279 => 0x201, 337 => 0x48, 387 => 0x40, 388 => 0x40, 389 => [0x86,0x286] },
	'aelockbutton' => { 262 => '16.1', 264 => '4.1', 267 => '15.1', 268 => '16.1', 269 => '16.1', 271 => '30.1', 272 => '16.1', 273 => '4.1', 275 => '17.1', 277 => '17.1' },
	'aelockbuttonplusdials' => { 262 => '16.2', 271 => '32.1', 275 => '44.1' },
	'aelockformb-d80' => { 277 => '3.1' },
	'aelockmetermodeafterfocus' => { 79 => 0x114 },
	'aemaxaperture' => { 310 => 0x9, 311 => 0x10, 312 => 0x1c },
	'aemaxaperture2' => { 310 => 0xa, 311 => 0x11, 312 => 0x1d },
	'aemeteringmode' => { 310 => 0xc },
	'aemeteringmode2' => { 310 => '13.1' },
	'aemeteringsegments' => { 178 => 0x628, 337 => 0x209 },
	'aemicroadjustment' => { 79 => 0x110 },
	'aeminaperture' => { 310 => 0xb, 311 => 0x12, 312 => 0x1e },
	'aeminexposuretime' => { 310 => 0x5, 311 => 0x13, 312 => 0x1f },
	'aeprogrammode' => { 310 => 0x6 },
	'aeprojectlink' => { 455 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 455 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 455 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 455 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 455 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 455 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 34 => 0x21 },
	'aewhitebalance' => { 310 => 0xd },
	'aexv' => { 310 => 0x3, 311 => 0x5 },
	'af-cpriority' => { 123 => '0.2' },
	'af-cpriorityselection' => { 262 => '1.1', 263 => '1.1', 265 => '1.1', 266 => '1.1', 268 => '0.1', 269 => '0.1', 270 => '0.1', 271 => '1.1', 272 => '0.1', 275 => '1.1', 276 => '1.1' },
	'af-csetting' => { 119 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 119 => '0.2' },
	'af-ctrackingsensitivity' => { 119 => '0.1' },
	'af-czoneareaswitching' => { 119 => '0.3' },
	'af-onbutton' => { 265 => '70.1', 266 => '70.1', 276 => '70.1' },
	'af-onformb-d10' => { 262 => '3.3', 271 => '3.2' },
	'af-onformb-d11' => { 272 => '2.2' },
	'af-onformb-d12' => { 275 => '50.1' },
	'af-spriority' => { 123 => '0.1' },
	'af-spriorityselection' => { 262 => '1.2', 263 => '1.2', 265 => '1.2', 266 => '1.2', 270 => '0.2', 271 => '1.2', 272 => '0.2', 275 => '1.2', 276 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 262 => '2.1', 263 => '2.1', 265 => '78.3', 266 => '78.3', 271 => '2.1', 275 => '2.1', 276 => '78.3' },
	'afadjustment' => { 337 => 0x72, 346 => 0x267 },
	'afandmeteringbuttons' => { 79 => 0x701 },
	'afaperture' => { 208 => 0x5, 209 => 0x5, 213 => 0x5 },
	'afareaheight' => { 184 => [0x1a,0x34,0x50] },
	'afareaillumination' => { 175 => 0x4b, 273 => '15.3' },
	'afareamode' => { 121 => '0.2', 171 => 0x33, 175 => 0xe, 183 => 0x0, 184 => 0x5, 302 => 0xf, 369 => 0x1205, 380 => [0xa,0x3a], 387 => 0x11, 388 => 0x10, 389 => 0x24, 400 => 0xb043, 423 => 0x17 },
	'afareamodesetting' => { 264 => '11.1', 267 => '0.1', 273 => '16.1', 277 => '2.1', 400 => 0x201c },
	'afareapointsize' => { 121 => '0.3' },
	'afareas' => { 279 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 79 => 0x51b },
	'afareawidth' => { 184 => [0x18,0x32,0x4e] },
	'afareaxposition' => { 184 => [0x14,0x2e,0x4a], 369 => 0x1203 },
	'afareaxposition1' => { 369 => 0x1201 },
	'afareayposition' => { 184 => [0x16,0x30,0x4c], 369 => 0x1204 },
	'afareayposition1' => { 369 => 0x1202 },
	'afareazonesize' => { 121 => '0.4' },
	'afassist' => { 77 => 0x5, 85 => 0x5, 175 => 0x48, 262 => '2.5', 264 => '0.2', 267 => '0.2', 268 => '1.1', 269 => '1.1', 270 => '1.3', 271 => '2.4', 272 => '1.3', 273 => '0.2', 275 => '2.4', 277 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 79 => 0x50e, 80 => 0x4, 81 => 0x5, 82 => 0x4, 83 => 0x4, 84 => 0x5 },
	'afassistlamp' => { 302 => 0x31 },
	'afbuttonpressed' => { 389 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 313 => 0x6 },
	'afduringliveview' => { 79 => 0x511 },
	'affinea' => { 449 => 'AffineA' },
	'affineb' => { 449 => 'AffineB' },
	'affinec' => { 449 => 'AffineC' },
	'affined' => { 449 => 'AffineD' },
	'affinetune' => { 185 => 0x0, 279 => 0x306 },
	'affinetuneadj' => { 185 => 0x2, 226 => 0x2d1, 227 => 0x2dc, 279 => 0x307 },
	'affinetuneindex' => { 185 => 0x1 },
	'affinex' => { 449 => 'AffineX' },
	'affiney' => { 449 => 'AffineY' },
	'afhold' => { 313 => 0x1fd },
	'afilluminator' => { 387 => 0x29, 400 => 0xb044 },
	'afimageheight' => { 184 => [0x12,0x2c,0x48] },
	'afimagewidth' => { 184 => [0x10,0x2a,0x46] },
	'afintegrationtime' => { 313 => 0x7 },
	'afmicroadj' => { 380 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 384 => 0x131 },
	'afmicroadjregisteredlenses' => { 384 => '305.1' },
	'afmicroadjustment' => { 79 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 384 => 0x130 },
	'afmode' => { 108 => 0x3009, 122 => 0x1022, 171 => 0x16, 379 => 0x5 },
	'afmoderestrictions' => { 263 => '50.3', 265 => '48.3', 266 => '48.3', 275 => '48.3', 276 => '48.3' },
	'afonaelockbuttonswitch' => { 79 => 0x702 },
	'afonbutton' => { 262 => '3.1', 263 => '47.1' },
	'afpoint' => { 34 => 0x13, 107 => 0x18, 171 => 0x15, 183 => 0x1, 282 => 0x308, 379 => 0x1f, 380 => [0x37,0x7], 384 => 0x19, 385 => 0x18, 386 => [0x18,0x20] },
	'afpointactivationarea' => { 78 => 0x11, 84 => 0x11 },
	'afpointareaexpansion' => { 79 => 0x508 },
	'afpointatshutterrelease' => { 380 => [0x39,0x9] },
	'afpointautoselection' => { 79 => 0x50b },
	'afpointbrightness' => { 79 => 0x50d, 262 => '2.4', 263 => '46.5', 265 => '2.2', 266 => '2.2', 275 => '2.3', 276 => '2.2' },
	'afpointdisplayduringfocus' => { 2 => 0x10, 79 => 0x50c },
	'afpointillumination' => { 78 => 0xa, 262 => '2.3', 263 => '46.2', 265 => '47.2', 266 => '47.2', 270 => '1.2', 271 => '2.3', 272 => '1.2', 275 => '47.2', 276 => '47.2', 277 => '2.4' },
	'afpointinfocus' => { 380 => [0x38,0x8] },
	'afpointmode' => { 318 => 0x3 },
	'afpointposition' => { 108 => 0x2021, 302 => 0x4d },
	'afpointregistration' => { 77 => 0x7 },
	'afpoints' => { 174 => 0x10 },
	'afpointselected' => { 175 => 0xd, 279 => 0x305, 337 => 0xe, 384 => 0x15, 385 => 0x14, 386 => [0x14,0x1c], 400 => 0x201e },
	'afpointselected2' => { 318 => 0x4 },
	'afpointselection' => { 78 => 0xb, 262 => '1.3', 263 => '1.3', 271 => '1.3', 275 => '1.3', 276 => '1.3' },
	'afpointselectionmethod' => { 79 => 0x50f, 80 => 0xc, 81 => 0xd, 84 => 0xd },
	'afpointsetting' => { 387 => 0x12, 388 => 0x11 },
	'afpointsinfocus' => { 73 => 0xe, 183 => 0x2, 313 => 0xb, 314 => 0x4, 337 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 78 => 0xd },
	'afpointsselected' => { 314 => '4.1', 431 => 0x4 },
	'afpointsspecial' => { 314 => '4.2' },
	'afpointsunknown1' => { 313 => 0x0 },
	'afpointsunknown2' => { 313 => 0x2 },
	'afpointsused' => { 184 => 0x8, 380 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 313 => 0x4 },
	'afresponse' => { 215 => 0xad },
	'afresult' => { 284 => 0x1038 },
	'afsearch' => { 279 => 0x303 },
	'afsensoractive' => { 171 => 0x1 },
	'afstatus' => { 369 => 0x1200 },
	'afstatus_00_b4' => { 383 => 0x0 },
	'afstatus_01_c4' => { 383 => 0x2 },
	'afstatus_02_d4' => { 383 => 0x4 },
	'afstatus_03_e4' => { 383 => 0x6 },
	'afstatus_04_f4' => { 383 => 0x8 },
	'afstatus_05_g4' => { 383 => 0xa },
	'afstatus_06_h4' => { 383 => 0xc },
	'afstatus_07_b3' => { 383 => 0xe },
	'afstatus_08_c3' => { 383 => 0x10 },
	'afstatus_09_d3' => { 383 => 0x12 },
	'afstatus_10_e3' => { 383 => 0x14 },
	'afstatus_11_f3' => { 383 => 0x16 },
	'afstatus_12_g3' => { 383 => 0x18 },
	'afstatus_13_h3' => { 383 => 0x1a },
	'afstatus_14_b2' => { 383 => 0x1c },
	'afstatus_15_c2' => { 383 => 0x1e },
	'afstatus_16_d2' => { 383 => 0x20 },
	'afstatus_17_e2' => { 383 => 0x22 },
	'afstatus_18_f2' => { 383 => 0x24 },
	'afstatus_19_g2' => { 383 => 0x26 },
	'afstatus_20_h2' => { 383 => 0x28 },
	'afstatus_21_c1' => { 383 => 0x2a },
	'afstatus_22_d1' => { 383 => 0x2c },
	'afstatus_23_e1' => { 383 => 0x2e },
	'afstatus_24_f1' => { 383 => 0x30 },
	'afstatus_25_g1' => { 383 => 0x32 },
	'afstatus_26_a7_vertical' => { 383 => 0x34 },
	'afstatus_27_a6_vertical' => { 383 => 0x36 },
	'afstatus_28_a5_vertical' => { 383 => 0x38 },
	'afstatus_29_c7_vertical' => { 383 => 0x3a },
	'afstatus_30_c6_vertical' => { 383 => 0x3c },
	'afstatus_31_c5_vertical' => { 383 => 0x3e },
	'afstatus_32_e7_vertical' => { 383 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 383 => 0x42 },
	'afstatus_34_e5_vertical' => { 383 => 0x44 },
	'afstatus_35_g7_vertical' => { 383 => 0x46 },
	'afstatus_36_g6_vertical' => { 383 => 0x48 },
	'afstatus_37_g5_vertical' => { 383 => 0x4a },
	'afstatus_38_i7_vertical' => { 383 => 0x4c },
	'afstatus_39_i6_vertical' => { 383 => 0x4e },
	'afstatus_40_i5_vertical' => { 383 => 0x50 },
	'afstatus_41_a7' => { 383 => 0x52 },
	'afstatus_42_b7' => { 383 => 0x54 },
	'afstatus_43_c7' => { 383 => 0x56 },
	'afstatus_44_d7' => { 383 => 0x58 },
	'afstatus_45_e7' => { 383 => 0x5a },
	'afstatus_46_f7' => { 383 => 0x5c },
	'afstatus_47_g7' => { 383 => 0x5e },
	'afstatus_48_h7' => { 383 => 0x60 },
	'afstatus_49_i7' => { 383 => 0x62 },
	'afstatus_50_a6' => { 383 => 0x64 },
	'afstatus_51_b6' => { 383 => 0x66 },
	'afstatus_52_c6' => { 383 => 0x68 },
	'afstatus_53_d6' => { 383 => 0x6a },
	'afstatus_54_e6_center' => { 383 => 0x6c },
	'afstatus_55_f6' => { 383 => 0x6e },
	'afstatus_56_g6' => { 383 => 0x70 },
	'afstatus_57_h6' => { 383 => 0x72 },
	'afstatus_58_i6' => { 383 => 0x74 },
	'afstatus_59_a5' => { 383 => 0x76 },
	'afstatus_60_b5' => { 383 => 0x78 },
	'afstatus_61_c5' => { 383 => 0x7a },
	'afstatus_62_d5' => { 383 => 0x7c },
	'afstatus_63_e5' => { 383 => 0x7e },
	'afstatus_64_f5' => { 383 => 0x80 },
	'afstatus_65_g5' => { 383 => 0x82 },
	'afstatus_66_h5' => { 383 => 0x84 },
	'afstatus_67_i5' => { 383 => 0x86 },
	'afstatus_68_c11' => { 383 => 0x88 },
	'afstatus_69_d11' => { 383 => 0x8a },
	'afstatus_70_e11' => { 383 => 0x8c },
	'afstatus_71_f11' => { 383 => 0x8e },
	'afstatus_72_g11' => { 383 => 0x90 },
	'afstatus_73_b10' => { 383 => 0x92 },
	'afstatus_74_c10' => { 383 => 0x94 },
	'afstatus_75_d10' => { 383 => 0x96 },
	'afstatus_76_e10' => { 383 => 0x98 },
	'afstatus_77_f10' => { 383 => 0x9a },
	'afstatus_78_g10' => { 383 => 0x9c },
	'afstatus_79_h10' => { 383 => 0x9e },
	'afstatus_80_b9' => { 383 => 0xa0 },
	'afstatus_81_c9' => { 383 => 0xa2 },
	'afstatus_82_d9' => { 383 => 0xa4 },
	'afstatus_83_e9' => { 383 => 0xa6 },
	'afstatus_84_f9' => { 383 => 0xa8 },
	'afstatus_85_g9' => { 383 => 0xaa },
	'afstatus_86_h9' => { 383 => 0xac },
	'afstatus_87_b8' => { 383 => 0xae },
	'afstatus_88_c8' => { 383 => 0xb0 },
	'afstatus_89_d8' => { 383 => 0xb2 },
	'afstatus_90_e8' => { 383 => 0xb4 },
	'afstatus_91_f8' => { 383 => 0xb6 },
	'afstatus_92_g8' => { 383 => 0xb8 },
	'afstatus_93_h8' => { 383 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 383 => 0xbc },
	'afstatusactivesensor' => { 171 => 0x2, 380 => [0x4,0x3b], 384 => 0x1e, 385 => 0x1b, 386 => [0x1b,0x21] },
	'afstatusbottom' => { 171 => 0x8, 384 => 0x2a, 385 => 0x21, 386 => 0x21 },
	'afstatusbottom-left' => { 171 => 0x12, 385 => 0x2b, 386 => 0x2b },
	'afstatusbottom-right' => { 171 => 0x6, 385 => 0x1f, 386 => 0x1f },
	'afstatusbottomassist-left' => { 384 => 0x28 },
	'afstatusbottomassist-right' => { 384 => 0x2c },
	'afstatusbottomhorizontal' => { 381 => 0x10, 382 => 0x1c },
	'afstatusbottomvertical' => { 381 => 0x16, 382 => 0x26 },
	'afstatuscenter-10' => { 384 => 0x34 },
	'afstatuscenter-11' => { 384 => 0x36 },
	'afstatuscenter-12' => { 384 => 0x38 },
	'afstatuscenter-14' => { 384 => 0x3c },
	'afstatuscenter-7' => { 384 => 0x2e },
	'afstatuscenter-9' => { 384 => 0x32 },
	'afstatuscenter-horizontal' => { 384 => 0x30 },
	'afstatuscenter-vertical' => { 384 => 0x3a },
	'afstatuscenterf2-8' => { 384 => 0x4c },
	'afstatuscenterhorizontal' => { 171 => 0x2f, 381 => 0xc, 382 => 0x18, 385 => 0x2f, 386 => 0x2f },
	'afstatuscentervertical' => { 171 => 0xc, 381 => 0x14, 382 => 0x22, 385 => 0x25, 386 => 0x25 },
	'afstatusfarleft' => { 381 => 0x6, 384 => 0x26 },
	'afstatusfarlefthorizontal' => { 382 => 0x4 },
	'afstatusfarleftvertical' => { 382 => 0x12 },
	'afstatusfarright' => { 381 => 0x18, 384 => 0x44 },
	'afstatusfarrighthorizontal' => { 382 => 0x2c },
	'afstatusfarrightvertical' => { 382 => 0x34 },
	'afstatusleft' => { 171 => 0x2d, 381 => 0x2, 384 => 0x22, 385 => 0x2d, 386 => 0x2d },
	'afstatuslefthorizontal' => { 382 => 0x6 },
	'afstatusleftvertical' => { 382 => 0xe },
	'afstatuslower-left' => { 381 => 0x4, 384 => 0x24 },
	'afstatuslower-lefthorizontal' => { 382 => 0xa },
	'afstatuslower-leftvertical' => { 382 => 0x10 },
	'afstatuslower-middle' => { 381 => 0x22, 382 => 0x24 },
	'afstatuslower-right' => { 381 => 0x1e, 384 => 0x4a },
	'afstatuslower-righthorizontal' => { 382 => 0x32 },
	'afstatuslower-rightvertical' => { 382 => 0x3a },
	'afstatuslowerfarleft' => { 382 => 0x8 },
	'afstatuslowerfarright' => { 382 => 0x30 },
	'afstatusmiddlehorizontal' => { 171 => 0xa, 385 => 0x23, 386 => 0x23 },
	'afstatusnearleft' => { 381 => 0xe, 382 => 0x1a },
	'afstatusnearright' => { 381 => 0xa, 382 => 0x16 },
	'afstatusright' => { 171 => 0x31, 381 => 0x1c, 384 => 0x48, 385 => 0x31, 386 => 0x31 },
	'afstatusrighthorizontal' => { 382 => 0x2e },
	'afstatusrightvertical' => { 382 => 0x38 },
	'afstatustop' => { 171 => 0xe, 384 => 0x40, 385 => 0x27, 386 => 0x27 },
	'afstatustop-left' => { 171 => 0x10, 385 => 0x29, 386 => 0x29 },
	'afstatustop-right' => { 171 => 0x4, 385 => 0x1d, 386 => 0x1d },
	'afstatustopassist-left' => { 384 => 0x3e },
	'afstatustopassist-right' => { 384 => 0x42 },
	'afstatustophorizontal' => { 381 => 0x8, 382 => 0x14 },
	'afstatustopvertical' => { 381 => 0x12, 382 => 0x1e },
	'afstatusupper-left' => { 381 => 0x0, 384 => 0x20 },
	'afstatusupper-lefthorizontal' => { 382 => 0x2 },
	'afstatusupper-leftvertical' => { 382 => 0xc },
	'afstatusupper-middle' => { 381 => 0x20, 382 => 0x20 },
	'afstatusupper-right' => { 381 => 0x1a, 384 => 0x46 },
	'afstatusupper-righthorizontal' => { 382 => 0x2a },
	'afstatusupper-rightvertical' => { 382 => 0x36 },
	'afstatusupperfarleft' => { 382 => 0x0 },
	'afstatusupperfarright' => { 382 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'aftracking' => { 400 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 380 => 0x2 },
	'afwithshutter' => { 387 => 0x2a },
	'aggregateissuenumber' => { 470 => 'aggregateIssueNumber' },
	'aggregationtype' => { 470 => 'aggregationType' },
	'agreement' => { 473 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 132 => 0xe4e },
	'aiservocontinuousshooting' => { 78 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 79 => 0x519 },
	'aiservoimagepriority' => { 79 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 79 => 0x51a },
	'aiservotrackingmethod' => { 79 => 0x504 },
	'aiservotrackingsensitivity' => { 78 => 0x14, 79 => 0x502 },
	'album' => { 354 => ['albm',"\xa9alb"], 356 => 'album', 362 => ['albm',"\xa9alb"], 480 => 'album' },
	'albumartist' => { 354 => 'aART', 362 => 'albr' },
	'albumtitleid' => { 354 => 'atID' },
	'alreadyapplied' => { 456 => 'AlreadyApplied' },
	'alternatetitle' => { 470 => 'alternateTitle' },
	'alternatetitlea-lang' => { 470 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 470 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 470 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 186 => 0x6 },
	'alttapename' => { 480 => 'altTapeName' },
	'alttimecode' => { 480 => 'altTimecode' },
	'alttimecodetimeformat' => { 480 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 480 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 480 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 365 => 0x5c },
	'ambientlight' => { 365 => 0x5e },
	'ambienttemperature' => { 114 => 0x9400, 363 => 0x14, 364 => 0x46, 365 => 0x50, 423 => 0x4, 461 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 363 => 0x13, 364 => 0x44, 365 => 0x4e },
	'analogbalance' => { 114 => 0xc627 },
	'analogcaptureiso' => { 132 => 0x89e },
	'analogisotable' => { 132 => 0x89d },
	'androidversion' => { 356 => 'com.android.version' },
	'angleadj' => { 98 => 0x10003, 104 => 0x8b },
	'angleinforoll' => { 451 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 451 => 'AngleInfoYaw' },
	'anti-blur' => { 400 => 0xb04b },
	'antialiasstrength' => { 114 => 0xc632 },
	'aperturelock' => { 263 => '38.2', 265 => '38.2', 266 => '38.2', 275 => '38.2', 276 => '38.2' },
	'aperturemode' => { 362 => 'apmd' },
	'aperturerange' => { 79 => 0x10d },
	'apertureringuse' => { 318 => '1.4' },
	'aperturesetting' => { 175 => 0x7, 387 => 0x30, 388 => 0x29, 389 => 0x1 },
	'aperturevalue' => { 88 => 0x2, 114 => 0x9202, 284 => 0x1002, 346 => 0x401, 460 => 'ApertureValue' },
	'applekeywords' => { 288 => 'AAPL:Keywords' },
	'applestoreaccount' => { 354 => 'apID' },
	'applestoreaccounttype' => { 354 => 'akID' },
	'applestorecatalogid' => { 354 => 'cnID' },
	'applestorecountry' => { 354 => 'sfID' },
	'applicationkeystring' => { 132 => 0x400 },
	'applicationnotes' => { 114 => 0x2bc, 307 => 0x2bc },
	'applicationrecordversion' => { 126 => 0x0 },
	'applyshootingmeteringmode' => { 79 => 0x10e },
	'approved' => { 462 => 'Approved' },
	'approvedby' => { 462 => 'ApprovedBy' },
	'approximatefnumber' => { 297 => 0x313, 304 => 0x3406 },
	'approximatefocusdistance' => { 452 => 'ApproximateFocusDistance' },
	'appversion' => { 464 => 'AppVersion' },
	'aquahsl' => { 98 => 0x20914 },
	'armidentifier' => { 127 => 0x78 },
	'armversion' => { 127 => 0x7a },
	'arranger' => { 362 => "\xa9arg" },
	'arrangerkeywords' => { 362 => "\xa9ark" },
	'artfilter' => { 279 => 0x529 },
	'artfiltereffect' => { 279 => 0x52f },
	'artist' => { 114 => 0x13b, 292 => 'Artist', 337 => 0x22e, 354 => "\xa9ART", 356 => 'artist', 362 => "\xa9ART", 476 => 'Artist', 480 => 'artist' },
	'artmode' => { 108 => 0x301b },
	'artmodeparameters' => { 108 => 0x310b },
	'artwork' => { 356 => 'artwork' },
	'artworkcircadatecreated' => { 466 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 466 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 466 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 466 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 466 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 466 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 466 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 466 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 466 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 466 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 466 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 466 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 466 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 466 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 466 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 466 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 466 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 466 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 283 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 283 => 0x1112, 337 => 0x80, 387 => 0x55, 388 => 0x55, 389 => 0xa },
	'assetid' => { 445 => 'AssetID' },
	'asshoticcprofile' => { 114 => 0xc68f },
	'asshotneutral' => { 114 => 0xc628 },
	'asshotpreprofilematrix' => { 114 => 0xc690 },
	'asshotprofilename' => { 114 => 0xc6f6 },
	'asshotwhitexy' => { 114 => 0xc629 },
	'assignbktbutton' => { 262 => '4.2', 263 => '16.1', 265 => '16.1', 266 => '16.1', 275 => '16.1', 276 => '16.1' },
	'assignfuncbutton' => { 79 => 0x70b },
	'assignmb-d17af-onbutton' => { 266 => '79.1' },
	'assignmb-d17funcbutton' => { 266 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 266 => '68.1' },
	'assignmb-d18af-onbutton' => { 276 => '79.1' },
	'assignmb-d18funcbutton' => { 276 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 276 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 265 => '75.1', 266 => '75.1', 276 => '75.1' },
	'assignmoviefunc2button' => { 265 => '82.1', 266 => '82.1', 276 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 265 => '75.2', 266 => '75.2', 276 => '75.2' },
	'assignmovierecordbutton' => { 263 => '43.2', 275 => '45.1' },
	'assignmovierecordbuttonplusdials' => { 265 => '45.1', 266 => '45.1', 276 => '45.1' },
	'assignmoviesubselector' => { 265 => '74.1', 266 => '74.1', 276 => '74.1' },
	'assignmoviesubselectorplusdials' => { 265 => '76.1', 266 => '76.1', 276 => '76.1' },
	'assignremotefnbutton' => { 263 => '54.1', 275 => '51.1' },
	'assistbuttonfunction' => { 77 => 0xd },
	'atcaptureusercrop' => { 132 => 0x943 },
	'attributionname' => { 453 => 'attributionName' },
	'attributionurl' => { 453 => 'attributionURL' },
	'audio' => { 302 => 0x20 },
	'audiobitrate' => { 64 => 0x6c, 466 => 'audioBitRate' },
	'audiobitratemode' => { 466 => 'audioBitRateMode' },
	'audiobitspersample' => { 466 => 'audioBitsPerSample' },
	'audiochannelcount' => { 466 => 'audioChannelCount' },
	'audiochannels' => { 64 => 0x70 },
	'audiochanneltype' => { 480 => 'audioChannelType' },
	'audiocompression' => { 147 => 'Compression' },
	'audiocompressor' => { 480 => 'audioCompressor' },
	'audiodata' => { 437 => 'Data' },
	'audioduration' => { 126 => 0x99 },
	'audiogain' => { 356 => 'player.movie.audio.gain' },
	'audiomimetype' => { 437 => 'Mime' },
	'audiomoddate' => { 480 => 'audioModDate' },
	'audiooutcue' => { 126 => 0x9a },
	'audiosamplerate' => { 64 => 0x6e, 480 => 'audioSampleRate' },
	'audiosampletype' => { 480 => 'audioSampleType' },
	'audiosamplingrate' => { 126 => 0x97 },
	'audiosamplingresolution' => { 126 => 0x98 },
	'audiotype' => { 126 => 0x96 },
	'author' => { 149 => 'Author', 288 => 'Author', 292 => 'Author', 353 => 'Author', 354 => ['auth',"\xa9aut"], 356 => 'author', 362 => 'auth', 450 => 'author', 467 => 'Author', 478 => 'Author' },
	'authorsposition' => { 468 => 'AuthorsPosition' },
	'autoafpointcolortracking' => { 79 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 328 => '0.1' },
	'autobracket' => { 379 => 0x19 },
	'autobracketing' => { 122 => 0x1100, 337 => 0x18, 369 => 0x1007 },
	'autobracketingmode' => { 274 => '12.3' },
	'autobracketingset' => { 274 => '12.1' },
	'autobracketmodem' => { 262 => '21.2', 263 => '13.3', 265 => '13.2', 266 => '13.2', 271 => '26.2', 275 => '13.3', 276 => '13.2' },
	'autobracketorder' => { 175 => 0x43, 262 => '21.3', 263 => '13.2', 265 => '13.1', 266 => '13.1', 271 => '26.3', 272 => '12.2', 273 => '2.2', 274 => '12.2', 275 => '13.2', 276 => '13.1', 277 => '13.2' },
	'autobracketset' => { 262 => '21.1', 263 => '13.1', 267 => '11.1', 268 => '12.1', 269 => '12.1', 271 => '26.1', 272 => '12.1', 273 => '2.1', 275 => '13.1', 277 => '13.1' },
	'autobrightness' => { 456 => 'AutoBrightness' },
	'autocontrast' => { 456 => 'AutoContrast' },
	'autodistortioncontrol' => { 196 => 0x4 },
	'autodynamicrange' => { 122 => 0x140b },
	'autoexposure' => { 456 => 'AutoExposure' },
	'autoexposurebracketing' => { 73 => 0x10 },
	'autoflashisosensitivity' => { 265 => '38.5', 266 => '38.5', 276 => '38.5' },
	'autofocus' => { 282 => 0x209 },
	'autofp' => { 273 => '7.3', 277 => '31.4' },
	'autoiso' => { 73 => 0x1, 108 => 0x3008, 264 => '1.1', 273 => '1.1' },
	'autoisomax' => { 264 => '1.2', 273 => '1.2' },
	'autoisominshutterspeed' => { 264 => '1.3', 273 => '1.3' },
	'autolateralca' => { 456 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 60 => 0x2, 79 => 0x204, 98 => 0x20500, 104 => 0x6f },
	'autolightingoptimizeron' => { 98 => '0x20500.0', 104 => 0x6e },
	'autoportraitframed' => { 400 => 0x2016 },
	'autoredeye' => { 255 => 0xfe28a44f },
	'autorotate' => { 73 => 0x1b },
	'autoshadows' => { 456 => 'AutoShadows' },
	'autotone' => { 456 => 'AutoTone' },
	'autowhiteversion' => { 456 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 215 => 0x82 },
	'avaperturesetting' => { 318 => 0x13 },
	'averageblacklevel' => { 43 => 0xe7, 45 => 0xfb, 46 => 0x114, 47 => 0x146 },
	'averagelv' => { 178 => 0x38 },
	'avsettingwithoutlens' => { 79 => 0x707 },
	'azimuth' => { 157 => 'Azimuth' },
	'babyage' => { 302 => [0x8010,0x33] },
	'babyname' => { 302 => 0x66 },
	'backgroundalpha' => { 475 => 'bgalpha' },
	'balance' => { 356 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 318 => 0x15 },
	'baseiso' => { 73 => 0x2, 92 => 0x101c, 132 => 0x903, 304 => 0x312a, 429 => 0x6 },
	'baseisodaylight' => { 132 => 0x910 },
	'baseisoflash' => { 132 => 0x913 },
	'baseisofluorescent' => { 132 => 0x912 },
	'baseisotungsten' => { 132 => 0x911 },
	'baselineexposure' => { 114 => 0xc62a },
	'baselineexposureoffset' => { 114 => 0xc7a5 },
	'baselinenoise' => { 114 => 0xc62b },
	'baselinesharpness' => { 114 => 0xc62c },
	'baseurl' => { 478 => 'BaseURL' },
	'bass' => { 356 => 'player.movie.audio.bass' },
	'batterylevel' => { 387 => 0x51, 391 => 0xc, 392 => 0x4, 393 => 0x4, 430 => 0x7 },
	'batterylevelgrip1' => { 430 => 0x6 },
	'batterylevelgrip2' => { 430 => 0x8 },
	'batteryorder' => { 262 => '12.5', 271 => '13.2', 272 => '2.1', 275 => '3.1' },
	'batterystate' => { 175 => 0x60, 387 => 0x50, 393 => 0x14 },
	'batterytemperature' => { 391 => 0x1, 393 => 0x2, 430 => 0x5 },
	'batterytype' => { 61 => 0x38, 365 => 0x66 },
	'batteryunknown' => { 391 => 0x2, 393 => 0x0 },
	'batteryvoltage' => { 132 => 0x408, 363 => 0x2a, 364 => 0x49, 365 => 0x62, 391 => 0x8 },
	'batteryvoltage1' => { 393 => 0x6 },
	'batteryvoltage2' => { 393 => 0x8 },
	'batteryvoltageavg' => { 365 => 0x64 },
	'bayergreensplit' => { 114 => 0xc62d },
	'bayerpattern' => { 131 => 0xf902, 179 => 0x17 },
	'beatsperminute' => { 354 => 'tmpo' },
	'beatspliceparams' => { 480 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 480 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 480 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 480 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 480 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 480 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 262 => '13.1', 263 => '5.4', 264 => '0.1', 267 => '2.1', 268 => '3.1', 269 => '3.1', 271 => '10.1', 273 => '0.1', 275 => '5.5', 277 => '4.1' },
	'beeppitch' => { 272 => '3.1' },
	'beepvolume' => { 272 => '4.5' },
	'bestqualityscale' => { 114 => 0xc65c },
	'bestshotmode' => { 108 => 0x3007 },
	'bitdepth' => { 154 => 'BitDepth', 179 => 0x11, 223 => 0x41 },
	'bitspercomponent' => { 128 => 0x87 },
	'bitspersample' => { 114 => 0x102, 307 => 0xa, 476 => 'BitsPerSample' },
	'blackacquirerows' => { 132 => 0x18ba },
	'blacklevel' => { 114 => 0xc61a, 194 => 0x20, 215 => 0x3d, 284 => [0x401,0x1012], 346 => 0x21d },
	'blacklevel2' => { 283 => 0x600, 287 => 0x600 },
	'blacklevelblue' => { 307 => 0x1e },
	'blacklevelbottom' => { 132 => 0x3f0 },
	'blackleveldata' => { 346 => 0x223 },
	'blackleveldeltah' => { 114 => 0xc61b },
	'blackleveldeltav' => { 114 => 0xc61c },
	'blacklevelgreen' => { 307 => 0x1d },
	'blacklevelred' => { 307 => 0x1c },
	'blacklevelrepeatdim' => { 114 => 0xc619 },
	'blacklevelrough' => { 132 => 0x40e },
	'blacklevelroughafter' => { 132 => 0x416 },
	'blacklevels' => { 35 => 0x1d },
	'blackleveltop' => { 132 => 0x3ef },
	'blackpoint' => { 337 => 0x200 },
	'blacks2012' => { 456 => 'Blacks2012' },
	'blacksadj' => { 433 => 0x9018 },
	'bleachbypasstoning' => { 337 => 0x7f },
	'blockshotafresponse' => { 265 => '1.5', 266 => '1.5', 276 => '1.5' },
	'blogtitle' => { 470 => 'blogTitle' },
	'blogurl' => { 470 => 'blogURL' },
	'bluebalance' => { 284 => 0x1018, 307 => 0x12, 337 => 0x1b },
	'bluecurvelimits' => { 103 => 0x1fe },
	'bluecurvepoints' => { 102 => 0x79, 103 => 0x1d4 },
	'bluehsl' => { 98 => 0x20915 },
	'bluehue' => { 456 => 'BlueHue' },
	'bluesaturation' => { 456 => 'BlueSaturation' },
	'bluratinfinity' => { 441 => 'BlurAtInfinity' },
	'blurcontrol' => { 337 => 0x82 },
	'blurwarning' => { 122 => 0x1300 },
	'bodybatteryadload' => { 316 => 0x3 },
	'bodybatteryadnoload' => { 316 => 0x2 },
	'bodybatterystate' => { 316 => '1.1' },
	'bodybatteryvoltage1' => { 316 => 0x2 },
	'bodybatteryvoltage2' => { 316 => 0x4 },
	'bodybatteryvoltage3' => { 316 => 0x6 },
	'bodybatteryvoltage4' => { 316 => 0x8 },
	'bodyfirmware' => { 370 => 0x0 },
	'bodyfirmwareversion' => { 280 => 0x104, 281 => 0x100, 284 => 0x104 },
	'bodyserialnumber' => { 370 => 0x10 },
	'bookedition' => { 470 => 'bookEdition' },
	'bootloaderversion' => { 364 => 0x26 },
	'bracketmode' => { 55 => 0x3 },
	'bracketsequence' => { 108 => 0x301d },
	'bracketsettings' => { 302 => 0x45 },
	'bracketshotnumber' => { 55 => 0x5, 318 => 0x9, 398 => 0x2b },
	'bracketshotnumber2' => { 398 => 0x2d },
	'bracketstep' => { 172 => 0xe },
	'bracketvalue' => { 55 => 0x4 },
	'brightness' => { 114 => 0xfe53, 148 => 'Brightness', 168 => 'Brightness', 172 => 0x2c, 217 => 0x34, 218 => 0x39, 219 => 0x41, 356 => 'player.movie.visual.brightness', 363 => 0x25, 365 => 0x54, 387 => 0x22, 400 => 0x2007, 456 => 'Brightness' },
	'brightnessadj' => { 103 => 0x114, 248 => 0x0, 258 => 0x2d, 433 => 0x8018 },
	'brightnessvalue' => { 114 => 0x9203, 178 => [0x691,0x49c3], 284 => 0x1003, 405 => 0x1e, 408 => 0x1140, 409 => 0x1140, 410 => 0x111c, 411 => 0x1198, 412 => 0x1174, 413 => 0x102c, 414 => 0x224, 415 => 0x224, 416 => 0x219, 460 => 'BrightnessValue' },
	'bulbduration' => { 73 => 0x18 },
	'burstcount' => { 132 => 0x40d },
	'burstid' => { 438 => 'BurstID' },
	'burstmode' => { 134 => 0xa, 302 => 0x2a },
	'burstmode2' => { 134 => 0x18 },
	'burstprimary' => { 438 => 'BurstPrimary' },
	'burstshot' => { 379 => 0x34 },
	'burstspeed' => { 302 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 79 => 0x70a },
	'bwadjustment' => { 122 => 0x1049 },
	'bwfilter' => { 172 => 0x2a, 180 => 0x39 },
	'bwmode' => { 284 => 0x203 },
	'by-line' => { 126 => 0x50 },
	'by-linetitle' => { 126 => 0x55 },
	'bytecount' => { 470 => 'byteCount' },
	'c14configuration' => { 132 => 0x1964 },
	'cacheversion' => { 114 => 0xc7aa },
	'calibratedfocallength' => { 111 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 111 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 111 => 'CalibratedOpticalCenterY' },
	'calibration' => { 379 => [0x24,0x30] },
	'calibrationhistory' => { 132 => 0x9c9 },
	'calibrationilluminant1' => { 114 => 0xc65a },
	'calibrationilluminant2' => { 114 => 0xc65b },
	'calibrationversion' => { 132 => 0x9c6 },
	'callforimage' => { 445 => 'CallForImage' },
	'cameraangle' => { 362 => 'angl', 480 => 'cameraAngle' },
	'cameraburstid' => { 439 => 'CameraBurstID' },
	'cameracalibration1' => { 114 => 0xc623 },
	'cameracalibration2' => { 114 => 0xc624 },
	'cameracalibrationsig' => { 114 => 0xc6f3 },
	'cameracolorcalibration01' => { 36 => 0x0, 37 => 0x0 },
	'cameracolorcalibration02' => { 36 => 0x4, 37 => 0x5 },
	'cameracolorcalibration03' => { 36 => 0x8, 37 => 0xa },
	'cameracolorcalibration04' => { 36 => 0xc, 37 => 0xf },
	'cameracolorcalibration05' => { 36 => 0x10, 37 => 0x14 },
	'cameracolorcalibration06' => { 36 => 0x14, 37 => 0x19 },
	'cameracolorcalibration07' => { 36 => 0x18, 37 => 0x1e },
	'cameracolorcalibration08' => { 36 => 0x1c, 37 => 0x23 },
	'cameracolorcalibration09' => { 36 => 0x20, 37 => 0x28 },
	'cameracolorcalibration10' => { 36 => 0x24, 37 => 0x2d },
	'cameracolorcalibration11' => { 36 => 0x28, 37 => 0x32 },
	'cameracolorcalibration12' => { 36 => 0x2c, 37 => 0x37 },
	'cameracolorcalibration13' => { 36 => 0x30, 37 => 0x3c },
	'cameracolorcalibration14' => { 36 => 0x34, 37 => 0x41 },
	'cameracolorcalibration15' => { 36 => 0x38, 37 => 0x46 },
	'cameradirection' => { 356 => 'direction.facing' },
	'camerae-mountversion' => { 432 => 0xb },
	'cameraelevationangle' => { 114 => 0x9405, 461 => 'CameraElevationAngle' },
	'camerafilename' => { 445 => 'CameraFilename' },
	'cameraid' => { 284 => 0x209, 362 => 'cmid', 378 => 0x209 },
	'cameraidentifier' => { 356 => 'camera.identifier' },
	'cameraiso' => { 34 => 0x10 },
	'cameralabel' => { 114 => 0xc7a1, 480 => 'cameraLabel' },
	'cameramakemodel' => { 445 => 'CameraMakeModel' },
	'cameramodel' => { 346 => 0x410, 480 => 'cameraModel' },
	'cameramodelid' => { 168 => 'CameraModelID' },
	'cameramotion' => { 356 => 'direction.motion' },
	'cameramove' => { 480 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => 0x36, 24 => 0x7d, 25 => 0x83, 26 => 0x84, 28 => 0x35, 29 => 0x96, 302 => 0x8f, 341 => 0x1, 346 => 0x100, 393 => [0x16,0x18], 420 => 0x28, 421 => 0x24, 422 => 0x29 },
	'cameraowner' => { 135 => 0xc353 },
	'cameraparameters' => { 284 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 110 => 0x9, 362 => "\xa9gpt" },
	'cameraprofile' => { 456 => 'CameraProfile' },
	'cameraprofiledigest' => { 456 => 'CameraProfileDigest' },
	'camerarawcolortone' => { 104 => 0xe1 },
	'camerarawcontrast' => { 104 => 0xe3 },
	'camerarawhighlightpoint' => { 104 => 0xe6 },
	'camerarawlinear' => { 104 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 104 => 0xe8 },
	'camerarawoutputshadowpoint' => { 104 => 0xe9 },
	'camerarawsaturation' => { 104 => 0xe2 },
	'camerarawshadowpoint' => { 104 => 0xe7 },
	'camerarawsharpness' => { 104 => 0xe5 },
	'cameraroll' => { 110 => 0xb, 362 => "\xa9grl" },
	'cameraserialnumber' => { 114 => 0xc62f, 170 => 'CameraSerialNumber', 445 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 279 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 30 => [0x87,0x91], 31 => [0x99,0x9f,0xa4,0xa8,0x105], 33 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 73 => 0xc, 132 => 0x406, 283 => 0x1306, 297 => 0x320, 304 => 0x3402, 337 => 0x47, 376 => 0x43, 424 => 0x5 },
	'cameratemperature4' => { 342 => 0x14 },
	'cameratemperature5' => { 342 => 0x16 },
	'cameratemperaturerangemax' => { 116 => 0x5 },
	'cameratemperaturerangemin' => { 116 => 0x6 },
	'cameratype' => { 73 => 0x1a, 284 => 0x207 },
	'cameratype2' => { 280 => 0x100 },
	'camerayaw' => { 110 => 0xa, 362 => "\xa9gyw" },
	'camreverse' => { 111 => 'CamReverse' },
	'canondr4' => { 115 => 'CanonDR4' },
	'canonexposuremode' => { 34 => 0x14 },
	'canonfiledescription' => { 92 => 0x805 },
	'canonfilelength' => { 61 => 0xe },
	'canonfirmwareversion' => { 61 => 0x7, 92 => 0x80b },
	'canonflashinfo' => { 92 => 0x1028 },
	'canonflashmode' => { 34 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 34 => 0xa },
	'canonimagetype' => { 61 => 0x6, 92 => 0x815 },
	'canonmodelid' => { 61 => 0x10, 92 => 0x1834 },
	'canonvrd' => { 115 => 'CanonVRD' },
	'caption' => { 450 => 'caption' },
	'caption-abstract' => { 126 => 0x78 },
	'captionsauthornames' => { 459 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 459 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 468 => 'CaptionWriter' },
	'captureframerate' => { 108 => 0x4001 },
	'captureheightnormal' => { 132 => 0x1839 },
	'capturelook' => { 132 => 0xc48 },
	'capturemode' => { 356 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 443 => 'CaptureSoftware' },
	'capturewidthnormal' => { 132 => 0x1838 },
	'capturewidthtest' => { 132 => 0x1842 },
	'cardshutterlock' => { 175 => 0x49 },
	'casioimagesize' => { 108 => 0x9 },
	'catalogsets' => { 126 => 0xff, 436 => 'CatalogSets', 448 => 'CatalogSets' },
	'categories' => { 61 => 0x23, 450 => 'categories' },
	'category' => { 126 => 0xf, 278 => 0x30, 354 => 'catg', 468 => 'Category' },
	'cbcrgain' => { 376 => 0xa036 },
	'cbcrgaindefault' => { 376 => 0xa035 },
	'cbcrmatrix' => { 376 => 0xa034 },
	'cbcrmatrixdefault' => { 376 => 0xa033 },
	'ccdboardversion' => { 297 => 0x331 },
	'ccdscanmode' => { 284 => 0x1039 },
	'ccdsensitivity' => { 245 => 0x6 },
	'ccdversion' => { 297 => 0x330 },
	'cellglobalid' => { 454 => 'cgi' },
	'celllength' => { 114 => 0x109 },
	'cellr' => { 454 => 'r' },
	'celltowerid' => { 454 => 'cellid' },
	'cellwidth' => { 114 => 0x108 },
	'centerafarea' => { 273 => '15.1' },
	'centerfocuspoint' => { 277 => '2.2' },
	'centerpixel' => { 132 => 0x40c },
	'centerweightedareasize' => { 262 => '7.1', 263 => '8.1', 265 => '8.1', 266 => '8.1', 270 => '7.1', 271 => '5.1', 272 => '7.1', 273 => '6.3', 275 => '8.1', 276 => '8.1', 277 => '8.1' },
	'certificate' => { 484 => 'Certificate' },
	'cfainterpolationalgorithm' => { 132 => 0xe60 },
	'cfainterpolationmetric' => { 132 => 0xe61 },
	'cfaoffsetcols' => { 132 => 0xc71 },
	'cfaoffsetrows' => { 132 => 0xc6f },
	'cfapattern' => { 114 => 0xa302, 307 => 0x9, 460 => 'CFAPattern' },
	'cfapattern2' => { 114 => 0x828e },
	'cfapatterncolumns' => { 460 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 460 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 460 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 114 => 0x828d },
	'cfazipperfixthreshold' => { 132 => 0xe62 },
	'channel' => { 470 => 'channel' },
	'channela-lang' => { 470 => [\'channel','channelA-lang'] },
	'channelchannel' => { 470 => [\'channel','channelChannel'] },
	'channels' => { 147 => 'Channels' },
	'channelsubchannel1' => { 470 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 470 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 470 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 470 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 362 => 'chpl' },
	'checkmark' => { 98 => 0x10101, 103 => 0x26a },
	'checkmark2' => { 104 => 0x8e },
	'childfontfiles' => { 485 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 262 => '10.3', 263 => '11.2' },
	'chromablurradius' => { 114 => 0xc631 },
	'chromanoisecolorspace' => { 132 => 0xe6d },
	'chromanoiseedgemapthresh' => { 132 => 0xe6c },
	'chromanoisehighfthresh' => { 132 => 0xe6a },
	'chromanoiselowfthresh' => { 132 => 0xe6b },
	'chromaticaberration' => { 98 => 0x20703, 104 => 0x66, 376 => 0xa051 },
	'chromaticaberrationb' => { 456 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 98 => 0x20708, 104 => 0x6b },
	'chromaticaberrationcorr' => { 75 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 114 => 0x7034, 327 => 0x1, 433 => 0x900d },
	'chromaticaberrationcorrparams' => { 114 => 0x7035, 428 => 0x66a, 429 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 98 => '0x20703.0', 104 => 0x62 },
	'chromaticaberrationr' => { 456 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 98 => 0x20707, 104 => 0x6a },
	'chromaticaberrationsetting' => { 76 => 0x6 },
	'chrominancenoisereduction' => { 98 => 0x20601, 104 => 0x5e, 379 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 104 => 0x60 },
	'circadatecreated' => { 466 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 456 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 456 => 'CircularGradientBasedCorrections' },
	'city' => { 126 => 0x5a, 153 => 'City', 302 => 0x6d, 468 => 'City' },
	'city2' => { 302 => 0x80 },
	'clarity' => { 218 => 0x35, 219 => 0x3d, 456 => 'Clarity' },
	'clarity2012' => { 456 => 'Clarity2012' },
	'claritycontrol' => { 337 => 0x96 },
	'classifystate' => { 126 => 0xe1 },
	'clearretouch' => { 302 => 0x7c },
	'clearretouchvalue' => { 302 => 0xa3 },
	'client' => { 480 => 'client' },
	'clientname' => { 462 => 'ClientName' },
	'clipfilename' => { 362 => 'clfn' },
	'clipid' => { 362 => 'clid' },
	'clmodeshootingspeed' => { 262 => '10.2', 263 => '11.3', 265 => '11.2', 266 => '11.2', 271 => '11.2', 272 => '10.2', 275 => '11.2', 276 => '11.2', 277 => '11.1' },
	'cmcontrast' => { 287 => 0x2022 },
	'cmexposurecompensation' => { 287 => 0x2000 },
	'cmhue' => { 287 => 0x2021 },
	'cmsaturation' => { 287 => 0x2020 },
	'cmsharpness' => { 287 => 0x2023 },
	'cmwhitebalance' => { 287 => 0x2001 },
	'cmwhitebalancecomp' => { 287 => 0x2002 },
	'cmwhitebalancegraypoint' => { 287 => 0x2010 },
	'codec' => { 161 => 'Codec' },
	'codedcharacterset' => { 127 => 0x5a },
	'codeversion' => { 362 => 'cver' },
	'collection' => { 292 => 'Collection' },
	'collectionname' => { 162 => [\'Collections','CollectionsCollectionName'], 362 => 'coll' },
	'collections' => { 162 => 'Collections', 450 => 'collections' },
	'collectionuri' => { 162 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 356 => 'player.movie.visual.color', 469 => 'color' },
	'coloraberrationcontrol' => { 255 => 0xc89224b },
	'coloradjustment' => { 379 => 0x14 },
	'coloradjustmentmode' => { 378 => 0x210 },
	'coloranta' => { 485 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 485 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 485 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 485 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 485 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 485 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 485 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 485 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 485 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 485 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 485 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 485 => 'Colorants' },
	'colorantswatchname' => { 485 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 485 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 485 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 485 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 148 => 'ColorBalance' },
	'colorbalanceadj' => { 255 => 0x76a43202 },
	'colorbalanceblue' => { 172 => 0x1e },
	'colorbalancegreen' => { 172 => 0x1d },
	'colorbalancered' => { 172 => 0x1c },
	'colorbalanceversion' => { 193 => 0x4, 194 => 0x4, 195 => 0x0 },
	'colorblur' => { 104 => 0x65 },
	'colorbluron' => { 98 => 0x20704 },
	'colorbooster' => { 255 => 0x5f0e7d23 },
	'colorboostlevel' => { 249 => 0x1 },
	'colorboosttype' => { 249 => 0x0 },
	'colorchromeeffect' => { 122 => 0x1048 },
	'colorclass' => { 348 => 0xde, 349 => 'ColorClass' },
	'colorcompensationfilter' => { 175 => [0x3a,0x5f], 177 => 0x111, 400 => 0xb022 },
	'colorcompensationfiltercustom' => { 387 => 0xd, 388 => 0xc },
	'colorcompensationfilterset' => { 387 => 0x8, 388 => 0x7, 389 => 0x18, 405 => 0xf },
	'colorcontrol' => { 284 => 0x102b },
	'colorcorrection' => { 433 => 0x8015 },
	'colorcreatoreffect' => { 279 => 0x532 },
	'colordataversion' => { 42 => 0x0, 43 => 0x0, 44 => 0x0, 45 => 0x0, 46 => 0x0, 47 => 0x0, 48 => 0x0 },
	'coloreffect' => { 302 => 0x28 },
	'colorfilter' => { 107 => 0x17, 108 => 0x3017, 172 => 0x29, 180 => [0x38,0x4d,0x4f], 344 => 0x17 },
	'colorgain' => { 223 => 0x51 },
	'colorhue' => { 98 => 0x20900, 215 => 0x8d },
	'colorimetricreference' => { 114 => 0xc6bf },
	'colorlabel' => { 459 => 'ColorLabel' },
	'colormatrix' => { 283 => 0x200, 284 => 0x1011, 376 => 0xa030 },
	'colormatrix1' => { 114 => 0xc621, 346 => 0x106 },
	'colormatrix2' => { 114 => 0xc622, 287 => 0x200, 346 => 0x226 },
	'colormatrixa' => { 337 => 0x203 },
	'colormatrixadobergb' => { 376 => 0xa032 },
	'colormatrixb' => { 337 => 0x204 },
	'colormatrixnumber' => { 284 => 0x1019 },
	'colormatrixsrgb' => { 376 => 0xa031 },
	'colormode' => { 108 => 0x3015, 122 => 0x1210, 134 => 0x66, 172 => 0x28, 175 => 0x16, 177 => 0x101, 178 => 0x36, 180 => 0x7, 215 => 0x3, 245 => 0x4, 302 => 0x32, 379 => 0x2c, 400 => 0xb029, 468 => 'ColorMode' },
	'colormoirereduction' => { 98 => 0x20670, 256 => 0x15 },
	'colormoirereductionmode' => { 256 => 0x5 },
	'colormoirereductionon' => { 98 => '0x20670.0' },
	'colornoisereduction' => { 433 => 0x8029, 456 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 456 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 256 => 0x18 },
	'colornoisereductionsharpness' => { 256 => 0x1c },
	'colornoisereductionsmoothness' => { 456 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 118 => 0x2 },
	'colorprofile' => { 172 => 0x33 },
	'colorprofilesettings' => { 279 => 0x539 },
	'colorrepresentation' => { 128 => 0x3c },
	'colorsaturationadj' => { 98 => 0x20305 },
	'colorsequence' => { 128 => 0x41 },
	'colorspace' => { 49 => 0x3, 61 => 0xb4, 92 => 0x10b4, 114 => 0xa001, 154 => 'ColorSpace', 173 => 0x2f, 174 => 0x25, 175 => 0x17, 215 => 0x1e, 279 => 0x507, 337 => 0x37, 376 => 0xa011, 379 => 0xb, 387 => 0x1b, 388 => 0x83, 389 => 0xe, 405 => 0x6, 460 => 'ColorSpace' },
	'colortempasshot' => { 38 => 0x4, 39 => 0x7, 40 => 0x1d, 41 => 0x26, 42 => 0x43, 45 => 0x43, 46 => 0x43, 47 => 0x43, 48 => 0x4b },
	'colortempauto' => { 38 => 0x9, 39 => 0xf, 40 => 0x22, 41 => 0x1c, 42 => 0x48, 45 => 0x48, 46 => 0x48, 47 => 0x48, 48 => 0x50 },
	'colortempcloudy' => { 38 => 0x22, 39 => 0x37, 40 => 0x31, 41 => 0x35, 42 => 0x5c, 45 => 0x75, 46 => 0x8e, 47 => 0x93, 48 => 0x96, 337 => 0x55 },
	'colortempcustom' => { 42 => 0x84 },
	'colortempcustom1' => { 40 => 0x45 },
	'colortempcustom2' => { 40 => 0x4a },
	'colortempdaylight' => { 38 => 0x18, 39 => 0x27, 40 => 0x27, 41 => 0x2b, 42 => 0x52, 45 => 0x6b, 46 => 0x84, 47 => 0x89, 48 => 0x8c, 337 => 0x53 },
	'colortemperature' => { 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 61 => 0xae, 71 => 0x9, 92 => 0x10ae, 122 => 0x1005, 132 => 0x846, 148 => 'ColorTemperature', 173 => [0x6e,0x49], 174 => 0x3f, 175 => [0x39,0x5e], 177 => 0x10b, 180 => [0x3c,0x4c,0x4e], 297 => 0x321, 337 => 0x50, 369 => 0x1308, 400 => 0xb021, 456 => 'Temperature' },
	'colortemperatureadj' => { 433 => 0x8013 },
	'colortemperatureauto' => { 215 => 0x4f },
	'colortemperaturebg' => { 284 => 0x1013 },
	'colortemperaturecustom' => { 387 => 0xc, 388 => 0xb },
	'colortemperaturerg' => { 284 => 0x1014 },
	'colortemperatureset' => { 387 => 0x7, 388 => 0x6 },
	'colortemperaturesetting' => { 175 => 0x25, 389 => 0x17, 405 => 0xe },
	'colortempflash' => { 38 => 0x36, 39 => 0x57, 40 => 0x40, 41 => 0x49, 42 => 0x70, 45 => 0x89, 46 => 0xa2, 47 => 0xa7, 48 => 0xaa, 337 => 0x5a },
	'colortempflashdata' => { 42 => 0x24a },
	'colortempfluorescent' => { 38 => 0x2c, 39 => 0x47, 40 => 0x3b, 41 => 0x3f, 42 => 0x66, 45 => 0x7f, 46 => 0x98, 47 => 0x9d, 48 => 0xa0 },
	'colortempfluorescentd' => { 337 => 0x57 },
	'colortempfluorescentn' => { 337 => 0x58 },
	'colortempfluorescentw' => { 337 => 0x59 },
	'colortempkelvin' => { 38 => 0x31, 39 => 0x4f, 41 => 0x44, 42 => 0x6b, 45 => 0x84, 46 => 0x9d, 47 => 0xa2, 48 => 0xa5, 302 => 0x44, 369 => 0x1307 },
	'colortempmeasured' => { 38 => 0xe, 39 => 0x17, 42 => 0x4d, 45 => 0x4d, 46 => 0x4d, 47 => 0x4d, 48 => 0x55 },
	'colortemppc1' => { 41 => 0x94, 42 => 0x75 },
	'colortemppc2' => { 41 => 0x99, 42 => 0x7a },
	'colortemppc3' => { 41 => 0x9e, 42 => 0x7f },
	'colortempshade' => { 38 => 0x1d, 39 => 0x2f, 40 => 0x2c, 41 => 0x30, 42 => 0x57, 45 => 0x70, 46 => 0x89, 47 => 0x8e, 48 => 0x91, 337 => 0x54 },
	'colortemptungsten' => { 38 => 0x27, 39 => 0x3f, 40 => 0x36, 41 => 0x3a, 42 => 0x61, 45 => 0x7a, 46 => 0x93, 47 => 0x98, 48 => 0x9b, 337 => 0x56 },
	'colortempunknown' => { 38 => 0x13, 39 => 0x1f, 41 => 0x21, 45 => 0x52, 46 => 0x52, 47 => 0x52, 48 => 0x5a },
	'colortempunknown10' => { 38 => 0x63, 39 => 0x9f, 41 => 0x76, 45 => 0xa2, 46 => 0x7f, 47 => 0x7f, 48 => 0x87 },
	'colortempunknown11' => { 38 => 0x68, 39 => 0xa7, 41 => 0x7b, 45 => 0xa7, 46 => 0xa7, 47 => 0x84, 48 => 0xaf },
	'colortempunknown12' => { 38 => 0x6d, 39 => 0xaf, 41 => 0x80, 45 => 0xac, 46 => 0xac, 47 => 0xac, 48 => 0xb4 },
	'colortempunknown13' => { 38 => 0x72, 39 => 0xb7, 41 => 0x85, 45 => 0xb1, 46 => 0xb1, 47 => 0xb1, 48 => 0xb9 },
	'colortempunknown14' => { 41 => 0x8a, 45 => 0xb6, 46 => 0xb6, 47 => 0xb6, 48 => 0xbe },
	'colortempunknown15' => { 41 => 0x8f, 45 => 0xbb, 46 => 0xbb, 47 => 0xbb, 48 => 0xc3 },
	'colortempunknown16' => { 41 => 0xa3, 46 => 0xc0, 47 => 0xc0, 48 => 0xc8 },
	'colortempunknown17' => { 46 => 0xc5, 47 => 0xc5, 48 => 0xcd },
	'colortempunknown18' => { 46 => 0xca, 47 => 0xca, 48 => 0xd2 },
	'colortempunknown19' => { 46 => 0xcf, 47 => 0xcf, 48 => 0xd7 },
	'colortempunknown2' => { 38 => 0x3b, 39 => 0x5f, 41 => 0x4e, 45 => 0x57, 46 => 0x57, 47 => 0x57, 48 => 0x5f },
	'colortempunknown20' => { 46 => 0xd4, 47 => 0xd4, 48 => 0xdc },
	'colortempunknown21' => { 47 => 0xd9, 48 => 0xe1 },
	'colortempunknown22' => { 47 => 0xde, 48 => 0xe6 },
	'colortempunknown23' => { 47 => 0xe3, 48 => 0xeb },
	'colortempunknown24' => { 47 => 0xe8, 48 => 0xf0 },
	'colortempunknown25' => { 47 => 0xed, 48 => 0xf5 },
	'colortempunknown26' => { 47 => 0xf2, 48 => 0xfa },
	'colortempunknown27' => { 47 => 0xf7, 48 => 0xff },
	'colortempunknown28' => { 47 => 0xfc, 48 => 0x104 },
	'colortempunknown29' => { 47 => 0x101, 48 => 0x109 },
	'colortempunknown3' => { 38 => 0x40, 39 => 0x67, 41 => 0x53, 45 => 0x5c, 46 => 0x5c, 47 => 0x5c, 48 => 0x64 },
	'colortempunknown30' => { 47 => 0x106 },
	'colortempunknown4' => { 38 => 0x45, 39 => 0x6f, 41 => 0x58, 45 => 0x61, 46 => 0x61, 47 => 0x61, 48 => 0x69 },
	'colortempunknown5' => { 38 => 0x4a, 39 => 0x77, 41 => 0x5d, 45 => 0x66, 46 => 0x66, 47 => 0x66, 48 => 0x6e },
	'colortempunknown6' => { 38 => 0x4f, 39 => 0x7f, 41 => 0x62, 45 => 0x8e, 46 => 0x6b, 47 => 0x6b, 48 => 0x73 },
	'colortempunknown7' => { 38 => 0x54, 39 => 0x87, 41 => 0x67, 45 => 0x93, 46 => 0x70, 47 => 0x70, 48 => 0x78 },
	'colortempunknown8' => { 38 => 0x59, 39 => 0x8f, 41 => 0x6c, 45 => 0x98, 46 => 0x75, 47 => 0x75, 48 => 0x7d },
	'colortempunknown9' => { 38 => 0x5e, 39 => 0x97, 41 => 0x71, 45 => 0x9d, 46 => 0x7a, 47 => 0x7a, 48 => 0x82 },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 34 => 0x2a, 49 => 0x2 },
	'colortoneadj' => { 98 => 0x20304, 103 => 0x11e },
	'colortoneauto' => { 68 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 67 => 0x6c, 68 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 67 => 0x3c, 68 => 0x3c },
	'colortonemonochrome' => { 67 => 0x84, 68 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 67 => 0x54, 68 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 67 => 0x24, 68 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 67 => 0xc, 68 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 67 => 0x9c, 68 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 67 => 0xb4, 68 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 67 => 0xcc, 68 => 0xe4 },
	'comlenblksize' => { 132 => 0xfde8 },
	'commanddials' => { 273 => '5.1' },
	'commanddialsaperturesetting' => { 262 => '17.3', 263 => '18.3', 265 => '18.3', 266 => '18.3', 271 => '33.3', 272 => '17.3', 275 => '18.3', 276 => '18.3' },
	'commanddialschangemainsub' => { 262 => '17.2', 263 => '18.1', 265 => '18.1', 266 => '18.1', 271 => '33.2', 272 => '17.2', 275 => '18.1', 276 => '18.1' },
	'commanddialsmenuandplayback' => { 262 => '17.4', 263 => '18.2', 265 => '18.2', 266 => '18.2', 271 => '33.4', 272 => '17.4', 275 => '18.2', 276 => '18.2' },
	'commanddialsreverserotation' => { 262 => '17.1', 263 => '6.4', 265 => '6.2', 266 => '6.2', 267 => '16.2', 268 => '17.2', 271 => '33.1', 272 => '17.1', 275 => '6.2', 276 => '6.2', 277 => '18.1' },
	'commanderchannel' => { 273 => '10.2', 274 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 273 => '13.1', 274 => '31.1' },
	'commandergroupa_ttlcomp' => { 277 => '32.1' },
	'commandergroupamanualoutput' => { 273 => '13.2', 274 => '28.2' },
	'commandergroupamode' => { 273 => '11.2', 274 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 273 => '14.1', 274 => '32.1' },
	'commandergroupb_ttlcomp' => { 277 => '33.1' },
	'commandergroupbmanualoutput' => { 273 => '14.2', 274 => '29.2' },
	'commandergroupbmode' => { 273 => '11.3', 274 => '29.1' },
	'commanderinternalflash' => { 273 => '11.1', 274 => '27.1' },
	'commanderinternalmanualoutput' => { 273 => '12.2', 274 => '27.2' },
	'commanderinternalttlchannel' => { 271 => '18.2' },
	'commanderinternalttlcomp' => { 273 => '12.1', 274 => '30.2', 277 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 271 => '20.1', 272 => '26.1' },
	'commanderinternalttlcompgroupa' => { 271 => '21.1', 272 => '27.1' },
	'commanderinternalttlcompgroupb' => { 271 => '22.1', 272 => '28.1' },
	'comment' => { 0 => 0x2, 115 => 'Comment', 149 => 'Comment', 292 => 'Comment', 354 => "\xa9cmt", 356 => 'comment', 362 => "\xa9cmt" },
	'compass' => { 372 => 0x4 },
	'compilation' => { 354 => 'cpil' },
	'complianceprofile' => { 470 => 'complianceProfile' },
	'componentsconfiguration' => { 114 => 0x9101, 154 => 'Components', 460 => 'ComponentsConfiguration' },
	'componentversion' => { 92 => 0x80c },
	'composer' => { 354 => ["\xa9com","\xa9wrt"], 362 => ["\xa9com","\xa9wrt"], 480 => 'composer' },
	'composerkeywords' => { 362 => "\xa9cok" },
	'composition' => { 445 => 'Composition' },
	'compositionadjust' => { 336 => '0.1' },
	'compositionadjustrotation' => { 336 => 0x7 },
	'compositionadjustx' => { 336 => 0x5 },
	'compositionadjusty' => { 336 => 0x6 },
	'compressedbitsperpixel' => { 114 => 0x9102, 460 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 177 => 0x40, 284 => 0x40 },
	'compression' => { 114 => 0x103, 307 => 0xb, 476 => 'Compression' },
	'compressionfactor' => { 279 => 0x50d },
	'compressionratio' => { 154 => 'Compression', 284 => 0x1034 },
	'compressorversion' => { 362 => 'CNCV' },
	'condadobvfactor' => { 132 => 0xf3e },
	'condadodaybvthresh' => { 132 => 0xf3c },
	'condadodayoffsets' => { 132 => 0xf42 },
	'condadofluoffsets' => { 132 => 0xf44 },
	'condadofluthresh' => { 132 => 0xf41 },
	'condadoillfactor' => { 132 => 0xf3f },
	'condadoneurange' => { 132 => 0xf3d },
	'condadotunoffsets' => { 132 => 0xf43 },
	'condadotunthresh' => { 132 => 0xf40 },
	'confidence' => { 440 => 'Confidence' },
	'confidencelevel' => { 451 => 'ConfidenceLevel' },
	'confidencemime' => { 440 => 'ConfidenceMime' },
	'constrainedcropheight' => { 103 => 0x266, 348 => 0xd6 },
	'constrainedcropwidth' => { 103 => 0x262, 348 => 0xd5 },
	'contact' => { 126 => 0x76 },
	'contactinfo' => { 469 => 'contactInfo' },
	'containerformat' => { 466 => 'ContainerFormat' },
	'containerformatidentifier' => { 466 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 466 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 354 => "\xa9day", 362 => "\xa9day" },
	'contentdistributorid' => { 362 => 'cdis' },
	'contentid' => { 362 => 'ccid' },
	'contentidentifier' => { 1 => 0x11 },
	'contentlocationcode' => { 126 => 0x1a },
	'contentlocationname' => { 126 => 0x1b },
	'contenttype' => { 470 => 'contentType' },
	'continuousbracketing' => { 175 => 0x20 },
	'continuousdrive' => { 34 => 0x5 },
	'continuousmodeliveview' => { 276 => '77.2' },
	'continuousshootingspeed' => { 79 => 0x610 },
	'continuousshotlimit' => { 79 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 34 => 0xd, 107 => 0xc, 108 => [0x3012,0x20], 114 => [0xa408,0xfe54], 122 => [0x1004,0x1006], 148 => 'Contrast', 168 => 'Contrast', 172 => 0x20, 173 => 0x31, 174 => 0x27, 175 => 0x19, 180 => 0x2, 217 => 0x33, 218 => 0x37, 219 => 0x3f, 284 => 0x1029, 302 => 0x39, 304 => 0x300a, 337 => 0x20, 344 => 0xc, 356 => 'player.movie.visual.contrast', 363 => 0x24, 365 => 0x52, 369 => 0x1012, 379 => 0xd, 387 => 0x1d, 388 => 0x1a, 400 => 0x2004, 456 => 'Contrast', 460 => 'Contrast' },
	'contrast2012' => { 456 => 'Contrast2012' },
	'contrastadj' => { 98 => 0x20303, 103 => 0x115, 258 => 0x2c, 433 => 0x8017 },
	'contrastauto' => { 68 => 0x90 },
	'contrastcurve' => { 215 => 0x8c },
	'contrastdetectaf' => { 184 => 0x4 },
	'contrastdetectafarea' => { 337 => 0x231 },
	'contrastdetectafinfocus' => { 184 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 67 => 0x60, 68 => 0x60 },
	'contrasthighlight' => { 337 => 0x6d },
	'contrasthighlightshadowadj' => { 337 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 67 => 0x30, 68 => 0x30 },
	'contrastmode' => { 302 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 67 => 0x78, 68 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 67 => 0x48, 68 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 67 => 0x18, 68 => 0x18 },
	'contrastsetting' => { 279 => 0x505, 287 => 0x1012, 389 => 0x10, 405 => 0x8 },
	'contrastshadow' => { 337 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 67 => 0x0, 68 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 67 => 0x90, 68 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 67 => 0xa8, 68 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 67 => 0xc0, 68 => 0xd8 },
	'contributedmedia' => { 480 => 'contributedMedia' },
	'contributedmediaduration' => { 480 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 480 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 480 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 480 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 480 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 480 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 480 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 480 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 480 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 480 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 457 => 'contributor', 466 => 'Contributor' },
	'contributoridentifier' => { 466 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 466 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 466 => [\'Contributor','ContributorRole'] },
	'contributors' => { 149 => 'Contributors' },
	'controldialset' => { 175 => 0x46 },
	'controlledvocabularyterm' => { 466 => 'CVterm' },
	'controllerboardversion' => { 297 => 0x332 },
	'controlmode' => { 73 => 0x12 },
	'controlringrotation' => { 79 => 0x712 },
	'conversionlens' => { 280 => 0x403, 302 => 0x35 },
	'converter' => { 114 => 0xfe4d, 245 => 0xb, 456 => 'Converter' },
	'converttograyscale' => { 456 => 'ConvertToGrayscale' },
	'cookingequipment' => { 472 => 'cookingEquipment' },
	'cookingmethod' => { 472 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 114 => 0x8298, 149 => 'Copyright', 292 => 'Copyright', 337 => 0x22f, 353 => 'Copyright', 354 => ['cprt',"\xa9cpy"], 356 => 'copyright', 362 => ['cprt',"\xa9cpy"], 467 => 'Copyright', 473 => 'copyright', 476 => 'Copyright', 480 => 'copyright' },
	'copyrightflag' => { 351 => 0x40a },
	'copyrightnotice' => { 126 => 0x74 },
	'copyrightowner' => { 289 => 'CopyrightOwner' },
	'copyrightownerid' => { 289 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 289 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 289 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 289 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 289 => 'CopyrightStatus' },
	'copyrightyear' => { 466 => 'CopyrightYear', 470 => 'copyrightYear' },
	'coringfilter' => { 283 => 0x310, 284 => 0x102d, 287 => 0x310 },
	'coringvalues' => { 283 => 0x311, 287 => 0x311 },
	'corporateentity' => { 470 => 'corporateEntity' },
	'country' => { 153 => 'Country', 302 => 0x69, 468 => 'Country' },
	'country-primarylocationcode' => { 126 => 0x64 },
	'country-primarylocationname' => { 126 => 0x65 },
	'countrycode' => { 214 => 0x5, 349 => 'CountryCode', 465 => 'CountryCode' },
	'course' => { 472 => 'course' },
	'coverage' => { 457 => 'coverage' },
	'coverart' => { 354 => 'covr' },
	'coverdate' => { 470 => 'coverDate' },
	'coverdisplaydate' => { 470 => 'coverDisplayDate' },
	'coveruri' => { 362 => 'cvru' },
	'cpufirmwareversion' => { 337 => 0x28 },
	'crc32' => { 458 => 'crc32' },
	'createdate' => { 114 => 0x9004, 149 => 'CreateDate', 288 => 'CreationDate', 292 => 'create-date', 353 => 'CreationDate', 359 => 0x1, 478 => 'CreateDate' },
	'creationdate' => { 356 => 'creationdate', 467 => 'CreationDate', 470 => 'creationDate' },
	'creationtime' => { 292 => 'Creation Time' },
	'creativestyle' => { 387 => 0x1a, 388 => 0x18, 398 => 0x41, 400 => 0xb020, 429 => 0x4a },
	'creativestylesetting' => { 389 => 0xf, 405 => 0x7 },
	'creativestylewaschanged' => { 433 => 0x8001 },
	'creator' => { 288 => 'Creator', 353 => 'Creator', 457 => 'creator', 466 => 'Creator', 467 => 'Creator' },
	'creatoraddress' => { 465 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 170 => 'CreatorAppId' },
	'creatorcity' => { 465 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 465 => 'CreatorContactInfo' },
	'creatorcountry' => { 465 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 466 => [\'Creator','CreatorIdentifier'] },
	'creatorname' => { 466 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 170 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 465 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 465 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 466 => [\'Creator','CreatorRole'] },
	'creatortool' => { 478 => 'CreatorTool' },
	'creatorworkemail' => { 465 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 465 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 465 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 126 => 0x6e, 468 => 'Credit' },
	'creditline' => { 473 => 'creditLine' },
	'creditlinereq' => { 483 => 'CreditLineReq' },
	'creditlinerequired' => { 289 => 'CreditLineRequired' },
	'cropactive' => { 96 => 0x0, 103 => 0x244 },
	'cropangle' => { 456 => 'CropAngle' },
	'croparea' => { 215 => 0x45, 433 => 0x9011 },
	'cropaspectratio' => { 98 => 0x30101, 103 => 0x260 },
	'cropaspectratiocustom' => { 98 => 0x30102 },
	'cropbottom' => { 118 => 0x9, 250 => 0x36, 307 => 0x31, 348 => 0xdc, 456 => 'CropBottom' },
	'cropbottommargin' => { 51 => 0x3 },
	'cropcircleactive' => { 104 => 0xd6 },
	'cropcircleradius' => { 104 => 0xd9 },
	'cropcirclex' => { 104 => 0xd7 },
	'cropcircley' => { 104 => 0xd8 },
	'cropconstraintowarp' => { 456 => 'CropConstrainToWarp' },
	'croph' => { 449 => 'CropH' },
	'cropheight' => { 96 => 0x6, 103 => 0x24c, 283 => 0x615, 287 => 0x615, 456 => 'CropHeight' },
	'crophispeed' => { 215 => 0x1b },
	'cropleft' => { 103 => 0x246, 118 => 0x6, 250 => 0x1e, 283 => 0x612, 287 => 0x612, 307 => 0x30, 348 => 0xd9, 456 => 'CropLeft' },
	'cropleftmargin' => { 51 => 0x0 },
	'cropmode' => { 122 => 0x104d },
	'cropmode35mm' => { 369 => 0x1018 },
	'croporiginalheight' => { 96 => 0xb },
	'croporiginalwidth' => { 96 => 0xa },
	'cropoutputheight' => { 250 => 0xce },
	'cropoutputheightinches' => { 250 => 0x96 },
	'cropoutputpixels' => { 250 => 0xd6 },
	'cropoutputresolution' => { 250 => 0xb6 },
	'cropoutputscale' => { 250 => 0xbe },
	'cropoutputwidth' => { 250 => 0xc6 },
	'cropoutputwidthinches' => { 250 => 0x8e },
	'croppedareaimageheightpixels' => { 443 => 'CroppedAreaImageHeightPixels', 444 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 443 => 'CroppedAreaImageWidthPixels', 444 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 443 => 'CroppedAreaLeftPixels', 444 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 443 => 'CroppedAreaTopPixels', 444 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 369 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 369 => 0x1603 },
	'cropping' => { 433 => 0x9010 },
	'cropright' => { 118 => 0x8, 250 => 0x2e, 307 => 0x32, 348 => 0xdb, 456 => 'CropRight' },
	'croprightmargin' => { 51 => 0x1 },
	'croprotatedoriginalheight' => { 96 => 0x2 },
	'croprotatedoriginalwidth' => { 96 => 0x1 },
	'croprotation' => { 96 => 0x8, 118 => 0xb },
	'cropscaledresolution' => { 250 => 0x9e },
	'cropsourceresolution' => { 250 => 0xae },
	'croptop' => { 103 => 0x248, 118 => 0x7, 250 => 0x26, 283 => 0x613, 287 => 0x613, 307 => 0x2f, 348 => 0xda, 456 => 'CropTop' },
	'croptopmargin' => { 51 => 0x2 },
	'cropunit' => { 456 => 'CropUnit' },
	'cropunits' => { 456 => 'CropUnits' },
	'cropw' => { 449 => 'CropW' },
	'cropwidth' => { 96 => 0x5, 103 => 0x24a, 283 => 0x614, 287 => 0x614, 456 => 'CropWidth' },
	'cropx' => { 96 => 0x3, 449 => 'CropX' },
	'cropy' => { 96 => 0x4, 449 => 'CropY' },
	'crossprocess' => { 337 => 0x7b },
	'crossprocessparams' => { 337 => 0x235 },
	'cuisine' => { 472 => 'cuisine' },
	'currenticcprofile' => { 114 => 0xc691 },
	'currentpreprofilematrix' => { 114 => 0xc692 },
	'currentversion' => { 433 => 0xd000 },
	'curve0x' => { 449 => 'Curve0x' },
	'curve0y' => { 449 => 'Curve0y' },
	'curve1x' => { 449 => 'Curve1x' },
	'curve1y' => { 449 => 'Curve1y' },
	'curve2x' => { 449 => 'Curve2x' },
	'curve2y' => { 449 => 'Curve2y' },
	'curve3x' => { 449 => 'Curve3x' },
	'curve3y' => { 449 => 'Curve3y' },
	'curve4x' => { 449 => 'Curve4x' },
	'curve4y' => { 449 => 'Curve4y' },
	'curves' => { 255 => 0x76a43201 },
	'custom1' => { 289 => 'Custom1' },
	'custom10' => { 289 => 'Custom10' },
	'custom2' => { 289 => 'Custom2' },
	'custom3' => { 289 => 'Custom3' },
	'custom4' => { 289 => 'Custom4' },
	'custom5' => { 289 => 'Custom5' },
	'custom6' => { 289 => 'Custom6' },
	'custom7' => { 289 => 'Custom7' },
	'custom8' => { 289 => 'Custom8' },
	'custom9' => { 289 => 'Custom9' },
	'customcolortone' => { 104 => 0x4c },
	'customcontrast' => { 104 => 0x4e },
	'customcontrols' => { 79 => 0x70c },
	'customdefaultunsharpfineness' => { 104 => 0xbe },
	'customdefaultunsharpstrength' => { 104 => 0xbc },
	'customdefaultunsharpthreshold' => { 104 => 0xc0 },
	'customilluminant' => { 132 => 0x405 },
	'customizedials' => { 79 => 0x715 },
	'customlinear' => { 104 => 0x4f },
	'customoutputhighlightpoint' => { 104 => 0x53 },
	'customoutputshadowpoint' => { 104 => 0x54 },
	'custompicturestyle' => { 98 => 0x10021 },
	'custompicturestyledata' => { 98 => 0xf0500 },
	'custompicturestylefilename' => { 61 => 0x4010 },
	'customrawhighlight' => { 104 => 0x7c },
	'customrawhighlightpoint' => { 104 => 0x51 },
	'customrawshadow' => { 104 => 0x85 },
	'customrawshadowpoint' => { 104 => 0x52 },
	'customrendered' => { 114 => 0xa401, 460 => 'CustomRendered' },
	'customsaturation' => { 104 => 0x4d, 279 => 0x503 },
	'customsettingsalldefault' => { 262 => '0.2', 271 => '0.2' },
	'customsettingsbank' => { 262 => '0.1', 263 => '0.1', 265 => '0.1', 266 => '0.1', 271 => '0.1', 275 => '0.2', 276 => '0.2' },
	'customsharpness' => { 104 => 0x50 },
	'customunsharpmaskfineness' => { 104 => 0xb8 },
	'customunsharpmaskstrength' => { 104 => 0xb6 },
	'customunsharpmaskthreshold' => { 104 => 0xba },
	'customwb_rblevels' => { 405 => 0x1a },
	'customwb_rgblevels' => { 388 => 0x8, 389 => 0x19 },
	'customwbbluelevel' => { 175 => 0x36 },
	'customwberror' => { 175 => 0x37 },
	'customwbgreenlevel' => { 175 => 0x35 },
	'customwbredlevel' => { 175 => 0x34 },
	'customwbsetting' => { 175 => 0x26 },
	'cx' => { 362 => '_cx_' },
	'cy' => { 362 => '_cy_' },
	'd-lightinghq' => { 255 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 251 => 0x2 },
	'd-lightinghqhighlight' => { 251 => 0x1 },
	'd-lightinghqselected' => { 255 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 251 => 0x0 },
	'd-lightinghs' => { 255 => 0xce5554aa },
	'd-lightinghsadjustment' => { 252 => 0x0 },
	'd-lightinghscolorboost' => { 252 => 0x1 },
	'd-rangeoptimizerhighlight' => { 433 => 0x8024 },
	'd-rangeoptimizermode' => { 433 => 0x8022 },
	'd-rangeoptimizershadow' => { 433 => 0x802d },
	'd-rangeoptimizervalue' => { 433 => 0x8023 },
	'd810meteringmode' => { 242 => 0x175e },
	'darkblacksegrows' => { 132 => 0x18d8 },
	'darkfocusenvironment' => { 302 => 0x8003 },
	'darkframecountfactor' => { 132 => 0xc85 },
	'darkframelongexposure' => { 132 => 0xc84 },
	'darkframeshortexposure' => { 132 => 0xc83 },
	'darkpedestal' => { 132 => 0xc7f },
	'datacompressionmethod' => { 128 => 0x6e },
	'dataimprint' => { 172 => 0x34 },
	'dataonscreen' => { 466 => 'DataOnScreen' },
	'dataonscreenregion' => { 466 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 466 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 466 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 466 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 466 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 466 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 466 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 466 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 337 => 0x3d },
	'date' => { 337 => 0x6, 457 => 'date' },
	'dateacquired' => { 170 => 'DateAcquired' },
	'datecreated' => { 126 => 0x37, 468 => 'DateCreated' },
	'datedisplayformat' => { 247 => 0x3 },
	'dateidentified' => { 113 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 267 => '4.2' },
	'daterecieved' => { 470 => 'dateRecieved' },
	'datesent' => { 127 => 0x46 },
	'datestampmode' => { 61 => 0x1c },
	'datetime' => { 450 => 'datetime', 476 => 'DateTime' },
	'datetimedigitized' => { 460 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 95 => 0x0, 114 => 0x9003, 146 => 0x14, 149 => 'OriginalDate', 357 => 'IDIT', 362 => 'date', 363 => 0xb, 364 => 0x3b, 365 => 0x3e, 460 => 'DateTimeOriginal' },
	'datetimestamp' => { 134 => 0x64 },
	'datetimeutc' => { 279 => 0x908 },
	'daylightsavings' => { 74 => 0x3, 247 => 0x2 },
	'dayofweek' => { 364 => 0x42, 365 => 0x4a },
	'dccontinent' => { 113 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 113 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 113 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 113 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 113 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 113 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 113 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 113 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 113 => 'Event' },
	'dcfootprintspatialfit' => { 113 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 113 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 113 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 113 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 113 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 113 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 113 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 113 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 113 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 113 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 113 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 113 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 113 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 113 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 113 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 113 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 113 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 113 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 113 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 113 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 113 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 113 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 113 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 113 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 113 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 113 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 113 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 113 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 113 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 113 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 113 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 113 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 113 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 113 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 113 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 113 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 113 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 157 => 'Declination' },
	'decposition' => { 172 => 0x32 },
	'defaultautogray' => { 456 => 'DefaultAutoGray' },
	'defaultautotone' => { 456 => 'DefaultAutoTone' },
	'defaultblackrender' => { 114 => 0xc7a6 },
	'defaultcroporigin' => { 114 => 0xc61f },
	'defaultcropsize' => { 114 => 0xc620 },
	'defaulteraseoption' => { 79 => 0x813 },
	'defaultscale' => { 114 => 0xc61e },
	'defaultsspecifictoiso' => { 456 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 456 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 114 => 0xc7b5 },
	'defectisocode' => { 132 => 0x90f },
	'defringe' => { 456 => 'Defringe' },
	'defringegreenamount' => { 456 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 456 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 456 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 456 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 456 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 456 => 'DefringePurpleHueLo' },
	'dehaze' => { 456 => 'Dehaze' },
	'deletedimagecount' => { 215 => 0xa6, 224 => 0x6e },
	'deprecatedon' => { 453 => 'deprecatedOn' },
	'depthimage' => { 440 => 'Data' },
	'derivedfrom' => { 481 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 481 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 481 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 481 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 481 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 481 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 481 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 481 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 481 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 481 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 481 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 481 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 481 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 481 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 481 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 481 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 481 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 481 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 481 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 481 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 481 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 481 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 481 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 481 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 292 => 'Description', 354 => ['desc','dscp',"\xa9des"], 356 => 'description', 362 => 'dscp', 457 => 'description', 478 => 'Description' },
	'destination' => { 127 => 0x5 },
	'destinationcity' => { 337 => 0x24, 343 => 0x3 },
	'destinationcitycode' => { 344 => 0x1001 },
	'destinationdst' => { 337 => 0x26, 343 => '0.3' },
	'developmentdynamicrange' => { 122 => 0x1403 },
	'deviantmatrixcustom' => { 132 => 0x7de },
	'deviantmatrixdaylight' => { 132 => 0x7da },
	'deviantmatrixflash' => { 132 => 0x7dd },
	'deviantmatrixfluorescent' => { 132 => 0x7dc },
	'deviantmatrixtungsten' => { 132 => 0x7db },
	'deviantwhitecustom' => { 132 => 0x842 },
	'deviantwhitedaylight' => { 132 => 0x83e },
	'deviantwhiteflash' => { 132 => 0x841 },
	'deviantwhitefluorescent' => { 132 => 0x840 },
	'deviantwhitetungsten' => { 132 => 0x83f },
	'device' => { 470 => 'device' },
	'devicesettingdescription' => { 460 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 460 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 460 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 460 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 376 => 0x2 },
	'dewarpdata' => { 111 => 'DewarpData' },
	'dewarpflag' => { 111 => 'DewarpFlag' },
	'dialdirectiontvav' => { 79 => 0x706 },
	'dietaryneeds' => { 472 => 'dietaryNeeds' },
	'diffractioncorrection' => { 302 => 0xbc, 327 => 0x3 },
	'diffractioncorrectionon' => { 98 => 0x2070b },
	'digitalcreationdate' => { 126 => 0x3e },
	'digitalcreationtime' => { 126 => 0x3f },
	'digitaldeehighlightadj' => { 223 => 0x202 },
	'digitaldeeshadowadj' => { 223 => 0x200 },
	'digitaldeethreshold' => { 223 => 0x201 },
	'digitalfilter' => { 379 => 0x59 },
	'digitalfilter01' => { 324 => 0x5 },
	'digitalfilter02' => { 324 => 0x16 },
	'digitalfilter03' => { 324 => 0x27 },
	'digitalfilter04' => { 324 => 0x38 },
	'digitalfilter05' => { 324 => 0x49 },
	'digitalfilter06' => { 324 => 0x5a },
	'digitalfilter07' => { 324 => 0x6b },
	'digitalfilter08' => { 324 => 0x7c },
	'digitalfilter09' => { 324 => 0x8d },
	'digitalfilter10' => { 324 => 0x9e },
	'digitalfilter11' => { 324 => 0xaf },
	'digitalfilter12' => { 324 => 0xc0 },
	'digitalfilter13' => { 324 => 0xd1 },
	'digitalfilter14' => { 324 => 0xe2 },
	'digitalfilter15' => { 324 => 0xf3 },
	'digitalfilter16' => { 324 => 0x104 },
	'digitalfilter17' => { 324 => 0x115 },
	'digitalfilter18' => { 324 => 0x126 },
	'digitalfilter19' => { 324 => 0x137 },
	'digitalfilter20' => { 324 => 0x148 },
	'digitalgain' => { 71 => 0xb },
	'digitalgem' => { 204 => 0x0 },
	'digitalice' => { 223 => 0x100 },
	'digitalimageguid' => { 466 => 'DigImageGUID' },
	'digitalroc' => { 221 => 0x0 },
	'digitalsourcefiletype' => { 466 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 466 => 'DigitalSourceType' },
	'digitalzoom' => { 34 => 0xc, 107 => 0xa, 122 => 0x1044, 134 => 0x68, 148 => 'DigitalZoom', 172 => 0xc, 215 => 0x86, 245 => 0xa, 284 => 0x204, 337 => 0x1e, 344 => 0xa, 378 => 0x204, 420 => 0x12, 421 => 0x12 },
	'digitalzoomon' => { 378 => 0x21b },
	'digitalzoomratio' => { 114 => 0xa404, 410 => 0x200, 412 => 0x21c, 460 => 'DigitalZoomRatio' },
	'director' => { 356 => 'director', 362 => "\xa9dir", 480 => 'director' },
	'directorphotography' => { 480 => 'directorPhotography' },
	'directory' => { 115 => 'Directory' },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba },
	'directoryindex2' => { 21 => 0x29c },
	'directorynumber' => { 198 => 0x3, 365 => 0x12 },
	'disclaimer' => { 292 => 'Disclaimer' },
	'discnumber' => { 480 => 'discNumber' },
	'dishtype' => { 472 => 'dishType' },
	'disknumber' => { 354 => 'disk' },
	'displayallafpoints' => { 79 => 0x514 },
	'displayaperture' => { 34 => 0x23 },
	'displayedunitsx' => { 352 => 0x2 },
	'displayedunitsy' => { 352 => 0x6 },
	'displayname' => { 356 => 'displayname', 469 => 'displayName' },
	'distance1' => { 134 => 0x28 },
	'distance2' => { 134 => 0x2c },
	'distance3' => { 134 => 0x30 },
	'distance4' => { 134 => 0x34 },
	'distortion' => { 376 => 0xa050 },
	'distortioncompensation' => { 433 => 0x8040 },
	'distortioncontrol' => { 224 => 0x10 },
	'distortioncorrection' => { 98 => 0x20705, 104 => 0x67, 114 => 0x7036, 279 => 0x50b, 306 => '7.1', 327 => 0x0, 428 => 0x601, 429 => 0x5b },
	'distortioncorrection2' => { 283 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 452 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 98 => '0x20705.0', 104 => 0x63 },
	'distortioncorrectionsetting' => { 400 => 0x2013 },
	'distortioncorrparams' => { 114 => 0x7037, 409 => 0x1a23, 412 => 0x1870, 414 => 0x189c, 415 => 0x18cc, 416 => 0x17d0, 428 => 0x6ca, 429 => 0x64 },
	'distortioncorrparamsnumber' => { 412 => 0x1899, 414 => 0x18c5, 415 => 0x18f5, 416 => 0x17f9 },
	'distortioncorrparamspresent' => { 412 => 0x1898, 414 => 0x18c4, 415 => 0x18f4, 416 => 0x17f8, 418 => 0x10b, 419 => 0x10b, 428 => 0x600, 429 => 0x5a },
	'distortioneffect' => { 98 => 0x20709 },
	'distortionn' => { 306 => 0xc },
	'distortionparam02' => { 306 => 0x2 },
	'distortionparam04' => { 306 => 0x4 },
	'distortionparam08' => { 306 => 0x8 },
	'distortionparam09' => { 306 => 0x9 },
	'distortionparam11' => { 306 => 0xb },
	'distortionscale' => { 306 => 0x5 },
	'distributor' => { 470 => 'distributor' },
	'distributorproductid' => { 469 => 'distributorProductID' },
	'dloon' => { 98 => '0x20706.0', 104 => 0xdc },
	'dlosetting' => { 98 => 0x20706, 104 => 0xdd },
	'dlosettingapplied' => { 97 => 0x4 },
	'dloshootingdistance' => { 104 => 0xde },
	'dloversion' => { 97 => 0x5 },
	'dmcomment' => { 480 => 'comment' },
	'dmdithermatrix' => { 132 => 0xc7a },
	'dmdithermatrixheight' => { 132 => 0xc7c },
	'dmdithermatrixwidth' => { 132 => 0xc7b },
	'dngadobedata' => { 114 => 0xc634 },
	'dngbackwardversion' => { 114 => 0xc613 },
	'dngignoresidecars' => { 456 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 114 => 0xc630 },
	'dngprivatedata' => { 114 => 0xc634 },
	'dngversion' => { 114 => 0xc612 },
	'document' => { 292 => 'Document' },
	'documentancestors' => { 468 => 'DocumentAncestors' },
	'documenthistory' => { 126 => 0xe7 },
	'documentid' => { 481 => 'DocumentID' },
	'documentname' => { 114 => 0x10d },
	'documentnotes' => { 126 => 0xe6 },
	'doi' => { 470 => 'doi' },
	'dopesheet' => { 466 => 'Dopesheet' },
	'dopesheetlink' => { 466 => 'DopesheetLink' },
	'dopesheetlinklink' => { 466 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 466 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 132 => 0xc82 },
	'dpp' => { 450 => 'dpp' },
	'dr4cameramodel' => { 99 => 0x3 },
	'drangepriority' => { 122 => 0x1443 },
	'drangepriorityauto' => { 122 => 0x1444 },
	'drangepriorityfixed' => { 122 => 0x1445 },
	'drivemode' => { 108 => 0x3103, 120 => '0.1', 172 => 0x6, 175 => 0x1e, 178 => 0xe, 279 => 0x600, 337 => 0x34, 369 => 0x1002, 379 => 0x3, 387 => 0x4, 388 => 0x7e, 389 => 0x34 },
	'drivemode2' => { 175 => 0xa, 318 => 0x7, 398 => 0xe, 405 => 0x1 },
	'drivemodesetting' => { 389 => 0x4 },
	'drivespeed' => { 120 => '0.2' },
	'dspfirmwareversion' => { 337 => 0x27 },
	'duration' => { 64 => 0x6a, 147 => 'Duration', 161 => 'Duration', 472 => 'duration', 480 => 'duration' },
	'durationscale' => { 480 => [\'duration','durationScale'] },
	'durationvalue' => { 480 => [\'duration','durationValue'] },
	'dustremovaldata' => { 61 => 0x97 },
	'dynamicafarea' => { 262 => '1.4', 271 => '1.4' },
	'dynamicareaafdisplay' => { 263 => '46.1', 265 => '47.1', 266 => '47.1', 275 => '47.1', 276 => '47.1' },
	'dynamicrange' => { 122 => 0x1400 },
	'dynamicrangeexpansion' => { 337 => 0x69, 369 => 0x100e },
	'dynamicrangemax' => { 103 => 0x7c },
	'dynamicrangemin' => { 103 => 0x7a },
	'dynamicrangeoptimizer' => { 175 => 0x15, 400 => [0xb025,0xb04f], 408 => 0x1144, 409 => [0x1144,0x324], 410 => [0x1120,0x300], 411 => [0x119c,0x37c], 412 => [0x1178,0x328], 413 => [0x1030,0x50], 414 => [0x228,0x50], 415 => [0x228,0x50], 416 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 398 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 387 => 0x19, 388 => 0x17, 389 => 0xd, 398 => 0x79, 405 => 0x5 },
	'dynamicrangeoptimizermode' => { 178 => 0x15, 387 => 0x18, 388 => 0x16, 398 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 175 => 0x27, 389 => 0xc, 405 => 0x4 },
	'dynamicrangesetting' => { 122 => 0x1402 },
	'e-dialinprogram' => { 318 => '1.3' },
	'earliestageorloweststage' => { 113 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 113 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 113 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 113 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 113 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 277 => '6.1' },
	'easyexposurecompensation' => { 262 => '6.4', 263 => '6.5', 265 => '6.3', 266 => '6.3', 270 => '5.1', 271 => '4.4', 272 => '5.2', 275 => '6.3', 276 => '6.3' },
	'easymode' => { 34 => 0xb },
	'edgemapslope' => { 132 => 0x930 },
	'edgemapx1' => { 132 => 0x931 },
	'edgemapx2' => { 132 => 0x932 },
	'edgemapx3' => { 132 => 0x934 },
	'edgemapx4' => { 132 => 0x935 },
	'edgenoisereduction' => { 256 => 0x4, 433 => 0x8028 },
	'edit1' => { 362 => "\xa9ed1" },
	'edit2' => { 362 => "\xa9ed2" },
	'edit3' => { 362 => "\xa9ed3" },
	'edit4' => { 362 => "\xa9ed4" },
	'edit5' => { 362 => "\xa9ed5" },
	'edit6' => { 362 => "\xa9ed6" },
	'edit7' => { 362 => "\xa9ed7" },
	'edit8' => { 362 => "\xa9ed8" },
	'edit9' => { 362 => "\xa9ed9" },
	'edition' => { 470 => 'edition' },
	'editorialupdate' => { 126 => 0x8 },
	'editstatus' => { 126 => 0x7, 349 => 'EditStatus', 450 => 'EditStatus' },
	'editversionname' => { 255 => 0x3d136244 },
	'effectivelv' => { 337 => 0x2d },
	'effectivemaxaperture' => { 208 => 0x12, 209 => 0x13, 213 => 0x14 },
	'eissn' => { 470 => 'eIssn' },
	'electricalblackcolumns' => { 132 => 0x1810 },
	'electronicfront-curtainshutter' => { 265 => '5.2', 266 => '5.2', 275 => '5.3', 276 => '5.2' },
	'electronicfrontcurtainshutter' => { 400 => 0x201a },
	'elevation' => { 157 => 'Elevation' },
	'email' => { 149 => 'EMail' },
	'embargodate' => { 473 => 'embargoDate' },
	'embdencrightsexpr' => { 466 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 466 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 466 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 466 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 468 => 'EmbeddedXMPDigest' },
	'emissivity' => { 116 => 0x3 },
	'enablechromanoisereduction' => { 132 => 0xe6e },
	'enablesharpening' => { 132 => 0x92e },
	'encodedby' => { 354 => "\xa9enc" },
	'encodedwith' => { 356 => 'Encoded_With' },
	'encoder' => { 354 => "\xa9too", 362 => "\xa9too" },
	'encoderid' => { 362 => "\xa9enc" },
	'encryptionkey' => { 376 => 0xa020 },
	'endingpage' => { 470 => 'endingPage' },
	'enduser' => { 289 => 'EndUser' },
	'enduserid' => { 289 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 289 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 480 => 'engineer' },
	'enhancedarktones' => { 248 => 0x8 },
	'enhancement' => { 107 => 0x16, 108 => 0x3016 },
	'enhancer' => { 283 => 0x300 },
	'enhancervalues' => { 283 => 0x301 },
	'envelopenumber' => { 127 => 0x28 },
	'envelopepriority' => { 127 => 0x3c },
	'enveloperecordversion' => { 127 => 0x0 },
	'episode' => { 466 => 'Episode' },
	'episodeglobaluniqueid' => { 354 => 'egid' },
	'episodeidentifier' => { 466 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 466 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 466 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 284 => 0x20c },
	'epsonimagewidth' => { 284 => 0x20b },
	'epsonsoftware' => { 284 => 0x20d },
	'equipmentinstitution' => { 435 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 435 => 'EquipmentManufacturer' },
	'equipmentversion' => { 280 => 0x0 },
	'ettlii' => { 79 => 0x304, 80 => 0xd, 81 => 0xe, 82 => 0x7, 83 => 0x7, 84 => 0xe },
	'event' => { 436 => 'Event', 448 => 'Event', 466 => 'Event', 470 => 'event' },
	'eventalias' => { 469 => 'eventAlias' },
	'eventdate' => { 113 => [\'Event','EventEventDate'] },
	'eventday' => { 113 => [\'Event','EventDay'] },
	'eventearliestdate' => { 113 => [\'Event','EventEarliestDate'] },
	'eventend' => { 469 => 'eventEnd' },
	'eventenddayofyear' => { 113 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 113 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 113 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 113 => [\'Event','EventHabitat'] },
	'eventid' => { 113 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 113 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 113 => [\'Event','EventMonth'] },
	'eventnumber' => { 363 => 0x9, 364 => 0x37, 365 => 0x3a },
	'eventparenteventid' => { 113 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 113 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 113 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 113 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 113 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 113 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 469 => 'eventStart' },
	'eventstartdayofyear' => { 113 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 469 => 'eventSubtype' },
	'eventtime' => { 113 => [\'Event','EventEventTime'] },
	'eventtype' => { 469 => 'eventType' },
	'eventverbatimeventdate' => { 113 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 113 => [\'Event','EventYear'] },
	'evsteps' => { 318 => '1.2', 320 => 0x0 },
	'evstepsize' => { 267 => '5.1', 268 => '6.1', 269 => '6.1', 273 => '0.7' },
	'exclusivecoverage' => { 445 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 473 => 'exclusivityEndDate' },
	'excursiontolerance' => { 128 => 0x82 },
	'exif' => { 115 => 'EXIF' },
	'exifbyteorder' => { 115 => 'ExifByteOrder' },
	'exifcamerainfo' => { 126 => 0xe8 },
	'exifimageheight' => { 114 => 0xa003, 460 => 'PixelYDimension' },
	'exifimagewidth' => { 114 => 0xa002, 460 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 115 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 114 => 0x9000, 460 => 'ExifVersion' },
	'exitpupilposition' => { 208 => 0x4, 209 => 0x4, 213 => 0x4 },
	'expirationdate' => { 126 => 0x25, 473 => 'expirationDate' },
	'expirationtime' => { 126 => 0x26 },
	'exposure' => { 114 => 0xfe51, 456 => 'Exposure' },
	'exposure2012' => { 456 => 'Exposure2012' },
	'exposureadj' => { 253 => 0x0 },
	'exposureadj2' => { 253 => 0x12 },
	'exposureadjust' => { 379 => 0xc },
	'exposurebracketingindicatorlast' => { 175 => 0x52 },
	'exposurebracketshotnumber' => { 178 => 0x2d, 398 => 0x2f },
	'exposurebracketstepsize' => { 318 => 0x8 },
	'exposurebracketvalue' => { 215 => 0x19 },
	'exposurecompautocancel' => { 79 => 0x113 },
	'exposurecompensation' => { 73 => 0x6, 88 => 0x0, 114 => 0x9204, 134 => 0x24, 148 => 'ExposureComp', 168 => 'ExposureCompensation', 172 => 0xd, 173 => 0x53, 174 => 0x1e, 178 => 0x49c0, 284 => 0x1006, 337 => 0x16, 346 => 0x402, 376 => 0xa013, 379 => [0xc,0x35,0x4d], 408 => 0x114c, 409 => 0x114c, 410 => 0x1128, 412 => 0x1180, 413 => 0x1038, 414 => 0x230, 415 => 0x230, 416 => 0x223, 460 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 405 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 175 => 0x47, 178 => 0x2a },
	'exposurecompensationset' => { 387 => 0x3, 388 => 0x3, 389 => 0x3, 405 => 0x1e },
	'exposurecompensationsetting' => { 175 => 0x1 },
	'exposurecompstepsize' => { 262 => '6.3', 263 => '7.3', 265 => '7.3', 266 => '7.3', 271 => '4.3', 275 => '7.3', 276 => '7.3' },
	'exposurecontrolstep' => { 270 => '6.1', 272 => '6.1' },
	'exposurecontrolstepsize' => { 262 => '6.2', 263 => '7.1', 265 => '7.1', 266 => '7.1', 271 => '4.2', 275 => '7.1', 276 => '7.1', 277 => '7.1' },
	'exposurecount' => { 122 => 0x1032 },
	'exposuredelaymode' => { 262 => '10.1', 263 => '11.1', 265 => '11.1', 266 => '11.1', 267 => '9.1', 268 => '10.1', 269 => '10.1', 271 => '10.4', 272 => '10.1', 273 => '6.4', 275 => '11.1', 276 => '11.1', 277 => '11.2' },
	'exposuredifference' => { 215 => 0xe },
	'exposuregaincustom' => { 132 => 0x89c },
	'exposuregaindaylight' => { 132 => 0x898 },
	'exposuregainflash' => { 132 => 0x89b },
	'exposuregainfluorescent' => { 132 => 0x89a },
	'exposuregaintungsten' => { 132 => 0x899 },
	'exposureindex' => { 114 => 0xa215, 460 => 'ExposureIndex' },
	'exposureindicator' => { 175 => 0x50 },
	'exposurelevelincrements' => { 77 => 0x6, 78 => 0x6, 79 => 0x101, 80 => 0x5, 81 => 0x6, 82 => 0x5, 83 => 0x5, 84 => 0x6, 85 => 0x4, 387 => 0x58, 388 => 0x58 },
	'exposurelockused' => { 443 => 'ExposureLockUsed' },
	'exposuremode' => { 114 => 0xa402, 148 => 'ExposureMode', 172 => 0x1, 173 => 0xa, 174 => 0x0, 175 => 0x0, 178 => 0x34, 279 => 0x200, 299 => 0x40d, 379 => 0x8, 400 => 0xb041, 460 => 'ExposureMode' },
	'exposuremodeinmanual' => { 79 => 0x10b },
	'exposureprogram' => { 114 => 0x8822, 369 => 0x1001, 380 => [0x17e,0x43], 387 => 0x3c, 388 => 0x3c, 389 => 0x5, 393 => 0x14, 398 => 0x3f, 405 => 0x2, 408 => 0x1175, 409 => 0x1179, 410 => 0x1155, 411 => 0x11d1, 412 => 0x11ad, 413 => 0x1065, 414 => 0x25d, 415 => 0x25d, 416 => 0x24c, 425 => 0xb, 426 => 0xc, 427 => 0xb, 429 => 0x48, 460 => 'ExposureProgram' },
	'exposureshift' => { 279 => 0x203 },
	'exposurestandardadjustment' => { 400 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 30 => 0x6, 31 => 0x7, 73 => 0x16, 114 => 0x829a, 131 => 0xfd05, 134 => 0x20, 136 => 0xfa24, 138 => 0xf104, 141 => 0x12, 143 => 0x38, 146 => 0x10, 148 => 'ExposureTime', 172 => 0x9, 173 => 0x35, 174 => 0x48, 175 => 0x8, 178 => 0x49b8, 337 => 0x12, 376 => 0xa018, 379 => [0x32,0x4a], 387 => 0x0, 388 => 0x0, 405 => [0x21,0x23,0x27], 429 => 0x10, 460 => 'ExposureTime' },
	'exposuretime2' => { 379 => [0x33,0x4b] },
	'exposuretuning' => { 215 => 0x1c },
	'exposurevalue' => { 132 => 0x3 },
	'exposurewarning' => { 122 => 0x1302 },
	'exrauto' => { 122 => 0x1033 },
	'exrmode' => { 122 => 0x1034 },
	'extendedwbdetect' => { 279 => 0x902 },
	'extender' => { 280 => 0x301 },
	'extenderfirmwareversion' => { 280 => 0x304 },
	'extendermagnification' => { 150 => 'Magnification' },
	'extendermake' => { 150 => 'Make' },
	'extendermodel' => { 150 => 'Model', 280 => 0x303 },
	'extenderserialnumber' => { 150 => 'SerialNumber', 280 => 0x302 },
	'extenderstatus' => { 335 => 0x3 },
	'externalflash' => { 282 => 0x1201 },
	'externalflashae1' => { 284 => 0x101f },
	'externalflashae1_0' => { 284 => 0x101b },
	'externalflashae2' => { 284 => 0x1020 },
	'externalflashae2_0' => { 284 => 0x101c },
	'externalflashbounce' => { 282 => 0x1204, 284 => 0x1026, 325 => 0x1a },
	'externalflashcompensation' => { 201 => 0x1b },
	'externalflashexposurecomp' => { 215 => 0x17, 325 => 0x19 },
	'externalflashfirmware' => { 199 => 0x6, 200 => 0x6, 201 => 0x6, 202 => 0x6, 203 => 0x6 },
	'externalflashflags' => { 199 => 0x8, 200 => 0x8, 201 => 0x8, 202 => 0x8 },
	'externalflashguidenumber' => { 282 => 0x1203, 325 => '24.1' },
	'externalflashgvalue' => { 284 => 0x1025 },
	'externalflashmode' => { 284 => 0x1028, 325 => 0x2 },
	'externalflashreadystate' => { 203 => '9.1' },
	'externalflashstatus' => { 203 => '8.2' },
	'externalflashzoom' => { 282 => 0x1205, 284 => 0x1027 },
	'externalflashzoomoverride' => { 203 => '8.1' },
	'externalmetadatalink' => { 466 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 297 => 0x311, 300 => 0x311, 301 => 0x311, 304 => 0x3408 },
	'extrainfoversion' => { 391 => 0x1a },
	'eyestartaf' => { 175 => 0x40 },
	'fac100per' => { 132 => 0xe94 },
	'fac170per' => { 132 => 0xe93 },
	'fac18per' => { 132 => 0xe92 },
	'face10position' => { 105 => 0x3f4, 106 => 0x1ec, 197 => 0x28, 322 => 0x12 },
	'face10size' => { 323 => 0x12 },
	'face11position' => { 197 => 0x2c, 322 => 0x14 },
	'face11size' => { 323 => 0x14 },
	'face12position' => { 197 => 0x30, 322 => 0x16 },
	'face12size' => { 323 => 0x16 },
	'face13position' => { 322 => 0x18 },
	'face13size' => { 323 => 0x18 },
	'face14position' => { 322 => 0x1a },
	'face14size' => { 323 => 0x1a },
	'face15position' => { 322 => 0x1c },
	'face15size' => { 323 => 0x1c },
	'face16position' => { 322 => 0x1e },
	'face16size' => { 323 => 0x1e },
	'face17position' => { 322 => 0x20 },
	'face17size' => { 323 => 0x20 },
	'face18position' => { 322 => 0x22 },
	'face18size' => { 323 => 0x22 },
	'face19position' => { 322 => 0x24 },
	'face19size' => { 323 => 0x24 },
	'face1position' => { 52 => 0x8, 105 => 0xd, 106 => 0x18, 197 => 0x4, 294 => 0x1, 322 => 0x0, 366 => 0xbc, 394 => 0x1, 395 => 0x0, 396 => 0x0, 397 => 0x5b },
	'face1size' => { 323 => 0x0 },
	'face20position' => { 322 => 0x26 },
	'face20size' => { 323 => 0x26 },
	'face21position' => { 322 => 0x28 },
	'face21size' => { 323 => 0x28 },
	'face22position' => { 322 => 0x2a },
	'face22size' => { 323 => 0x2a },
	'face23position' => { 322 => 0x2c },
	'face23size' => { 323 => 0x2c },
	'face24position' => { 322 => 0x2e },
	'face24size' => { 323 => 0x2e },
	'face25position' => { 322 => 0x30 },
	'face25size' => { 323 => 0x30 },
	'face26position' => { 322 => 0x32 },
	'face26size' => { 323 => 0x32 },
	'face27position' => { 322 => 0x34 },
	'face27size' => { 323 => 0x34 },
	'face28position' => { 322 => 0x36 },
	'face28size' => { 323 => 0x36 },
	'face29position' => { 322 => 0x38 },
	'face29size' => { 323 => 0x38 },
	'face2position' => { 52 => 0xa, 105 => 0x7c, 106 => 0x4c, 197 => 0x8, 294 => 0x5, 322 => 0x2, 366 => 0xc8, 394 => 0x6, 395 => 0x20, 396 => 0x25, 397 => 0x65 },
	'face2size' => { 323 => 0x2 },
	'face30position' => { 322 => 0x3a },
	'face30size' => { 323 => 0x3a },
	'face31position' => { 322 => 0x3c },
	'face31size' => { 323 => 0x3c },
	'face32position' => { 322 => 0x3e },
	'face32size' => { 323 => 0x3e },
	'face3position' => { 52 => 0xc, 105 => 0xeb, 106 => 0x80, 197 => 0xc, 294 => 0x9, 322 => 0x4, 366 => 0xd4, 394 => 0xb, 395 => 0x40, 396 => 0x4a, 397 => 0x6f },
	'face3size' => { 323 => 0x4 },
	'face4position' => { 52 => 0xe, 105 => 0x15a, 106 => 0xb4, 197 => 0x10, 294 => 0xd, 322 => 0x6, 366 => 0xe0, 394 => 0x10, 395 => 0x60, 396 => 0x6f, 397 => 0x79 },
	'face4size' => { 323 => 0x6 },
	'face5position' => { 52 => 0x10, 105 => 0x1c9, 106 => 0xe8, 197 => 0x14, 294 => 0x11, 322 => 0x8, 366 => 0xec, 394 => 0x15, 395 => 0x80, 396 => 0x94 },
	'face5size' => { 323 => 0x8 },
	'face6position' => { 52 => 0x12, 105 => 0x238, 106 => 0x11c, 197 => 0x18, 322 => 0xa, 366 => 0xf8, 394 => 0x1a, 395 => 0xa0, 396 => 0xb9 },
	'face6size' => { 323 => 0xa },
	'face7position' => { 52 => 0x14, 105 => 0x2a7, 106 => 0x150, 197 => 0x1c, 322 => 0xc, 366 => 0x104, 394 => 0x1f, 395 => 0xc0, 396 => 0xde },
	'face7size' => { 323 => 0xc },
	'face8position' => { 52 => 0x16, 105 => 0x316, 106 => 0x184, 197 => 0x20, 322 => 0xe, 366 => 0x110, 394 => 0x24, 395 => 0xe0, 396 => 0x103 },
	'face8size' => { 323 => 0xe },
	'face9position' => { 52 => 0x18, 105 => 0x385, 106 => 0x1b8, 197 => 0x24, 322 => 0x10 },
	'face9size' => { 323 => 0x10 },
	'facebalanceorigi' => { 449 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 449 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 449 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 449 => 'FaceBalanceWarmth' },
	'facedetect' => { 337 => 0x76, 376 => 0x100 },
	'facedetectarea' => { 283 => 0x1201 },
	'facedetectframecrop' => { 283 => 0x1207 },
	'facedetectframesize' => { 52 => 0x3, 105 => 0x1, 106 => 0x4, 197 => 0x1, 283 => 0x1203, 337 => 0x77, 366 => 0xb6 },
	'facedetection' => { 389 => 0x30, 405 => 0x19 },
	'faceelementpositions' => { 122 => 0x4203 },
	'faceelementselected' => { 122 => 0x4005 },
	'faceelementtypes' => { 122 => 0x4201 },
	'faceid' => { 451 => 'FaceID' },
	'faceinfounknown' => { 108 => 0x2089 },
	'facename' => { 376 => 0x123 },
	'faceorientation' => { 106 => 0x8 },
	'faceposition' => { 321 => 0x2, 377 => 0x4 },
	'facepositions' => { 122 => 0x4103 },
	'facerecognition' => { 376 => 0x120 },
	'facesdetected' => { 52 => 0x2, 53 => 0x2, 54 => 0x3, 105 => 0x0, 106 => 0x2, 108 => 0x211c, 122 => 0x4100, 197 => 0x3, 283 => 0x1200, 302 => 0x3f, 321 => 0x0, 366 => 0xb5, 377 => 0x0, 394 => 0x0, 397 => 0x3, 407 => 0x30 },
	'facesrecognized' => { 295 => 0x0 },
	'facewidth' => { 53 => 0x1 },
	'faithfuloutputhighlightpoint' => { 104 => 0x38 },
	'faithfuloutputshadowpoint' => { 104 => 0x39 },
	'faithfulrawcolortone' => { 104 => 0x31 },
	'faithfulrawcontrast' => { 104 => 0x33 },
	'faithfulrawhighlight' => { 104 => 0x79 },
	'faithfulrawhighlightpoint' => { 104 => 0x36 },
	'faithfulrawlinear' => { 104 => 0x34 },
	'faithfulrawsaturation' => { 104 => 0x32 },
	'faithfulrawshadow' => { 104 => 0x82 },
	'faithfulrawshadowpoint' => { 104 => 0x37 },
	'faithfulrawsharpness' => { 104 => 0x35 },
	'faithfulunsharpmaskfineness' => { 104 => 0xac },
	'faithfulunsharpmaskstrength' => { 104 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 104 => 0xae },
	'far' => { 440 => 'Far' },
	'fastresetlinetime' => { 132 => 0x1860 },
	'feedidentifier' => { 466 => 'FeedIdentifier' },
	'femicroadjustment' => { 79 => 0x111 },
	'ffid' => { 458 => 'ffid' },
	'field' => { 469 => 'field' },
	'fieldcount' => { 284 => 0x103f },
	'fieldofview' => { 362 => "FOV\x00" },
	'fifoenonepixeldelay' => { 132 => 0x1901 },
	'filecreatedate' => { 115 => 'FileCreateDate' },
	'filedatarate' => { 480 => 'fileDataRate' },
	'fileformat' => { 90 => 0x0, 127 => 0x14, 379 => [0x22,0x26], 400 => 0xb000 },
	'filegroupid' => { 115 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 303 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 115 => 'FileModifyDate' },
	'filename' => { 115 => 'FileName' },
	'filenameasdelivered' => { 289 => 'FileNameAsDelivered' },
	'filenumber' => { 55 => 0x1, 61 => 0x8, 92 => 0x1817, 109 => 'FileNumber', 198 => 0x4, 365 => 0x10 },
	'filenumbermemory' => { 172 => 0x1a },
	'filenumbersequence' => { 262 => '12.2', 267 => '3.1', 268 => '4.1', 269 => '4.1', 271 => '11.1', 272 => '4.3', 277 => '5.2' },
	'filepermissions' => { 115 => 'FilePermissions' },
	'filesource' => { 114 => 0xa300, 122 => 0x8000, 460 => 'FileSource' },
	'fileuserid' => { 115 => 'FileUserID' },
	'fileversion' => { 127 => 0x16 },
	'fillflashautoreduction' => { 77 => 0xe, 78 => 0xe, 85 => 0xa },
	'filllight' => { 456 => 'FillLight' },
	'fillorder' => { 114 => 0x10a },
	'filmgraineffect' => { 279 => 0x538 },
	'filmmode' => { 122 => 0x1401, 299 => 0x412, 302 => 0x42 },
	'filmtype' => { 223 => 0x2 },
	'filtereffect' => { 55 => 0xe, 217 => 0x37, 218 => 0x3f, 219 => 0x47 },
	'filtereffectauto' => { 68 => 0xa0 },
	'filtereffectfaithful' => { 67 => 0x70, 68 => 0x70 },
	'filtereffectlandscape' => { 67 => 0x40, 68 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 67 => 0x88, 68 => 0x88 },
	'filtereffectneutral' => { 67 => 0x58, 68 => 0x58 },
	'filtereffectportrait' => { 67 => 0x28, 68 => 0x28 },
	'filtereffectstandard' => { 67 => 0x10, 68 => 0x10 },
	'filtereffectuserdef1' => { 67 => 0xa0, 68 => 0xb8 },
	'filtereffectuserdef2' => { 67 => 0xb8, 68 => 0xd0 },
	'filtereffectuserdef3' => { 67 => 0xd0, 68 => 0xe8 },
	'finderdisplayduringexposure' => { 78 => 0x1 },
	'finesharpness' => { 337 => 0x70 },
	'finetuneoptcenterweighted' => { 262 => '7.2', 263 => '9.1', 265 => '9.1', 266 => '9.1', 270 => '8.1', 275 => '9.1', 276 => '9.1', 277 => '9.1' },
	'finetuneopthighlightweighted' => { 265 => '46.1', 266 => '46.1', 275 => '46.1', 276 => '46.1' },
	'finetuneoptmatrixmetering' => { 262 => '8.1', 263 => '8.2', 265 => '8.2', 266 => '8.2', 270 => '7.2', 271 => '6.1', 275 => '8.2', 276 => '8.2', 277 => '8.2' },
	'finetuneoptspotmetering' => { 262 => '8.2', 263 => '9.2', 265 => '9.2', 266 => '9.2', 270 => '8.2', 271 => '6.2', 275 => '9.2', 276 => '9.2', 277 => '9.2' },
	'finishexposure' => { 132 => 0xdbd },
	'finishfiletype' => { 132 => 0xdb8 },
	'finishlook' => { 132 => 0xdbc },
	'finishnoise' => { 132 => 0xdba },
	'finishresolution' => { 132 => 0xdb9 },
	'finishsharpening' => { 132 => 0xdbb },
	'firmware' => { 284 => 0x405, 379 => [0x17,0x3b,0x57], 452 => 'Firmware' },
	'firmwaredate' => { 107 => 0x15, 108 => 0x2001, 363 => 0x4, 365 => 0x30 },
	'firmwareid' => { 179 => 0x0 },
	'firmwarename' => { 376 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 61 => 0x1e, 367 => 0x0 },
	'firmwarerevision2' => { 367 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 132 => [0x415,0xce5], 146 => 0x57, 148 => 'FirmwareVersion', 300 => 0x320, 302 => 0x2, 304 => 0x3109, 337 => 0x230, 362 => ['CNFV','FIRM'], 364 => 0x18, 365 => 0x2a, 369 => 0x2 },
	'firmwareversions' => { 346 => 0x301 },
	'firstphotodate' => { 443 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 289 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 126 => 0x16, 450 => 'FixtureIdentifier' },
	'flash' => { 109 => 'Flash', 114 => 0x9209, 173 => 0x1f, 174 => 0x15, 365 => 0x5a, 460 => 'Flash' },
	'flashaction' => { 387 => 0x3e, 388 => 0x3e, 400 => 0x2017, 405 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 387 => 0x4c, 388 => 0x4c, 405 => 0x77 },
	'flashactionexternal' => { 405 => [0x78,0x7c] },
	'flashactivity' => { 34 => 0x1c },
	'flashbatterylevel' => { 42 => 0x249 },
	'flashbias' => { 302 => 0x24 },
	'flashbits' => { 34 => 0x1d },
	'flashbuttonfunction' => { 79 => 0x70e },
	'flashchargelevel' => { 284 => 0x1010 },
	'flashcolorfilter' => { 201 => 0x10, 202 => 0x10 },
	'flashcommandermode' => { 199 => '9.1', 200 => '9.1', 201 => '9.1', 202 => '9.1' },
	'flashcompensation' => { 132 => 0x3f3, 199 => 0xa, 200 => 0xa, 201 => 0xa, 202 => 0x27, 203 => 0xa, 452 => 'FlashCompensation' },
	'flashcontrol' => { 387 => 0x23, 388 => 0x1f, 389 => 0x21 },
	'flashcontrolbuilt-in' => { 271 => '16.1', 272 => '23.1', 274 => '23.1', 275 => '24.1' },
	'flashcontrolmode' => { 199 => '9.2', 200 => '9.2', 201 => '9.2', 202 => '9.2', 279 => 0x404 },
	'flashcurtain' => { 302 => 0x48 },
	'flashdefault' => { 175 => 0x42 },
	'flashdevice' => { 284 => 0x1005 },
	'flashdistance' => { 108 => 0x2034 },
	'flashenergy' => { 114 => 0xa20b, 460 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 215 => 0x18 },
	'flashexposurecomp' => { 73 => 0xf, 122 => 0x1011, 151 => 'ExposureComp', 172 => 0x23, 177 => 0x104, 178 => 0x49c1, 215 => 0x12, 279 => 0x401, 284 => 0x1023, 337 => 0x4d, 369 => 0x100b, 379 => [0x3a,0x56], 400 => 0x104 },
	'flashexposurecomp2' => { 241 => 0x4d2 },
	'flashexposurecomp3' => { 201 => 0x1d },
	'flashexposurecomp4' => { 201 => 0x27 },
	'flashexposurecomparea' => { 263 => '38.4', 265 => '38.4', 266 => '38.4', 275 => '38.4', 276 => '38.4' },
	'flashexposurecompset' => { 175 => 0x10, 310 => 0xe, 387 => 0x14, 388 => 0x12, 389 => 0x23, 405 => 0x1f },
	'flashexposurecompset2' => { 405 => [0x26,0x2c] },
	'flashexposureindicator' => { 175 => 0x54 },
	'flashexposureindicatorlast' => { 175 => 0x56 },
	'flashexposureindicatornext' => { 175 => 0x55 },
	'flashexposurelock' => { 55 => 0x19 },
	'flashfired' => { 134 => 0x5d, 151 => 'Fired', 172 => 0x14, 240 => '590.3', 460 => [\'Flash','FlashFired'] },
	'flashfiring' => { 79 => 0x306, 80 => 0x6, 81 => 0x7, 84 => 0x7 },
	'flashfirmwareversion' => { 280 => 0x1002 },
	'flashfocallength' => { 199 => 0xb, 200 => 0xc, 201 => 0xc, 202 => 0xc, 203 => 0xc },
	'flashfunction' => { 178 => 0x31, 460 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 199 => 0xe, 200 => 0xf, 201 => 0xf, 202 => 0xf, 203 => 0xf },
	'flashgroupacompensation' => { 199 => 0x11, 200 => 0x12, 201 => 0x13, 202 => 0x28, 203 => 0x28 },
	'flashgroupacontrolmode' => { 199 => 0xf, 200 => '16.1', 201 => '17.1', 202 => '17.1', 203 => '17.1' },
	'flashgroupaoutput' => { 199 => 0x11, 200 => 0x12, 201 => 0x13, 202 => 0x28, 203 => 0x28 },
	'flashgroupbcompensation' => { 199 => 0x12, 200 => 0x13, 201 => 0x14, 202 => 0x29, 203 => 0x29 },
	'flashgroupbcontrolmode' => { 199 => 0x10, 200 => '17.1', 201 => '18.1', 202 => '18.1', 203 => '18.1' },
	'flashgroupboutput' => { 199 => 0x12, 200 => 0x13, 201 => 0x14, 202 => 0x29, 203 => 0x29 },
	'flashgroupccompensation' => { 200 => 0x14, 201 => 0x15, 202 => 0x2a, 203 => 0x2a },
	'flashgroupccontrolmode' => { 200 => '17.2', 201 => '18.2', 202 => '18.2', 203 => '18.2' },
	'flashgroupcoutput' => { 200 => 0x14, 201 => 0x15, 202 => 0x2a, 203 => 0x2a },
	'flashguidenumber' => { 73 => 0xd, 89 => 0x0, 151 => 'GuideNumber' },
	'flashintensity' => { 107 => [0x19,0x5], 279 => 0x405 },
	'flashlevel' => { 264 => 0x9, 400 => 0xb048 },
	'flashmake' => { 151 => 'Make' },
	'flashmanufacturer' => { 170 => 'FlashManufacturer' },
	'flashmetering' => { 172 => 0x3f, 175 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 337 => 0x20a },
	'flashmode' => { 107 => 0x4, 132 => 0x3f2, 134 => 0x5c, 151 => 'Mode', 172 => 0x2, 173 => 0x20, 174 => 0x16, 175 => 0xf, 215 => 0x87, 279 => 0x400, 284 => 0x1004, 337 => 0xc, 344 => 0x4, 368 => 0x20, 369 => 0x100a, 378 => 0x225, 387 => 0x13, 388 => 0x7f, 389 => 0x20, 405 => 0x10, 408 => 0x1138, 409 => 0x1138, 410 => 0x1114, 411 => 0x1190, 412 => 0x116c, 413 => 0x1024, 414 => 0x21c, 415 => 0x21c, 416 => 0x211, 460 => [\'Flash','FlashMode'] },
	'flashmodel' => { 151 => 'Model', 170 => 'FlashModel', 280 => 0x1001 },
	'flashoptions' => { 318 => 0x2 },
	'flashoptions2' => { 318 => 0x10 },
	'flashoutput' => { 42 => 0x248, 73 => 0x21, 199 => 0xa, 200 => 0xa, 201 => 0xa, 202 => 0x27 },
	'flashpixversion' => { 114 => 0xa000, 460 => 'FlashpixVersion' },
	'flashredeyemode' => { 460 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 279 => 0x403 },
	'flashreturn' => { 460 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 151 => 'SerialNumber', 280 => 0x1003 },
	'flashsetting' => { 215 => 0x8 },
	'flashshutterspeed' => { 262 => '20.2', 263 => '23.2', 265 => '23.2', 266 => '23.2', 271 => '15.2', 272 => '22.2', 273 => '7.2', 274 => '22.2', 275 => '23.2', 276 => '23.2', 277 => '23.1' },
	'flashsource' => { 199 => 0x4, 200 => 0x4, 201 => 0x4, 202 => 0x4, 203 => 0x4 },
	'flashstatus' => { 325 => 0x0, 405 => [0x82,0x86], 418 => 0x31, 419 => 0x39 },
	'flashstatusbuilt-in' => { 389 => [0x87,0x287] },
	'flashstatusexternal' => { 389 => [0x88,0x288] },
	'flashsyncspeed' => { 262 => '20.1', 263 => '23.1', 265 => '23.1', 266 => '23.1', 271 => '15.1', 272 => '22.1', 274 => '22.1', 275 => '23.1', 276 => '23.1' },
	'flashsyncspeedav' => { 77 => 0x3, 79 => 0x10f, 80 => 0x2, 81 => 0x3, 82 => 0x2, 83 => 0x2, 84 => 0x3, 85 => 0x6 },
	'flashthreshold' => { 89 => 0x1 },
	'flashtype' => { 151 => 'Type', 175 => 0x59, 215 => 0x9, 280 => 0x1000 },
	'flashwarning' => { 272 => '30.1', 273 => '7.1', 277 => '31.1', 302 => 0x62 },
	'flexiblespotposition' => { 400 => 0x201d },
	'flickerreduce' => { 378 => 0x218 },
	'flickerreduction' => { 122 => 0x1446, 234 => 0xe84 },
	'flickerreductionindicator' => { 234 => 0x5e2 },
	'flightpitchdegree' => { 111 => 'FlightPitchDegree' },
	'flightrolldegree' => { 111 => 'FlightRollDegree' },
	'flightxspeed' => { 111 => 'FlightXSpeed' },
	'flightyawdegree' => { 111 => 'FlightYawDegree' },
	'flightyspeed' => { 111 => 'FlightYSpeed' },
	'flightzspeed' => { 111 => 'FlightZSpeed' },
	'fliphorizontal' => { 255 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 30 => 0x5, 31 => 0x6, 73 => 0x15, 114 => 0x829d, 131 => 0xfd04, 134 => 0x1e, 136 => 0xfa23, 138 => 0xf103, 141 => 0x13, 143 => 0x3c, 146 => 0xc, 155 => 'FNumber', 172 => 0xa, 173 => 0x36, 174 => 0x47, 175 => 0x9, 178 => 0x49c7, 213 => 0x38, 337 => 0x13, 376 => 0xa019, 379 => [0x31,0x49], 387 => 0x1, 388 => 0x1, 405 => [0x20,0x22,0x26], 460 => 'FNumber' },
	'focaldistance' => { 441 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 57 => 0x1, 108 => 0x1d, 114 => 0x920a, 141 => 0x1d, 155 => 'FocalLength', 172 => 0x12, 208 => 0xa, 209 => 0xb, 213 => [0xc,0x3c], 296 => 0x1, 337 => 0x1d, 346 => 0x403, 369 => 0x1500, 386 => 0xe, 412 => 0x1278, 413 => 0x1134, 414 => 0x32c, 415 => 0x32c, 416 => 0x30a, 460 => 'FocalLength' },
	'focallength2' => { 405 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 114 => 0xa405, 376 => 0xa01a, 460 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 386 => 0x10 },
	'focalplaneafpointarea' => { 417 => 0x2 },
	'focalplaneafpointlocation1' => { 417 => 0x6 },
	'focalplaneafpointlocation10' => { 417 => 0x2a },
	'focalplaneafpointlocation11' => { 417 => 0x2e },
	'focalplaneafpointlocation12' => { 417 => 0x32 },
	'focalplaneafpointlocation13' => { 417 => 0x36 },
	'focalplaneafpointlocation14' => { 417 => 0x3a },
	'focalplaneafpointlocation15' => { 417 => 0x3e },
	'focalplaneafpointlocation2' => { 417 => 0xa },
	'focalplaneafpointlocation3' => { 417 => 0xe },
	'focalplaneafpointlocation4' => { 417 => 0x12 },
	'focalplaneafpointlocation5' => { 417 => 0x16 },
	'focalplaneafpointlocation6' => { 417 => 0x1a },
	'focalplaneafpointlocation7' => { 417 => 0x1e },
	'focalplaneafpointlocation8' => { 417 => 0x22 },
	'focalplaneafpointlocation9' => { 417 => 0x26 },
	'focalplaneafpointsused' => { 417 => 0x1 },
	'focalplanediagonal' => { 280 => 0x103, 284 => 0x205 },
	'focalplaneresolutionunit' => { 114 => 0xa210, 460 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 114 => 0xa20e, 460 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 57 => 0x2 },
	'focalplanexunknown' => { 57 => 0x2 },
	'focalplaneyresolution' => { 114 => 0xa20f, 460 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 57 => 0x3 },
	'focalplaneyunknown' => { 57 => 0x3 },
	'focalpointx' => { 441 => 'FocalPointX' },
	'focalpointy' => { 441 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 57 => 0x0 },
	'focalunits' => { 34 => 0x19 },
	'focus' => { 245 => 0x8 },
	'focusarea' => { 172 => 0x31 },
	'focusareaselection' => { 273 => '15.2' },
	'focuscontinuous' => { 34 => 0x20 },
	'focusdisplayaiservoandmf' => { 79 => 0x515 },
	'focusdistance' => { 155 => 'FocusDistance', 172 => 0x13, 178 => 0x49bb, 208 => 0x9, 209 => 0xa, 213 => 0xb, 282 => 0x305, 296 => 0x0, 300 => 0x304, 301 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 55 => 0x15, 73 => 0x14 },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 55 => 0x14, 73 => 0x13 },
	'focusholdbutton' => { 175 => 0x44 },
	'focusinfoversion' => { 282 => 0x0 },
	'focusingscreen' => { 78 => 0x0, 79 => 0x80b, 84 => 0x0 },
	'focuslocation' => { 400 => 0x2027 },
	'focuslocked' => { 171 => 0x14 },
	'focusmode' => { 34 => 0x7, 107 => 0x3, 108 => [0x3003,0xd], 122 => 0x1021, 132 => 0x3f5, 134 => 0x38, 148 => 'FocusMode', 172 => 0x30, 174 => 0xe, 175 => 0xc, 215 => 0x7, 279 => 0x301, 284 => 0x100b, 302 => 0x7, 337 => 0xd, 344 => 0x3, 369 => 0x1006, 380 => [0xb,0x5], 386 => [0x15,0x1d], 387 => 0x4d, 388 => 0x4d, 400 => [0xb042,0xb04e,0x201b], 405 => 0x13, 423 => 0x16 },
	'focusmode2' => { 121 => '0.1', 318 => '3.1', 405 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 264 => '10.1', 384 => 0x14, 385 => 0x15, 387 => 0x10, 388 => 0xf, 389 => 0x6 },
	'focusmodeswitch' => { 175 => 0x58, 387 => 0x2e },
	'focuspixel' => { 122 => 0x1023 },
	'focuspointwrap' => { 262 => '2.2', 263 => '2.2', 265 => '2.1', 266 => '2.1', 270 => '1.1', 271 => '2.2', 272 => '1.1', 275 => '2.2', 276 => '2.1', 277 => '2.5' },
	'focusposition' => { 208 => 0x8, 209 => 0x8, 213 => 0x9, 337 => 0x10, 398 => 0x9bb },
	'focusposition2' => { 405 => [0x29,0x2b,0x2f], 423 => 0x2d, 426 => 0x20 },
	'focusprocess' => { 279 => 0x302 },
	'focusrange' => { 34 => 0x12, 284 => 0x100a },
	'focusrangeindex' => { 328 => '3.1' },
	'focusringrotation' => { 79 => 0x713 },
	'focussetting' => { 379 => 0x6 },
	'focusstatus' => { 386 => 0x19, 387 => 0x53, 388 => 0x53 },
	'focusstepcount' => { 282 => 0x301, 284 => 0x100e },
	'focusstepinfinity' => { 282 => 0x303, 284 => 0x103b },
	'focusstepnear' => { 282 => 0x304, 284 => 0x103c },
	'focustrackinglockon' => { 262 => ['1.5','4.1'], 263 => '1.4', 270 => '0.4', 271 => '3.1', 272 => '0.4', 275 => '1.4' },
	'focuswarning' => { 122 => 0x1301 },
	'foldername' => { 172 => 0x27 },
	'foldernumber' => { 387 => 0x9a, 389 => [0x402,0x114,0x316] },
	'fontcomposite' => { 485 => [\'Fonts','FontsComposite'] },
	'fontface' => { 485 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 485 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 485 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 485 => [\'Fonts','FontsFontName'] },
	'fonts' => { 485 => 'Fonts' },
	'fonttype' => { 485 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 485 => [\'Fonts','FontsVersionString'] },
	'for' => { 353 => 'For' },
	'forcewrite' => { 115 => 'ForceWrite' },
	'format' => { 362 => "\xa9fmt", 440 => 'Format', 457 => 'format', 478 => 'Format' },
	'forwardlock' => { 475 => 'forwardlock' },
	'forwardmatrix1' => { 114 => 0xc714 },
	'forwardmatrix2' => { 114 => 0xc715 },
	'fossilspecimen' => { 113 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 113 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 64 => [0x2,0x4] },
	'frameheight' => { 122 => 0x3822 },
	'framenum' => { 348 => 0xd7 },
	'framenumber' => { 122 => 0x8003, 178 => 0x3c, 337 => 0x29 },
	'framerate' => { 64 => [0x1,0x6], 114 => 0xc764, 122 => 0x3820 },
	'framereadouttime' => { 356 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 122 => 0x3821 },
	'framing' => { 469 => 'framing' },
	'freebytes' => { 92 => 0x1 },
	'freememorycardimages' => { 173 => [0x37,0x54], 174 => [0x2d,0x4a], 175 => 0x32 },
	'fujiflashmode' => { 122 => 0x1010 },
	'fullimagesize' => { 400 => 0xb02b },
	'fullpanoheightpixels' => { 443 => 'FullPanoHeightPixels', 444 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 443 => 'FullPanoWidthPixels', 444 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 369 => 0x100d },
	'fullsizeimage' => { 154 => 'data' },
	'fullsizeimagename' => { 154 => '1Name' },
	'fullsizeimagetype' => { 154 => '0Type' },
	'func1button' => { 265 => '14.1', 266 => '14.1', 276 => '14.1' },
	'func1buttonplusdials' => { 265 => '42.1', 266 => '42.1', 276 => '42.1' },
	'func2button' => { 265 => '80.1', 266 => '80.1', 276 => '80.1' },
	'func2buttonplusdials' => { 265 => '81.1' },
	'func3button' => { 265 => '83.1' },
	'funcbutton' => { 262 => ['14.1','15.1'], 263 => '14.1', 271 => '28.1', 272 => '13.1', 275 => '14.1', 277 => '14.1' },
	'funcbuttonplusdials' => { 262 => ['14.2','15.2'], 263 => '14.2', 271 => '31.1', 275 => '42.1' },
	'functionbutton' => { 269 => '13.1', 273 => '5.2' },
	'gainbase' => { 283 => 0x610 },
	'gaincontrol' => { 114 => 0xa407, 460 => 'GainControl' },
	'gamma' => { 114 => 0xa500, 132 => 0x8fe, 307 => 0x11c, 461 => 'Gamma' },
	'gammablackpoint' => { 100 => 0xc },
	'gammacolortone' => { 100 => 0x3 },
	'gammacompensatedvalue' => { 128 => 0x91 },
	'gammacontrast' => { 100 => 0x2 },
	'gammacurveoutputrange' => { 100 => 0xf },
	'gammahighlight' => { 100 => 0xa },
	'gammalinear' => { 98 => 0x20200 },
	'gammamidpoint' => { 100 => 0xe },
	'gammasaturation' => { 100 => 0x4 },
	'gammashadow' => { 100 => 0x9 },
	'gammasharpnessstrength' => { 100 => 0x8 },
	'gammaunsharpmaskfineness' => { 100 => 0x6 },
	'gammaunsharpmaskstrength' => { 100 => 0x5 },
	'gammaunsharpmaskthreshold' => { 100 => 0x7 },
	'gammawhitepoint' => { 100 => 0xd },
	'gdalmetadata' => { 114 => 0xa480 },
	'gdalnodata' => { 114 => 0xa481 },
	'geimagesize' => { 122 => 0x1304 },
	'gemake' => { 124 => 0x300 },
	'gemodel' => { 124 => 0x207 },
	'genre' => { 354 => ['gnre',"\xa9gen"], 356 => 'genre', 362 => ['gnre',"\xa9gen"], 466 => 'Genre', 470 => 'genre', 480 => 'genre' },
	'genrecvid' => { 466 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 466 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 466 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 466 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 354 => 'geID' },
	'geography' => { 471 => 'geography' },
	'geologicalcontext' => { 113 => 'GeologicalContext' },
	'geologicalcontextbed' => { 113 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 113 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 113 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 113 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 113 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 115 => 'Geosync' },
	'geotag' => { 115 => 'Geotag' },
	'geotiffasciiparams' => { 114 => 0x87b1 },
	'geotiffdirectory' => { 114 => 0x87af },
	'geotiffdoubleparams' => { 114 => 0x87b0 },
	'geotime' => { 115 => 'Geotime' },
	'giftftppriority' => { 445 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 111 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 111 => 'GimbalReverse' },
	'gimbalrolldegree' => { 111 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 111 => 'GimbalYawDegree' },
	'globalaltitude' => { 351 => 0x419 },
	'globalangle' => { 351 => 0x40d },
	'good' => { 480 => 'good' },
	'googlehostheader' => { 354 => 'gshh' },
	'googlepingmessage' => { 354 => 'gspm' },
	'googlepingurl' => { 354 => 'gspu' },
	'googleplusuploadcode' => { 114 => 0x9009 },
	'googlesourcedata' => { 354 => 'gssd' },
	'googlestarttime' => { 354 => 'gsst' },
	'googletrackduration' => { 354 => 'gstd' },
	'goprotype' => { 362 => 'GoPr' },
	'gpsaltitude' => { 125 => 0x6, 152 => 'Altitude', 460 => 'GPSAltitude' },
	'gpsaltituderef' => { 125 => 0x5, 460 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 125 => 0x1c, 460 => 'GPSAreaInformation' },
	'gpscoordinates' => { 356 => 'location.ISO6709', 362 => "\xa9xyz" },
	'gpsdatestamp' => { 125 => 0x1d },
	'gpsdatetime' => { 152 => 'DateTime', 460 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 125 => 0x18, 152 => 'Bearing', 460 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 125 => 0x17, 460 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 125 => 0x1a, 152 => 'Distance', 460 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 125 => 0x19, 460 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 125 => 0x14, 460 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 125 => 0x13 },
	'gpsdestlongitude' => { 125 => 0x16, 460 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 125 => 0x15 },
	'gpsdifferential' => { 125 => 0x1e, 152 => 'Differential', 460 => 'GPSDifferential' },
	'gpsdop' => { 125 => 0xb, 460 => 'GPSDOP' },
	'gpshpositioningerror' => { 125 => 0x1f, 460 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 125 => 0x11, 460 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 125 => 0x10, 460 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 111 => 'GpsLatitude', 125 => 0x2, 152 => 'Latitude', 460 => 'GPSLatitude' },
	'gpslatituderef' => { 125 => 0x1 },
	'gpslongitude' => { 111 => 'GpsLongitude', 125 => 0x4, 152 => 'Longitude', 460 => 'GPSLongitude' },
	'gpslongituderef' => { 125 => 0x3 },
	'gpslongtitude' => { 111 => 'GpsLongtitude' },
	'gpsmapdatum' => { 125 => 0x12, 152 => 'Datum', 460 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 125 => 0xa, 152 => 'MeasureMode', 460 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 125 => 0x1b, 460 => 'GPSProcessingMethod' },
	'gpssatellites' => { 125 => 0x8, 152 => 'Satellites', 460 => 'GPSSatellites' },
	'gpsspeed' => { 125 => 0xd, 152 => 'Speed', 460 => 'GPSSpeed' },
	'gpsspeedref' => { 125 => 0xc, 460 => 'GPSSpeedRef' },
	'gpsstatus' => { 125 => 0x9, 460 => 'GPSStatus' },
	'gpsstring' => { 132 => 0x402 },
	'gpstimestamp' => { 125 => 0x7 },
	'gpstrack' => { 125 => 0xf, 152 => 'Heading', 460 => 'GPSTrack' },
	'gpstrackref' => { 125 => 0xe, 460 => 'GPSTrackRef' },
	'gpsversionid' => { 125 => 0x0, 460 => 'GPSVersionID' },
	'gradation' => { 279 => 0x50f },
	'gradientbasedcorractive' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 456 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 456 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 456 => 'GrainAmount' },
	'graineffect' => { 122 => 0x1047 },
	'grainfrequency' => { 456 => 'GrainFrequency' },
	'grainsize' => { 456 => 'GrainSize' },
	'graymixeraqua' => { 456 => 'GrayMixerAqua' },
	'graymixerblue' => { 456 => 'GrayMixerBlue' },
	'graymixergreen' => { 456 => 'GrayMixerGreen' },
	'graymixermagenta' => { 456 => 'GrayMixerMagenta' },
	'graymixerorange' => { 456 => 'GrayMixerOrange' },
	'graymixerpurple' => { 456 => 'GrayMixerPurple' },
	'graymixerred' => { 456 => 'GrayMixerRed' },
	'graymixeryellow' => { 456 => 'GrayMixerYellow' },
	'graypoint' => { 433 => 0x8021 },
	'grayresponseunit' => { 114 => 0x122 },
	'greencurvelimits' => { 103 => 0x1c4 },
	'greencurvepoints' => { 102 => 0x53, 103 => 0x19a },
	'greenhsl' => { 98 => 0x20913 },
	'greenhue' => { 456 => 'GreenHue' },
	'greensaturation' => { 456 => 'GreenSaturation' },
	'griddisplay' => { 262 => '13.3', 263 => '4.3', 265 => '4.2', 266 => '4.2', 267 => '2.2', 271 => '10.5', 272 => '3.4', 273 => '6.1', 275 => '4.4', 276 => '4.2', 277 => '4.2' },
	'gripbatteryadload' => { 316 => 0x5 },
	'gripbatteryadnoload' => { 316 => 0x4 },
	'gripbatterystate' => { 316 => '1.2' },
	'groupareaafillumination' => { 263 => '46.4', 266 => '47.4', 275 => '47.4' },
	'grouping' => { 354 => ['grup',"\xa9grp"], 362 => "\xa9grp" },
	'guid' => { 354 => 'GUID' },
	'h2resetblackpixels' => { 132 => 0x18a6 },
	'h3resetblackcolumns' => { 132 => 0x18ce },
	'h3resetblackpixels' => { 132 => 0x18b0 },
	'halftonehints' => { 114 => 0x141 },
	'hardlink' => { 115 => 'HardLink' },
	'hasalternative' => { 470 => 'hasAlternative' },
	'hascorrection' => { 470 => 'hasCorrection' },
	'hascorrectiona-lang' => { 470 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 470 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 470 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 456 => 'HasCrop' },
	'hasextendedxmp' => { 482 => 'HasExtendedXMP' },
	'hassettings' => { 456 => 'HasSettings' },
	'hastranslation' => { 470 => 'hasTranslation' },
	'hasvisibleoverprint' => { 485 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 485 => 'HasVisibleTransparency' },
	'hdr' => { 58 => 0x1, 205 => 0x4, 302 => 0x9e, 337 => 0x85, 400 => 0x200a },
	'hdreffect' => { 58 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 205 => 0x0 },
	'hdrlevel' => { 205 => 0x5, 389 => 0x2e, 405 => 0x17 },
	'hdrlevel2' => { 205 => 0x7 },
	'hdrsetting' => { 389 => 0x2d, 405 => 0x16, 408 => 0x1148, 409 => 0x1148, 410 => 0x1124, 411 => 0x11a0, 412 => 0x117c, 413 => 0x1034, 414 => 0x22c, 415 => 0x22c, 416 => 0x21f },
	'hdrshot' => { 302 => 0x76 },
	'hdrsmoothing' => { 205 => 0x6 },
	'hdvideo' => { 354 => 'hdvd' },
	'headline' => { 126 => 0x69, 466 => 'Headline', 468 => 'Headline' },
	'hierarchicalkeywords' => { 163 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 163 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 163 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 163 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 163 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 163 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 163 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 163 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 163 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 163 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 163 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 163 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 163 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 163 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 163 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 163 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 163 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 163 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 447 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 113 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 307 => 0x1a },
	'highisomultipliergreen' => { 307 => 0x19 },
	'highisomultiplierred' => { 307 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 60 => 0x5, 79 => 0x202, 215 => 0xb1, 337 => 0x71, 387 => 0x2c, 388 => 0x26, 389 => 0x26, 400 => 0x2009, 405 => 0x12, 429 => 0x42 },
	'highisonoisereduction2' => { 400 => 0xb050 },
	'highlight' => { 379 => 0xf },
	'highlightadj' => { 98 => 0x2030c },
	'highlightcolordistortreduct' => { 433 => 0x8026 },
	'highlightlinearitylimit' => { 376 => 0xa025 },
	'highlightprotection' => { 254 => 0x6 },
	'highlightrecovery' => { 456 => 'HighlightRecovery' },
	'highlights' => { 449 => 'Highlights' },
	'highlights2012' => { 456 => 'Highlights2012' },
	'highlightsadj' => { 433 => 0x9019 },
	'highlightshadow' => { 302 => 0xad },
	'highlighttone' => { 122 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 60 => 0x3, 79 => 0x203 },
	'highlightwarning' => { 302 => 0x8002 },
	'highlowkeyadj' => { 337 => 0x6c },
	'highspeedsync' => { 175 => 0x5, 387 => 0x2, 388 => 0x2 },
	'hintversion' => { 362 => 'hinv' },
	'histogramxml' => { 255 => 0x83a1a25 },
	'history' => { 468 => 'History', 481 => 'History' },
	'historyaction' => { 481 => [\'History','HistoryAction'] },
	'historychanged' => { 481 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 481 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 481 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 481 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 481 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 132 => 0xc88 },
	'holefilldeltathreshold' => { 132 => 0xc7e },
	'hometowncity' => { 108 => 0x3006, 337 => 0x23, 343 => 0x2 },
	'hometowncitycode' => { 344 => 0x1000 },
	'hometowndst' => { 337 => 0x25, 343 => '0.2' },
	'hostcomputer' => { 114 => 0x13c },
	'hostsoftwarerendering' => { 132 => 0xce7 },
	'hue' => { 180 => 0x3b, 218 => 0x3d, 219 => 0x45, 337 => 0x67 },
	'hueadj' => { 258 => 0x2f, 433 => 0x8019 },
	'hueadjust' => { 369 => 0x1016 },
	'hueadjustment' => { 173 => 0x4a, 174 => 0x40, 215 => 0x92, 217 => 0x36 },
	'hueadjustmentaqua' => { 456 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 456 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 456 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 456 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 456 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 456 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 456 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 456 => 'HueAdjustmentYellow' },
	'huesetting' => { 287 => 0x1011 },
	'humanobservation' => { 113 => 'HumanObservation' },
	'humanobservationday' => { 113 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 113 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 113 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 113 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 113 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 113 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 113 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationfieldnotes' => { 113 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 113 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 113 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 113 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 113 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 113 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 113 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 113 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 113 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 113 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 113 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 113 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 113 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 114 => 0x9401, 461 => 'Humidity' },
	'icc_profile' => { 115 => 'ICC_Profile' },
	'iccprofilename' => { 468 => 'ICCProfile' },
	'iconuri' => { 362 => 'icnu' },
	'idccreativestyle' => { 433 => 0x8000 },
	'idcpreviewlength' => { 433 => 0x202 },
	'idcpreviewstart' => { 433 => 0x201 },
	'identification' => { 113 => 'Identification' },
	'identificationid' => { 113 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 113 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 113 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 113 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 113 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 113 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 457 => 'identifier', 478 => 'Identifier' },
	'ifcameramodel' => { 132 => 0x9c8 },
	'illumination' => { 273 => '0.5', 364 => 0x48 },
	'imageabsolutex' => { 132 => 0x3fe },
	'imageabsolutey' => { 132 => 0x3ff },
	'imageadjustment' => { 215 => 0x80, 245 => 0x5 },
	'imagealterationconstraints' => { 289 => 'ImageAlterationConstraints' },
	'imagearea' => { 228 => 0x10, 231 => 0x10 },
	'imageareaoffset' => { 337 => 0x38 },
	'imageauthentication' => { 215 => 0x20 },
	'imageboundary' => { 215 => 0x16 },
	'imagecount' => { 122 => 0x1438, 215 => 0xa5, 403 => 0x11b },
	'imagecreator' => { 289 => 'ImageCreator' },
	'imagecreatorid' => { 289 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 289 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 289 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 132 => 0x41f },
	'imagecropy' => { 132 => 0x420 },
	'imagedata' => { 442 => 'Data' },
	'imagedatasize' => { 215 => 0xa2 },
	'imagedescription' => { 114 => 0x10e, 476 => 'ImageDescription' },
	'imageduplicationconstraints' => { 289 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 255 => 0xfe443a45 },
	'imageeditcount' => { 337 => 0x41 },
	'imageediting' => { 337 => 0x32 },
	'imageeffects' => { 369 => 0x1010 },
	'imagefileconstraints' => { 289 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 289 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 289 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 122 => 0x1436 },
	'imageheight' => { 114 => 0x101, 179 => 0xc, 346 => 0x10d, 440 => 'ImageHeight', 476 => 'ImageLength' },
	'imagehistory' => { 114 => 0x9213, 459 => 'ImageHistory' },
	'imageidnumber' => { 297 => 0x340 },
	'imagemimetype' => { 442 => 'Mime' },
	'imagenumber' => { 114 => 0x9211, 148 => 'ImageNumber', 173 => 0xae, 174 => 0x5e, 346 => 0x113, 387 => 0x9b, 389 => [0x400,'276.1',0x314], 452 => 'ImageNumber' },
	'imagenumber2' => { 174 => 0x62 },
	'imageoptimization' => { 215 => 0xa9 },
	'imageorientation' => { 126 => 0x83 },
	'imageprocessing' => { 215 => 0x1a },
	'imageprocessingfiledatecreated' => { 132 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 132 => 0xc80 },
	'imageprocessingversion' => { 283 => 0x0 },
	'imagequality' => { 148 => 'ImageQuality', 230 => '723.2', 231 => '732.2', 240 => '708.1', 302 => 0x1 },
	'imagequality2' => { 279 => 0x603 },
	'imagerank' => { 445 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 132 => 0x600 },
	'imagerboardversion' => { 132 => 0x439 },
	'imagercols' => { 132 => 0x17d4 },
	'imageref' => { 464 => 'ImageRef' },
	'imageresolution' => { 132 => 0x944 },
	'imageresolutionjpg' => { 132 => 0x945 },
	'imagereview' => { 264 => '0.4', 273 => '0.4' },
	'imagereviewmonitorofftime' => { 263 => '21.1', 265 => '21.1', 266 => '21.1', 270 => '20.1', 275 => '21.1', 276 => '21.1' },
	'imagereviewtime' => { 262 => '25.1', 264 => '2.1', 267 => '19.1', 268 => '20.1', 269 => '20.1', 271 => '9.2', 272 => '20.1', 277 => '21.2' },
	'imagerfiledatecreated' => { 132 => 0x9c5 },
	'imagerfileproductionlevel' => { 132 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 132 => 0x9c7 },
	'imagerpowerondelaymsec' => { 132 => 0x5fd },
	'imagerrows' => { 132 => 0x17de },
	'imagesegmentlines' => { 132 => 0x184d },
	'imagesegmentstartline' => { 132 => 0x184c },
	'imagesize' => { 154 => 'ImageSize' },
	'imagesizerestriction' => { 473 => 'imageSizeRestriction' },
	'imagesourcedata' => { 114 => 0x935c },
	'imagespace' => { 132 => 0x909 },
	'imagestabilization' => { 34 => 0x22, 108 => 0x3020, 122 => 0x1422, 148 => 'ImageStabilization', 173 => 0xbd, 174 => 0x71, 175 => 0x57, 176 => 0x0, 177 => [0x18,0x107,0x113], 178 => 0x49c2, 215 => 0xac, 279 => 0x604, 282 => 0x1600, 302 => 0x1a, 392 => 0x12, 393 => 0x11, 400 => 0xb026 },
	'imagestabilization2' => { 391 => 0xa },
	'imagestabilizationsetting' => { 178 => 0x14, 387 => 0x3d, 388 => 0x3d, 398 => 0x14 },
	'imagestyle' => { 387 => 0x2d, 388 => 0x27 },
	'imagesupplier' => { 289 => 'ImageSupplier' },
	'imagesupplierid' => { 289 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 289 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 289 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 116 => 0x1 },
	'imagetemperaturemin' => { 116 => 0x2 },
	'imagetone' => { 337 => 0x4f },
	'imagetype' => { 126 => 0x82, 289 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 61 => 0x28, 114 => 0xa420, 459 => 'ImageUniqueID', 460 => 'ImageUniqueID' },
	'imagewidth' => { 114 => 0x100, 179 => 0xe, 346 => 0x10c, 440 => 'ImageWidth', 476 => 'ImageWidth' },
	'inclinationangle' => { 433 => 0x900f },
	'inclinationcorrection' => { 433 => 0x900e },
	'incrementaltemperature' => { 456 => 'IncrementalTemperature' },
	'incrementaltint' => { 456 => 'IncrementalTint' },
	'industry' => { 470 => 'industry', 471 => 'industry' },
	'infobuttonwhenshooting' => { 79 => 0x409 },
	'information' => { 356 => 'information', 362 => "\xa9inf" },
	'infourl' => { 362 => 'infu' },
	'infraredilluminator' => { 363 => 0x28 },
	'ingredientexclusion' => { 472 => 'ingredientExclusion' },
	'ingredients' => { 481 => 'Ingredients' },
	'ingredientsalternatepaths' => { 481 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 481 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 481 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 481 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 481 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 481 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 481 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 481 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 481 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 481 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 481 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 481 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 481 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 481 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 481 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 481 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 481 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 481 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 481 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 481 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 481 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 481 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 481 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 79 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 443 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 443 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 443 => 'InitialViewHeadingDegrees', 444 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 443 => 'InitialViewPitchDegrees', 444 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 443 => 'InitialViewRollDegrees', 444 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 262 => '4.4' },
	'initialzoomsetting' => { 262 => '9.3', 271 => '27.3' },
	'inkset' => { 114 => 0x14c },
	'inputprofile' => { 132 => 0x1389 },
	'instanceid' => { 481 => 'InstanceID' },
	'instantplaybacksetup' => { 175 => 0x3e },
	'instantplaybacktime' => { 175 => 0x3d },
	'instructions' => { 468 => 'Instructions' },
	'instrument' => { 480 => 'instrument' },
	'integrationtime' => { 132 => 0x423 },
	'intellectualgenre' => { 465 => 'IntellectualGenre' },
	'intelligentauto' => { 400 => 0xb052, 425 => 0xd, 426 => 0xe, 427 => 0xd },
	'intelligentcontrast' => { 50 => 0x4 },
	'intelligentd-range' => { 302 => 0x79 },
	'intelligentexposure' => { 302 => 0x5d },
	'intelligentresolution' => { 302 => 0x70 },
	'interchangecolorspace' => { 128 => 0x40 },
	'intergraphmatrix' => { 114 => 0x8480 },
	'internalflash' => { 172 => 0x2b, 262 => '23.1', 264 => '8.1', 267 => '22.1', 269 => '23.1', 273 => '8.1', 277 => '24.1', 282 => 0x1208 },
	'internalflashae1' => { 284 => 0x1021 },
	'internalflashae1_0' => { 284 => 0x101d },
	'internalflashae2' => { 284 => 0x1022 },
	'internalflashae2_0' => { 284 => 0x101e },
	'internalflashmode' => { 325 => 0x1 },
	'internalflashstrength' => { 325 => 0x3 },
	'internalflashtable' => { 284 => 0x1024 },
	'internallensserialnumber' => { 376 => 0xa005 },
	'internalndfilter' => { 302 => 0x9d },
	'internalserialnumber' => { 61 => 0x96, 72 => 0x9, 122 => 0x10, 178 => 0x49dc, 278 => 0x18, 280 => 0x102, 299 => 0x500, 302 => 0x25, 317 => 0x4, 369 => 0x5, 418 => [0x7c,0xf0], 419 => 0x88 },
	'interopindex' => { 114 => 0x1, 461 => 'InteroperabilityIndex' },
	'interopversion' => { 114 => 0x2 },
	'intervallength' => { 172 => 0x10 },
	'intervalmode' => { 172 => 0x26 },
	'intervalnumber' => { 172 => 0x11 },
	'intervalshooting' => { 337 => 0x92 },
	'introtime' => { 480 => 'introTime' },
	'introtimescale' => { 480 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 480 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 132 => 0xdae },
	'ipfcameramodel' => { 132 => 0xe4d },
	'iptc' => { 115 => 'IPTC' },
	'iptc-naa' => { 114 => 0x83bb, 307 => 0x83bb },
	'iptcbitspersample' => { 128 => 0x56 },
	'iptcdigest' => { 351 => 0x425 },
	'iptcimageheight' => { 128 => 0x1e },
	'iptcimagerotation' => { 128 => 0x66 },
	'iptcimagewidth' => { 128 => 0x14 },
	'iptclastedited' => { 466 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 128 => 0xa },
	'iptcpixelheight' => { 128 => 0x32 },
	'iptcpixelwidth' => { 128 => 0x28 },
	'isalternativeof' => { 470 => 'isAlternativeOf' },
	'isbn' => { 470 => 'isbn' },
	'iscorrectionof' => { 470 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 104 => 0x3 },
	'ismergedhdr' => { 452 => 'IsMergedHDR' },
	'ismergedpanorama' => { 452 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 30 => 0x0, 31 => 0x1, 107 => 0x14, 108 => [0x3014,0x14], 114 => 0x8827, 131 => 0xfd06, 132 => 0x1784, 134 => 0x60, 136 => [0xfa2e,0xfa46], 137 => [0x27,0x28], 138 => 0xf105, 141 => 0x14, 143 => 0x4e, 146 => 0x34, 148 => 'ISO', 172 => 0x8, 178 => 0x49ba, 206 => 0x0, 215 => 0x2, 307 => 0x17, 337 => [0x8b,0x14], 344 => 0x14, 346 => 0x105, 376 => 0xa014, 398 => 0x6f, 405 => [0x1f,0x21,0x25], 460 => 'ISOSpeedRatings' },
	'iso2' => { 206 => 0x6, 225 => 0x265, 226 => 0x25c, 227 => 0x265, 228 => 0x221, 229 => 0x25d, 230 => 0x256, 231 => 0x25d, 235 => 0x2b5, 238 => 0x265, 244 => 0x2b5 },
	'isoauto' => { 318 => '14.4' },
	'isoautohilimit' => { 233 => 0x18eb, 234 => 0xe82, 242 => 0x185d },
	'isoautomax' => { 399 => 0x4 },
	'isoautomin' => { 399 => 0x2 },
	'isoautoparameters' => { 337 => 0x7a },
	'isoautoshuttertime' => { 233 => 0x18ea, 234 => 0xe81, 242 => 0x185c },
	'isocalibrationgain' => { 132 => 0x89f },
	'isodisplay' => { 265 => '4.1', 266 => '4.1', 267 => '2.3', 268 => '3.3', 269 => '3.3', 272 => '3.3', 275 => '4.3', 276 => '4.1', 277 => '4.3' },
	'isoexpansion' => { 79 => 0x103, 80 => 0x7, 81 => 0x8, 84 => 0x8, 206 => 0x4 },
	'isoexpansion2' => { 206 => 0xa },
	'isofloor' => { 318 => 0x6 },
	'isoselection' => { 215 => 0xf },
	'isosensitivitystep' => { 270 => '6.2', 272 => '6.2' },
	'isosetting' => { 134 => 0x5e, 148 => 'ISOSetting', 172 => 0x24, 173 => 0x26, 174 => 0x1c, 175 => 0x13, 180 => 0x6, 215 => 0x13, 318 => '17.3', 368 => 0x27, 387 => 0x16, 388 => 0x14, 389 => 0x2, 398 => 0x6d, 399 => 0x0 },
	'isospeed' => { 114 => 0x8833, 461 => 'ISOSpeed' },
	'isospeedexpansion' => { 78 => 0x3 },
	'isospeedincrements' => { 79 => 0x102 },
	'isospeedlatitudeyyy' => { 114 => 0x8834, 461 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 114 => 0x8835, 461 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 79 => 0x103 },
	'isostepsize' => { 262 => '6.1', 263 => '7.2', 265 => '7.2', 266 => '7.2', 271 => '4.1', 275 => '7.2', 276 => '7.2' },
	'isovalue' => { 284 => 0x1001 },
	'isrccode' => { 362 => "\xa9isr" },
	'issn' => { 470 => 'issn' },
	'issueidentifier' => { 470 => 'issueIdentifier' },
	'issuename' => { 470 => 'issueName' },
	'issueteaser' => { 470 => 'issueTeaser' },
	'issuetype' => { 470 => 'issueType' },
	'istranslationof' => { 470 => 'isTranslationOf' },
	'itemsubtype' => { 170 => 'ItemSubType' },
	'itunesu' => { 354 => 'itnu' },
	'jobid' => { 126 => 0xb8 },
	'jobname' => { 462 => 'JobName' },
	'jobref' => { 479 => 'JobRef' },
	'jobrefid' => { 479 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 479 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 479 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 462 => 'JobStatus' },
	'jpeghandling' => { 456 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 302 => 0x43, 304 => 0x3034, 400 => 0xb047 },
	'jpegsize' => { 304 => 0x303a },
	'jpgcompression' => { 234 => 0x7d4 },
	'jpgfromraw' => { 92 => 0x2007, 109 => 'JpgFromRaw', 307 => 0x2e },
	'jpgfromrawlength' => { 114 => [0x117,0x202] },
	'jpgfromrawstart' => { 114 => [0x111,0x201] },
	'jpgrecordedpixels' => { 318 => '14.1' },
	'jurisdiction' => { 453 => 'jurisdiction' },
	'kelvinwb_01' => { 326 => 0x5 },
	'kelvinwb_02' => { 326 => 0x9 },
	'kelvinwb_03' => { 326 => 0xd },
	'kelvinwb_04' => { 326 => 0x11 },
	'kelvinwb_05' => { 326 => 0x15 },
	'kelvinwb_06' => { 326 => 0x19 },
	'kelvinwb_07' => { 326 => 0x1d },
	'kelvinwb_08' => { 326 => 0x21 },
	'kelvinwb_09' => { 326 => 0x25 },
	'kelvinwb_10' => { 326 => 0x29 },
	'kelvinwb_11' => { 326 => 0x2d },
	'kelvinwb_12' => { 326 => 0x31 },
	'kelvinwb_13' => { 326 => 0x35 },
	'kelvinwb_14' => { 326 => 0x39 },
	'kelvinwb_15' => { 326 => 0x3d },
	'kelvinwb_16' => { 326 => 0x41 },
	'kelvinwb_daylight' => { 326 => 0x1 },
	'kerneldenominators' => { 132 => 0x933 },
	'key' => { 480 => 'key' },
	'keystonecompensation' => { 283 => 0x1900 },
	'keystonedirection' => { 283 => 0x1901 },
	'keystonevalue' => { 283 => 0x1906 },
	'keyword' => { 354 => 'keyw', 470 => 'keyword' },
	'keywordinfo' => { 163 => 'Keywords' },
	'keywords' => { 126 => 0x19, 149 => 'Keywords', 288 => 'Keywords', 353 => 'Keywords', 356 => 'keywords', 450 => 'keywords', 467 => 'Keywords', 478 => 'Keywords' },
	'killdate' => { 470 => 'killDate' },
	'killdatea-platform' => { 470 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 470 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 131 => 0xf908, 134 => 0xe, 136 => [0xfa1e,0xfa52], 142 => 0x70 },
	'kodakimagewidth' => { 131 => 0xf907, 134 => 0xc, 136 => [0xfa1d,0xfa51], 142 => 0x6c },
	'kodakinfotype' => { 131 => 0xfa00 },
	'kodaklook' => { 132 => 0xe4c },
	'kodaklookprofile' => { 132 => 0x138a },
	'kodakmaker' => { 142 => 0x8 },
	'kodakmodel' => { 134 => 0x0, 142 => 0x28 },
	'kodaktag' => { 132 => 0x3ea },
	'kodakversion' => { 132 => 0x0 },
	'label' => { 292 => 'Label', 478 => 'Label' },
	'labelname1' => { 464 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 464 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 464 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 464 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 464 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 464 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 302 => 0x6f },
	'landscapeoutputhighlightpoint' => { 104 => 0x26 },
	'landscapeoutputshadowpoint' => { 104 => 0x27 },
	'landscaperawcolortone' => { 104 => 0x1f },
	'landscaperawcontrast' => { 104 => 0x21 },
	'landscaperawhighlight' => { 104 => 0x77 },
	'landscaperawhighlightpoint' => { 104 => 0x24 },
	'landscaperawlinear' => { 104 => 0x22 },
	'landscaperawsaturation' => { 104 => 0x20 },
	'landscaperawshadow' => { 104 => 0x80 },
	'landscaperawshadowpoint' => { 104 => 0x25 },
	'landscaperawsharpness' => { 104 => 0x23 },
	'landscapeunsharpmaskfineness' => { 104 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 104 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 104 => 0xa2 },
	'language' => { 457 => 'language' },
	'languageidentifier' => { 126 => 0x87 },
	'largestvalidinteriorrectheight' => { 443 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 443 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 443 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 443 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 172 => 0x1b },
	'lastkeywordiptc' => { 170 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 170 => 'LastKeywordXMP' },
	'lastphotodate' => { 443 => 'LastPhotoDate' },
	'lasturl' => { 481 => 'LastURL' },
	'lateralchromaticaberration' => { 400 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 452 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 113 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 113 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 113 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 113 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 113 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 111 => 'Latitude' },
	'lc1' => { 328 => 0x2 },
	'lc10' => { 328 => 0xb },
	'lc11' => { 328 => 0xc },
	'lc12' => { 328 => 0xd },
	'lc14' => { 328 => 0xf },
	'lc15' => { 328 => 0x10 },
	'lc3' => { 328 => 0x4 },
	'lc4' => { 328 => 0x5 },
	'lc5' => { 328 => 0x6 },
	'lc6' => { 328 => 0x7 },
	'lc7' => { 328 => 0x8 },
	'lc8' => { 328 => 0x9 },
	'lcddisplayatpoweron' => { 79 => 0x811, 83 => 0xa },
	'lcddisplayreturntoshoot' => { 84 => 0x12 },
	'lcdillumination' => { 262 => '17.5', 263 => '5.2', 265 => '5.1', 266 => '5.1', 271 => '10.3', 272 => '4.2', 275 => '5.2', 276 => '5.1', 277 => '5.4' },
	'lcdilluminationduringbulb' => { 79 => 0x408 },
	'lcdmatrix' => { 132 => 0xe74 },
	'lcdmatrixchickfix' => { 132 => 0xe75 },
	'lcdmatrixmarvin' => { 132 => 0xe76 },
	'lcdpanels' => { 78 => 0x8 },
	'lcheditor' => { 255 => 0x8ae85e },
	'legacyiptcdigest' => { 468 => 'LegacyIPTCDigest' },
	'legalcode' => { 453 => 'legalcode' },
	'lens' => { 114 => 0xfdea, 215 => 0x84, 452 => 'Lens' },
	'lensafstopbutton' => { 77 => 0x11, 78 => 0x13, 79 => 0x506, 80 => 0x10, 81 => 0x12, 84 => 0x13, 85 => 0x9 },
	'lensaperturerange' => { 379 => [0x30,0x48] },
	'lenscorrectionsettings' => { 459 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 452 => 'LensDistortInfo' },
	'lensdistortionparams' => { 284 => 0x206 },
	'lensdrivenoaf' => { 79 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 389 => 0x3f0, 432 => 0xd },
	'lensfirmware' => { 370 => 0x20, 376 => 0xa004 },
	'lensfirmwareversion' => { 280 => 0x204, 302 => 0x60, 389 => 0x3f3, 432 => 0x14 },
	'lensfocallength' => { 98 => 0xf0512, 328 => 0x9 },
	'lensfocalrange' => { 379 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 263 => '55.1', 265 => '52.1', 266 => '52.1', 275 => '52.1', 276 => '52.1' },
	'lensformat' => { 412 => 0x1891, 414 => 0x18bd, 415 => 0x18ed, 416 => 0x17f1, 418 => 0x106, 419 => 0x106, 428 => 0x603, 429 => 0x5d },
	'lensfstops' => { 207 => 0x7, 208 => 0xc, 209 => 0xd, 213 => 0xe, 215 => 0x8b, 328 => '0.3' },
	'lensid' => { 452 => 'LensID' },
	'lensidnumber' => { 207 => 0x6, 208 => 0xb, 209 => 0xc, 213 => 0xd },
	'lensinfo' => { 114 => 0xa432, 334 => 0x2a, 452 => 'LensInfo', 461 => 'LensSpecification' },
	'lenskind' => { 328 => 0x1 },
	'lensmake' => { 114 => 0xa433, 155 => 'Make', 461 => 'LensMake' },
	'lensmanualdistortionamount' => { 456 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 170 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 379 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 61 => 0x95, 114 => 0xa434, 155 => 'Model', 170 => 'LensModel', 210 => 0x18a, 211 => 0x18b, 212 => 0x2ac, 280 => 0x203, 334 => 0xc, 346 => 0x412, 461 => 'LensModel' },
	'lensmodulationoptimizer' => { 122 => 0x1045 },
	'lensmount' => { 389 => 0x99, 412 => 0x1892, 414 => 0x18be, 415 => 0x18ee, 416 => 0x17f2, 418 => 0x105, 419 => 0x105, 428 => 0x604, 429 => 0x5e },
	'lensmount2' => { 432 => 0x8 },
	'lensprofilechromaticaberrationscale' => { 456 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 456 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 456 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 456 => 'LensProfileEnable' },
	'lensprofilefilename' => { 456 => 'LensProfileFilename' },
	'lensprofilematchkeycameramodelname' => { 456 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 456 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 456 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 456 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 456 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 456 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 456 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 456 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 456 => 'LensProfileName' },
	'lensprofilesetup' => { 456 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 456 => 'LensProfileVignettingScale' },
	'lensproperties' => { 280 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 32 => 0x16b, 59 => 0x0, 114 => 0xa435, 155 => 'SerialNumber', 280 => 0x202, 300 => 0x321, 302 => 0x52, 362 => 'LENS', 370 => 0x30, 452 => 'LensSerialNumber', 461 => 'LensSerialNumber' },
	'lensshutterlock' => { 175 => 0x4a },
	'lensspec' => { 384 => 0x0, 385 => 0x0, 386 => 0x0, 400 => 0xb02a },
	'lensspecfeatures' => { 418 => [0x115,0x116], 419 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 284 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 34 => 0x16, 177 => 0x10c, 178 => 0x49bd, 215 => 0x83, 280 => 0x201, 293 => 0x16, 297 => 0x310, 299 => 0x303, 300 => 0x303, 302 => 0x51, 304 => 0x3405, 329 => 0x0, 330 => 0x0, 331 => 0x1, 332 => 0x1, 333 => 0x1, 335 => 0x0, 376 => 0xa003, 379 => 0x27, 400 => 0xb027, 412 => 0x1896, 414 => 0x18c2, 415 => 0x18f2, 416 => 0x17f6, 418 => 0x109, 419 => 0x109, 428 => 0x608, 429 => 0x62 },
	'lenstype2' => { 389 => 0x3f7, 412 => 0x1893, 414 => 0x18bf, 415 => 0x18ef, 416 => 0x17f3, 418 => 0x107, 419 => 0x107, 428 => 0x605, 429 => 0x60 },
	'lenstype3' => { 432 => 0x9 },
	'lenszoomposition' => { 425 => 0x19, 426 => 0x1e, 429 => [0x342,0x35a] },
	'levelindicator' => { 310 => 0x15 },
	'levelmeter' => { 362 => ['Lvlm','lvlm'] },
	'levelorientation' => { 336 => 0x0 },
	'license' => { 453 => 'license' },
	'licensee' => { 289 => 'Licensee' },
	'licenseeid' => { 289 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 289 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 289 => 'LicenseeImageNotes' },
	'licenseename' => { 289 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 289 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 289 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 289 => 'LicenseeTransactionID' },
	'licenseid' => { 289 => 'LicenseID' },
	'licensestartdate' => { 289 => 'LicenseStartDate' },
	'licensetransactiondate' => { 289 => 'LicenseTransactionDate' },
	'licensetype' => { 458 => 'licensetype' },
	'licensor' => { 289 => 'Licensor' },
	'licensorcity' => { 289 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 289 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 289 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 289 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 289 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 289 => 'LicensorImageID' },
	'licensorname' => { 289 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 289 => 'LicensorNotes' },
	'licensorpostalcode' => { 289 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 289 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 289 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 289 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 289 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 289 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 289 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 289 => 'LicensorTransactionID' },
	'licensorurl' => { 289 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 284 => 0x1009 },
	'lightingmode' => { 108 => 0x302a },
	'lightreading' => { 337 => 0x15 },
	'lightsource' => { 114 => 0x9208, 215 => 0x90, 287 => 0x1000, 460 => 'LightSource' },
	'lightsourcespecial' => { 378 => 0x21d },
	'lightswitch' => { 275 => '0.1', 277 => '0.1' },
	'lightvaluecenter' => { 284 => 0x103d },
	'lightvalueperiphery' => { 284 => 0x103e },
	'limitafareamodeselection' => { 263 => '51.1', 265 => '49.1', 266 => '49.1', 275 => '49.1', 276 => '49.1' },
	'linearitylimitblue' => { 307 => 0x10 },
	'linearitylimitgreen' => { 307 => 0xf },
	'linearitylimitred' => { 307 => 0xe },
	'linearityuppermargin' => { 43 => [0x2ba,0x2d1,0x2d5], 45 => 0x1e5, 46 => [0x1fe,0x2de], 47 => [0x232,0x310], 48 => 0x31e },
	'linearizationtable' => { 114 => 0xc618 },
	'linearresponselimit' => { 114 => 0xc62e },
	'link' => { 470 => 'link' },
	'linkaetoafpoint' => { 318 => '14.2' },
	'linkedencodedrightsexpr' => { 466 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 466 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 466 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 466 => 'LinkedEncRightsExpr' },
	'linlogcoring' => { 132 => 0x904 },
	'lithostratigraphicterms' => { 113 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 267 => '32.1', 277 => '34.1' },
	'liveviewafareamode' => { 272 => '34.1' },
	'liveviewafmethod' => { 405 => 0x20 },
	'liveviewafmode' => { 272 => '34.2' },
	'liveviewafsetting' => { 389 => 0x36 },
	'liveviewbuttonoptions' => { 263 => '50.2', 265 => '48.2', 266 => '48.2', 275 => '48.2', 276 => '48.2' },
	'liveviewexposuresimulation' => { 79 => 0x810 },
	'liveviewfocusmode' => { 389 => [0x8b,0x28b] },
	'liveviewmetering' => { 389 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 263 => '21.2', 265 => '21.2', 266 => '21.2', 268 => '20.2', 269 => '20.2', 270 => '20.2', 272 => '20.2', 275 => '21.2', 276 => '21.2' },
	'liveviewshooting' => { 55 => 0x13 },
	'livingspecimen' => { 113 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 113 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 126 => 0x79 },
	'localizedcameramodel' => { 114 => 0xc615 },
	'locallocationname' => { 376 => 0x30 },
	'location' => { 214 => 0x9, 302 => 0x67, 448 => 'Location', 465 => 'Location', 469 => 'location', 470 => 'location' },
	'locationareacode' => { 454 => 'lac' },
	'locationbody' => { 356 => 'location.body' },
	'locationcreated' => { 466 => 'LocationCreated' },
	'locationcreatedcity' => { 466 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 466 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 466 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 466 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpslatitude' => { 466 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 466 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 466 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 466 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 466 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 466 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 466 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 466 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 356 => 'location.date' },
	'locationinfoversion' => { 214 => 0x0 },
	'locationname' => { 356 => 'location.name', 376 => 0x31 },
	'locationnote' => { 356 => 'location.note' },
	'locationrole' => { 356 => 'location.role' },
	'locationshown' => { 466 => 'LocationShown' },
	'locationshowncity' => { 466 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 466 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 466 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 466 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpslatitude' => { 466 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 466 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 466 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 466 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 466 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 466 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 466 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 466 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 79 => 0x709 },
	'logcomment' => { 480 => 'logComment' },
	'logscale' => { 132 => 0x902 },
	'longdescription' => { 354 => 'ldes' },
	'longexposurenoisereduction' => { 60 => 0x4, 79 => 0x201, 80 => 0x1, 81 => 0x2, 82 => 0x1, 83 => 0x1, 84 => 0x2, 85 => 0x1, 302 => 0x49, 387 => 0x2b, 388 => 0x25, 389 => 0x25, 400 => 0x2008, 405 => 0x11, 429 => 0x44 },
	'longexposurenoisereduction2' => { 55 => 0x8 },
	'longitude' => { 111 => 'Longitude' },
	'loop' => { 480 => 'loop' },
	'loopstyle' => { 362 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 113 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 456 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 456 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 456 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 456 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 456 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 456 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 456 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 456 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 103 => 0x150 },
	'luminancecurvepoints' => { 103 => 0x126 },
	'luminancenoisereduction' => { 98 => 0x20600, 104 => 0x5f, 379 => 0x1b },
	'luminancenoisereductioncontrast' => { 456 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 456 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 104 => 0x6d },
	'luminancesmoothing' => { 456 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 79 => [0x40b,0x40c] },
	'lyrics' => { 354 => "\xa9lyr", 362 => "\xa9lyr", 480 => 'lyrics' },
	'lyricsuri' => { 362 => 'lrcu' },
	'm16cversion' => { 297 => 0x333 },
	'macatom' => { 455 => 'macAtom' },
	'macatomapplicationcode' => { 455 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 455 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 455 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 113 => 'MachineObservation' },
	'machineobservationday' => { 113 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 113 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 113 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 113 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 113 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 113 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 113 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationfieldnotes' => { 113 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 113 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 113 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 113 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 113 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 113 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 113 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 113 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 113 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 113 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 113 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 113 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 113 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 122 => 0x1020, 124 => 0x202, 284 => 0x202, 368 => 0x21, 378 => 0x202, 400 => 0xb040 },
	'macroled' => { 282 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 55 => 0x10 },
	'macromode' => { 34 => 0x1, 172 => 0xb, 279 => 0x300, 302 => 0x1c, 369 => 0x1009 },
	'magentahsl' => { 98 => 0x20917 },
	'magicfilter' => { 279 => 0x52c },
	'magnifiedview' => { 81 => 0x11, 83 => 0x9 },
	'mainboardversion' => { 132 => 0x438 },
	'maindialexposurecomp' => { 273 => '0.6' },
	'mainingredient' => { 472 => 'mainIngredient' },
	'majorversion' => { 446 => 'MajorVersion' },
	'make' => { 93 => 0x0, 110 => 0x1, 114 => 0x10f, 148 => 'Make', 292 => 'Make', 307 => 0x10f, 356 => 'make', 362 => "\xa9mak", 469 => 'make', 476 => 'Make' },
	'makernote' => { 460 => 'MakerNote' },
	'makernoteapple' => { 112 => 'MakN', 114 => 0x927c },
	'makernotecanon' => { 112 => 'MakN', 114 => 0x927c },
	'makernotecasio' => { 112 => 'MakN', 114 => 0x927c },
	'makernotecasio2' => { 112 => 'MakN', 114 => 0x927c },
	'makernotedji' => { 112 => 'MakN', 114 => 0x927c },
	'makernoteflir' => { 112 => 'MakN', 114 => 0x927c },
	'makernotefujifilm' => { 112 => 'MakN', 114 => 0x927c },
	'makernotege' => { 112 => 'MakN', 114 => 0x927c },
	'makernotege2' => { 112 => 'MakN', 114 => 0x927c },
	'makernotehasselblad' => { 112 => 'MakN', 114 => 0x927c },
	'makernotehp' => { 112 => 'MakN', 114 => 0x927c },
	'makernotehp2' => { 112 => 'MakN', 114 => 0x927c },
	'makernotehp4' => { 112 => 'MakN', 114 => 0x927c },
	'makernotehp6' => { 112 => 'MakN', 114 => 0x927c },
	'makernoteisl' => { 112 => 'MakN', 114 => 0x927c },
	'makernotejvc' => { 112 => 'MakN', 114 => 0x927c },
	'makernotejvctext' => { 112 => 'MakN', 114 => 0x927c },
	'makernotekodak10' => { 112 => 'MakN', 114 => 0x927c },
	'makernotekodak11' => { 112 => 'MakN', 114 => 0x927c },
	'makernotekodak12' => { 112 => 'MakN', 114 => 0x927c },
	'makernotekodak1a' => { 112 => 'MakN', 114 => 0x927c },
	'makernotekodak1b' => { 112 => 'MakN', 114 => 0x927c },
	'makernotekodak2' => { 112 => 'MakN', 114 => 0x927c },
	'makernotekodak3' => { 112 => 'MakN', 114 => 0x927c },
	'makernotekodak4' => { 112 => 'MakN', 114 => 0x927c },
	'makernotekodak5' => { 112 => 'MakN', 114 => 0x927c },
	'makernotekodak6a' => { 112 => 'MakN', 114 => 0x927c },
	'makernotekodak6b' => { 112 => 'MakN', 114 => 0x927c },
	'makernotekodak7' => { 112 => 'MakN', 114 => 0x927c },
	'makernotekodak8a' => { 112 => 'MakN', 114 => 0x927c },
	'makernotekodak8b' => { 112 => 'MakN', 114 => 0x927c },
	'makernotekodak8c' => { 112 => 'MakN', 114 => 0x927c },
	'makernotekodak9' => { 112 => 'MakN', 114 => 0x927c },
	'makernotekodakunknown' => { 112 => 'MakN', 114 => 0x927c },
	'makernotekyocera' => { 112 => 'MakN', 114 => 0x927c },
	'makernoteleica' => { 112 => 'MakN', 114 => 0x927c },
	'makernoteleica10' => { 112 => 'MakN', 114 => 0x927c },
	'makernoteleica2' => { 112 => 'MakN', 114 => 0x927c },
	'makernoteleica3' => { 112 => 'MakN', 114 => 0x927c },
	'makernoteleica4' => { 112 => 'MakN', 114 => 0x927c },
	'makernoteleica5' => { 112 => 'MakN', 114 => 0x927c },
	'makernoteleica6' => { 112 => 'MakN', 114 => 0x927c },
	'makernoteleica7' => { 112 => 'MakN', 114 => 0x927c },
	'makernoteleica8' => { 112 => 'MakN', 114 => 0x927c },
	'makernoteleica9' => { 112 => 'MakN', 114 => 0x927c },
	'makernoteminolta' => { 112 => 'MakN', 114 => 0x927c },
	'makernoteminolta2' => { 112 => 'MakN', 114 => 0x927c },
	'makernoteminolta3' => { 112 => 'MakN', 114 => 0x927c },
	'makernotemotorola' => { 112 => 'MakN', 114 => 0x927c },
	'makernotenikon' => { 112 => 'MakN', 114 => 0x927c },
	'makernotenikon2' => { 112 => 'MakN', 114 => 0x927c },
	'makernotenikon3' => { 112 => 'MakN', 114 => 0x927c },
	'makernotenintendo' => { 112 => 'MakN', 114 => 0x927c },
	'makernoteoffset' => { 378 => 0xff },
	'makernoteolympus' => { 112 => 'MakN', 114 => 0x927c },
	'makernoteolympus2' => { 112 => 'MakN', 114 => 0x927c },
	'makernotepanasonic' => { 112 => 'MakN', 114 => 0x927c },
	'makernotepanasonic2' => { 112 => 'MakN', 114 => 0x927c },
	'makernotepanasonic3' => { 112 => 'MakN', 114 => 0x927c },
	'makernotepentax' => { 112 => 'MakN', 114 => 0x927c },
	'makernotepentax2' => { 112 => 'MakN', 114 => 0x927c },
	'makernotepentax3' => { 112 => 'MakN', 114 => 0x927c },
	'makernotepentax4' => { 112 => 'MakN', 114 => 0x927c },
	'makernotepentax5' => { 112 => 'MakN', 114 => 0x927c },
	'makernotepentax6' => { 112 => 'MakN', 114 => 0x927c },
	'makernotepentaxunknown' => { 362 => 'PXMN' },
	'makernotephaseone' => { 112 => 'MakN', 114 => 0x927c },
	'makernotereconyx' => { 112 => 'MakN', 114 => 0x927c },
	'makernotereconyx2' => { 112 => 'MakN', 114 => 0x927c },
	'makernotereconyx3' => { 112 => 'MakN', 114 => 0x927c },
	'makernotericoh' => { 112 => 'MakN', 114 => 0x927c },
	'makernotericoh2' => { 112 => 'MakN', 114 => 0x927c },
	'makernotericohpentax' => { 112 => 'MakN', 114 => 0x927c },
	'makernotericohtext' => { 112 => 'MakN', 114 => 0x927c },
	'makernotesafety' => { 114 => 0xc635 },
	'makernotesamsung1a' => { 112 => 'MakN', 114 => 0x927c },
	'makernotesamsung1b' => { 112 => 'MakN', 114 => 0x927c },
	'makernotesamsung2' => { 112 => 'MakN', 114 => 0x927c },
	'makernotesanyo' => { 112 => 'MakN', 114 => 0x927c },
	'makernotesanyoc4' => { 112 => 'MakN', 114 => 0x927c },
	'makernotesanyopatch' => { 112 => 'MakN', 114 => 0x927c },
	'makernotesigma' => { 112 => 'MakN', 114 => 0x927c },
	'makernotesigma3' => { 112 => 'MakN', 114 => 0x927c },
	'makernotesony' => { 112 => 'MakN', 114 => 0x927c },
	'makernotesony2' => { 112 => 'MakN', 114 => 0x927c },
	'makernotesony3' => { 112 => 'MakN', 114 => 0x927c },
	'makernotesony4' => { 112 => 'MakN', 114 => 0x927c },
	'makernotesony5' => { 112 => 'MakN', 114 => 0x927c },
	'makernotesonyericsson' => { 112 => 'MakN', 114 => 0x927c },
	'makernotesonysrf' => { 112 => 'MakN', 114 => 0x927c },
	'makernotetype' => { 369 => 0x1 },
	'makernoteunknown' => { 112 => 'MakN', 114 => 0x927c },
	'makernoteunknownbinary' => { 112 => 'MakN', 114 => 0x927c },
	'makernoteunknowntext' => { 112 => 'MakN', 114 => 0x927c },
	'makernoteversion' => { 177 => 0x0, 215 => 0x1, 284 => 0x0, 302 => 0x8000, 373 => 0x0, 376 => 0x1, 379 => [0x1d,0x1f], 390 => 0x2000 },
	'makerurl' => { 362 => "\xa9mal" },
	'managedfrom' => { 481 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 481 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 481 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 481 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 481 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 481 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 481 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 481 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 481 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 481 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 481 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 481 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 481 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 481 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 481 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 481 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 481 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 481 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 481 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 481 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 481 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 481 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 481 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 481 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 481 => 'Manager' },
	'managervariant' => { 481 => 'ManagerVariant' },
	'manageto' => { 481 => 'ManageTo' },
	'manageui' => { 481 => 'ManageUI' },
	'manifest' => { 481 => 'Manifest' },
	'manifestlinkform' => { 481 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 481 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 481 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 481 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 481 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 481 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 481 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 481 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 481 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 481 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 481 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 481 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 481 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 481 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 481 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 481 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 481 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 481 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 481 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 481 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 481 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 481 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 481 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 481 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 481 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 481 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 481 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 481 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 279 => 0x900, 302 => 0x86 },
	'manometerreading' => { 279 => 0x901 },
	'manualafpointselectpattern' => { 79 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 282 => 0x1209 },
	'manualflashoutput' => { 34 => 0x29, 264 => '8.2', 267 => '22.2', 268 => '23.1', 269 => '23.2', 271 => '16.2', 272 => '23.2', 273 => '8.2', 274 => '23.2', 277 => '24.2', 369 => 0x100c },
	'manualflashstrength' => { 279 => 0x406 },
	'manualfocusdistance' => { 215 => 0x85, 284 => 0x100c, 378 => 0x223 },
	'manualtv' => { 78 => 0x5, 79 => 0x705 },
	'manufacturedate' => { 182 => 0x6705, 317 => 0x1 },
	'manufacturedate1' => { 371 => 0x4 },
	'manufacturedate2' => { 371 => 0x5 },
	'manufacturer' => { 440 => 'Manufacturer', 469 => 'manufacturer' },
	'mariahchromablursize' => { 132 => 0xf0d },
	'mariahmaphithreshold' => { 132 => 0xf0c },
	'mariahmaplothreshold' => { 132 => 0xf0b },
	'mariahsigmathreshold' => { 132 => 0xf0e },
	'mariahtexturethreshold' => { 132 => 0xf0a },
	'marked' => { 467 => 'Marked', 484 => 'Marked' },
	'markers' => { 480 => 'markers' },
	'markerscomment' => { 480 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 480 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 480 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 480 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 480 => [\'markers','markersCuePointType'] },
	'markersduration' => { 480 => [\'markers','markersDuration'] },
	'markerslocation' => { 480 => [\'markers','markersLocation'] },
	'markersname' => { 480 => [\'markers','markersName'] },
	'markersprobability' => { 480 => [\'markers','markersProbability'] },
	'markersspeaker' => { 480 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 480 => [\'markers','markersStartTime'] },
	'markerstarget' => { 480 => [\'markers','markersTarget'] },
	'markerstype' => { 480 => [\'markers','markersType'] },
	'maskedareas' => { 114 => 0xc68e },
	'masterdocumentid' => { 126 => 0xb9 },
	'mastergain' => { 223 => 0x50 },
	'materialsample' => { 113 => 'MaterialSample' },
	'materialsampleid' => { 113 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 263 => '50.1', 265 => '48.1', 266 => '48.1', 275 => '48.1', 276 => '48.1' },
	'matrixselectk' => { 132 => 0x91b },
	'matrixselectthreshold' => { 132 => 0x91a },
	'matrixselectthreshold1' => { 132 => 0x91e },
	'matrixselectthreshold2' => { 132 => 0x91f },
	'matrixstructure' => { 361 => 0xa },
	'maxaperture' => { 34 => 0x1a, 132 => 0x3f9, 138 => 0x6103, 155 => 'MaxAperture', 172 => 0x17, 178 => 0x49c5, 213 => 0x36, 280 => 0x20a, 328 => '14.1' },
	'maxapertureatmaxfocal' => { 122 => 0x1407, 155 => 'MaxApertureAtMaxFocal', 207 => 0xb, 208 => 0x10, 209 => 0x11, 213 => 0x12, 280 => 0x206 },
	'maxapertureatminfocal' => { 122 => 0x1406, 207 => 0xa, 208 => 0xf, 209 => 0x10, 213 => 0x11, 280 => 0x205 },
	'maxaperturevalue' => { 114 => 0x9205, 346 => 0x414, 460 => 'MaxApertureValue' },
	'maxavailheight' => { 466 => 'MaxAvailHeight' },
	'maxavailwidth' => { 466 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 262 => 0xb, 263 => 0xc, 265 => '12.1', 266 => '12.1', 271 => 0xc, 272 => 0xb, 275 => '12.1', 276 => '12.1' },
	'maxfaces' => { 283 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 34 => 0x17, 122 => 0x1405, 155 => 'MaxFocalLength', 207 => 0x9, 208 => 0xe, 209 => 0xf, 213 => 0x10, 280 => 0x208, 412 => 0x127c, 413 => 0x1138, 414 => 0x330, 415 => 0x330, 416 => 0x30e },
	'maximumdensityrange' => { 128 => 0x8c },
	'maxpagesize' => { 485 => 'MaxPageSize' },
	'maxpagesizeh' => { 485 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 485 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 485 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 132 => 0xc7d },
	'maxsamplevalue' => { 114 => 0x119 },
	'maxstorage' => { 475 => 'maxstorage' },
	'mb-d10batteries' => { 262 => '12.6' },
	'mb-d10batterytype' => { 271 => '13.3' },
	'mb-d11batterytype' => { 272 => '2.3' },
	'mb-d12batterytype' => { 275 => '3.2' },
	'mb-d80batteries' => { 273 => '6.5' },
	'mb-d80batterytype' => { 277 => '3.2' },
	'mcuversion' => { 207 => 0xc, 208 => 0x11, 209 => 0x12, 213 => 0x13 },
	'md5digest' => { 156 => 'zmd5' },
	'mditemfindercomment' => { 165 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 165 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 165 => 'MDItemFSLabel' },
	'mditemusertags' => { 165 => 'MDItemUserTags' },
	'meal' => { 472 => 'meal' },
	'measuredev' => { 28 => 0x9, 73 => 0x3, 92 => 0x1814, 148 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 73 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 178 => 0x690, 297 => 0x312, 300 => 0x312, 301 => 0x312, 304 => 0x3407 },
	'measuredrggb' => { 62 => 0x1 },
	'measuredrggbdata' => { 42 => 0x287 },
	'measurementaccuracy' => { 113 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 113 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 113 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 113 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 113 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 113 => 'MeasurementOrFact' },
	'measurementremarks' => { 113 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 113 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 113 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 113 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 440 => 'MeasureType' },
	'mechanicalshuttercount' => { 215 => 0x37 },
	'mediaconstraints' => { 289 => 'MediaConstraints' },
	'mediacreatedate' => { 358 => 0x1 },
	'mediaeventiddate' => { 445 => 'MediaEventIdDate' },
	'mediamodifydate' => { 358 => 0x2 },
	'mediasummarycode' => { 289 => 'MediaSummaryCode' },
	'mediatype' => { 354 => 'stik' },
	'memoaudioquality' => { 79 => 0x812 },
	'memorycardconfiguration' => { 393 => 0x16 },
	'memorycardnumber' => { 198 => 0x2 },
	'menubuttondisplayposition' => { 77 => 0xb, 80 => 0xa, 81 => 0xb, 84 => 0xb },
	'menubuttonreturn' => { 85 => 0xb },
	'menumonitorofftime' => { 262 => '26.1', 263 => '22.1', 265 => '22.1', 266 => '22.1', 270 => '21.1', 271 => '8.2', 272 => '21.1', 275 => '22.1', 276 => '22.1', 277 => '22.1' },
	'metadatadate' => { 478 => 'MetadataDate' },
	'metadatamoddate' => { 480 => 'metadataModDate' },
	'metaversion' => { 407 => 0x34 },
	'meterinfo1row1' => { 401 => 0x0, 402 => 0x0 },
	'meterinfo1row2' => { 401 => 0x6c, 402 => 0x5a },
	'meterinfo1row3' => { 401 => 0xd8, 402 => 0xb4 },
	'meterinfo1row4' => { 401 => 0x144, 402 => 0x10e },
	'meterinfo1row5' => { 401 => 0x1b0, 402 => 0x168 },
	'meterinfo1row6' => { 401 => 0x21c, 402 => 0x1c2 },
	'meterinfo1row7' => { 401 => 0x288, 402 => 0x21c },
	'meterinfo2row1' => { 401 => 0x2f4, 402 => 0x276 },
	'meterinfo2row2' => { 401 => 0x378, 402 => 0x2e4 },
	'meterinfo2row3' => { 401 => 0x3fc, 402 => 0x352 },
	'meterinfo2row4' => { 401 => 0x480, 402 => 0x3c0 },
	'meterinfo2row5' => { 401 => 0x504, 402 => 0x42e },
	'meterinfo2row6' => { 401 => 0x588, 402 => 0x49c },
	'meterinfo2row7' => { 401 => 0x60c, 402 => 0x50a },
	'meterinfo2row8' => { 401 => 0x690, 402 => 0x578 },
	'meterinfo2row9' => { 401 => 0x714, 402 => 0x5e6 },
	'metering' => { 264 => '6.1' },
	'meteringmode' => { 34 => 0x11, 114 => 0x9207, 134 => 0x1c, 172 => 0x7, 173 => 0x25, 175 => 0x12, 279 => 0x202, 337 => 0x17, 379 => 0x9, 387 => 0x15, 388 => 0x13, 389 => 0x7, 405 => 0x3, 408 => 0x1174, 409 => 0x1178, 410 => 0x1154, 411 => 0x11d0, 412 => 0x11ac, 413 => 0x1064, 414 => 0x25c, 415 => 0x25c, 416 => 0x24b, 460 => 'MeteringMode' },
	'meteringmode2' => { 318 => '2.1', 400 => 0x202c },
	'meteringmode3' => { 318 => '16.1' },
	'meteringoffscaleindicator' => { 175 => 0x53 },
	'meteringtime' => { 262 => '22.2', 264 => '3.2', 267 => '17.1', 268 => '18.1', 271 => '7.3', 272 => '18.1', 273 => '3.2', 277 => '19.1' },
	'micro1version' => { 364 => 0x1f },
	'micro2version' => { 364 => 0x2d },
	'midrangesharpness' => { 219 => 0x3b },
	'mieversion' => { 156 => '0Vers' },
	'mime' => { 440 => 'Mime' },
	'minaperture' => { 34 => 0x1b, 132 => 0x3f8, 155 => 'MinAperture', 328 => '0.2' },
	'minaperturevalue' => { 346 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 34 => 0x18, 122 => 0x1404, 155 => 'MinFocalLength', 207 => 0x8, 208 => 0xd, 209 => 0xe, 213 => 0xf, 280 => 0x207, 412 => 0x127a, 413 => 0x1136, 414 => 0x32e, 415 => 0x32e, 416 => 0x30c },
	'minfocusdistance' => { 328 => 0x3 },
	'minintegrationrows' => { 132 => 0x1874 },
	'minoltadate' => { 172 => 0x15 },
	'minoltaimagesize' => { 172 => 0x4, 173 => 0xc, 174 => 0x2, 177 => 0x103 },
	'minoltamodelid' => { 172 => 0x25 },
	'minoltaquality' => { 172 => 0x5, 173 => 0xd, 174 => 0x3, 177 => [0x102,0x103] },
	'minoltatime' => { 172 => 0x16 },
	'minormodelagedisclosure' => { 289 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 446 => 'MinorVersion' },
	'minsamplevalue' => { 114 => 0x118 },
	'mirrorlockup' => { 77 => 0xc, 78 => 0xc, 79 => 0x60f, 80 => 0xb, 81 => 0xc, 82 => 0x6, 83 => 0x6, 84 => 0xc, 85 => 0x3 },
	'mobilecountrycode' => { 454 => 'mcc' },
	'mobilenetworkcode' => { 454 => 'mnc' },
	'moddate' => { 292 => 'modify-date', 467 => 'ModDate' },
	'modedialposition' => { 393 => 0x14 },
	'model' => { 93 => 0x6, 114 => 0x110, 148 => 'Model', 292 => 'Model', 307 => 0x110, 337 => 0x23f, 356 => 'model', 362 => ['CNMN','cmnm',"\xa9mdl","\xa9mod"], 379 => 0x84, 440 => 'Model', 469 => 'model', 476 => 'Model' },
	'modelage' => { 466 => 'ModelAge' },
	'modelid' => { 278 => 0x0 },
	'modelingflash' => { 262 => '21.4', 263 => '31.1', 265 => '31.1', 266 => '31.1', 271 => '26.4', 272 => '30.2', 273 => '7.4', 274 => '30.1', 275 => '31.1', 276 => '31.1', 277 => '31.3' },
	'modelreleaseid' => { 289 => 'ModelReleaseID' },
	'modelreleasestatus' => { 289 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 420 => 0x52, 421 => 0x46, 422 => 0x53 },
	'modeltiepoint' => { 114 => 0x8482 },
	'modeltransform' => { 114 => 0x85d8 },
	'modelyear' => { 469 => 'modelYear' },
	'modificationdate' => { 470 => 'modificationDate' },
	'modifiedcolortemp' => { 63 => 0x9 },
	'modifieddigitalgain' => { 63 => 0xb },
	'modifiedparamflag' => { 56 => 0x1 },
	'modifiedpicturestyle' => { 63 => 0xa },
	'modifiedsaturation' => { 279 => 0x504 },
	'modifiedsensorbluelevel' => { 63 => 0x5 },
	'modifiedsensorredlevel' => { 63 => 0x4 },
	'modifiedsharpness' => { 63 => 0x2 },
	'modifiedsharpnessfreq' => { 63 => 0x3 },
	'modifiedtonecurve' => { 63 => 0x1 },
	'modifiedwhitebalance' => { 63 => 0x8 },
	'modifiedwhitebalanceblue' => { 63 => 0x7 },
	'modifiedwhitebalancered' => { 63 => 0x6 },
	'modifydate' => { 114 => 0x132, 149 => 'ModifyDate', 288 => 'ModDate', 290 => 'tIME', 353 => 'ModDate', 359 => 0x2, 478 => 'ModifyDate' },
	'moirefilter' => { 114 => 0xfe58, 456 => 'MoireFilter' },
	'monitordisplayoff' => { 175 => 0x4c },
	'monitormatrix' => { 132 => 0x8fc },
	'monitorofftime' => { 262 => '18.2', 264 => '3.1', 273 => '3.1' },
	'monochromecolor' => { 279 => 0x53b },
	'monochromecontrast' => { 104 => 0x3c },
	'monochromefiltereffect' => { 98 => 0x20307, 104 => 0x3a, 337 => 0x73 },
	'monochromelinear' => { 104 => 0x3d },
	'monochromeoutputhighlightpoint' => { 104 => 0x41 },
	'monochromeoutputshadowpoint' => { 104 => 0x42 },
	'monochromeprofilesettings' => { 279 => 0x537 },
	'monochromerawhighlight' => { 104 => 0x7a },
	'monochromerawhighlightpoint' => { 104 => 0x3f },
	'monochromerawshadow' => { 104 => 0x83 },
	'monochromerawshadowpoint' => { 104 => 0x40 },
	'monochromesharpness' => { 104 => 0x3e },
	'monochrometoning' => { 337 => 0x74 },
	'monochrometoningeffect' => { 98 => 0x20306, 104 => 0x3b },
	'monochromeunsharpmaskfineness' => { 104 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 104 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 104 => 0xb4 },
	'monochromevignetting' => { 279 => 0x53a },
	'monthdaycreated' => { 134 => 0x12, 143 => 0xe },
	'moonphase' => { 363 => 0x12, 364 => 0x43, 365 => 0x4c },
	'morepermissions' => { 453 => 'morePermissions' },
	'motionsensitivity' => { 363 => 0x29, 365 => 0x60 },
	'movieaelockbuttonassignment' => { 275 => '40.1' },
	'moviefunc1button' => { 265 => '41.1', 266 => '41.1', 276 => '41.1' },
	'moviefunctionbutton' => { 263 => '41.1', 275 => '41.1' },
	'moviefunctionbuttonplusdials' => { 263 => '52.1' },
	'moviepreviewbutton' => { 263 => '41.2', 265 => '41.2', 266 => '41.2', 275 => '41.2', 276 => '41.2' },
	'moviepreviewbuttonplusdials' => { 263 => '52.2' },
	'movieshutterbutton' => { 263 => '38.3', 265 => '38.3', 266 => '38.3', 275 => '38.3', 276 => '38.3' },
	'moviesubselectorassignment' => { 263 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 263 => '53.1' },
	'multiburstimageheight' => { 400 => 0x1002 },
	'multiburstimagewidth' => { 400 => 0x1001 },
	'multiburstmode' => { 400 => 0x1000 },
	'multicontrollerwhilemetering' => { 79 => 0x517 },
	'multiexposure' => { 65 => 0x1, 302 => 0xb4 },
	'multiexposureautogain' => { 216 => 0x3 },
	'multiexposurecontrol' => { 65 => 0x2 },
	'multiexposuremode' => { 216 => 0x1 },
	'multiexposureshots' => { 65 => 0x3, 216 => 0x2 },
	'multiframenoisereduction' => { 389 => 0x35, 400 => 0x200b, 405 => 0x15 },
	'multiframenreffect' => { 400 => 0x2023 },
	'multifunctionlock' => { 79 => 0x70f },
	'multipleexposuremode' => { 283 => 0x101c },
	'multipleexposureset' => { 318 => '10.1' },
	'multisample' => { 223 => 0x40 },
	'multiselector' => { 262 => '9.4', 263 => '10.3', 265 => '10.3', 266 => '10.3', 271 => '27.4', 275 => '10.3', 276 => '10.3' },
	'multiselectorliveview' => { 262 => '4.3', 265 => '37.1', 266 => '37.1', 275 => '37.1', 276 => '37.1' },
	'multiselectorliveviewmode' => { 233 => 0x18c2 },
	'multiselectorplaybackmode' => { 262 => ['13.5','9.2'], 263 => '10.2', 266 => '10.2', 271 => '27.2', 275 => '10.2', 276 => '10.2' },
	'multiselectorshootmode' => { 262 => '9.1', 263 => '10.1', 265 => '10.1', 266 => '10.1', 271 => '27.1', 275 => '10.1', 276 => '10.1' },
	'multishot' => { 307 => 0x121 },
	'mute' => { 356 => 'player.movie.audio.mute' },
	'mycolormode' => { 66 => 0x2 },
	'name' => { 362 => 'name' },
	'narrator' => { 354 => "\xa9nrt" },
	'nationalcatalognumber' => { 470 => 'nationalCatalogNumber' },
	'nativedigest' => { 460 => 'NativeDigest', 476 => 'NativeDigest' },
	'ndfilter' => { 73 => 0x1c, 279 => 0x204, 369 => 0x1019 },
	'near' => { 440 => 'Near' },
	'nefbitdepth' => { 215 => 0xe22 },
	'nefcompression' => { 215 => 0x93 },
	'neflinearizationtable' => { 215 => 0x96 },
	'negativecachelargepreviewsize' => { 456 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 456 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 456 => 'NegativeCachePath' },
	'neutraldensityfilter' => { 337 => 0x88 },
	'neutraloutputhighlightpoint' => { 104 => 0x2f },
	'neutraloutputshadowpoint' => { 104 => 0x30 },
	'neutralrawcolortone' => { 104 => 0x28 },
	'neutralrawcontrast' => { 104 => 0x2a },
	'neutralrawhighlight' => { 104 => 0x78 },
	'neutralrawhighlightpoint' => { 104 => 0x2d },
	'neutralrawlinear' => { 104 => 0x2b },
	'neutralrawsaturation' => { 104 => 0x29 },
	'neutralrawshadow' => { 104 => 0x81 },
	'neutralrawshadowpoint' => { 104 => 0x2e },
	'neutralrawsharpness' => { 104 => 0x2c },
	'neutralunsharpmaskfineness' => { 104 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 104 => 0xa8 },
	'neutraunsharpmaskstrength' => { 104 => 0xa4 },
	'newrawimagedigest' => { 114 => 0xc7a7 },
	'newsphotoversion' => { 128 => 0x0 },
	'nickname' => { 478 => 'Nickname' },
	'nikoncapturedata' => { 215 => 0xe01 },
	'nikoncaptureeditversions' => { 215 => 0xe13 },
	'nikoncaptureoutput' => { 215 => 0xe1e },
	'nikoncaptureversion' => { 215 => 0xe09 },
	'nikoniccprofile' => { 215 => 0xe1d },
	'nikonimagesize' => { 230 => '723.1', 231 => '732.1', 240 => 0x2c4 },
	'noisefilter' => { 279 => 0x527 },
	'noiseprofile' => { 114 => 0xc761 },
	'noisereduction' => { 122 => [0x100b,0x100e], 173 => 0xb0, 174 => 0x60, 175 => 0x3f, 215 => 0x95, 255 => 0x753dcbc0, 256 => 0x17, 279 => 0x50a, 284 => 0x103a, 302 => 0x2d, 337 => 0x49, 369 => 0x100f, 371 => 0x2a },
	'noisereduction2' => { 283 => 0x1010 },
	'noisereductionapplied' => { 114 => 0xc6f7 },
	'noisereductionintensity' => { 256 => 0x9 },
	'noisereductionmethod' => { 256 => 0x11 },
	'noisereductionmode' => { 433 => 0x801e },
	'noisereductionparametersatcapture' => { 132 => 0xe73 },
	'noisereductionparameterscamera' => { 132 => 0xe72 },
	'noisereductionparametershost3mp' => { 132 => 0xe71 },
	'noisereductionparametershost6mp' => { 132 => 0xe70 },
	'noisereductionparametershostrgb' => { 132 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 132 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 132 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 132 => 0xe63 },
	'noisereductionparams' => { 307 => 0x1b },
	'noisereductionsharpness' => { 256 => 0xd },
	'noisereductionvalue' => { 433 => 0x8027 },
	'nomemorycard' => { 262 => '22.1', 263 => '4.2', 264 => '0.3', 267 => '2.4', 268 => '3.2', 269 => '3.2', 271 => '33.7', 272 => '3.2', 273 => '0.3', 275 => '4.2', 277 => '4.5' },
	'nominalmaxaperture' => { 328 => 0xa },
	'nominalminaperture' => { 328 => '10.1' },
	'normallinetime' => { 132 => 0x186a },
	'normalwhitelevel' => { 43 => [0x2b8,0x2cf,0x2d3], 45 => 0x1e3, 46 => [0x1fc,0x2dc], 47 => [0x230,0x30e], 48 => 0x31c },
	'notes' => { 434 => 'Notes', 450 => 'notes' },
	'npages' => { 485 => 'NPages' },
	'nullrecord' => { 92 => 0x0 },
	'numafpoints' => { 314 => 0x2 },
	'number' => { 470 => 'number' },
	'numberofbeats' => { 480 => 'numberOfBeats' },
	'numberoffocuspoints' => { 265 => '1.3', 266 => '1.3', 269 => '0.2', 270 => '0.3', 272 => '0.3' },
	'numfaceelements' => { 122 => 0x4200 },
	'numfacepositions' => { 294 => 0x0 },
	'numindexentries' => { 128 => 0x54 },
	'numwbentries' => { 308 => 0x0, 309 => 0x0 },
	'object' => { 470 => 'object' },
	'objectattributereference' => { 126 => 0x4 },
	'objectcycle' => { 126 => 0x4b, 450 => 'ObjectCycle' },
	'objectdescription' => { 469 => 'objectDescription' },
	'objectdistance' => { 107 => 0x6, 108 => 0x2022 },
	'objectname' => { 126 => 0x5 },
	'objectpreviewdata' => { 126 => 0xca },
	'objectpreviewfileformat' => { 126 => 0xc8 },
	'objectpreviewfileversion' => { 126 => 0xc9 },
	'objectsubtype' => { 469 => 'objectSubtype' },
	'objecttype' => { 469 => 'objectType' },
	'objecttypereference' => { 126 => 0x3 },
	'occurrence' => { 113 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 113 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 113 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 113 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 113 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 113 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 113 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 113 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 113 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 113 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 113 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 113 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 113 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 113 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 113 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 113 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 113 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 113 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 113 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 113 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 113 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 113 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 113 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 113 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 113 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 113 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 460 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 460 => [\'OECF','OECFNames'] },
	'oecfrows' => { 460 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 460 => [\'OECF','OECFValues'] },
	'offsaledate' => { 470 => 'offSaleDate' },
	'offsaledatea-platform' => { 470 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 470 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 132 => 0x190a },
	'offsetschema' => { 114 => 0xea1d },
	'offsettime' => { 114 => 0x9010 },
	'offsettimedigitized' => { 114 => 0x9012 },
	'offsettimeoriginal' => { 114 => 0x9011 },
	'okbutton' => { 272 => '15.1', 277 => '16.1' },
	'oldsubfiletype' => { 114 => 0xff },
	'olympusimageheight' => { 284 => 0x102f },
	'olympusimagewidth' => { 284 => 0x102e },
	'omenatcapturestrength' => { 132 => 0xa60 },
	'omenautostrength' => { 132 => 0xa5f },
	'omenearlystrength' => { 132 => 0xa5e },
	'omenfocallengthlimit' => { 132 => 0xa62 },
	'omeninitialipfstrength' => { 132 => 0xa5d },
	'omensurfaceindex' => { 132 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 284 => 0x302 },
	'onsaledate' => { 470 => 'onSaleDate' },
	'onsaledatea-platform' => { 470 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 470 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 470 => 'onSaleDay' },
	'onsaledaya-platform' => { 470 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 470 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 114 => 0xc740 },
	'opcodelist2' => { 114 => 0xc741 },
	'opcodelist3' => { 114 => 0xc74e },
	'opticalzoom' => { 136 => 0xfa3d, 138 => [0x6006,0xf006], 139 => 0x1000, 140 => 0xf, 143 => 0x1e, 155 => 'OpticalZoom' },
	'opticalzoomcode' => { 73 => 0xa },
	'opticalzoommode' => { 302 => 0x34 },
	'opticalzoomon' => { 378 => 0x219 },
	'optionenddate' => { 473 => 'optionEndDate' },
	'opto-electricconvfactor' => { 460 => 'OECF' },
	'orangehsl' => { 98 => 0x20911 },
	'ordernumber' => { 122 => 0x8002 },
	'organisationinimagecode' => { 466 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 466 => 'OrganisationInImageName' },
	'organism' => { 113 => 'Organism' },
	'organismassociatedoccurrences' => { 113 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 113 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 113 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 113 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 113 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 113 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 113 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 470 => 'organization' },
	'orientation' => { 114 => 0x112, 307 => 0x112, 469 => 'orientation', 476 => 'Orientation' },
	'orientation2' => { 405 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 79 => 0x516 },
	'originalbestqualitysize' => { 114 => 0xc792 },
	'originalcreatedatetime' => { 445 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 109 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 61 => 0x83 },
	'originaldefaultcropsize' => { 114 => 0xc793 },
	'originaldefaultfinalsize' => { 114 => 0xc791 },
	'originaldirectory' => { 299 => 0x408 },
	'originaldocumentid' => { 481 => 'OriginalDocumentID' },
	'originalfilename' => { 92 => 0x816, 132 => 0x3e9, 144 => 0x20, 299 => 0x407, 445 => 'OriginalFilename' },
	'originalimageheight' => { 75 => 0xc, 118 => 0x1 },
	'originalimagewidth' => { 75 => 0xb, 118 => 0x0 },
	'originalrawfiledata' => { 114 => 0xc68c },
	'originalrawfiledigest' => { 114 => 0xc71d },
	'originalrawfilename' => { 114 => 0xc68b },
	'originaltransmissionreference' => { 126 => 0x67 },
	'originatingprogram' => { 126 => 0x41, 450 => 'OriginatingProgram' },
	'originplatform' => { 470 => 'originPlatform' },
	'os' => { 458 => 'os' },
	'otherconditions' => { 289 => 'OtherConditions' },
	'otherconstraints' => { 289 => 'OtherConstraints' },
	'otherimage' => { 109 => 'OtherImage' },
	'otherimageinfo' => { 289 => 'OtherImageInfo' },
	'otherimagelength' => { 114 => 0x202 },
	'otherimagestart' => { 114 => 0x201 },
	'otherlicensedocuments' => { 289 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 289 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 289 => 'OtherLicenseRequirements' },
	'outcue' => { 480 => 'outCue' },
	'outcuescale' => { 480 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 480 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 187 => 0x3 },
	'outputimagewidth' => { 187 => 0x2 },
	'outputlut' => { 302 => 0xa7 },
	'outputprofile' => { 132 => 0x138b },
	'outputresolution' => { 187 => 0x4 },
	'overclockcols' => { 132 => 0x189c },
	'overclockrows' => { 132 => 0x18c4 },
	'owner' => { 484 => 'Owner' },
	'ownerid' => { 126 => 0xbc },
	'ownername' => { 15 => 0x10f, 61 => 0x9, 92 => 0x810, 114 => [0xa430,0xfde8], 148 => 'OwnerName', 452 => 'OwnerName', 461 => 'CameraOwnerName' },
	'padding' => { 114 => 0xea1c },
	'pagecount' => { 470 => 'pageCount' },
	'pageimage' => { 478 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 478 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 478 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 478 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 478 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 478 => 'PageInfo' },
	'pagename' => { 114 => 0x11d },
	'pagenumber' => { 114 => 0x129 },
	'pageprogressiondirection' => { 470 => 'pageProgressionDirection' },
	'pagerange' => { 470 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 456 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 456 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicdatetime' => { 305 => 0x0 },
	'panasonicexifversion' => { 302 => 0x26 },
	'panasonicimageheight' => { 302 => 0x4c },
	'panasonicimagewidth' => { 302 => 0x4b },
	'panasonicrawversion' => { 307 => 0x1 },
	'panasonictitle' => { 114 => 0xc6d2 },
	'panasonictitle2' => { 114 => 0xc6d3 },
	'panoramaangle' => { 122 => 0x1153 },
	'panoramacropbottom' => { 406 => 0x7 },
	'panoramacropleft' => { 406 => 0x4 },
	'panoramacropright' => { 406 => 0x6 },
	'panoramacroptop' => { 406 => 0x5 },
	'panoramadirection' => { 69 => 0x5, 122 => 0x1154, 406 => 0x3 },
	'panoramaframeheight' => { 406 => 0x9 },
	'panoramaframenumber' => { 69 => 0x2 },
	'panoramaframewidth' => { 406 => 0x8 },
	'panoramafullheight' => { 406 => 0x2 },
	'panoramafullwidth' => { 406 => 0x1 },
	'panoramamode' => { 134 => 0x3c, 279 => 0x601 },
	'panoramasize3d' => { 389 => 0x38 },
	'panoramasourceheight' => { 406 => 0xb },
	'panoramasourcewidth' => { 406 => 0xa },
	'panoramicstitchcameramotion' => { 168 => 'PanoramicStitchCameraMotion', 169 => 0x1 },
	'panoramicstitchmaptype' => { 168 => 'PanoramicStitchMapType', 169 => 0x2 },
	'panoramicstitchphi0' => { 168 => 'PanoramicStitchPhi0', 169 => 0x5 },
	'panoramicstitchphi1' => { 168 => 'PanoramicStitchPhi1', 169 => 0x6 },
	'panoramicstitchtheta0' => { 168 => 'PanoramicStitchTheta0', 169 => 0x3 },
	'panoramicstitchtheta1' => { 168 => 'PanoramicStitchTheta1', 169 => 0x4 },
	'panoramicstitchversion' => { 169 => 0x0 },
	'pantry' => { 481 => 'Pantry' },
	'parallax' => { 122 => 0xb211, 278 => 0x28 },
	'parametricdarks' => { 456 => 'ParametricDarks' },
	'parametrichighlights' => { 456 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 456 => 'ParametricHighlightSplit' },
	'parametriclights' => { 456 => 'ParametricLights' },
	'parametricmidtonesplit' => { 456 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 456 => 'ParametricShadows' },
	'parametricshadowsplit' => { 456 => 'ParametricShadowSplit' },
	'parentmediaeventid' => { 445 => 'ParentMediaEventID' },
	'parentmeid' => { 445 => 'ParentMEID' },
	'parentproductid' => { 354 => '@ppi' },
	'parentreference1' => { 464 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 464 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 464 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 464 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 464 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 464 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 354 => '@PST' },
	'parenttitle' => { 354 => '@pti' },
	'partialactivecols1' => { 132 => 0x17e8 },
	'partialactivecols2' => { 132 => 0x17f2 },
	'partialactiverows1' => { 132 => 0x17fc },
	'partialactiverows2' => { 132 => 0x1806 },
	'partofcompilation' => { 480 => 'partOfCompilation' },
	'patientbirthdate' => { 435 => 'PatientDOB' },
	'patientid' => { 435 => 'PatientID' },
	'patientname' => { 435 => 'PatientName' },
	'patientsex' => { 435 => 'PatientSex' },
	'patternareaheight' => { 132 => 0x963 },
	'patternareawidth' => { 132 => 0x962 },
	'patterncorrectionfactorscale' => { 132 => 0x969 },
	'patterncropcols1' => { 132 => 0x96c },
	'patterncropcols2' => { 132 => 0x96d },
	'patterncroprows1' => { 132 => 0x96a },
	'patterncroprows2' => { 132 => 0x96b },
	'patternimagerheight' => { 132 => 0x961 },
	'patternimagerwidth' => { 132 => 0x960 },
	'patternx' => { 132 => 0x966 },
	'patterny' => { 132 => 0x967 },
	'pdfversion' => { 467 => 'PDFVersion' },
	'pentaximagesize' => { 337 => 0x9 },
	'pentaxmodelid' => { 317 => 0x0, 337 => 0x5 },
	'pentaxmodeltype' => { 337 => 0x1 },
	'pentaxversion' => { 337 => 0x0 },
	'people' => { 436 => 'People', 448 => 'People' },
	'perchannelblacklevel' => { 42 => 0xc4, 43 => [0x2b4,0x2cb,0x2cf], 44 => [0x108,0x14d], 45 => 0x1df, 46 => [0x1f8,0x2d8], 47 => [0x22c,0x30a], 48 => 0x149 },
	'performer' => { 354 => 'perf', 362 => 'perf' },
	'performerkeywords' => { 362 => "\xa9prk" },
	'performers' => { 362 => "\xa9prf" },
	'performerurl' => { 362 => "\xa9prl" },
	'peripheralillumcentralradius' => { 433 => 0x8030 },
	'peripheralillumcentralvalue' => { 433 => 0x8031 },
	'peripheralillumination' => { 98 => 0x20702, 104 => 0x68 },
	'peripheralilluminationcorr' => { 60 => 0x1, 327 => 0x2 },
	'peripheralilluminationon' => { 98 => '0x20702.0', 104 => 0x64 },
	'peripheralillumperiphvalue' => { 433 => 0x8032 },
	'peripherallighting' => { 75 => 0x2, 122 => 0x3804 },
	'peripherallightingsetting' => { 76 => 0x5 },
	'peripherallightingvalue' => { 75 => 0x6 },
	'permissions' => { 473 => 'permissions' },
	'permits' => { 453 => 'permits' },
	'person' => { 470 => 'person' },
	'personality' => { 445 => 'Personality' },
	'personheard' => { 466 => 'PersonHeard' },
	'personheardidentifier' => { 466 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 466 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 466 => 'PersonInImage' },
	'personinimagecharacteristic' => { 466 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 466 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 466 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 466 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 466 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 466 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 466 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 466 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 466 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 456 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 456 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 456 => 'PerspectiveRotate' },
	'perspectivescale' => { 456 => 'PerspectiveScale' },
	'perspectiveupright' => { 456 => 'PerspectiveUpright' },
	'perspectivevertical' => { 456 => 'PerspectiveVertical' },
	'perspectivex' => { 456 => 'PerspectiveX' },
	'perspectivey' => { 456 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 87 => 0x1 },
	'pf10retainprogramshift' => { 87 => 0xb },
	'pf13drivepriority' => { 87 => 0xe },
	'pf14disablefocussearch' => { 87 => 0xf },
	'pf15disableafassistbeam' => { 87 => 0x10 },
	'pf16autofocuspointshoot' => { 87 => 0x11 },
	'pf17disableafpointsel' => { 87 => 0x12 },
	'pf18enableautoafpointsel' => { 87 => 0x13 },
	'pf19continuousshootspeed' => { 87 => 0x14 },
	'pf19shootingspeedhigh' => { 86 => 0xa },
	'pf19shootingspeedlow' => { 86 => 0x9 },
	'pf1disableshootingmodes' => { 87 => 0x2 },
	'pf1value' => { 86 => 0x1 },
	'pf20limitcontinousshots' => { 87 => 0x15 },
	'pf20maxcontinousshots' => { 86 => 0xb },
	'pf21enablequietoperation' => { 87 => 0x16 },
	'pf23felocktime' => { 86 => 0xd },
	'pf23postreleasetime' => { 86 => 0xe },
	'pf23settimerlengths' => { 87 => 0x18 },
	'pf23shutterbuttontime' => { 86 => 0xc },
	'pf24lightlcdduringbulb' => { 87 => 0x19 },
	'pf25aemode' => { 86 => 0xf },
	'pf25afmode' => { 86 => 0x12 },
	'pf25afpointsel' => { 86 => 0x13 },
	'pf25colormatrix' => { 86 => 0x17 },
	'pf25defaultclearsettings' => { 87 => 0x1a },
	'pf25drivemode' => { 86 => 0x11 },
	'pf25imagesize' => { 86 => 0x14 },
	'pf25meteringmode' => { 86 => 0x10 },
	'pf25parameters' => { 86 => 0x16 },
	'pf25wbmode' => { 86 => 0x15 },
	'pf26shortenreleaselag' => { 87 => 0x1b },
	'pf27reversedialrotation' => { 87 => 0x1c },
	'pf27value' => { 86 => 0x18 },
	'pf28noquickdialexpcomp' => { 87 => 0x1d },
	'pf29quickdialswitchoff' => { 87 => 0x1e },
	'pf2disablemeteringmodes' => { 87 => 0x3 },
	'pf2value' => { 86 => 0x2 },
	'pf30enlargementmode' => { 87 => 0x1f },
	'pf31originaldecisiondata' => { 87 => 0x20 },
	'pf3manualexposuremetering' => { 87 => 0x4 },
	'pf3value' => { 86 => 0x3 },
	'pf4exposuretimelimits' => { 87 => 0x5 },
	'pf4exposuretimemax' => { 86 => 0x5 },
	'pf4exposuretimemin' => { 86 => 0x4 },
	'pf5aperturelimits' => { 87 => 0x6 },
	'pf5aperturemax' => { 86 => 0x7 },
	'pf5aperturemin' => { 86 => 0x6 },
	'pf6presetshootingmodes' => { 87 => 0x7 },
	'pf7bracketcontinuousshoot' => { 87 => 0x8 },
	'pf8bracketshots' => { 86 => 0x8 },
	'pf8setbracketshots' => { 87 => 0x9 },
	'pf9changebracketsequence' => { 87 => 0xa },
	'phasedetectaf' => { 184 => 0x6 },
	'phonenumber' => { 149 => 'Phone' },
	'photoeffect' => { 34 => 0x28 },
	'photoeffecthistoryxml' => { 255 => 0xe9651831 },
	'photoeffects' => { 255 => 0xab5eca5e },
	'photoeffectsblue' => { 257 => 0x8 },
	'photoeffectsgreen' => { 257 => 0x6 },
	'photoeffectsred' => { 257 => 0x4 },
	'photoeffectstype' => { 257 => 0x0 },
	'photographicsensitivity' => { 461 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 262 => '17.6', 271 => '33.6' },
	'photometricinterpretation' => { 114 => 0x106, 476 => 'PhotometricInterpretation' },
	'photoshootingmenubank' => { 234 => 0xe7d, 243 => 0xfbd },
	'photoshootingmenubankimagearea' => { 234 => '3716.1', 243 => 0x791 },
	'photoshopbgrthumbnail' => { 351 => 0x409 },
	'photoshopquality' => { 350 => 0x0 },
	'photoshopthumbnail' => { 351 => 0x40c },
	'photostyle' => { 302 => 0x89 },
	'picklabel' => { 459 => 'PickLabel' },
	'pictinfo' => { 378 => 0x208 },
	'picturecontrol' => { 255 => 0xe2173c47 },
	'picturecontrolactive' => { 258 => 0x0 },
	'picturecontroladjust' => { 217 => 0x30, 218 => 0x30, 219 => 0x36 },
	'picturecontrolbase' => { 217 => 0x18, 218 => 0x18, 219 => 0x1c },
	'picturecontroldata' => { 215 => [0xbd,0x23] },
	'picturecontrolmode' => { 258 => 0x13 },
	'picturecontrolname' => { 217 => 0x4, 218 => 0x4, 219 => 0x8 },
	'picturecontrolquickadjust' => { 217 => 0x31, 218 => 0x31, 219 => 0x37 },
	'pictureeffect' => { 400 => 0x200e },
	'pictureeffect2' => { 408 => 0x1163, 409 => 0x1167, 410 => 0x1143, 411 => 0x11bf, 412 => 0x119b, 413 => 0x1053, 414 => 0x24b, 415 => 0x24b, 416 => 0x23c, 429 => 0x46 },
	'picturefinish' => { 173 => 0x71 },
	'picturemode' => { 122 => 0x1031, 279 => 0x520, 337 => [0xb,0x33], 379 => 0x3d },
	'picturemode2' => { 318 => 0x0 },
	'picturemodebwfilter' => { 279 => 0x525 },
	'picturemodecontrast' => { 279 => 0x523 },
	'picturemodeeffect' => { 279 => 0x52d },
	'picturemodehue' => { 279 => 0x522 },
	'picturemodesaturation' => { 279 => 0x521 },
	'picturemodesharpness' => { 279 => 0x524 },
	'picturemodetone' => { 279 => 0x526 },
	'pictureprofile' => { 408 => [0x115e,0x115f], 409 => [0x1162,0x1163], 410 => [0x113e,0x113f], 411 => [0x11ba,0x11bb], 412 => [0x1196,0x1197], 413 => [0x104e,0x104f], 414 => [0x246,0x247], 415 => [0x246,0x247], 416 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 71 => 0xa, 98 => 0x20301, 104 => 0x2 },
	'picturewizard' => { 376 => 0x21 },
	'picturewizardcolor' => { 375 => 0x1 },
	'picturewizardcontrast' => { 375 => 0x4 },
	'picturewizardmode' => { 375 => 0x0 },
	'picturewizardsaturation' => { 375 => 0x2 },
	'picturewizardsharpness' => { 375 => 0x3 },
	'pipelineversion' => { 168 => 'PipelineVersion' },
	'pitch' => { 110 => 0x6, 263 => '4.1', 275 => '4.1', 362 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 233 => 0x350f, 234 => 0x2c28, 242 => 0x36f8, 279 => 0x904, 302 => 0x91, 336 => 0x2, 374 => 0x1 },
	'pitchshift' => { 356 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 355 => 'pasp' },
	'pixelclockfrequency' => { 132 => 0x40b },
	'pixelcorrectionoffset' => { 132 => 0x972 },
	'pixelcorrectionscale' => { 132 => 0x971 },
	'pixelscale' => { 114 => 0x830e },
	'pixelshiftinfo' => { 400 => 0x202f },
	'pixelshiftresolution' => { 338 => 0x0 },
	'pixelsperunitx' => { 291 => 0x0 },
	'pixelsperunity' => { 291 => 0x4 },
	'pixelunits' => { 291 => 0x8 },
	'planarconfiguration' => { 114 => 0x11c, 476 => 'PlanarConfiguration' },
	'planningref' => { 466 => 'PlanningRef' },
	'planningrefidentifier' => { 466 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 466 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 466 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 485 => 'PlateNames' },
	'platform' => { 470 => 'platform' },
	'playallframes' => { 362 => 'AllF' },
	'playbackmenustime' => { 267 => '20.1', 268 => '21.1', 269 => '21.1' },
	'playbackmonitorofftime' => { 262 => '25.2', 263 => '36.1', 265 => '36.1', 266 => '36.1', 270 => '35.1', 271 => '8.1', 272 => '35.1', 275 => '36.1', 276 => '36.1', 277 => '21.1' },
	'playbackzoom' => { 263 => '37.1' },
	'playdisplay' => { 175 => 0x4e },
	'playerversion' => { 356 => 'player.version' },
	'playgap' => { 354 => 'pgap' },
	'playlistid' => { 354 => 'plID' },
	'playmode' => { 362 => 'SDLN' },
	'playselection' => { 362 => 'SelO' },
	'plusversion' => { 289 => 'Version' },
	'pmversion' => { 349 => 'PMVersion' },
	'pngwarning' => { 292 => 'Warning' },
	'podcast' => { 354 => 'pcst' },
	'podcasturl' => { 354 => 'purl' },
	'poilevel' => { 214 => 0x8 },
	'portraitnote' => { 438 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 104 => 0x1d },
	'portraitoutputshadowpoint' => { 104 => 0x1e },
	'portraitrawcolortone' => { 104 => 0x16 },
	'portraitrawcontrast' => { 104 => 0x18 },
	'portraitrawhighlight' => { 104 => 0x76 },
	'portraitrawhighlightpoint' => { 104 => 0x1b },
	'portraitrawlinear' => { 104 => 0x19 },
	'portraitrawsaturation' => { 104 => 0x17 },
	'portraitrawshadow' => { 104 => 0x7f },
	'portraitrawshadowpoint' => { 104 => 0x1c },
	'portraitrawsharpness' => { 104 => 0x1a },
	'portraitrefiner' => { 108 => 0x302b },
	'portraitrequest' => { 438 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 104 => 0x9a },
	'portraitunsharpmaskstrength' => { 104 => 0x98 },
	'portraitunsharpmaskthreshold' => { 104 => 0x9c },
	'portraitversion' => { 438 => 'PortraitVersion' },
	'poseheadingdegrees' => { 443 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 443 => 'PosePitchDegrees' },
	'poserolldegrees' => { 443 => 'PoseRollDegrees' },
	'positiondescriptor' => { 469 => 'positionDescriptor' },
	'postalcode' => { 153 => 'PostalCode' },
	'postcropvignetteamount' => { 456 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 456 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 456 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 456 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 456 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 456 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 397 => 0xb },
	'potentialface2position' => { 397 => 0x15 },
	'potentialface3position' => { 397 => 0x1f },
	'potentialface4position' => { 397 => 0x29 },
	'potentialface5position' => { 397 => 0x33 },
	'potentialface6position' => { 397 => 0x3d },
	'potentialface7position' => { 397 => 0x47 },
	'potentialface8position' => { 397 => 0x51 },
	'powersource' => { 316 => '0.1' },
	'poweruptime' => { 215 => 0xb6 },
	'precaptureframes' => { 284 => 0x300 },
	'predictor' => { 114 => 0x13d },
	'preflashreturnstrength' => { 231 => 0x28a },
	'prefs' => { 126 => 0xdd, 349 => 'Prefs' },
	'prereadfastresetcount' => { 132 => 0x187e },
	'preservedfilename' => { 481 => 'PreservedFileName' },
	'preservedspecimen' => { 113 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 113 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presetwhitebalance' => { 175 => 0x24, 433 => 0x8002 },
	'presetwhitebalanceadj' => { 433 => 0x8014 },
	'pressure' => { 114 => 0x9402, 461 => 'Pressure' },
	'previewapplicationname' => { 114 => 0xc716 },
	'previewapplicationversion' => { 114 => 0xc717 },
	'previewbutton' => { 262 => ['14.1','15.1'], 263 => '15.1', 265 => '15.1', 266 => '15.1', 271 => '29.1', 272 => '14.1', 275 => '15.1', 276 => '15.1' },
	'previewbuttonplusdials' => { 262 => ['14.2','15.2'], 263 => '15.2', 265 => '43.1', 266 => '43.1', 271 => '31.2', 275 => '43.1', 276 => '43.1' },
	'previewcolorspace' => { 114 => 0xc71a },
	'previewcropbottom' => { 348 => 0xef },
	'previewcropleft' => { 348 => 0xec },
	'previewcropright' => { 348 => 0xee },
	'previewcroptop' => { 348 => 0xed },
	'previewdate' => { 360 => 0x0 },
	'previewdatetime' => { 114 => 0xc71b },
	'previewimage' => { 108 => 0x2000, 109 => 'PreviewImage', 115 => 'PreviewImage', 117 => 0x4, 158 => 'data', 177 => 0x81, 284 => 0x280, 300 => 0x300, 400 => 0x2001 },
	'previewimageborders' => { 337 => 0x3e },
	'previewimageheight' => { 70 => 0x4, 136 => 0xfa58 },
	'previewimagelength' => { 70 => 0x2, 108 => 0x3, 114 => [0x117,0x202], 177 => 0x89, 220 => 0x202, 279 => 0x102, 284 => 0x1037, 337 => 0x3, 368 => 0x1e, 373 => 0x3, 379 => [0x1b,0x1d], 390 => 0x202 },
	'previewimagename' => { 158 => '1Name' },
	'previewimagesize' => { 108 => 0x2, 141 => 0x2, 158 => 'ImageSize', 337 => 0x2, 379 => [0x1c,0x1e], 400 => 0xb02c, 433 => 0x9012 },
	'previewimagestart' => { 70 => 0x5, 108 => 0x4, 114 => [0x111,0x201], 177 => 0x88, 220 => 0x201, 279 => 0x101, 284 => 0x1036, 337 => 0x4, 368 => 0x1c, 373 => 0x2, 379 => [0x1a,0x1c], 390 => 0x201 },
	'previewimagetype' => { 158 => '0Type' },
	'previewimagevalid' => { 279 => 0x100, 284 => 0x1035 },
	'previewimagewidth' => { 70 => 0x3, 136 => 0xfa57 },
	'previewquality' => { 70 => 0x1 },
	'previewsettingsdigest' => { 114 => 0xc719 },
	'previewsettingsname' => { 114 => 0xc718 },
	'primaryafpoint' => { 184 => [0x44,0x7] },
	'primarychromaticities' => { 114 => 0x13f, 476 => 'PrimaryChromaticities' },
	'primaryftp' => { 445 => 'PrimaryFTP' },
	'primaryslot' => { 234 => 0xe7f, 243 => 0xfbf },
	'printim' => { 114 => 0xc4a5 },
	'prioritysetinawb' => { 400 => 0x202b },
	'prioritysetupshutterrelease' => { 175 => 0x1d, 387 => 0x28 },
	'privatertkinfo' => { 447 => 'privateRTKInfo' },
	'processbordercolsleft' => { 132 => 0xc61 },
	'processbordercolsright' => { 132 => 0xc62 },
	'processborderrowsbottom' => { 132 => 0xc64 },
	'processborderrowstop' => { 132 => 0xc63 },
	'processingsoftware' => { 114 => 0xb },
	'processversion' => { 456 => 'ProcessVersion' },
	'producer' => { 288 => 'Producer', 356 => 'producer', 362 => "\xa9prd", 467 => 'Producer' },
	'producerkeywords' => { 362 => "\xa9pdk" },
	'productcode' => { 470 => 'productCode' },
	'productid' => { 127 => 0x32, 354 => 'prID', 469 => 'productID' },
	'productidtype' => { 469 => 'productIDType' },
	'productinimage' => { 466 => 'ProductInImage' },
	'productinimagedescription' => { 466 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 466 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 466 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 317 => 0x2 },
	'productorserviceconstraints' => { 289 => 'ProductOrServiceConstraints' },
	'productversion' => { 354 => 'VERS' },
	'profession' => { 470 => 'profession' },
	'profilecalibrationsig' => { 114 => 0xc6f4 },
	'profilecopyright' => { 114 => 0xc6fe },
	'profileembedpolicy' => { 114 => 0xc6fd },
	'profilehuesatmapdata1' => { 114 => 0xc6fa },
	'profilehuesatmapdata2' => { 114 => 0xc6fb },
	'profilehuesatmapdims' => { 114 => 0xc6f9 },
	'profilehuesatmapencoding' => { 114 => 0xc7a3 },
	'profilelooktabledata' => { 114 => 0xc726 },
	'profilelooktabledims' => { 114 => 0xc725 },
	'profilelooktableencoding' => { 114 => 0xc7a4 },
	'profilename' => { 114 => 0xc6f8 },
	'profiletonecurve' => { 114 => 0xc6fc },
	'programiso' => { 302 => 0x3c },
	'programline' => { 318 => '1.1' },
	'programmode' => { 180 => 0x5 },
	'programshift' => { 215 => 0xd },
	'programversion' => { 126 => 0x46 },
	'prohibits' => { 453 => 'prohibits' },
	'projectiontype' => { 443 => 'ProjectionType', 444 => 'ProjectionType' },
	'projectname' => { 480 => 'projectName' },
	'projectref' => { 480 => 'projectRef' },
	'projectrefpath' => { 480 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 480 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 289 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 289 => 'PropertyReleaseStatus' },
	'province-state' => { 126 => 0x5f },
	'publicationdate' => { 470 => 'publicationDate' },
	'publicationdatea-platform' => { 470 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 470 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 470 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 470 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 470 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 466 => 'PublicationEvent' },
	'publicationeventdate' => { 466 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 466 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 466 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 470 => 'publicationName' },
	'publisher' => { 354 => "\xa9pub", 356 => 'publisher', 457 => 'publisher' },
	'publishingfrequency' => { 470 => 'publishingFrequency' },
	'pulldown' => { 480 => 'pullDown' },
	'purchasedate' => { 354 => 'purd' },
	'purplehsl' => { 98 => 0x20916 },
	'pxshiftperiphedgenr' => { 433 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 433 => 0x9014 },
	'quality' => { 0 => 0x1, 34 => 0x3, 107 => 0x2, 108 => 0x3002, 122 => 0x1000, 134 => 0x9, 215 => 0x4, 245 => 0x3, 284 => 0x201, 297 => 0x300, 337 => 0x8, 344 => 0x2, 379 => 0x16, 387 => 0x56, 388 => 0x56, 389 => 0xb, 400 => [0x102,0x202e] },
	'quality2' => { 408 => 0x1170, 409 => 0x1174, 410 => 0x1150, 412 => 0x11a8, 413 => 0x1060, 414 => 0x258, 415 => 0x258, 416 => 0x247, 420 => 0x29, 421 => 0x25, 422 => 0x2a },
	'qualitymode' => { 108 => 0x8 },
	'quantizationmethod' => { 128 => 0x78 },
	'quickadjust' => { 258 => 0x2a },
	'quickcontroldialinmeter' => { 79 => 0x703 },
	'quickfix' => { 255 => 0x416391c6 },
	'quickshot' => { 378 => 0x213 },
	'quiettime' => { 132 => 0x188a },
	'rads' => { 362 => 'rads' },
	'rangefinder' => { 267 => '4.1', 268 => '5.1', 269 => '5.1' },
	'rasterizedcaption' => { 126 => 0x7d },
	'rating' => { 114 => 0x4746, 122 => 0x1431, 348 => 0xdf, 354 => 'rtng', 400 => 0x2002, 450 => 'rating', 458 => 'rating', 466 => 'Rating', 470 => 'rating', 478 => 'Rating' },
	'ratingpercent' => { 114 => 0x4749, 170 => 'Rating', 354 => 'rate' },
	'ratingratingregion' => { 466 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 466 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 466 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 466 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 466 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpslatitude' => { 466 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 466 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 466 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 466 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 466 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 466 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 466 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 466 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 466 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 466 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 466 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 466 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 466 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 77 => 0x8, 177 => 0x109, 318 => 0xd },
	'rawbrightnessadj' => { 98 => 0x20001, 103 => 0x38 },
	'rawcoloradj' => { 103 => 0x2e },
	'rawcropbottom' => { 348 => 0xd4 },
	'rawcropleft' => { 348 => 0xd1 },
	'rawcropright' => { 348 => 0xd3 },
	'rawcroptop' => { 348 => 0xd2 },
	'rawcustomsaturation' => { 103 => 0x30 },
	'rawcustomtone' => { 103 => 0x34 },
	'rawdata' => { 376 => 0xa048 },
	'rawdatabyteorder' => { 376 => 0x40 },
	'rawdatacfapattern' => { 376 => 0x50 },
	'rawdatauniqueid' => { 114 => 0xc65d },
	'rawdepth' => { 179 => 0x10 },
	'rawdevartfilter' => { 286 => 0x121 },
	'rawdevautogradation' => { 286 => 0x119 },
	'rawdevcolorspace' => { 285 => 0x108, 286 => 0x109 },
	'rawdevcontrastvalue' => { 285 => 0x106, 286 => 0x105 },
	'rawdeveditstatus' => { 285 => 0x10b },
	'rawdevelopmentprocess' => { 337 => 0x62 },
	'rawdevengine' => { 285 => 0x109, 286 => 0x10b },
	'rawdevexposurebiasvalue' => { 285 => 0x100, 286 => 0x100 },
	'rawdevgradation' => { 286 => 0x112 },
	'rawdevgraypoint' => { 285 => 0x103, 286 => 0x104 },
	'rawdevmemorycoloremphasis' => { 285 => 0x105, 286 => 0x108 },
	'rawdevnoisereduction' => { 285 => 0x10a, 286 => 0x10a },
	'rawdevpicturemode' => { 286 => 0x10c },
	'rawdevpm_bwfilter' => { 286 => 0x110 },
	'rawdevpmcontrast' => { 286 => 0x10e },
	'rawdevpmnoisefilter' => { 286 => 0x120 },
	'rawdevpmpicturetone' => { 286 => 0x111 },
	'rawdevpmsaturation' => { 286 => 0x10d },
	'rawdevpmsharpness' => { 286 => 0x10f },
	'rawdevsaturation3' => { 286 => 0x113 },
	'rawdevsaturationemphasis' => { 285 => 0x104, 286 => 0x107 },
	'rawdevsettings' => { 285 => 0x10c },
	'rawdevsharpnessvalue' => { 285 => 0x107, 286 => 0x106 },
	'rawdevversion' => { 285 => 0x0, 286 => 0x0 },
	'rawdevwbfineadjustment' => { 285 => 0x102, 286 => 0x103 },
	'rawdevwhitebalance' => { 286 => 0x101 },
	'rawdevwhitebalancevalue' => { 285 => 0x101, 286 => 0x102 },
	'rawfile' => { 114 => 0xfe4c },
	'rawfilename' => { 456 => 'RawFileName' },
	'rawfiletype' => { 400 => 0x2029 },
	'rawformat' => { 307 => 0x2d, 346 => 0x10e },
	'rawimagecenter' => { 215 => 0x99 },
	'rawimagedigest' => { 114 => 0xc71c },
	'rawimagesize' => { 337 => 0x39 },
	'rawinfoversion' => { 287 => 0x0 },
	'rawjpgheight' => { 94 => 0x4 },
	'rawjpgquality' => { 55 => 0x6, 94 => 0x1 },
	'rawjpgsize' => { 55 => 0x7, 94 => 0x2 },
	'rawjpgwidth' => { 94 => 0x3 },
	'rawmeasuredrggb' => { 41 => 0x26a, 43 => 0x280, 45 => 0x194, 46 => [0x1ad,0x26b] },
	'rawrppused' => { 450 => 'rawrppused' },
	'rawtopreviewgain' => { 114 => 0xc7a8 },
	'readouttypeactual' => { 132 => 0x1903 },
	'readouttyperequested' => { 132 => 0x1902 },
	'reardisplay' => { 262 => '12.3', 263 => '6.2' },
	'recdevice' => { 466 => 'RecDevice' },
	'recdeviceattlensdescription' => { 466 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 466 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 466 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 466 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 466 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 472 => 'recipeEndingPage' },
	'recipepagerange' => { 472 => 'recipePageRange' },
	'recipesource' => { 472 => 'recipeSource' },
	'recipestartingpage' => { 472 => 'recipeStartingPage' },
	'recipetitle' => { 472 => 'recipeTitle' },
	'recognizedface1age' => { 295 => 0x20 },
	'recognizedface1name' => { 295 => 0x4 },
	'recognizedface1position' => { 295 => 0x18 },
	'recognizedface2age' => { 295 => 0x50 },
	'recognizedface2name' => { 295 => 0x34 },
	'recognizedface2position' => { 295 => 0x48 },
	'recognizedface3age' => { 295 => 0x80 },
	'recognizedface3name' => { 295 => 0x64 },
	'recognizedface3position' => { 295 => 0x78 },
	'recognizedfaceflags' => { 302 => 0x63 },
	'recommendedexposureindex' => { 114 => 0x8832, 461 => 'RecommendedExposureIndex' },
	'record' => { 113 => 'Record' },
	'recordbasisofrecord' => { 113 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 113 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 113 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 113 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 113 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 113 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 175 => 0x4d },
	'recorddynamicproperties' => { 113 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 92 => 0x1804 },
	'recordinformationwithheld' => { 113 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 362 => "\xa9phg" },
	'recordingformat' => { 369 => 0x1000 },
	'recordingmode' => { 107 => 0x1, 344 => 0x1 },
	'recordinstitutioncode' => { 113 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 113 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 362 => "\xa9lab" },
	'recordlabelurl' => { 362 => "\xa9lal" },
	'recordmode' => { 34 => 0x9, 108 => 0x3000 },
	'recordownerinstitutioncode' => { 113 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 378 => 0x217 },
	'redbalance' => { 284 => 0x1017, 307 => 0x11, 337 => 0x1c },
	'redcurvelimits' => { 103 => 0x18a },
	'redcurvepoints' => { 102 => 0x2d, 103 => 0x160 },
	'redeyecorrection' => { 259 => 0x0 },
	'redeyeinfo' => { 456 => 'RedEyeInfo' },
	'redeyereduction' => { 175 => 0x41, 387 => 0x6a, 389 => 0x28 },
	'redeyeremoval' => { 302 => 0xb9 },
	'redhsl' => { 98 => 0x20910 },
	'redhue' => { 456 => 'RedHue' },
	'redsaturation' => { 456 => 'RedSaturation' },
	'reductionmatrix1' => { 114 => 0xc625 },
	'reductionmatrix2' => { 114 => 0xc626 },
	'reelname' => { 114 => 0xc789, 362 => 'reel' },
	'reference1' => { 464 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 464 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 464 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 464 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 464 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 464 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 114 => 0x214, 476 => 'ReferenceBlackWhite' },
	'referencedate' => { 126 => 0x2f },
	'referencenumber' => { 126 => 0x32 },
	'references' => { 149 => 'References' },
	'referenceservice' => { 126 => 0x2d },
	'regionappliedtodimensions' => { 164 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 164 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 164 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 164 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 164 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 164 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 164 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 164 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 164 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 164 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 164 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 164 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 289 => 'RegionConstraints' },
	'regiondescription' => { 164 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 164 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 164 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 164 => 'Regions' },
	'regioninfodateregionsvalid' => { 167 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 167 => 'RegionInfo' },
	'regioninforegions' => { 167 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 164 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 164 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 167 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 167 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 167 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 167 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 167 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 164 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 164 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 164 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 466 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 466 => 'RegistryId' },
	'registryitemid' => { 466 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 466 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 147 => 'data' },
	'relatedaudiofilename' => { 147 => '1Name' },
	'relatedaudiofiletype' => { 147 => '0Type' },
	'relatedimagefileformat' => { 114 => 0x1000 },
	'relatedimageheight' => { 114 => 0x1002 },
	'relatedimagewidth' => { 114 => 0x1001 },
	'relatedresourceid' => { 113 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 114 => 0xa004, 460 => 'RelatedSoundFile' },
	'relatedvideofile' => { 161 => 'data' },
	'relatedvideofilename' => { 161 => '1Name' },
	'relatedvideofiletype' => { 161 => '0Type' },
	'relation' => { 457 => 'relation' },
	'relationshipaccordingto' => { 113 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 113 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 113 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 113 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 111 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 480 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 480 => 'relativeTimestamp' },
	'relativetimestampscale' => { 480 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 480 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 262 => '17.8', 263 => '18.5', 265 => '18.4', 266 => '18.4', 271 => '33.8', 272 => '17.6', 275 => '18.5', 276 => '18.4' },
	'releasedate' => { 126 => 0x1e, 354 => 'rldt', 450 => 'ReleaseDate', 480 => 'releaseDate' },
	'releasemode' => { 108 => 0x3001, 233 => 0x184d, 400 => 0xb049 },
	'releasemode2' => { 408 => 0x112c, 409 => [0x112c,0x8], 410 => [0x1108,0x8], 411 => [0x1184,0x8], 412 => [0x1160,0x8], 413 => [0x4,0x1018], 414 => [0x4,0x210], 415 => [0x4,0x210], 416 => [0x4,0x208], 418 => [0x67,0x3f], 419 => [0x6b,0x6d,0x73,0x4b], 420 => 0x10, 421 => 0x10, 422 => 0x9, 429 => 0x34 },
	'releasemode3' => { 408 => 0x1128, 409 => 0x1128, 410 => 0x1104, 411 => 0x1180, 412 => 0x115c, 413 => 0x1014, 414 => 0x20c, 415 => 0x20c, 416 => 0x204 },
	'releaseready' => { 466 => 'ReleaseReady' },
	'releasesetting' => { 92 => 0x1016 },
	'releasetime' => { 126 => 0x23, 450 => 'ReleaseTime' },
	'remoteonduration' => { 264 => '3.4', 267 => '17.2', 268 => '18.2', 269 => '18.2', 270 => '18.2', 272 => '18.2', 273 => '4.3', 277 => '19.2' },
	'renditionclass' => { 481 => 'RenditionClass' },
	'renditionof' => { 481 => 'RenditionOf' },
	'renditionofalternatepaths' => { 481 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 481 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 481 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 481 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 481 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 481 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 481 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 481 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 481 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 481 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 481 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 481 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 481 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 481 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 481 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 481 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 481 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 481 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 481 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 481 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 481 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 481 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 481 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 481 => 'RenditionParams' },
	'repeatingflashcount' => { 199 => 0xd, 200 => 0xe, 201 => 0xe, 202 => 0xe, 203 => 0xe, 271 => '17.2', 272 => '24.2', 273 => '9.2', 274 => '24.2', 277 => '25.2' },
	'repeatingflashcountbuilt-in' => { 241 => 0x4db },
	'repeatingflashcountexternal' => { 241 => 0x4c3 },
	'repeatingflashoutput' => { 271 => '17.1', 272 => '24.1', 273 => '9.1', 274 => '24.1', 277 => '25.1' },
	'repeatingflashoutputexternal' => { 241 => 0x4c0 },
	'repeatingflashrate' => { 199 => 0xc, 200 => 0xd, 201 => 0xd, 202 => 0xd, 203 => 0xd, 271 => '18.1', 272 => '25.1', 273 => '10.1', 274 => '25.1', 277 => '26.1' },
	'repeatingflashratebuilt-in' => { 241 => 0x4da },
	'repeatingflashrateexternal' => { 241 => 0x4c2 },
	'requirements' => { 362 => "\xa9req" },
	'requires' => { 453 => 'requires' },
	'resampleparams' => { 480 => 'resampleParams' },
	'resampleparamsquality' => { 480 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 132 => 0xe50 },
	'resamplingkerneldenominators067' => { 132 => 0xe4f },
	'resamplingkerneldenominators100' => { 132 => 0xe51 },
	'resaved' => { 378 => 0x21e },
	'resetblacksegrows' => { 132 => 0x181a },
	'resolution' => { 154 => 'Resolution' },
	'resolutionmode' => { 379 => 0x4 },
	'resolutionunit' => { 114 => 0x128, 129 => 0x2, 476 => 'ResolutionUnit' },
	'resourceid' => { 113 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 113 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 113 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 79 => 0x612 },
	'restrictions' => { 473 => 'restrictions' },
	'retouchareafeather' => { 456 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 456 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 456 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 456 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 456 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 456 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 456 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 456 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 456 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 456 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 456 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 456 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 456 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 456 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 456 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 456 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 456 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 456 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 456 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 456 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 456 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 456 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 456 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 456 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 456 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 456 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 456 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 456 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 456 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 456 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 456 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 456 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 456 => 'RetouchAreas' },
	'retouchareaseed' => { 456 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 456 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 456 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 456 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 215 => 0x9e },
	'retouchinfo' => { 456 => 'RetouchInfo' },
	'retouchnefprocessing' => { 222 => 0x5 },
	'retractlensonpoweroff' => { 79 => 0x814 },
	'reuse' => { 289 => 'Reuse' },
	'reuseallowed' => { 483 => 'ReuseAllowed' },
	'reuseprohibited' => { 473 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 269 => '5.2' },
	'reverseindicators' => { 262 => '12.1', 263 => '6.1', 265 => '6.1', 266 => '6.1', 267 => '4.3', 268 => '5.2', 269 => '5.4', 271 => '33.5', 272 => '5.1', 275 => '6.1', 276 => '6.1', 277 => '6.2' },
	'reverseshutterspeedaperture' => { 269 => '5.3' },
	'revision' => { 458 => 'revision' },
	'rflensmffocusringsensitivity' => { 79 => 0x714 },
	'rgbcurvelimits' => { 103 => 0x238 },
	'rgbcurvepoints' => { 102 => 0x7, 103 => 0x20e },
	'richtextcomment' => { 463 => 'RichTextComment' },
	'ricohdate' => { 368 => 0x6 },
	'ricohimageheight' => { 368 => 0x2 },
	'ricohimagewidth' => { 368 => 0x0 },
	'rightalbedo' => { 446 => 'RightAlbedo' },
	'rightascension' => { 157 => 'RightAscension' },
	'rights' => { 457 => 'rights' },
	'rightsagent' => { 473 => 'rightsAgent' },
	'rightsowner' => { 473 => 'rightsOwner' },
	'roll' => { 110 => 0x8, 362 => ['roll',"\xa9frl"] },
	'rollangle' => { 233 => 0x350b, 234 => 0x2c24, 242 => 0x36f4, 279 => 0x903, 302 => 0x90, 336 => 0x1, 374 => 0x2 },
	'romoperationmode' => { 92 => 0x80d },
	'rotation' => { 30 => 0x17, 31 => 0x18, 91 => 0x3, 98 => 0x10002, 103 => 0x26e, 109 => 'Rotation', 118 => 0x4, 157 => 'Rotation', 173 => [0x65,0x50], 174 => 0x46, 175 => 0x5a, 178 => 0x10, 233 => 0x3693, 234 => 0xca, 240 => '590.1', 255 => 0x76a43207, 302 => 0x30, 318 => '17.2', 348 => 0xd8, 355 => 'irot', 387 => 0x3f, 388 => 0x3f, 398 => 0x10 },
	'routedto' => { 462 => 'RoutedTo' },
	'routing' => { 353 => 'Routing' },
	'routingdestinations' => { 445 => 'RoutingDestinations' },
	'routingexclusions' => { 445 => 'RoutingExclusions' },
	'routingnotes' => { 462 => 'RoutingNotes' },
	'rowsperstrip' => { 114 => 0x116 },
	'rpp' => { 450 => 'rpp' },
	'rtkflag' => { 111 => 'RtkFlag' },
	'rtkstdhgt' => { 111 => 'RtkStdHgt' },
	'rtkstdlat' => { 111 => 'RtkStdLat' },
	'rtkstdlon' => { 111 => 'RtkStdLon' },
	'safetyshift' => { 79 => 0x108 },
	'safetyshiftinavortv' => { 77 => 0x10, 78 => 0x10, 80 => 0xf, 81 => 0x10, 84 => 0x10 },
	'sameexposurefornewaperture' => { 79 => 0x112 },
	'samplebits' => { 147 => 'SampleBits' },
	'samplepagerange' => { 470 => 'samplePageRange' },
	'samplerate' => { 147 => 'SampleRate' },
	'samplesperpixel' => { 114 => 0x115, 307 => 0x8, 476 => 'SamplesPerPixel' },
	'samplestructure' => { 128 => 0x5a },
	'samsungmodelid' => { 376 => 0x3 },
	'sanyoquality' => { 378 => 0x201 },
	'sanyothumbnail' => { 378 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 34 => 0xe, 49 => 0x1, 107 => 0xd, 108 => [0x3013,0x1f], 114 => [0xa409,0xfe55], 122 => 0x1003, 148 => 'Saturation', 172 => 0x1f, 173 => 0x32, 174 => 0x28, 175 => 0x1a, 180 => 0x1, 215 => [0x94,0xaa], 217 => 0x35, 218 => 0x3b, 219 => 0x43, 302 => 0x40, 304 => 0x300d, 337 => 0x1f, 344 => 0xd, 363 => 0x27, 365 => 0x58, 368 => 0x28, 369 => 0x1013, 379 => 0x10, 387 => 0x1e, 388 => 0x1b, 400 => 0x2005, 456 => 'Saturation', 460 => 'Saturation' },
	'saturationadj' => { 98 => 0x20901, 103 => 0x116, 254 => 0x1, 258 => 0x2e, 433 => 0x8016 },
	'saturationadjustmentaqua' => { 456 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 456 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 456 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 456 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 456 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 456 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 456 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 456 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 68 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 67 => 0x68, 68 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 67 => 0x38, 68 => 0x38 },
	'saturationmonochrome' => { 67 => 0x80, 68 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 67 => 0x50, 68 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 67 => 0x20, 68 => 0x20 },
	'saturationsetting' => { 287 => 0x1010, 389 => 0x11, 405 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 67 => 0x8, 68 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 67 => 0x98, 68 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 67 => 0xb0, 68 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 67 => 0xc8, 68 => 0xe0 },
	'saveid' => { 481 => 'SaveID' },
	'sbaanalysiscomplete' => { 132 => 0xc35 },
	'sbablack' => { 132 => 0xc25 },
	'sbagmoffset' => { 132 => 0xc4a },
	'sbagray' => { 132 => 0xc26 },
	'sbagreenmagentabal' => { 132 => 0xc33 },
	'sbahighgray' => { 132 => 0xc46 },
	'sbailloffset' => { 132 => 0xc49 },
	'sbailluminantbal' => { 132 => 0xc34 },
	'sbalowgray' => { 132 => 0xc47 },
	'sbaneutralbal' => { 132 => 0xc32 },
	'sbawhite' => { 132 => 0xc27 },
	'scaletype' => { 480 => 'scaleType' },
	'scanimageenhancer' => { 223 => 0x60 },
	'scanningdirection' => { 128 => 0x64 },
	'scene' => { 362 => 'scen', 465 => 'Scene', 480 => 'scene' },
	'scenearea' => { 282 => 0x211, 284 => 0x1031 },
	'sceneassist' => { 215 => 0x9c },
	'scenecapturetype' => { 114 => 0xa406, 460 => 'SceneCaptureType' },
	'scenedetect' => { 282 => 0x210, 284 => 0x1030 },
	'scenedetectdata' => { 282 => 0x212, 284 => 0x1033 },
	'scenemode' => { 136 => 0xfa02, 177 => 0x100, 215 => 0x8f, 279 => 0x509, 284 => 0x403, 302 => 0x8001, 311 => 0xf, 400 => 0xb023 },
	'scenemodeused' => { 138 => [0x6002,0xf002] },
	'scenerecognition' => { 122 => 0x1425 },
	'sceneselect' => { 378 => 0x21f },
	'scenetype' => { 114 => 0xa301, 460 => 'SceneType' },
	'screentips' => { 262 => '12.7', 263 => '5.3', 271 => '13.1', 272 => '4.4', 275 => '5.4', 277 => '5.1' },
	'scriptversion' => { 132 => 0x1770 },
	'season' => { 466 => 'Season', 469 => 'season' },
	'seasonidentifier' => { 466 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 466 => [\'Season','SeasonName'] },
	'seasonnumber' => { 466 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 445 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 233 => 0x1d0, 242 => 0x1d0 },
	'section' => { 470 => 'section' },
	'securityclassification' => { 114 => 0x9212 },
	'selectableafpoint' => { 79 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 79 => 0x512 },
	'selfdata' => { 111 => 'SelfData' },
	'selftimer' => { 34 => 0x2, 302 => 0x2e, 378 => 0x214, 408 => 0x1134, 409 => 0x1134, 410 => 0x1110, 411 => 0x118c, 412 => 0x1168, 413 => 0x1020, 414 => 0x218, 415 => 0x218, 416 => 0x210 },
	'selftimer2' => { 73 => 0x1d },
	'selftimerinterval' => { 272 => '19.2' },
	'selftimermode' => { 114 => 0x882b },
	'selftimershotcount' => { 263 => '20.2', 265 => '20.3', 266 => '20.3', 267 => '18.2', 268 => '19.2', 269 => '19.2', 270 => '19.3', 272 => '19.3', 275 => '20.3', 276 => '20.3', 277 => '20.2' },
	'selftimershotinterval' => { 263 => '20.3', 265 => '20.2', 266 => '20.2', 270 => '19.2', 275 => '20.2', 276 => '20.2' },
	'selftimertime' => { 92 => 0x1806, 175 => 0x1f, 262 => '18.1', 263 => '20.1', 264 => '3.3', 265 => '20.1', 266 => '20.1', 267 => '18.1', 268 => '19.1', 269 => '19.1', 270 => '19.1', 271 => '7.2', 272 => '19.1', 273 => '3.3', 275 => '20.1', 276 => '20.1', 277 => '20.1' },
	'sellingagency' => { 470 => 'sellingAgency' },
	'seminfo' => { 114 => 0x8546 },
	'sensingmethod' => { 114 => 0xa217, 460 => 'SensingMethod' },
	'sensitivityadjust' => { 337 => 0x40 },
	'sensitivitysteps' => { 318 => ['14.3','17.4'], 320 => 0x1 },
	'sensitivitytype' => { 114 => 0x8830, 461 => 'SensitivityType' },
	'sensor' => { 182 => 0x665e },
	'sensorarea' => { 284 => 0x400 },
	'sensorareas' => { 376 => 0xa010 },
	'sensorbitdepth' => { 304 => 0x312d },
	'sensorbluelevel' => { 71 => 0x5 },
	'sensorcalibration' => { 283 => 0x805 },
	'sensorcleaning' => { 85 => 0xd },
	'sensorfullheight' => { 131 => 0xf904 },
	'sensorfullwidth' => { 131 => 0xf903 },
	'sensorheight' => { 131 => 0xf901, 136 => 0xfa21, 179 => 0x8, 304 => 0x312c, 346 => 0x109, 369 => 0x1602 },
	'sensorimageheight' => { 132 => 0x3ee },
	'sensorimagewidth' => { 132 => 0x3ed },
	'sensorleftborder' => { 132 => 0x3eb },
	'sensorleftmargin' => { 346 => 0x10a },
	'sensorpixelsize' => { 215 => 0x9a },
	'sensorredlevel' => { 71 => 0x4 },
	'sensorserialnumber' => { 132 => 0x9ce },
	'sensorsize' => { 148 => 'SensorSize', 337 => 0x35 },
	'sensortemperature' => { 282 => 0x1500, 284 => 0x1007, 342 => 0xc, 346 => 0x210, 379 => [0x39,0x55] },
	'sensortemperature2' => { 342 => 0xe, 346 => 0x211 },
	'sensortopborder' => { 132 => 0x3ec },
	'sensortopmargin' => { 346 => 0x10b },
	'sensorwidth' => { 131 => 0xf900, 136 => 0xfa20, 179 => 0xa, 304 => 0x312b, 346 => 0x108, 369 => 0x1601 },
	'sequence' => { 363 => 0x7, 364 => 0x35, 365 => 0x36 },
	'sequencefilenumber' => { 409 => 0x4, 410 => 0x4, 411 => 0x4, 412 => 0x4, 420 => 0xc, 421 => 0xc, 422 => 0x1a },
	'sequenceimagenumber' => { 409 => 0x0, 410 => 0x0, 411 => 0x0, 412 => 0x0, 420 => 0x8, 421 => 0x8, 422 => 0x12, 429 => 0x24 },
	'sequencelength' => { 420 => 0x22, 421 => 0x1e, 422 => [0x16,0x1e] },
	'sequencename' => { 469 => 'sequenceName' },
	'sequencenumber' => { 73 => 0x9, 108 => 0x301c, 122 => 0x1101, 134 => 0x1d, 241 => 0x51c, 302 => 0x2b, 389 => [0x10c,0x30c], 400 => 0xb04a, 469 => 'sequenceNumber' },
	'sequenceshotinterval' => { 378 => 0x224 },
	'sequencetotalnumber' => { 469 => 'sequenceTotalNumber' },
	'sequentialshot' => { 378 => 0x20e },
	'serialnumber' => { 61 => 0xc, 92 => 0x180b, 114 => [0xa431,0xfde9], 131 => 0xfa04, 133 => 0xfa00, 135 => 0xc354, 136 => 0xfa19, 145 => 0x0, 148 => 'SerialNumber', 215 => [0xa0,0x1d], 280 => 0x101, 284 => [0x404,0x101a], 297 => 0x303, 299 => 0x305, 304 => 0x3103, 337 => 0x229, 346 => 0x102, 347 => 0x407, 362 => ['SNum','slno'], 363 => 0x15, 364 => 0x4b, 365 => 0x7e, 369 => 0x5, 376 => 0xa002, 379 => 0x2, 400 => 0x2031, 452 => 'SerialNumber', 461 => 'BodySerialNumber' },
	'serialnumberformat' => { 61 => 0x15, 92 => 0x183b },
	'serialnumberhash' => { 362 => 'CAME' },
	'series' => { 466 => 'Series' },
	'seriesdatetime' => { 435 => 'SeriesDateTime' },
	'seriesdescription' => { 435 => 'SeriesDescription' },
	'seriesidentifier' => { 466 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 435 => 'SeriesModality' },
	'seriesname' => { 466 => [\'Series','SeriesName'] },
	'seriesnumber' => { 435 => 'SeriesNumber', 470 => 'seriesNumber' },
	'seriestitle' => { 470 => 'seriesTitle' },
	'serviceidentifier' => { 127 => 0x1e },
	'servingsize' => { 472 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 82 => 0x0, 83 => 0x0 },
	'setbuttonwhenshooting' => { 77 => 0x1, 79 => 0x704, 85 => 0xc },
	'setfunctionwhenshooting' => { 80 => 0x0, 81 => 0x1, 84 => 0x1 },
	'setting' => { 469 => 'setting' },
	'shadingcompensation' => { 279 => 0x50c, 302 => 0x8a },
	'shadingcompensation2' => { 283 => 0x1012 },
	'shadow' => { 379 => 0xe },
	'shadowadj' => { 98 => 0x2030b },
	'shadowcorrection' => { 337 => 0x79 },
	'shadowprotection' => { 254 => 0x0 },
	'shadows' => { 114 => 0xfe52, 449 => 'Shadows', 456 => 'Shadows' },
	'shadows2012' => { 456 => 'Shadows2012' },
	'shadowsadj' => { 433 => 0x901a },
	'shadowscale' => { 114 => 0xc633 },
	'shadowtint' => { 456 => 'ShadowTint' },
	'shadowtone' => { 122 => 0x1040 },
	'shakereduction' => { 339 => 0x1, 340 => 0x1 },
	'sharpendetail' => { 456 => 'SharpenDetail' },
	'sharpenedgemasking' => { 456 => 'SharpenEdgeMasking' },
	'sharpening' => { 304 => 0x300b },
	'sharpeningadj' => { 258 => 0x2b },
	'sharpeningkernel' => { 132 => 0x92f },
	'sharpenradius' => { 456 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 34 => 0xf, 71 => 0x2, 107 => 0xb, 108 => [0x3011,0x21], 114 => [0xa40a,0xfe56], 122 => 0x1001, 134 => 0x6b, 143 => 0x37, 148 => 'Sharpness', 172 => 0x21, 173 => 0x30, 174 => 0x26, 175 => 0x18, 180 => 0x3, 215 => 0x6, 217 => 0x32, 218 => 0x33, 219 => 0x39, 284 => 0x100f, 302 => 0x41, 337 => 0x21, 344 => 0xb, 363 => 0x26, 365 => 0x56, 368 => 0x22, 369 => [0x1003,0x1014], 379 => 0x11, 387 => 0x1c, 388 => 0x19, 400 => 0x2006, 429 => 0x52, 456 => 'Sharpness', 460 => 'Sharpness' },
	'sharpnessadj' => { 98 => 0x20310, 103 => 0x25a, 433 => 0x801a },
	'sharpnessadjon' => { 98 => '0x20310.0' },
	'sharpnessauto' => { 68 => 0x94 },
	'sharpnessfactor' => { 284 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 67 => 0x64, 68 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 71 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 67 => 0x34, 68 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 67 => 0x7c, 68 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 67 => 0x4c, 68 => 0x4c },
	'sharpnessovershoot' => { 433 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 67 => 0x1c, 68 => 0x1c },
	'sharpnesssetting' => { 279 => 0x506, 287 => 0x1013, 389 => 0x12, 405 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 67 => 0x4, 68 => 0x4 },
	'sharpnessstrength' => { 98 => 0x20311 },
	'sharpnessthreshold' => { 433 => 0x801d },
	'sharpnessundershoot' => { 433 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 67 => 0x94, 68 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 67 => 0xac, 68 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 67 => 0xc4, 68 => 0xdc },
	'shiftcols' => { 132 => 0xc70 },
	'shootid' => { 469 => 'shootID' },
	'shootingdistance' => { 98 => 0x20701 },
	'shootinginfodisplay' => { 262 => '13.2', 263 => '5.1', 271 => '10.2', 272 => '4.1', 275 => '5.1', 277 => '5.3' },
	'shootinginfomonitorofftime' => { 262 => '26.2', 263 => '22.2', 265 => '22.2', 266 => '22.2', 270 => '21.2', 271 => '9.1', 272 => '21.2', 275 => '22.2', 276 => '22.2', 277 => '22.2' },
	'shootingmode' => { 148 => 'ShootingMode', 215 => 0x89, 302 => 0x1f },
	'shootingmodesetting' => { 264 => '5.1' },
	'shortdescription' => { 458 => 'shortdescription' },
	'shortdocumentid' => { 126 => 0xba },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 79 => 0x80d },
	'shorttitle' => { 354 => '@sti' },
	'shotdate' => { 480 => 'shotDate' },
	'shotday' => { 480 => 'shotDay' },
	'shotlocation' => { 480 => 'shotLocation' },
	'shotname' => { 362 => 'shot', 480 => 'shotName' },
	'shotnumber' => { 480 => 'shotNumber' },
	'shotnumbersincepowerup' => { 404 => 0x44e, 420 => 0x1a, 421 => 0x16, 422 => 0xa },
	'shotnumbersincepowerup2' => { 389 => 0x200 },
	'shotsize' => { 480 => 'shotSize' },
	'shownevent' => { 466 => 'EventExt' },
	'showneventidentifier' => { 466 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 466 => [\'EventExt','EventExtName'] },
	'shutter' => { 418 => 0x20, 419 => 0x26 },
	'shutter-aelock' => { 77 => 0x4, 79 => 0x701, 80 => 0x3, 81 => 0x4, 82 => 0x3, 83 => 0x3, 84 => 0x4, 85 => 0x2 },
	'shutteraelbutton' => { 78 => 0x4 },
	'shutterbuttonafonbutton' => { 79 => 0x701 },
	'shuttercount' => { 11 => 0x176, 55 => 0x1, 215 => 0xa7, 224 => [0x6a,0x157,0x24d], 225 => 0x286, 226 => 0x279, 227 => 0x284, 228 => 0x242, 229 => 0x280, 230 => 0x276, 231 => [0x27d,0x27f], 232 => 0x246, 235 => 0x2d6, 236 => 0x321, 237 => 0xbd8, 238 => 0x287, 239 => 0x320, 240 => 0x24a, 241 => 0x5fb, 244 => 0x2d5, 337 => 0x5d, 398 => 0x846, 403 => [0x125,0x14a], 418 => 0x32, 419 => 0x3a },
	'shuttercount2' => { 418 => 0x4c, 419 => [0x50,0x52,0x58] },
	'shuttercount3' => { 418 => [0x1a0,0x1aa,0x1bd], 419 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 77 => 0xf, 78 => 0xf, 79 => 0x305, 80 => 0xe, 81 => 0xf, 82 => 0x8, 83 => 0x8, 84 => 0xf, 85 => 0x8 },
	'shuttermode' => { 134 => 0x1b, 215 => 0x34 },
	'shutterreleasebuttonae-l' => { 262 => '17.7', 263 => '18.4', 265 => '78.4', 266 => '78.4', 267 => '16.1', 268 => '17.1', 269 => '17.1', 270 => '17.1', 271 => '7.1', 272 => '17.5', 275 => '18.4', 276 => '78.4', 277 => '18.2' },
	'shutterreleasemethod' => { 92 => 0x1010 },
	'shutterreleasenocfcard' => { 77 => 0x2, 78 => 0x2, 85 => 0xf },
	'shutterreleasetiming' => { 92 => 0x1011 },
	'shutterreleasewithoutlens' => { 79 => 0x711 },
	'shutterspeedlock' => { 263 => '38.1', 265 => '38.1', 266 => '38.1', 275 => '38.1', 276 => '38.1' },
	'shutterspeedrange' => { 79 => 0x10c },
	'shutterspeedsetting' => { 175 => 0x6, 387 => 0x2f, 388 => 0x28, 389 => 0x0 },
	'shutterspeedvalue' => { 88 => 0x1, 114 => 0x9201, 284 => 0x1000, 346 => 0x400, 460 => 'ShutterSpeedValue' },
	'shuttertype' => { 122 => 0x1050, 302 => 0x9f },
	'sidecarforextension' => { 468 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 132 => 0xe0d },
	'sigmascalingfactorcamera' => { 132 => 0xe0c },
	'sigmascalingfactorlowres' => { 132 => 0xe0b },
	'sigmasizetable' => { 132 => 0xe0f },
	'similarityindex' => { 126 => 0xe4 },
	'singleframebracketing' => { 175 => 0x21 },
	'skilllevel' => { 472 => 'skillLevel' },
	'skintonecorrection' => { 337 => 0x95 },
	'skiplinetime' => { 132 => 0x184e },
	'slaveflashmeteringsegments' => { 337 => 0x20b },
	'slideshowname' => { 469 => 'slideshowName' },
	'slideshownumber' => { 469 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 469 => 'slideshowTotalNumber' },
	'slowshutter' => { 73 => 0x8 },
	'slowsync' => { 122 => 0x1030 },
	'smartalbumcolor' => { 376 => 0x20 },
	'smartrange' => { 376 => 0xa012 },
	'smileshutter' => { 389 => 0x31 },
	'smileshuttermode' => { 389 => 0x27 },
	'smoothness' => { 114 => 0xfe57, 456 => 'Smoothness' },
	'snapshot' => { 466 => 'SnapshotLink' },
	'snapshotformat' => { 466 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 466 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 466 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 466 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 466 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 450 => 'Snapshots' },
	'snapshotusedvideoframe' => { 466 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 466 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 466 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 466 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 466 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 400 => 0x200f },
	'software' => { 114 => 0x131, 149 => 'Software', 292 => 'Software', 346 => 0x203, 356 => 'software', 379 => 0x18, 440 => 'Software', 476 => 'Software' },
	'softwareversion' => { 362 => "\xa9swr", 378 => 0x207 },
	'songwriter' => { 362 => "\xa9swf" },
	'songwriterkeywords' => { 362 => "\xa9swk" },
	'sonycropsize' => { 114 => 0x74c8 },
	'sonycroptopleft' => { 114 => 0x74c7 },
	'sonydatetime' => { 407 => 0x6, 409 => 0x1b6, 410 => 0x210, 411 => 0x1fe, 412 => 0x22c },
	'sonydatetime2' => { 418 => 0x51 },
	'sonyexposuretime' => { 418 => 0x3a, 419 => 0x46 },
	'sonyexposuretime2' => { 429 => 0xe },
	'sonyfnumber' => { 418 => 0x3c, 419 => 0x48, 429 => 0x14 },
	'sonyimageheight' => { 407 => 0x1a, 420 => 0x44, 421 => 0x3f, 422 => 0x47 },
	'sonyimageheightmax' => { 429 => 0x40 },
	'sonyimagesize' => { 175 => 0x3b, 387 => 0x54, 388 => 0x54, 389 => 0x9 },
	'sonyimagewidth' => { 407 => 0x1c },
	'sonyimagewidthmax' => { 429 => 0x3e },
	'sonyiso' => { 409 => 0x1218, 410 => 0x11f4, 411 => 0x1270, 412 => [0x1254,0x1258,0x1280], 413 => 0x113c, 414 => 0x344, 415 => 0x346, 416 => 0x320, 429 => 0x4 },
	'sonymaxaperture' => { 418 => 0x0, 419 => 0x0 },
	'sonymaxaperturevalue' => { 429 => 0x16 },
	'sonyminaperture' => { 418 => 0x1, 419 => 0x1 },
	'sonymodelid' => { 400 => 0xb001 },
	'sonyquality' => { 175 => 0x3c },
	'sonytimeminsec' => { 419 => 0x61 },
	'sortalbum' => { 354 => 'soal' },
	'sortalbumartist' => { 354 => 'soaa' },
	'sortartist' => { 354 => 'soar' },
	'sortcomposer' => { 354 => 'soco' },
	'sortname' => { 354 => 'sonm' },
	'sortshow' => { 354 => 'sosn' },
	'source' => { 126 => 0x73, 292 => 'Source', 457 => 'source', 458 => 'source', 468 => 'Source' },
	'sourcecount' => { 444 => 'SourceCount' },
	'sourcecredits' => { 362 => "\xa9src" },
	'sourcedirectoryindex' => { 324 => 0x0 },
	'sourcefileindex' => { 324 => 0x2 },
	'sourcephotoscount' => { 443 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 132 => 0x1390 },
	'spatialfrequencyresponse' => { 460 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 460 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 460 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 460 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 460 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 480 => 'speakerPlacement' },
	'specialeffectlevel' => { 108 => 0x3030 },
	'specialeffectmode' => { 108 => 0x2076 },
	'specialeffectsetting' => { 108 => 0x3031 },
	'specialinstructions' => { 126 => 0x28 },
	'specialmode' => { 284 => 0x200, 378 => 0x200 },
	'specialoccasion' => { 472 => 'specialOccasion' },
	'specialtypeid' => { 438 => 'SpecialTypeID' },
	'spectralsensitivity' => { 114 => 0x8824, 460 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 43 => [0x2b9,0x2d0,0x2d4], 45 => 0x1e4, 46 => [0x1fd,0x2dd], 47 => [0x231,0x30f], 48 => 0x31d },
	'speedx' => { 110 => 0x3, 362 => "\xa9xsp" },
	'speedy' => { 110 => 0x4, 362 => "\xa9ysp" },
	'speedz' => { 110 => 0x5, 362 => "\xa9zsp" },
	'spherical' => { 444 => 'Spherical' },
	'splitcolumn' => { 346 => 0x222 },
	'splittoningbalance' => { 456 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 456 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 456 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 456 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 456 => 'SplitToningShadowSaturation' },
	'sport' => { 470 => 'sport' },
	'spotfocuspointx' => { 172 => 0x2d },
	'spotfocuspointy' => { 172 => 0x2e },
	'spotmeteringmode' => { 34 => 0x27 },
	'spotmeterlinktoafpoint' => { 79 => 0x107 },
	'sractive' => { 318 => '17.1' },
	'srawquality' => { 34 => 0x2e },
	'srfocallength' => { 339 => 0x3 },
	'srhalfpresstime' => { 339 => 0x2 },
	'srresult' => { 339 => 0x0, 340 => 0x0 },
	'stackedimage' => { 279 => 0x804 },
	'standardmatrixcustom' => { 132 => 0x7d4 },
	'standardmatrixdaylight' => { 132 => 0x7d0 },
	'standardmatrixflash' => { 132 => 0x7d3 },
	'standardmatrixfluorescent' => { 132 => 0x7d2 },
	'standardmatrixtungsten' => { 132 => 0x7d1 },
	'standardoutputhighlightpoint' => { 104 => 0x14 },
	'standardoutputsensitivity' => { 114 => 0x8831, 461 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 104 => 0x15 },
	'standardrawcolortone' => { 104 => 0xd },
	'standardrawcontrast' => { 104 => 0xf },
	'standardrawhighlight' => { 104 => 0x75 },
	'standardrawhighlightpoint' => { 104 => 0x12 },
	'standardrawlinear' => { 104 => 0x10 },
	'standardrawsaturation' => { 104 => 0xe },
	'standardrawshadow' => { 104 => 0x7e },
	'standardrawshadowpoint' => { 104 => 0x13 },
	'standardrawsharpness' => { 104 => 0x11 },
	'standardunsharpmaskfineness' => { 104 => 0x94 },
	'standardunsharpmaskstrength' => { 104 => 0x92 },
	'standardunsharpmaskthreshold' => { 104 => 0x96 },
	'standardwhitecustom' => { 132 => 0x838 },
	'standardwhitedaylight' => { 132 => 0x834 },
	'standardwhiteflash' => { 132 => 0x837 },
	'standardwhitefluorescent' => { 132 => 0x836 },
	'standardwhitetungsten' => { 132 => 0x835 },
	'standbytimer' => { 263 => '19.1', 265 => '19.1', 266 => '19.1', 269 => '18.1', 270 => '18.1', 275 => '19.1', 276 => '19.1' },
	'startingpage' => { 470 => 'startingPage' },
	'startmovieshooting' => { 79 => 0x70d },
	'starttimecode' => { 480 => 'startTimecode' },
	'starttimecodetimeformat' => { 480 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 480 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 480 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 362 => "\xa9TSZ", 480 => 'startTimeSampleSize' },
	'starttimescale' => { 362 => "\xa9TSC", 480 => 'startTimeScale' },
	'state' => { 153 => 'State', 302 => 0x6b, 468 => 'State' },
	'status' => { 436 => 'Status', 448 => 'Status' },
	'stereomode' => { 444 => 'StereoMode' },
	'stitched' => { 444 => 'Stitched' },
	'stitchingsoftware' => { 443 => 'StitchingSoftware', 444 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 408 => 0x113e, 409 => 0x113e, 410 => 0x111a, 411 => 0x1196, 412 => 0x1172, 413 => 0x102a, 414 => 0x222, 415 => 0x222, 416 => 0x217, 429 => 0xa },
	'storagemethod' => { 179 => 0x12 },
	'storebyorientation' => { 263 => '46.3', 265 => '47.3', 266 => '47.3', 275 => '47.3', 276 => '47.3' },
	'storylineidentifier' => { 466 => 'StorylineIdentifier' },
	'straightenangle' => { 255 => 0x2fc08431 },
	'streamready' => { 466 => 'StreamReady' },
	'streamtype' => { 168 => 'StreamType' },
	'stretchmode' => { 480 => 'stretchMode' },
	'studydatetime' => { 435 => 'StudyDateTime' },
	'studydescription' => { 435 => 'StudyDescription' },
	'studyid' => { 435 => 'StudyID' },
	'studyphysician' => { 435 => 'StudyPhysician' },
	'styleperiod' => { 466 => 'StylePeriod' },
	'sub-location' => { 126 => 0x5c },
	'subfiledata' => { 156 => 'data' },
	'subfiledirectory' => { 156 => '1Directory' },
	'subfilemimetype' => { 156 => '2MIME' },
	'subfilename' => { 156 => '1Name' },
	'subfileresource' => { 156 => 'rsrc' },
	'subfiletype' => { 114 => 0xfe, 156 => '0Type' },
	'subject' => { 288 => 'Subject', 353 => 'Subject', 457 => 'subject', 467 => 'Subject', 481 => 'subject' },
	'subjectarea' => { 114 => 0x9214, 460 => 'SubjectArea' },
	'subjectcode' => { 465 => 'SubjectCode' },
	'subjectdistance' => { 114 => 0x9206, 134 => 0x3e, 460 => 'SubjectDistance' },
	'subjectdistancerange' => { 114 => 0xa40c, 460 => 'SubjectDistanceRange' },
	'subjectlocation' => { 114 => 0xa214, 460 => 'SubjectLocation' },
	'subjectmotion' => { 265 => '78.2', 266 => '78.2', 276 => '78.2' },
	'subjectprogram' => { 172 => 0x22 },
	'subjectreference' => { 126 => 0xc },
	'sublabels4' => { 464 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 464 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 464 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 464 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 464 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 109 => 'SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 109 => 'SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 109 => 'SubSecModifyDate' },
	'subsectime' => { 114 => 0x9290 },
	'subsectimedigitized' => { 114 => 0x9292 },
	'subsectimeoriginal' => { 114 => 0x9291 },
	'subsection1' => { 470 => 'subsection1' },
	'subsection2' => { 470 => 'subsection2' },
	'subsection3' => { 470 => 'subsection3' },
	'subsection4' => { 470 => 'subsection4' },
	'subselector' => { 263 => '49.1', 265 => '71.1', 266 => '71.1', 276 => '71.1' },
	'subselectorassignment' => { 263 => '48.1' },
	'subselectorcenter' => { 265 => '72.1', 266 => '72.1', 276 => '72.1' },
	'subselectorplusdials' => { 263 => '49.2', 265 => '73.1', 266 => '73.1', 276 => '73.1' },
	'subtitle' => { 362 => "\xa9snm", 470 => 'subtitle' },
	'subtitlekeywords' => { 362 => "\xa9snk" },
	'subversionfilename' => { 464 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 464 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 464 => 'SubVersions' },
	'superimposeddisplay' => { 77 => 0xa, 79 => 0x510, 80 => 0x9, 81 => 0xa, 84 => 0xa, 85 => 0xe },
	'supermacro' => { 61 => 0x1a },
	'supplementalcategories' => { 126 => 0x14, 468 => 'SupplementalCategories' },
	'supplementaltype' => { 128 => 0x37 },
	'supplementdisplayid' => { 470 => 'supplementDisplayID' },
	'supplementstartingpage' => { 470 => 'supplementStartingPage' },
	'supplementtitle' => { 470 => 'supplementTitle' },
	'supplychainsource' => { 466 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 466 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 466 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'svisosetting' => { 318 => 0x14 },
	'swatchcoloranta' => { 485 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 485 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 485 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 485 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 485 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 485 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 485 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 485 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 485 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 485 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 485 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 485 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 485 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 485 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 485 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 485 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 485 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 485 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 485 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 302 => 0x93, 389 => 0x33 },
	'sweeppanoramafieldofview' => { 302 => 0x94 },
	'sweeppanoramasize' => { 389 => 0x32 },
	'switchtoregisteredafpoint' => { 78 => 0x12, 79 => 0x50a },
	'symlink' => { 115 => 'SymLink' },
	'syncreleasemode' => { 265 => '77.1', 266 => '77.1', 276 => '77.1' },
	'system' => { 346 => 0x204 },
	'tagged' => { 348 => 0xdd, 349 => 'Tagged', 450 => 'tagged' },
	'tagslist' => { 459 => 'TagsList' },
	'tagstructure' => { 464 => 'TagStructure' },
	'takenumber' => { 480 => 'takeNumber' },
	'tapename' => { 480 => 'tapeName' },
	'targetaperture' => { 73 => 0x4 },
	'targetcompressionratio' => { 90 => 0x1 },
	'targetdistancesetting' => { 92 => 0x1807 },
	'targetexposuretime' => { 73 => 0x5 },
	'targetimagetype' => { 92 => 0x100a },
	'targetprinter' => { 114 => 0x151 },
	'taxon' => { 113 => 'Taxon' },
	'taxonacceptednameusage' => { 113 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 113 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 113 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 113 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 113 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 113 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 113 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 113 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 113 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 113 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 113 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 113 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 113 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 113 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 113 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 113 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 113 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 113 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 113 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 113 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 113 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 113 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 113 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 113 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 113 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 113 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 113 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 113 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 113 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 113 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 113 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 113 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 113 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 132 => 0x196f },
	'tda1edgepolarity' => { 132 => 0x1971 },
	'tda1gain' => { 132 => 0x1970 },
	'tda1offset' => { 132 => 0x196e },
	'tda2bandwidth' => { 132 => 0x1979 },
	'tda2edgepolarity' => { 132 => 0x197b },
	'tda2gain' => { 132 => 0x197a },
	'tda2offset' => { 132 => 0x1978 },
	'tda3bandwidth' => { 132 => 0x1983 },
	'tda3edgepolarity' => { 132 => 0x1985 },
	'tda3gain' => { 132 => 0x1984 },
	'tda3offset' => { 132 => 0x1982 },
	'tda4bandwidth' => { 132 => 0x198d },
	'tda4edgepolarity' => { 132 => 0x198f },
	'tda4gain' => { 132 => 0x198e },
	'tda4offset' => { 132 => 0x198c },
	'teaser' => { 470 => 'teaser' },
	'teleconverter' => { 177 => 0x105, 400 => 0x105 },
	'tempampgainx100' => { 132 => 0x1914 },
	'tempo' => { 480 => 'tempo' },
	'temporalcoverage' => { 466 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 466 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 466 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 289 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 289 => 'TermsAndConditionsURL' },
	'testname' => { 115 => 'TestName' },
	'textencoding' => { 214 => 0x4 },
	'textlayername' => { 468 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 468 => 'TextLayers' },
	'textlayertext' => { 468 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 302 => [0x8008,0x8009,0x3b,0x3e] },
	'three-dtrackingfacedetection' => { 265 => '1.4', 266 => '1.4', 276 => '1.4' },
	'three-dtrackingwatcharea' => { 265 => '78.1', 266 => '78.1', 276 => '78.1' },
	'thresholding' => { 114 => 0x107 },
	'thumbnailfilename' => { 92 => 0x817 },
	'thumbnailformat' => { 478 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 136 => 0xfa55, 478 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 92 => 0x2008, 109 => 'ThumbnailImage', 117 => 0x3, 159 => 'data', 284 => 0x100, 362 => 'thmb', 478 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 159 => '1Name' },
	'thumbnailimagesize' => { 159 => 'ImageSize' },
	'thumbnailimagetype' => { 159 => '0Type' },
	'thumbnailimagevalidarea' => { 61 => 0x13 },
	'thumbnaillength' => { 114 => 0x202 },
	'thumbnailoffset' => { 114 => 0x201 },
	'thumbnailpng' => { 362 => 'thmb' },
	'thumbnails' => { 478 => 'Thumbnails' },
	'thumbnailwidth' => { 136 => 0xfa54, 478 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 470 => 'ticker' },
	'tiffhandling' => { 456 => 'TIFFHandling' },
	'tiffmeteringimage' => { 178 => 0x104c, 398 => 0x1110 },
	'tilelength' => { 114 => 0x143 },
	'tilewidth' => { 114 => 0x142 },
	'time' => { 132 => 0x401, 337 => 0x7 },
	'timecodes' => { 114 => 0xc763 },
	'timecreated' => { 126 => 0x3c, 134 => 0x14, 143 => 0x10, 349 => 'TimeCreated' },
	'timelapseshotnumber' => { 305 => 0x10 },
	'timeperiod' => { 470 => 'timePeriod' },
	'timerfunctionbutton' => { 264 => '5.2', 267 => '12.1', 268 => '13.1' },
	'timerlength' => { 79 => 0x80c },
	'timerrecording' => { 302 => 0x96 },
	'timescaleparams' => { 480 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 480 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 480 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 480 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 127 => 0x50 },
	'timeshot' => { 445 => 'TimeShot' },
	'timesignature' => { 480 => 'timeSignature' },
	'timesincepoweron' => { 302 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 278 => 0x8, 292 => 'TimeStamp', 302 => 0xaf, 444 => 'Timestamp', 451 => 'Timestamp', 464 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 74 => 0x1, 247 => 0x0, 372 => 0xa },
	'timezonecity' => { 74 => 0x2 },
	'timezonecode' => { 95 => 0x1 },
	'timezoneinfo' => { 95 => 0x2 },
	'timezoneoffset' => { 114 => 0x882a },
	'tint' => { 356 => 'player.movie.visual.tint', 456 => 'Tint' },
	'title' => { 149 => 'Title', 288 => 'Title', 292 => 'Title', 302 => 0x65, 353 => 'Title', 354 => ['titl',"\xa9nam"], 356 => 'title', 362 => ['titl',"\xa9nam"], 457 => 'title', 467 => 'Title', 478 => 'Title' },
	'tonecomp' => { 215 => 0x81 },
	'tonecurve' => { 71 => 0x1, 337 => 0x402, 456 => 'ToneCurve' },
	'tonecurveactive' => { 103 => 0x110 },
	'tonecurveadobergb' => { 376 => 0xa043 },
	'tonecurveadobergbdefault' => { 376 => 0xa041 },
	'tonecurveblue' => { 456 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 433 => 0x9003 },
	'tonecurvebluey' => { 433 => 0x9007 },
	'tonecurvebrightness' => { 98 => 0x20410 },
	'tonecurvebrightnessx' => { 433 => 0x9000 },
	'tonecurvebrightnessy' => { 433 => 0x9004 },
	'tonecurvecolorspace' => { 102 => 0x0 },
	'tonecurvecontrast' => { 98 => 0x20411 },
	'tonecurvegreen' => { 456 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 433 => 0x9002 },
	'tonecurvegreeny' => { 433 => 0x9006 },
	'tonecurveinputrange' => { 102 => 0x3 },
	'tonecurveinterpolation' => { 103 => 0x159 },
	'tonecurvemode' => { 103 => 0x113 },
	'tonecurvename' => { 456 => 'ToneCurveName' },
	'tonecurvename2012' => { 456 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 98 => '0x20400.1' },
	'tonecurveoutputrange' => { 102 => 0x5 },
	'tonecurveprofilename' => { 132 => 0x1391 },
	'tonecurveproperty' => { 103 => 0x3c },
	'tonecurvepv2012' => { 456 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 456 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 456 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 456 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 456 => 'ToneCurveRed' },
	'tonecurveredx' => { 433 => 0x9001 },
	'tonecurveredy' => { 433 => 0x9005 },
	'tonecurves' => { 337 => 0x403 },
	'tonecurveshape' => { 102 => 0x1 },
	'tonecurvesrgb' => { 376 => 0xa042 },
	'tonecurvesrgbdefault' => { 376 => 0xa040 },
	'tonecurvex' => { 102 => 0xa },
	'tonecurvey' => { 102 => 0xb },
	'tonelevel' => { 279 => 0x52e },
	'tonemapstrength' => { 456 => 'ToneMapStrength' },
	'toningeffect' => { 55 => 0xf, 215 => 0xb3, 217 => 0x38, 218 => 0x40, 219 => 0x48, 369 => 0x1015 },
	'toningeffectauto' => { 68 => 0xa4 },
	'toningeffectfaithful' => { 67 => 0x74, 68 => 0x74 },
	'toningeffectlandscape' => { 67 => 0x44, 68 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 67 => 0x8c, 68 => 0x8c },
	'toningeffectneutral' => { 67 => 0x5c, 68 => 0x5c },
	'toningeffectportrait' => { 67 => 0x2c, 68 => 0x2c },
	'toningeffectstandard' => { 67 => 0x14, 68 => 0x14 },
	'toningeffectuserdef1' => { 67 => 0xa4, 68 => 0xbc },
	'toningeffectuserdef2' => { 67 => 0xbc, 68 => 0xd4 },
	'toningeffectuserdef3' => { 67 => 0xd4, 68 => 0xec },
	'toningsaturation' => { 217 => 0x39, 218 => 0x41, 219 => 0x49 },
	'totalzoom' => { 134 => 0x62 },
	'touchae' => { 302 => 0xab },
	'track' => { 354 => "\xa9trk", 362 => "\xa9trk" },
	'trackcreatedate' => { 361 => 0x1 },
	'trackmodifydate' => { 361 => 0x2 },
	'tracknumber' => { 354 => 'trkn', 480 => 'trackNumber' },
	'tracks' => { 480 => 'Tracks' },
	'tracksframerate' => { 480 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 480 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 480 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 480 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 480 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 480 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 480 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 480 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 480 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 480 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 480 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 480 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 480 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 480 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 480 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 480 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 480 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 362 => 'kgtt' },
	'trailersignature' => { 156 => 'zmie' },
	'transcript' => { 466 => 'Transcript' },
	'transcriptlink' => { 466 => 'TranscriptLink' },
	'transcriptlinklink' => { 466 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 466 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 114 => 0x12d, 476 => 'TransferFunction' },
	'transfertimenormal' => { 132 => 0x1888 },
	'transfertimetest' => { 132 => 0x1889 },
	'transform' => { 302 => [0x8012,0x59] },
	'transmissionreference' => { 468 => 'TransmissionReference' },
	'trapped' => { 288 => 'Trapped', 467 => 'Trapped' },
	'trashbuttonfunction' => { 79 => 0x710 },
	'travelday' => { 302 => 0x36 },
	'trebel' => { 356 => 'player.movie.audio.treble' },
	'triggermode' => { 363 => 0x6, 364 => 0x34, 365 => 0x34 },
	'tstop' => { 114 => 0xc772 },
	'ttl_da_adown' => { 325 => 0x5 },
	'ttl_da_aup' => { 325 => 0x4 },
	'ttl_da_bdown' => { 325 => 0x7 },
	'ttl_da_bup' => { 325 => 0x6 },
	'tungstenawb' => { 315 => 0x1 },
	'tvepisode' => { 354 => 'tves' },
	'tvepisodeid' => { 354 => 'tven' },
	'tvexposuretimesetting' => { 318 => 0x12 },
	'tvnetworkname' => { 354 => 'tvnn' },
	'tvseason' => { 354 => 'tvsn' },
	'tvshow' => { 354 => 'tvsh' },
	'type' => { 457 => 'type', 475 => 'type' },
	'typestatus' => { 113 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 114 => 0xc614 },
	'uniquedocumentid' => { 126 => 0xbb },
	'uniquematrixauto' => { 132 => 0x7e9 },
	'uniquematrixcustom' => { 132 => 0x7e8 },
	'uniquematrixdaylight' => { 132 => 0x7e4 },
	'uniquematrixflash' => { 132 => 0x7e7 },
	'uniquematrixfluorescent' => { 132 => 0x7e6 },
	'uniquematrixtungsten' => { 132 => 0x7e5 },
	'uniqueobjectname' => { 127 => 0x64 },
	'units' => { 440 => 'Units' },
	'unknown_aacr' => { 354 => 'AACR' },
	'unknown_cdek' => { 354 => 'CDEK' },
	'unknown_cdet' => { 354 => 'CDET' },
	'unknownblock' => { 337 => 0x405 },
	'unknownblock1' => { 283 => 0x635 },
	'unknownblock2' => { 283 => 0x636 },
	'unknownblock3' => { 283 => 0x1103 },
	'unknownblock4' => { 283 => 0x1104 },
	'unknowncontrast' => { 104 => 0x45 },
	'unknowndate' => { 346 => 0x212 },
	'unknownev' => { 132 => 0x1 },
	'unknownlinear' => { 104 => 0x46 },
	'unknownnumber' => { 92 => 0x180b },
	'unknownoutputhighlightpoint' => { 104 => 0x4a },
	'unknownoutputshadowpoint' => { 104 => 0x4b },
	'unknownrawhighlight' => { 104 => 0x7b },
	'unknownrawhighlightpoint' => { 104 => 0x48 },
	'unknownrawshadow' => { 104 => 0x84 },
	'unknownrawshadowpoint' => { 104 => 0x49 },
	'unknownsharpness' => { 104 => 0x47 },
	'unknowntags' => { 362 => 'TAGS' },
	'unknowntemperature' => { 116 => 0x4 },
	'unknownthumbnail' => { 362 => 'thmb' },
	'unsharp1color' => { 260 => 0x13 },
	'unsharp1halowidth' => { 260 => 0x19 },
	'unsharp1intensity' => { 260 => 0x17 },
	'unsharp1threshold' => { 260 => 0x1b },
	'unsharp2color' => { 260 => 0x2e },
	'unsharp2halowidth' => { 260 => 0x34 },
	'unsharp2intensity' => { 260 => 0x32 },
	'unsharp2threshold' => { 260 => 0x36 },
	'unsharp3color' => { 260 => 0x49 },
	'unsharp3halowidth' => { 260 => 0x4f },
	'unsharp3intensity' => { 260 => 0x4d },
	'unsharp3threshold' => { 260 => 0x51 },
	'unsharp4color' => { 260 => 0x64 },
	'unsharp4halowidth' => { 260 => 0x6a },
	'unsharp4intensity' => { 260 => 0x68 },
	'unsharp4threshold' => { 260 => 0x6c },
	'unsharpcount' => { 260 => 0x0 },
	'unsharpmask' => { 104 => 0x90, 255 => 0x76a43200 },
	'unsharpmaskfineness' => { 98 => 0x20309 },
	'unsharpmaskstrength' => { 98 => 0x20308 },
	'unsharpmaskthreshold' => { 98 => 0x2030a },
	'uprightcentermode' => { 456 => 'UprightCenterMode' },
	'uprightcenternormx' => { 456 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 456 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 456 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 456 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 456 => 'UprightFocalMode' },
	'uprightfoursegmentscount' => { 456 => 'UprightFourSegmentsCount' },
	'uprightpreview' => { 456 => 'UprightPreview' },
	'uprighttransform_0' => { 456 => 'UprightTransform_0' },
	'uprighttransform_1' => { 456 => 'UprightTransform_1' },
	'uprighttransform_2' => { 456 => 'UprightTransform_2' },
	'uprighttransform_3' => { 456 => 'UprightTransform_3' },
	'uprighttransform_4' => { 456 => 'UprightTransform_4' },
	'uprighttransform_5' => { 456 => 'UprightTransform_5' },
	'uprighttransformcount' => { 456 => 'UprightTransformCount' },
	'uprightversion' => { 456 => 'UprightVersion' },
	'urgency' => { 126 => 0xa, 468 => 'Urgency' },
	'url' => { 149 => 'URL', 292 => 'URL', 351 => 0x40b, 470 => 'url' },
	'url_list' => { 351 => 0x41e },
	'urla-platform' => { 470 => [\'url','urlA-platform'] },
	'urlurl' => { 470 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 79 => 0x10a },
	'usableshootingmodes' => { 79 => 0x109 },
	'usage' => { 471 => 'usage' },
	'usageterms' => { 484 => 'UsageTerms' },
	'useguidelines' => { 453 => 'useGuidelines' },
	'usepanoramaviewer' => { 443 => 'UsePanoramaViewer' },
	'usercollection' => { 356 => 'collection.user' },
	'usercomment' => { 92 => 0x805, 114 => 0x9286, 460 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 67 => 0xd8, 68 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 67 => 0xda, 68 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 67 => 0xdc, 68 => 0xf4 },
	'userfields' => { 448 => 'UserFields' },
	'userlabel' => { 363 => 0x2b, 364 => 0x5a, 365 => 0x68 },
	'userprofile' => { 297 => 0x302, 304 => 0x3038 },
	'userrating' => { 356 => 'rating.user' },
	'usmlenselectronicmf' => { 2 => 0x7, 78 => 0x7, 79 => 0x501 },
	'uspsnumber' => { 470 => 'uspsNumber' },
	'utmeasting' => { 160 => 'Easting' },
	'utmmapdatum' => { 160 => 'Datum' },
	'utmnorthing' => { 160 => 'Northing' },
	'utmzone' => { 160 => 'Zone' },
	'uv-irfiltercorrection' => { 297 => 0x325 },
	'validbits' => { 283 => 0x611, 284 => 0x102c },
	'validpixeldepth' => { 287 => 0x611 },
	'variablelowpassfilter' => { 400 => 0x2028 },
	'variousmodes' => { 134 => 0x26 },
	'variousmodes2' => { 134 => 0x3a },
	'variprogram' => { 215 => 0xab },
	'varraydacnominalvalues' => { 132 => 0x191e },
	'vendor' => { 362 => 'vndr' },
	'version' => { 122 => 0x0, 353 => 'Version', 356 => 'version', 456 => 'Version' },
	'versioncreatedate' => { 433 => 0xd100 },
	'versionid' => { 481 => 'VersionID' },
	'versionidentifier' => { 470 => 'versionIdentifier' },
	'versionmodifydate' => { 433 => 0xd101 },
	'versions' => { 481 => 'Versions' },
	'versionscomments' => { 481 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 481 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 481 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 481 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 481 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 481 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 481 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 481 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 481 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 481 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 481 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 262 => '3.2', 263 => '47.2', 265 => '79.1' },
	'verticalclockoverlaps' => { 132 => 0x412 },
	'verticalfuncbutton' => { 263 => '42.2', 265 => '67.1' },
	'verticalfuncbuttonplusdials' => { 263 => '43.1' },
	'verticalfuncplusdials' => { 265 => '68.1' },
	'verticalmultiselector' => { 263 => '42.1', 265 => '66.1', 266 => '66.1', 276 => '66.1' },
	'vfdisplayillumination' => { 2 => 0x11, 79 => [0x510,0x51d] },
	'vibrance' => { 449 => 'Vibrance', 456 => 'Vibrance' },
	'vibrationreduction' => { 224 => [0x75,0x82,0x1ae], 232 => '586.1', 240 => '590.2', 246 => 0x4 },
	'videoalphamode' => { 480 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 480 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 480 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 480 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 480 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 480 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 480 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 480 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 480 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 480 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 480 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 480 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 480 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 480 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 480 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 480 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 480 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 480 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 466 => 'videoBitRate' },
	'videobitratemode' => { 466 => 'videoBitRateMode' },
	'videoburstmode' => { 302 => 0xbb },
	'videocodec' => { 64 => 0x74 },
	'videocolorspace' => { 480 => 'videoColorSpace' },
	'videocompression' => { 122 => 0x3806 },
	'videocompressor' => { 480 => 'videoCompressor' },
	'videodisplayaspectratio' => { 466 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 466 => 'videoEncodingProfile' },
	'videofieldorder' => { 480 => 'videoFieldOrder' },
	'videoframerate' => { 480 => 'videoFrameRate' },
	'videoframesize' => { 480 => 'videoFrameSize' },
	'videoframesizeh' => { 480 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 480 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 480 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 480 => 'videoModDate' },
	'videopixelaspectratio' => { 480 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 480 => 'videoPixelDepth' },
	'videoquality' => { 108 => 0x4003 },
	'videorecordingmode' => { 122 => 0x3803 },
	'videoshottype' => { 466 => 'VideoShotType' },
	'videoshottypeidentifier' => { 466 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 466 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 466 => 'videoStreamsCount' },
	'viewfinder' => { 346 => 0x455 },
	'viewfinderdisplay' => { 262 => '12.4', 263 => '6.3' },
	'viewfinderwarning' => { 262 => '13.4', 272 => '3.5', 273 => '6.2', 277 => '4.4' },
	'viewfinderwarnings' => { 79 => 0x40a },
	'viewinfoduringexposure' => { 79 => 0x407 },
	'viewingmode' => { 389 => 0x2f, 405 => 0x18 },
	'viewingmode2' => { 389 => [0x85,0x285] },
	'viewpoint' => { 469 => 'viewpoint' },
	'vignetteamount' => { 456 => 'VignetteAmount' },
	'vignettecontrol' => { 215 => 0x2a, 255 => 0x76a43205 },
	'vignettecontrolintensity' => { 255 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 452 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 456 => 'VignetteMidpoint' },
	'vignetting' => { 369 => 0x1011, 376 => 0xa052 },
	'vignettingcorrection' => { 114 => 0x7031, 376 => 0xa053, 400 => 0x2011 },
	'vignettingcorrparams' => { 114 => 0x7032, 428 => 0x64a, 429 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 376 => 0xa054 },
	'visualcolor' => { 466 => 'VisualColour' },
	'visualtechnique' => { 469 => 'visualTechnique' },
	'voicememo' => { 378 => 0x216 },
	'volume' => { 470 => 'volume' },
	'vr_0x66' => { 224 => 0x66 },
	'vrdoffset' => { 61 => 0xd0 },
	'vrmode' => { 246 => 0x6 },
	'waterdepth' => { 114 => 0x9403, 461 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 178 => 0x19a },
	'wb_bluelevel6500k' => { 178 => 0x18a },
	'wb_bluelevelcustom' => { 178 => 0x18e },
	'wb_bluelevelscloudy' => { 178 => 0x106 },
	'wb_bluelevelsdaylight' => { 178 => 0xea },
	'wb_bluelevelsflash' => { 178 => 0x122 },
	'wb_bluelevelsfluorescent' => { 178 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 178 => 0x254 },
	'wb_bluelevelsshade' => { 178 => 0x176 },
	'wb_bluelevelstungsten' => { 178 => 0xce },
	'wb_gbrglevels' => { 178 => 0xae, 181 => 0x4 },
	'wb_glevel' => { 283 => 0x11f },
	'wb_glevel3000k' => { 283 => 0x113 },
	'wb_glevel3300k' => { 283 => 0x114 },
	'wb_glevel3600k' => { 283 => 0x115 },
	'wb_glevel3900k' => { 283 => 0x116 },
	'wb_glevel4000k' => { 283 => 0x117 },
	'wb_glevel4300k' => { 283 => 0x118 },
	'wb_glevel4500k' => { 283 => 0x119 },
	'wb_glevel4800k' => { 283 => 0x11a },
	'wb_glevel5300k' => { 283 => 0x11b },
	'wb_glevel6000k' => { 283 => 0x11c },
	'wb_glevel6600k' => { 283 => 0x11d },
	'wb_glevel7500k' => { 283 => 0x11e },
	'wb_grbglevels' => { 191 => 0x0 },
	'wb_rbgglevels' => { 188 => 0x0 },
	'wb_rblevels' => { 192 => 0x270, 215 => 0xc, 283 => 0x100 },
	'wb_rblevels1' => { 308 => 0x2 },
	'wb_rblevels2' => { 308 => 0x5 },
	'wb_rblevels3' => { 308 => 0x8 },
	'wb_rblevels3000k' => { 283 => 0x102 },
	'wb_rblevels3300k' => { 283 => 0x103 },
	'wb_rblevels3500k' => { 178 => 0x430 },
	'wb_rblevels3600k' => { 283 => 0x104 },
	'wb_rblevels3900k' => { 283 => 0x105 },
	'wb_rblevels4' => { 308 => 0xb },
	'wb_rblevels4000k' => { 283 => 0x106 },
	'wb_rblevels4300k' => { 283 => 0x107 },
	'wb_rblevels4500k' => { 283 => 0x108 },
	'wb_rblevels4800k' => { 283 => 0x109 },
	'wb_rblevels5' => { 308 => 0xe },
	'wb_rblevels5300k' => { 283 => 0x10a },
	'wb_rblevels6' => { 308 => 0x11 },
	'wb_rblevels6000k' => { 283 => 0x10b },
	'wb_rblevels6500k' => { 178 => 0x420 },
	'wb_rblevels6600k' => { 283 => 0x10c },
	'wb_rblevels7' => { 308 => 0x14 },
	'wb_rblevels7500k' => { 283 => 0x10d },
	'wb_rblevelsauto' => { 192 => 0x272, 287 => 0x110 },
	'wb_rblevelscloudy' => { 178 => 0x3f0, 180 => 0x10, 192 => 0x296, 287 => 0x121 },
	'wb_rblevelscoolwhitef' => { 178 => 0x308, 180 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 287 => 0x132 },
	'wb_rblevelscustom' => { 178 => 0x424 },
	'wb_rblevelscwb1' => { 283 => 0x10e },
	'wb_rblevelscwb2' => { 283 => 0x10f },
	'wb_rblevelscwb3' => { 283 => 0x110 },
	'wb_rblevelscwb4' => { 283 => 0x111 },
	'wb_rblevelsdaylight' => { 178 => [0x3ec,0x528], 180 => 0xc, 192 => 0x274 },
	'wb_rblevelsdaylightf' => { 180 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 287 => 0x130 },
	'wb_rblevelsdaywhitef' => { 180 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 287 => 0x131 },
	'wb_rblevelseveningsunlight' => { 287 => 0x124 },
	'wb_rblevelsfineweather' => { 287 => 0x122 },
	'wb_rblevelsflash' => { 178 => [0x3f4,0x304], 180 => 0x18, 192 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 192 => 0x290 },
	'wb_rblevelsincandescent' => { 192 => 0x282 },
	'wb_rblevelsshade' => { 178 => 0x418, 180 => 0x20, 192 => 0x2b2, 287 => 0x120 },
	'wb_rblevelstungsten' => { 178 => 0x3e8, 180 => 0x8, 287 => 0x123 },
	'wb_rblevelsunknown' => { 180 => 0x1c },
	'wb_rblevelsused' => { 287 => 0x100 },
	'wb_rblevelswhitef' => { 180 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 287 => 0x133 },
	'wb_redlevel3500k' => { 178 => 0x198 },
	'wb_redlevel6500k' => { 178 => 0x188 },
	'wb_redlevelcustom' => { 178 => 0x18c },
	'wb_redlevelscloudy' => { 178 => 0xf8 },
	'wb_redlevelsdaylight' => { 178 => 0xdc },
	'wb_redlevelsflash' => { 178 => 0x114 },
	'wb_redlevelsfluorescent' => { 178 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 178 => 0x1be },
	'wb_redlevelsshade' => { 178 => 0x168 },
	'wb_redlevelstungsten' => { 178 => 0xc0 },
	'wb_rgbglevels' => { 190 => 0x0 },
	'wb_rgblevels' => { 178 => [0x546,0x96], 298 => 0xd, 299 => 0x413, 304 => 0x3036, 346 => 0x107, 408 => 0x117c, 409 => 0x1180, 410 => 0x115c, 411 => 0x11d8, 412 => 0x11b4, 413 => 0x106c, 414 => 0x264, 415 => 0x264, 416 => 0x252 },
	'wb_rgblevels1' => { 309 => 0x2 },
	'wb_rgblevels2' => { 309 => 0x6 },
	'wb_rgblevels3' => { 309 => 0xa },
	'wb_rgblevels4' => { 309 => 0xe },
	'wb_rgblevels5' => { 309 => 0x12 },
	'wb_rgblevels6' => { 309 => 0x16 },
	'wb_rgblevels7' => { 309 => 0x1a },
	'wb_rgbmuldaylight' => { 132 => 0x852 },
	'wb_rgbmulflash' => { 132 => 0x855 },
	'wb_rgbmulfluorescent' => { 132 => 0x854 },
	'wb_rgbmultungsten' => { 132 => 0x853 },
	'wb_rggbblacklevels' => { 35 => 0x25 },
	'wb_rggblevels' => { 181 => 0x4, 189 => 0x0, 193 => 0x13e8, 194 => 0x38 },
	'wb_rggblevelsasshot' => { 38 => 0x0, 39 => 0x0, 40 => 0x19, 41 => 0x22, 42 => 0x3f, 45 => 0x3f, 46 => 0x3f, 47 => 0x3f, 48 => 0x47 },
	'wb_rggblevelsauto' => { 35 => 0x1, 38 => 0x5, 39 => 0x8, 40 => 0x1e, 41 => 0x18, 42 => 0x44, 45 => 0x44, 46 => 0x44, 47 => 0x44, 48 => 0x4c, 193 => 0x1478, 194 => 0x114, 376 => 0xa022 },
	'wb_rggblevelsblack' => { 376 => 0xa028 },
	'wb_rggblevelscloudy' => { 35 => 0xd, 38 => 0x1e, 39 => 0x30, 40 => 0x2d, 41 => 0x31, 42 => 0x58, 45 => 0x71, 46 => 0x8a, 47 => 0x8f, 48 => 0x92, 193 => 0x1408, 194 => 0x60, 337 => 0x20f, 345 => 0x14 },
	'wb_rggblevelscustom' => { 35 => 0x1d, 42 => 0x80, 193 => 0x1468, 194 => 0x100 },
	'wb_rggblevelscustom1' => { 40 => 0x41 },
	'wb_rggblevelscustom2' => { 40 => 0x46 },
	'wb_rggblevelsdaylight' => { 35 => 0x5, 38 => 0x14, 39 => 0x20, 40 => 0x23, 41 => 0x27, 42 => 0x4e, 45 => 0x67, 46 => 0x80, 47 => 0x85, 48 => 0x88, 193 => 0x13f8, 194 => 0x4c, 337 => 0x20d, 345 => 0x2 },
	'wb_rggblevelsflash' => { 35 => 0x19, 38 => 0x32, 39 => 0x50, 40 => 0x3c, 41 => 0x45, 42 => 0x6c, 45 => 0x85, 46 => 0x9e, 47 => 0xa3, 48 => 0xa6, 193 => 0x1448, 337 => 0x214, 345 => 0x41 },
	'wb_rggblevelsfluorescent' => { 35 => 0x15, 38 => 0x28, 39 => 0x40, 40 => 0x37, 41 => 0x3b, 42 => 0x62, 45 => 0x7b, 46 => 0x94, 47 => 0x99, 48 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 194 => 0xc4, 337 => 0x211, 345 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 345 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 194 => 0xb0, 337 => 0x212, 345 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 193 => 0x1438, 194 => 0x9c, 337 => 0x213, 345 => 0x38 },
	'wb_rggblevelshtmercury' => { 194 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 376 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 376 => 0xa024 },
	'wb_rggblevelskelvin' => { 35 => 0x21, 38 => 0x2d, 39 => 0x48, 41 => 0x40, 42 => 0x67, 45 => 0x80, 46 => 0x99, 47 => 0x9e, 48 => 0xa1 },
	'wb_rggblevelsmeasured' => { 38 => 0xa, 39 => 0x10, 42 => 0x49, 45 => 0x49, 46 => 0x49, 47 => 0x49, 48 => 0x51 },
	'wb_rggblevelspc1' => { 41 => 0x90, 42 => 0x71 },
	'wb_rggblevelspc2' => { 41 => 0x95, 42 => 0x76 },
	'wb_rggblevelspc3' => { 41 => 0x9a, 42 => 0x7b },
	'wb_rggblevelsshade' => { 35 => 0x9, 38 => 0x19, 39 => 0x28, 40 => 0x28, 41 => 0x2c, 42 => 0x53, 45 => 0x6c, 46 => 0x85, 47 => 0x8a, 48 => 0x8d, 194 => 0x74, 337 => 0x20e, 345 => 0xb },
	'wb_rggblevelstungsten' => { 35 => 0x11, 38 => 0x23, 39 => 0x38, 40 => 0x32, 41 => 0x36, 42 => 0x5d, 45 => 0x76, 46 => 0x8f, 47 => 0x94, 48 => 0x97, 193 => 0x1428, 194 => 0x88, 337 => 0x210, 345 => 0x1d },
	'wb_rggblevelsuncorrected' => { 376 => 0xa021 },
	'wb_rggblevelsunknown' => { 38 => 0xf, 39 => 0x18, 41 => 0x1d, 45 => 0x4e, 46 => 0x4e, 47 => 0x4e, 48 => 0x56, 345 => 0x53 },
	'wb_rggblevelsunknown10' => { 38 => 0x5f, 39 => 0x98, 41 => 0x72, 45 => 0x9e, 46 => 0x7b, 47 => 0x7b, 48 => 0x83 },
	'wb_rggblevelsunknown11' => { 38 => 0x64, 39 => 0xa0, 41 => 0x77, 45 => 0xa3, 46 => 0xa3, 47 => 0x80, 48 => 0xab },
	'wb_rggblevelsunknown12' => { 38 => 0x69, 39 => 0xa8, 41 => 0x7c, 45 => 0xa8, 46 => 0xa8, 47 => 0xa8, 48 => 0xb0 },
	'wb_rggblevelsunknown13' => { 38 => 0x6e, 39 => 0xb0, 41 => 0x81, 45 => 0xad, 46 => 0xad, 47 => 0xad, 48 => 0xb5 },
	'wb_rggblevelsunknown14' => { 41 => 0x86, 45 => 0xb2, 46 => 0xb2, 47 => 0xb2, 48 => 0xba },
	'wb_rggblevelsunknown15' => { 41 => 0x8b, 45 => 0xb7, 46 => 0xb7, 47 => 0xb7, 48 => 0xbf },
	'wb_rggblevelsunknown16' => { 41 => 0x9f, 46 => 0xbc, 47 => 0xbc, 48 => 0xc4 },
	'wb_rggblevelsunknown17' => { 46 => 0xc1, 47 => 0xc1, 48 => 0xc9 },
	'wb_rggblevelsunknown18' => { 46 => 0xc6, 47 => 0xc6, 48 => 0xce },
	'wb_rggblevelsunknown19' => { 46 => 0xcb, 47 => 0xcb, 48 => 0xd3 },
	'wb_rggblevelsunknown2' => { 38 => 0x37, 39 => 0x58, 41 => 0x4a, 45 => 0x53, 46 => 0x53, 47 => 0x53, 48 => 0x5b },
	'wb_rggblevelsunknown20' => { 46 => 0xd0, 47 => 0xd0, 48 => 0xd8 },
	'wb_rggblevelsunknown21' => { 47 => 0xd5, 48 => 0xdd },
	'wb_rggblevelsunknown22' => { 47 => 0xda, 48 => 0xe2 },
	'wb_rggblevelsunknown23' => { 47 => 0xdf, 48 => 0xe7 },
	'wb_rggblevelsunknown24' => { 47 => 0xe4, 48 => 0xec },
	'wb_rggblevelsunknown25' => { 47 => 0xe9, 48 => 0xf1 },
	'wb_rggblevelsunknown26' => { 47 => 0xee, 48 => 0xf6 },
	'wb_rggblevelsunknown27' => { 47 => 0xf3, 48 => 0xfb },
	'wb_rggblevelsunknown28' => { 47 => 0xf8, 48 => 0x100 },
	'wb_rggblevelsunknown29' => { 47 => 0xfd, 48 => 0x105 },
	'wb_rggblevelsunknown3' => { 38 => 0x3c, 39 => 0x60, 41 => 0x4f, 45 => 0x58, 46 => 0x58, 47 => 0x58, 48 => 0x60 },
	'wb_rggblevelsunknown30' => { 47 => 0x102 },
	'wb_rggblevelsunknown4' => { 38 => 0x41, 39 => 0x68, 41 => 0x54, 45 => 0x5d, 46 => 0x5d, 47 => 0x5d, 48 => 0x65 },
	'wb_rggblevelsunknown5' => { 38 => 0x46, 39 => 0x70, 41 => 0x59, 45 => 0x62, 46 => 0x62, 47 => 0x62, 48 => 0x6a },
	'wb_rggblevelsunknown6' => { 38 => 0x4b, 39 => 0x78, 41 => 0x5e, 45 => 0x8a, 46 => 0x67, 47 => 0x67, 48 => 0x6f },
	'wb_rggblevelsunknown7' => { 38 => 0x50, 39 => 0x80, 41 => 0x63, 45 => 0x8f, 46 => 0x6c, 47 => 0x6c, 48 => 0x74 },
	'wb_rggblevelsunknown8' => { 38 => 0x55, 39 => 0x88, 41 => 0x68, 45 => 0x94, 46 => 0x71, 47 => 0x71, 48 => 0x79 },
	'wb_rggblevelsunknown9' => { 38 => 0x5a, 39 => 0x90, 41 => 0x6d, 45 => 0x99, 46 => 0x76, 47 => 0x76, 48 => 0x7e },
	'wb_rggblevelsuserselected' => { 345 => 0x5c },
	'wbadjblueamber' => { 98 => 0x20106 },
	'wbadjbluebalance' => { 261 => 0x8 },
	'wbadjcolortemp' => { 98 => 0x20102, 103 => 0x1a },
	'wbadjlighting' => { 261 => 0x14 },
	'wbadjmagentagreen' => { 98 => 0x20105 },
	'wbadjmode' => { 261 => 0x10 },
	'wbadjredbalance' => { 261 => 0x0 },
	'wbadjrggblevels' => { 98 => 0x20125, 103 => 0x6 },
	'wbadjtemperature' => { 261 => 0x18 },
	'wbadjtint' => { 261 => 0x25 },
	'wbbluelevel' => { 297 => 0x324, 302 => 0x8006, 307 => 0x26 },
	'wbbracketingsteps' => { 233 => 0x174d, 234 => 0x87c, 242 => 0x1757 },
	'wbbracketmode' => { 55 => 0x9 },
	'wbbracketshotnumber' => { 178 => 0x2b, 369 => 0x101a },
	'wbbracketvalueab' => { 55 => 0xc },
	'wbbracketvaluegm' => { 55 => 0xd },
	'wbfinetuneactive' => { 103 => 0x24 },
	'wbfinetunesaturation' => { 103 => 0x28 },
	'wbfinetunetone' => { 103 => 0x2c },
	'wbgreenlevel' => { 297 => 0x323, 302 => 0x8005, 307 => 0x25 },
	'wbmediaimagesizesetting' => { 79 => 0x708 },
	'wbmode' => { 180 => 0x4, 284 => 0x1015 },
	'wbredlevel' => { 297 => 0x322, 302 => 0x8004, 307 => 0x24 },
	'wbscale' => { 181 => 0x0 },
	'wbshiftab' => { 71 => 0xc, 302 => 0x46, 319 => 0x10 },
	'wbshiftab_gm' => { 400 => 0x2014 },
	'wbshiftab_gm_precise' => { 400 => 0x2026 },
	'wbshiftcreativecontrol' => { 302 => 0x92 },
	'wbshiftgm' => { 71 => 0xd, 302 => 0x47, 319 => 0x11 },
	'wbshiftintelligentauto' => { 302 => 0x8b },
	'wbtype1' => { 308 => 0x1, 309 => 0x1 },
	'wbtype2' => { 308 => 0x4, 309 => 0x5 },
	'wbtype3' => { 308 => 0x7, 309 => 0x9 },
	'wbtype4' => { 308 => 0xa, 309 => 0xd },
	'wbtype5' => { 308 => 0xd, 309 => 0x11 },
	'wbtype6' => { 308 => 0x10, 309 => 0x15 },
	'wbtype7' => { 308 => 0x13, 309 => 0x19 },
	'webstatement' => { 484 => 'WebStatement' },
	'what' => { 456 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 71 => 0x8, 73 => 0x7, 107 => 0x7, 108 => [0x19,0x2012], 114 => [0xa403,0xfe4e], 122 => 0x1002, 132 => 0x3fc, 133 => 0xfa0d, 134 => 0x40, 172 => 0x3, 173 => 0xe, 174 => 0x4, 175 => 0xb, 177 => 0x115, 215 => 0x5, 245 => 0x7, 297 => 0x304, 302 => 0x3, 304 => 0x3033, 337 => 0x19, 344 => 0x7, 368 => 0x26, 369 => 0x1003, 379 => [0x3c,0x7,0x58], 387 => 0xf, 388 => 0xe, 400 => [0x115,0xb054], 456 => 'WhiteBalance', 460 => 'WhiteBalance' },
	'whitebalance0' => { 168 => 'WhiteBalance0' },
	'whitebalance1' => { 168 => 'WhiteBalance1' },
	'whitebalance2' => { 168 => 'WhiteBalance2', 279 => 0x500 },
	'whitebalanceadj' => { 98 => 0x20101, 103 => 0x18, 255 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 315 => 0x0 },
	'whitebalancebias' => { 108 => 0x2011, 284 => 0x304, 302 => 0x23 },
	'whitebalanceblue' => { 71 => 0x7 },
	'whitebalancebracket' => { 279 => 0x502, 284 => 0x303 },
	'whitebalancebracketing' => { 175 => 0x22, 178 => 0x2c, 398 => 0x2c },
	'whitebalancecomp' => { 287 => 0x1001 },
	'whitebalancedetected' => { 132 => 0x3fb },
	'whitebalancefinetune' => { 122 => 0x100a, 175 => 0x38, 177 => 0x112, 215 => 0xb, 369 => 0x1004, 387 => 0x6, 388 => 0x5, 400 => 0x112 },
	'whitebalancemode' => { 132 => 0x3fa, 337 => 0x1a },
	'whitebalancered' => { 71 => 0x6 },
	'whitebalanceset' => { 318 => 0xa },
	'whitebalancesetting' => { 175 => 0x23, 387 => 0x5, 388 => 0x4, 389 => 0x16, 405 => 0xd },
	'whitebalancesetup' => { 376 => 0x41 },
	'whitebalancetemperature' => { 279 => 0x501 },
	'whiteboard' => { 284 => 0x301 },
	'whitelevel' => { 114 => 0xc61d, 337 => 0x7e },
	'whitepoint' => { 114 => 0x13e, 337 => 0x201, 476 => 'WhitePoint' },
	'whites2012' => { 456 => 'Whites2012' },
	'whitesadj' => { 433 => 0x9017 },
	'wideadapter' => { 369 => 0x1017 },
	'widefocuszone' => { 172 => 0x2f },
	'widerange' => { 378 => 0x20f },
	'windmode' => { 132 => 0x3f4 },
	'windowlocation' => { 362 => 'WLOC' },
	'windowsatom' => { 455 => 'windowsAtom' },
	'windowsatomextension' => { 455 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 455 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 455 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 470 => 'wordCount' },
	'workcolorspace' => { 98 => 0x10200, 103 => 0x270 },
	'workflowtag' => { 466 => 'WorkflowTag' },
	'workflowtagcvid' => { 466 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 466 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 466 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 466 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 462 => 'WorkToDo' },
	'worldtimelocation' => { 302 => 0x3a, 337 => 0x22, 343 => '0.1' },
	'writer-editor' => { 126 => 0x7a },
	'x3filllight' => { 379 => 0x12 },
	'xattrquarantine' => { 166 => 'com.apple.quarantine' },
	'xilinxversion' => { 132 => 0x414 },
	'xml' => { 130 => 'xml ' },
	'xmp' => { 101 => 0xffff00f6, 115 => 'XMP' },
	'xmptoolkit' => { 477 => 'xmptk' },
	'xpauthor' => { 114 => 0x9c9d },
	'xpcomment' => { 114 => 0x9c9c },
	'xpkeywords' => { 114 => 0x9c9e },
	'xposition' => { 114 => 0x11e },
	'xpsubject' => { 114 => 0x9c9f },
	'xptitle' => { 114 => 0x9c9b },
	'xresolution' => { 114 => 0x11a, 129 => 0x3, 352 => 0x0, 476 => 'XResolution' },
	'xyresolution' => { 118 => 0x3 },
	'yaw' => { 110 => 0x7, 362 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 233 => 0x3513, 234 => 0x2c2c, 242 => 0x36fc, 374 => 0x0 },
	'ycbcrcoefficients' => { 114 => 0x211, 476 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 114 => 0x213, 476 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 114 => 0x212, 476 => 'YCbCrSubSampling' },
	'year' => { 354 => 'yrrc', 356 => 'year' },
	'yearcreated' => { 134 => 0x10, 143 => 0xc },
	'yellowhsl' => { 98 => 0x20912 },
	'yield' => { 472 => 'yield' },
	'yposition' => { 114 => 0x11f },
	'yresolution' => { 114 => 0x11b, 129 => 0x5, 352 => 0x4, 476 => 'YResolution' },
	'zonematching' => { 177 => 0x10a, 180 => [0x3a,0x4a], 400 => 0xb024 },
	'zonematchingmode' => { 175 => 0x14 },
	'zonematchingon' => { 174 => 0x75 },
	'zonematchingvalue' => { 387 => 0x1f },
	'zoomedpreviewlength' => { 284 => 0xf05 },
	'zoomedpreviewsize' => { 284 => 0xf06 },
	'zoomedpreviewstart' => { 284 => 0xf04 },
	'zoomsourcewidth' => { 34 => 0x24 },
	'zoomstepcount' => { 282 => 0x300, 284 => 0x100d },
	'zoomtargetwidth' => { 34 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'acceldata' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airulerunits' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'angleaxis' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atsccontent' => 1,
	'attachments' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimagetype' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'breakchar' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd850' => 1,
	'customsettingsd90' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthmapdata' => 1,
	'depthmapheight' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecontainer' => 1,
	'deviceid' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualshotinfo' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideotype' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimes' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geometricdistortionparams' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'gpano' => 1,
	'gpmd' => 1,
	'gps' => 1,
	'gpsaltituderaw' => 1,
	'gpsdatalist' => 1,
	'gpsdatetimeraw' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongituderaw' => 1,
	'gpspos' => 1,
	'gpsposition' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'gyroscope' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hiddenslides' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idsbasevalue' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepuntil' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kinds' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelid' => 1,
	'labeltext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layerblendmodes' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'limage' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magneticfield' => 1,
	'magnetometer' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metaformat' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metdata' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midisong' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'moviefragment' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'normallinetransfertiming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationinfo' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputresponse' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parameters' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'performersortorder' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturestylepc' => 1,
	'picturestyleuserdef' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'playcounter' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraitmatrix' => 1,
	'portraittonescaletable' => 1,
	'pose' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesize' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protune' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtmd' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	's2n' => 1,
	'sampleblacksequence' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorrightborder' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'sphericalvideo' => 1,
	'sphericalvideoxml' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailtiff' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmditemwherefroms' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2019, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
